/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.CompoundDiscreteParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.ObjectParameter;

public class CompoundObjectParameter<T>
extends CompoundDiscreteParameter {
    private T[] objects = null;

    public CompoundObjectParameter(String label, T[] objects) {
        this(label, objects, null, null);
    }

    public CompoundObjectParameter(String label, T[] objects, T value) {
        this(label, objects, value, null);
    }

    public CompoundObjectParameter(String label, T[] objects, String[] options) {
        this(label, objects, null, options);
    }

    public CompoundObjectParameter(String label, T[] objects, T value, String[] options) {
        super(label, ObjectParameter.defaultValue(value, objects), 0, objects.length);
        this.setObjects(objects, options);
        this.setIncrementMode(DiscreteParameter.IncrementMode.RELATIVE);
        this.setWrappable(true);
    }

    @Override
    public CompoundObjectParameter<T> setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    public CompoundObjectParameter<T> setObjects(T[] objects) {
        return this.setObjects(objects, null);
    }

    public CompoundObjectParameter<T> setObjects(T[] objects, String[] options) {
        this.objects = objects;
        if (options == null) {
            options = ObjectParameter.toOptions(objects);
        }
        this.setOptions(options);
        return this;
    }

    @Override
    public CompoundObjectParameter<T> setRange(int minValue, int maxValue) {
        if (this.objects != null && this.objects.length != maxValue - minValue) {
            throw new UnsupportedOperationException("May not call setRange on an ObjectParameter with Object list of different length");
        }
        super.setRange(minValue, maxValue);
        return this;
    }

    public CompoundObjectParameter<T> setValue(Object object) {
        if (this.objects == null) {
            throw new UnsupportedOperationException("Cannot setValue with an object unless setObjects() was called");
        }
        int index = ObjectParameter.indexOf(object, this.objects);
        if (index >= 0) {
            this.setValue(index);
            return this;
        }
        throw new IllegalArgumentException("Not a valid object for this parameter: " + object.toString());
    }

    public T[] getObjects() {
        return this.objects;
    }

    public T getObject() {
        return this.objects[this.getIndex()];
    }

    public T getBaseObject() {
        return this.objects[this.getBaseIndex()];
    }
}

