/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.modulation.LXCompoundModulation;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class CompoundParameter
extends BoundedParameter
implements LXCompoundModulation.Target {
    private final List<LXCompoundModulation> mutableModulations = new CopyOnWriteArrayList<LXCompoundModulation>();
    public final List<LXCompoundModulation> modulations = Collections.unmodifiableList(this.mutableModulations);
    private final List<LXCompoundModulation.Listener> modulationListeners = new ArrayList<LXCompoundModulation.Listener>();

    @Override
    public final CompoundParameter addModulationListener(LXCompoundModulation.Listener listener) {
        Objects.requireNonNull(listener, "May not add null CompoundParameter.ModulationListener");
        if (this.modulationListeners.contains(listener)) {
            throw new IllegalStateException("Cannod add CompoundParameter.ModulationListener listener twice: " + listener);
        }
        this.modulationListeners.add(listener);
        return this;
    }

    @Override
    public final CompoundParameter removeModulationListener(LXCompoundModulation.Listener listener) {
        this.modulationListeners.remove(listener);
        return this;
    }

    public CompoundParameter(String label) {
        super(label, 0.0);
    }

    public CompoundParameter(String label, double value) {
        super(label, value, 1.0);
    }

    public CompoundParameter(String label, double value, double max) {
        super(label, value, 0.0, max);
    }

    public CompoundParameter(String label, double value, double v0, double v1) {
        super(label, value, v0, v1, null);
    }

    public CompoundParameter(LXListenableParameter underlying, double v0, double v1) {
        super(underlying.getLabel(), underlying.getValue(), v0, v1, underlying);
    }

    @Override
    public CompoundParameter setWrappable(boolean wrappable) {
        super.setWrappable(wrappable);
        return this;
    }

    @Override
    public CompoundParameter setUnits(LXParameter.Units units) {
        super.setUnits(units);
        return this;
    }

    @Override
    public CompoundParameter setPolarity(LXParameter.Polarity polarity) {
        super.setPolarity(polarity);
        return this;
    }

    @Override
    public CompoundParameter setExponent(double exponent) {
        super.setExponent(exponent);
        return this;
    }

    @Override
    public CompoundParameter setNormalizationCurve(BoundedParameter.NormalizationCurve curve) {
        super.setNormalizationCurve(curve);
        return this;
    }

    @Override
    public CompoundParameter setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CompoundParameter setDetents(double ... detents) {
        super.setDetents(detents, false);
        return this;
    }

    @Override
    public CompoundParameter setDetentsNormalized(double ... detents) {
        super.setDetents(detents, true);
        return this;
    }

    @Override
    public List<LXCompoundModulation> getModulations() {
        return this.modulations;
    }

    @Override
    public CompoundParameter addModulation(LXCompoundModulation modulation) {
        if (this.mutableModulations.contains(modulation)) {
            throw new IllegalStateException("Cannot add same modulation twice");
        }
        this.mutableModulations.add(modulation);
        for (LXCompoundModulation.Listener listener : this.modulationListeners) {
            listener.modulationAdded(this, modulation);
        }
        this.bang();
        return this;
    }

    @Override
    public CompoundParameter removeModulation(LXCompoundModulation modulation) {
        this.mutableModulations.remove(modulation);
        for (LXCompoundModulation.Listener listener : this.modulationListeners) {
            listener.modulationRemoved(this, modulation);
        }
        this.bang();
        return this;
    }

    @Override
    public double getBaseValue() {
        return super.getValue();
    }

    @Override
    public double getBaseNormalized() {
        return this.range.getNormalized(this.getBaseValue(), this.getExponent(), this.getNormalizationCurve());
    }

    @Override
    public double getNormalized() {
        return this.getNormalizedWithModulation(this.getBaseNormalized(), this.modulations);
    }

    @Override
    public double getValue() {
        if (this.mutableModulations.size() == 0) {
            return super.getValue();
        }
        return this.range.normalizedToValue(this.getNormalized(), this.getExponent(), this.getNormalizationCurve());
    }
}

