/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.utils.LXUtils;

public class DiscreteParameter
extends LXListenableNormalizedParameter {
    protected int minValue;
    protected int maxValue;
    protected int range;
    private String[] options = null;
    private IncrementMode incrementMode = IncrementMode.NORMALIZED;
    public final MutableParameter optionsChanged = new MutableParameter();

    public DiscreteParameter(String label, int range) {
        this(label, 0, range);
    }

    public DiscreteParameter(String label, int min, int max) {
        this(label, min, min, max);
    }

    public DiscreteParameter(String label, int value, int min, int max) {
        super(label, value);
        this.setRange(min, max);
        this.setUnits(LXParameter.Units.INTEGER);
        this.setOscMode(LXNormalizedParameter.OscMode.ABSOLUTE);
    }

    public DiscreteParameter(String label, String[] options) {
        this(label, options.length);
        this.options = options;
    }

    public DiscreteParameter(String label, String[] options, int value) {
        this(label, value, 0, options.length);
        this.options = options;
    }

    @Override
    public DiscreteParameter setUnits(LXParameter.Units units) {
        super.setUnits(units);
        return this;
    }

    @Override
    public DiscreteParameter setWrappable(boolean wrappable) {
        super.setWrappable(wrappable);
        return this;
    }

    @Override
    public DiscreteParameter setMappable(boolean mappable) {
        super.setMappable(mappable);
        return this;
    }

    @Override
    public DiscreteParameter setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    protected double updateValue(double value) {
        if (value < (double)this.minValue) {
            return this.minValue + (this.range - (int)((double)this.minValue - value) % this.range) % this.range;
        }
        return this.minValue + (int)(value - (double)this.minValue) % this.range;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getRange() {
        return this.range;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String getBaseOption() {
        return this.options != null ? this.options[this.getBaseIndex()] : this.getFormatter().format(this.getBaseValuei());
    }

    public String getOption() {
        return this.options != null ? this.options[this.getIndex()] : this.getFormatter().format(this.getValuei());
    }

    public DiscreteParameter setOptions(String[] options) {
        return this.setOptions(options, true);
    }

    public DiscreteParameter setOptions(String[] options, boolean updateRange) {
        if (this.options != options) {
            this.options = options;
            if (options != null) {
                if (updateRange) {
                    this.setRange(options.length);
                } else if (options.length != this.range) {
                    throw new IllegalArgumentException("Cannot set options array with length different from range: " + this.range + " != " + options.length);
                }
            }
            this.optionsChanged.bang();
        }
        return this;
    }

    public DiscreteParameter setRange(int minValue, int maxValue) {
        if (this.options != null && this.options.length != maxValue - minValue) {
            throw new UnsupportedOperationException("May not call setRange on a DiscreteParameter with String options of different length");
        }
        if (maxValue <= minValue) {
            throw new IllegalArgumentException("DiscreteParameter must have range of at least 1");
        }
        this.minValue = minValue;
        this.maxValue = maxValue - 1;
        this.range = maxValue - minValue;
        this.setValue(LXUtils.constrain(this.getBaseValuei(), this.minValue, this.maxValue));
        return this;
    }

    public DiscreteParameter setRange(int range) {
        return this.setRange(0, range);
    }

    public DiscreteParameter setIndex(int index) {
        this.setValue(index + this.minValue);
        return this;
    }

    public DiscreteParameter increment() {
        return this.increment(1, this.isWrappable());
    }

    public DiscreteParameter increment(boolean wrap) {
        return this.increment(1, wrap);
    }

    public DiscreteParameter increment(int amt) {
        return this.increment(amt, this.isWrappable());
    }

    public DiscreteParameter increment(int amt, boolean wrap) {
        if (wrap) {
            this.setValue(this.getBaseValuei() + amt);
        } else {
            this.setValue(Math.min(this.minValue + this.range - 1, this.getBaseValuei() + amt));
        }
        return this;
    }

    public DiscreteParameter decrement() {
        return this.decrement(1, this.isWrappable());
    }

    public DiscreteParameter decrement(boolean wrap) {
        return this.decrement(1, wrap);
    }

    public DiscreteParameter decrement(int amt) {
        return this.decrement(amt, this.isWrappable());
    }

    public DiscreteParameter decrement(int amt, boolean wrap) {
        if (wrap) {
            this.setValue(this.getValuei() - amt);
        } else {
            this.setValue(Math.max(this.minValue, this.getBaseValuei() - amt));
        }
        return this;
    }

    public int getValuei() {
        return (int)this.getValue();
    }

    public int getBaseValuei() {
        return this.getValuei();
    }

    public int getIndex() {
        return this.getValuei() - this.minValue;
    }

    public int getBaseIndex() {
        return this.getBaseValuei() - this.minValue;
    }

    @Override
    public double getNormalized() {
        if (this.range == 1) {
            return 0.0;
        }
        return (this.getValue() - (double)this.minValue) / (double)(this.range - 1);
    }

    @Override
    public double getValueFromNormalized(double normalized) {
        return this.normalizedToValue(normalized);
    }

    protected int normalizedToValue(double normalized) {
        return this.minValue + LXUtils.constrain((int)(normalized * (double)this.range), 0, this.range - 1);
    }

    @Override
    public DiscreteParameter setNormalized(double normalized) {
        this.setValue(this.normalizedToValue(normalized));
        return this;
    }

    public IncrementMode getIncrementMode() {
        return this.incrementMode;
    }

    public DiscreteParameter setIncrementMode(IncrementMode incrementMode) {
        this.incrementMode = incrementMode;
        return this;
    }

    public static enum IncrementMode {
        NORMALIZED,
        RELATIVE;

    }
}

