/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;

public abstract class LXListenableParameter
implements LXParameter {
    private final String label;
    private double defaultValue;
    private double value;
    private final List<LXParameterListener> listeners = new ArrayList<LXParameterListener>();
    private AggregateParameter parentParameter = null;
    private LXComponent parent;
    private String path;
    private LXParameter.Units units = LXParameter.Units.NONE;
    private LXParameter.Formatter formatter = null;
    private LXParameter.Polarity polarity = LXParameter.Polarity.UNIPOLAR;
    protected String description = null;
    private boolean mappable = true;
    private boolean inListener = false;
    private final Queue<Double> setValues = new ArrayDeque<Double>();

    protected LXListenableParameter() {
        this(null, 0.0);
    }

    protected LXListenableParameter(String label) {
        this(label, 0.0);
    }

    protected LXListenableParameter(double value) {
        this(null, value);
    }

    protected LXListenableParameter(String label, double value) {
        this.label = label;
        this.defaultValue = this.value = value;
    }

    @Override
    public LXParameter.Formatter getFormatter() {
        return this.formatter != null ? this.formatter : this.getUnits();
    }

    @Override
    public LXListenableParameter setFormatter(LXParameter.Formatter formatter) {
        this.formatter = formatter;
        return this;
    }

    @Override
    public LXParameter.Units getUnits() {
        return this.units;
    }

    public LXListenableParameter setUnits(LXParameter.Units units) {
        this.units = units;
        return this;
    }

    @Override
    public LXParameter.Polarity getPolarity() {
        return this.polarity;
    }

    public LXListenableParameter setPolarity(LXParameter.Polarity polarity) {
        this.polarity = polarity;
        return this;
    }

    public LXListenableParameter addListener(LXParameterListener listener) {
        return this.addListener(listener, false);
    }

    public LXListenableParameter addListener(LXParameterListener listener, boolean fireImmediately) {
        Objects.requireNonNull(listener, "May add null LXParameterListener: " + this);
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXParameterListener " + this.getCanonicalPath() + " " + listener.getClass().getName());
        }
        this.listeners.add(listener);
        if (fireImmediately) {
            listener.onParameterChanged(this);
        }
        return this;
    }

    public final LXListenableParameter removeListener(LXParameterListener listener) {
        if (!this.listeners.contains(listener)) {
            LX.error(new Exception(), "Trying to remove unregistered LXParameterListener " + this.getCanonicalPath() + " " + listener.getClass().getName());
        }
        this.listeners.remove(listener);
        return this;
    }

    public LXListenableParameter setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LXParameter setComponent(LXComponent component, String path) {
        if (component == null || path == null) {
            throw new IllegalArgumentException("May not set null component or path");
        }
        if (this.parent != null || this.path != null) {
            throw new IllegalStateException("Component already set on this modulator: " + this);
        }
        this.parent = component;
        this.path = path;
        return this;
    }

    void setParentParameter(AggregateParameter parentParameter) {
        this.parentParameter = parentParameter;
    }

    @Override
    public AggregateParameter getParentParameter() {
        return this.parentParameter;
    }

    @Override
    public LXComponent getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void dispose() {
        for (LXParameterListener listener : this.listeners) {
            String className = listener.getClass().getName();
            if (className.contains(".ui.")) {
                LX.warning("Stranded UI listener on parameter: " + this.getCanonicalPath() + " - " + className);
                continue;
            }
            LX.error(new Exception(), "WARNING / SHOULDFIX: Stranded listener on parameter: " + this.getCanonicalPath() + " - " + className);
        }
        this.listeners.clear();
    }

    @Override
    public LXParameter reset() {
        return this.setValue(this.defaultValue);
    }

    public LXParameter reset(double value) {
        this.defaultValue = value;
        return this.setValue(this.defaultValue);
    }

    public LXParameter incrementValue(double amount) {
        return this.setValue(this.value + amount);
    }

    @Override
    public final LXParameter setValue(double value) {
        return this.setValue(value, true);
    }

    public final LXParameter setValue(double value, boolean notifyListeners) {
        if (this.inListener) {
            this.setValues.add(value);
        } else if (this.value != value && this.value != (value = this.updateValue(value))) {
            this.value = value;
            if (notifyListeners) {
                this.inListener = true;
                for (LXParameterListener l : this.listeners) {
                    l.onParameterChanged(this);
                }
                this.inListener = false;
            }
            while (!this.setValues.isEmpty()) {
                this.setValue(this.setValues.poll());
            }
        }
        return this;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public final boolean isDefault() {
        return this.value == this.defaultValue;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public LXListenableParameter bang() {
        for (LXParameterListener l : this.listeners) {
            l.onParameterChanged(this);
        }
        return this;
    }

    @Override
    public LXListenableParameter setMappable(boolean mappable) {
        this.mappable = mappable;
        return this;
    }

    @Override
    public boolean isMappable() {
        return this.mappable;
    }

    protected abstract double updateValue(double var1);
}

