/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.DiscreteParameter;
import java.util.Objects;

public class ObjectParameter<T>
extends DiscreteParameter {
    private T[] objects = null;

    static <T> int defaultValue(T value, T[] objects) {
        if (value == null) {
            return 0;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (!Objects.equals(value, objects[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("The ObjectParameter value is not present in the objects[]: " + value);
    }

    static <T> int indexOf(T value, T[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (!Objects.equals(value, objects[i])) continue;
            return i;
        }
        return -1;
    }

    static <T> String[] toOptions(T[] objects) {
        String[] options = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            options[i] = objects[i] == null ? "null" : objects[i].toString();
        }
        return options;
    }

    public ObjectParameter(String label, T[] objects) {
        this(label, objects, null, null);
    }

    public ObjectParameter(String label, T[] objects, T value) {
        this(label, objects, value, null);
    }

    public ObjectParameter(String label, T[] objects, String[] options) {
        this(label, objects, null, options);
    }

    public ObjectParameter(String label, T[] objects, T value, String[] options) {
        super(label, ObjectParameter.defaultValue(value, objects), 0, objects.length);
        this.setObjects(objects, options);
        this.setIncrementMode(DiscreteParameter.IncrementMode.RELATIVE);
        this.setWrappable(true);
    }

    @Override
    public ObjectParameter<T> setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    public ObjectParameter<T> setObjects(T[] objects) {
        return this.setObjects(objects, null);
    }

    public ObjectParameter<T> setObjects(T[] objects, String[] options) {
        this.objects = objects;
        if (options == null) {
            options = ObjectParameter.toOptions(objects);
        }
        this.setOptions(options);
        return this;
    }

    @Override
    public ObjectParameter<T> setRange(int minValue, int maxValue) {
        if (this.objects != null && this.objects.length != maxValue - minValue) {
            throw new UnsupportedOperationException("May not call setRange on an ObjectParameter with Object list of different length");
        }
        super.setRange(minValue, maxValue);
        return this;
    }

    public ObjectParameter<T> setValue(Object object) {
        if (this.objects == null) {
            throw new UnsupportedOperationException("Cannot setValue with an object unless setObjects() was called");
        }
        int index = ObjectParameter.indexOf(object, this.objects);
        if (index >= 0) {
            this.setValue(index);
            return this;
        }
        throw new IllegalArgumentException("Not a valid object for this parameter: " + object.toString());
    }

    public T[] getObjects() {
        return this.objects;
    }

    public T getObject() {
        return this.objects[this.getIndex()];
    }
}

