/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;

public class StringParameter
extends LXListenableParameter {
    private String defaultString;
    private String string;

    public StringParameter(String label) {
        this(label, "");
    }

    public StringParameter(String label, String string) {
        super(label);
        this.defaultString = this.string = string;
    }

    @Override
    public StringParameter setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public LXParameter reset() {
        this.string = this.defaultString;
        super.reset();
        return this;
    }

    @Override
    public LXParameter reset(double value) {
        throw new UnsupportedOperationException("StringParamater cannot be reset to a numeric value");
    }

    public StringParameter setValue(String string) {
        return this.setValue(string, false);
    }

    public StringParameter setValue(String string, boolean update) {
        if (this.string == null) {
            if (string != null) {
                this.string = string;
                update = true;
            }
        } else if (!this.string.equals(string)) {
            this.string = string;
            update = true;
        }
        if (update) {
            this.incrementValue(1.0);
        }
        return this;
    }

    @Override
    protected double updateValue(double value) {
        return value;
    }

    public String getString() {
        return this.string;
    }
}

