/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.LX;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameterListener;

public class TriggerParameter
extends BooleanParameter {
    private Runnable onTrigger = null;
    private final LXParameterListener listener = p -> {
        if (this.isOn()) {
            if (this.onTrigger != null) {
                this.onTrigger.run();
            }
            this.setValue(false);
        }
    };

    public TriggerParameter(String label) {
        this(label, null);
    }

    public TriggerParameter(String label, Runnable onTrigger) {
        super(label, false);
        this.setMode(BooleanParameter.Mode.MOMENTARY);
        this.addListener(this.listener);
        this.onTrigger(onTrigger);
    }

    @Override
    public TriggerParameter setDescription(String description) {
        return (TriggerParameter)super.setDescription(description);
    }

    public TriggerParameter onTrigger(Runnable onTrigger) {
        if (this.onTrigger != null) {
            LX.error(new Exception(), "WARNING / SHOULDFIX: Overwriting previous onTrigger on TriggerParameter: " + this.getCanonicalPath());
        }
        this.onTrigger = onTrigger;
        return this;
    }

    public TriggerParameter trigger() {
        this.setValue(true);
        return this;
    }

    @Override
    public BooleanParameter setMode(BooleanParameter.Mode mode) {
        if (mode != BooleanParameter.Mode.MOMENTARY) {
            throw new IllegalArgumentException("TriggerParameter may only have MOMENTARY mode");
        }
        super.setMode(mode);
        return this;
    }

    @Override
    public void dispose() {
        this.removeListener(this.listener);
        this.onTrigger = null;
        super.dispose();
    }
}

