/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.audio.LXAudioEngine;
import heronarts.lx.color.LXColor;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.pattern.LXPattern;

@LXCategory(value="Form")
public class GraphicEqualizerPattern
extends LXPattern {
    public final EnumParameter<Plane> plane = new EnumParameter<Plane>("Plane", Plane.XY).setDescription("Which plane the equalizer renders on");
    public final CompoundParameter gain = new CompoundParameter("Gain", 1.0, 0.0, 3.0).setDescription("Amount of gain-scaling");
    public final CompoundParameter center = new CompoundParameter("Center", 0.0).setDescription("Center point on the axis");
    public final CompoundParameter fade = new CompoundParameter("Fade", 0.1).setExponent(2.0).setDescription("Amount of fade");
    public final CompoundParameter sharp = new CompoundParameter("Sharp", 0.9).setExponent(2.0).setDescription("Amount of sharpness");

    public GraphicEqualizerPattern(LX lx) {
        super(lx);
        this.addParameter("gain", this.gain);
        this.addParameter("center", this.center);
        this.addParameter("fade", this.fade);
        this.addParameter("sharp", this.sharp);
        this.addParameter("plane", this.plane);
    }

    @Override
    public void run(double deltaMs) {
        LXAudioEngine.Meter eq = this.lx.engine.audio.meter;
        float center = this.center.getValuef();
        float fade = 100.0f / this.fade.getValuef();
        float sharp = 100.0f / (1.0f - this.sharp.getValuef());
        float gain = this.gain.getValuef();
        Plane plane = this.plane.getEnum();
        float v1 = 0.0f;
        float v2 = 0.0f;
        for (LXPoint p : this.model.points) {
            switch (plane) {
                case XY: {
                    v1 = p.xn;
                    v2 = p.yn;
                    break;
                }
                case ZY: {
                    v1 = p.zn;
                    v2 = p.yn;
                    break;
                }
                case XZ: {
                    v1 = p.xn;
                    v2 = p.zn;
                    break;
                }
                case YZ: {
                    v1 = p.yn;
                    v2 = p.zn;
                    break;
                }
                case YX: {
                    v1 = p.yn;
                    v2 = p.xn;
                    break;
                }
                case ZX: {
                    v1 = p.zn;
                    v2 = p.xn;
                }
            }
            float level = gain * eq.getBandf((int)(v1 * (float)(eq.numBands - 1)));
            float value = Math.abs(v2 - center);
            this.colors[p.index] = value > level ? -16777216 : LXColor.gray(Math.min(100.0f, Math.min((level - value) * sharp, value * fade)));
        }
    }

    public static enum Plane {
        XY,
        ZY,
        XZ,
        YZ,
        YX,
        ZX;

    }
}

