/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.LXTime;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class LXPattern
extends LXDeviceComponent
implements LXComponent.Renamable,
LXOscComponent {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private int index = -1;
    private int intervalBegin = -1;
    private int intervalEnd = -1;
    private double compositeDampingLevel = 1.0;
    public final BooleanParameter enabled = new BooleanParameter("Enabled", true).setDescription("Whether the pattern is eligible for playlist cycling or compositing");
    public final TriggerParameter recall = new TriggerParameter("Recall", () -> this.getChannel().goPattern(this)).setDescription("Recalls this pattern to become active on the channel");
    public final ObjectParameter<LXBlend> compositeMode = new ObjectParameter<LXBlend>("Composite Blend", new LXBlend[1]).setDescription("Specifies the blending function used for blending of patterns on the channel");
    private LXBlend activeCompositeBlend;
    public final CompoundParameter compositeLevel = new CompoundParameter("Composite Level", 1.0).setDescription("Alpha level to composite pattern at when in channel blend mode");
    public final BooleanParameter hasCustomCycleTime = new BooleanParameter("Custom Cycle", false).setDescription("When enabled, this pattern uses its own custom duration rather than the default cycle time");
    public final BoundedParameter customCycleTimeSecs = new BoundedParameter("Cycle Time", 60.0, 0.1, 14400.0).setDescription("Sets the number of seconds after which the channel cycles to the next pattern").setUnits(LXParameter.Units.SECONDS);
    private final LXParameterListener onEnabled = p -> {
        boolean isEnabled = this.enabled.isOn();
        LXChannel channel = this.getChannel();
        if (channel != null && channel.compositeMode.getEnum() == LXChannel.CompositeMode.BLEND) {
            if (isEnabled) {
                channel.onPatternEnabled(this);
            }
            if (!channel.compositeDampingEnabled.isOn()) {
                if (isEnabled) {
                    this._activate();
                } else {
                    this._deactivate();
                }
            }
        }
    };
    private final LXParameterListener onCompositeMode = p -> {
        this.activeCompositeBlend.onInactive();
        this.activeCompositeBlend = this.compositeMode.getObject();
        this.activeCompositeBlend.onActive();
    };
    protected double runMs = 0.0;
    private boolean isActive = false;
    public final Profiler profiler = new Profiler();
    protected final List<LXEffect> mutableEffects = new ArrayList<LXEffect>();
    public final List<LXEffect> effects = Collections.unmodifiableList(this.mutableEffects);
    public static final String PATH_EFFECT = "effect";
    private static final String KEY_EFFECTS = "effects";

    public final void addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXPattern.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("May not add duplicate LXPattern.Listener: " + listener);
        }
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered Bus.Listener: " + listener);
        }
        this.listeners.remove(listener);
    }

    protected LXPattern(LX lx) {
        super(lx);
        this.label.setDescription("The name of this pattern");
        this.addArray(PATH_EFFECT, this.effects);
        this.addLegacyInternalParameter("autoCycleEligible", this.enabled);
        this.addParameter("enabled", this.enabled);
        this.addParameter("recall", this.recall);
        this.addParameter("compositeMode", this.compositeMode);
        this.addParameter("compositeLevel", this.compositeLevel);
        this.addParameter("hasCustomCycleTime", this.hasCustomCycleTime);
        this.addParameter("customCycleTimeSecs", this.customCycleTimeSecs);
        this.updateCompositeBlendOptions();
        this.compositeMode.addListener(this.onCompositeMode);
        this.enabled.addListener(this.onEnabled);
    }

    @Override
    public boolean isSnapshotControl(LXParameter parameter) {
        return parameter != this.recall && parameter != this.enabled && parameter != this.hasCustomCycleTime && parameter != this.customCycleTimeSecs && super.isSnapshotControl(parameter);
    }

    @Override
    public boolean isHiddenControl(LXParameter parameter) {
        return parameter == this.recall || parameter == this.compositeMode || parameter == this.compositeLevel || parameter == this.enabled || parameter == this.hasCustomCycleTime || parameter == this.customCycleTimeSecs || super.isHiddenControl(parameter);
    }

    @Override
    public String getPath() {
        return "pattern/" + (this.index + 1);
    }

    public void updateCompositeBlendOptions() {
        for (LXBlend blend : this.compositeMode.getObjects()) {
            if (blend == null) continue;
            blend.dispose();
        }
        this.compositeMode.setObjects((LXBlend[])this.lx.engine.mixer.instantiateChannelBlends());
        this.activeCompositeBlend = this.compositeMode.getObject();
        this.activeCompositeBlend.onActive();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public final LXChannel getChannel() {
        return (LXChannel)this.getParent();
    }

    public final LXPattern setChannel(LXChannel channel) {
        this.setParent(channel);
        return this;
    }

    public LXPattern setInterval(int begin, int end) {
        this.intervalBegin = begin;
        this.intervalEnd = end;
        return this;
    }

    public LXPattern clearInterval() {
        this.intervalEnd = -1;
        this.intervalBegin = -1;
        return this;
    }

    public final boolean hasInterval() {
        return this.intervalBegin >= 0 && this.intervalEnd >= 0;
    }

    public final boolean isInInterval() {
        if (!this.hasInterval()) {
            return false;
        }
        int now = LXTime.hour() * 60 + LXTime.minute();
        if (this.intervalBegin < this.intervalEnd) {
            return now >= this.intervalBegin && now < this.intervalEnd;
        }
        return now >= this.intervalBegin || now < this.intervalEnd;
    }

    public final LXPattern setAutoCycleEligible(boolean eligible) {
        this.enabled.setValue(eligible);
        return this;
    }

    public final LXPattern toggleAutoCycleEligible() {
        this.enabled.toggle();
        return this;
    }

    public final boolean isAutoCycleEligible() {
        return this.enabled.isOn() && (!this.hasInterval() || this.isInInterval());
    }

    public void initCompositeDamping(boolean wasActivePattern) {
        boolean isEnabled = this.enabled.isOn();
        double d = this.compositeDampingLevel = isEnabled ? 1.0 : 0.0;
        if (isEnabled && !wasActivePattern) {
            this.onActive();
        } else if (!isEnabled && wasActivePattern) {
            this.onInactive();
        }
    }

    public void updateCompositeDamping(double deltaMs, boolean dampingOn, double dampingTimeSecs) {
        boolean isEnabled = this.enabled.isOn();
        if (!dampingOn) {
            this.compositeDampingLevel = isEnabled ? 1.0 : 0.0;
        } else if (isEnabled) {
            if (this.compositeDampingLevel < 1.0) {
                if (this.compositeDampingLevel == 0.0) {
                    this.onActive();
                }
                this.compositeDampingLevel = LXUtils.min(1.0, this.compositeDampingLevel + deltaMs / (dampingTimeSecs * 1000.0));
            }
        } else if (this.compositeDampingLevel > 0.0) {
            this.compositeDampingLevel = LXUtils.max(0.0, this.compositeDampingLevel - deltaMs / (dampingTimeSecs * 1000.0));
            if (this.compositeDampingLevel == 0.0) {
                this.onInactive();
            }
        }
    }

    public double getCompositeDampingLevel() {
        return this.compositeDampingLevel;
    }

    public final LXPattern addEffect(LXEffect effect) {
        return this.addEffect(effect, -1);
    }

    public final LXPattern addEffect(LXEffect effect, int index) {
        if (index > this.mutableEffects.size()) {
            throw new IllegalArgumentException("Illegal effect index: " + index);
        }
        if (index < 0) {
            index = this.mutableEffects.size();
        }
        this.mutableEffects.add(index, effect);
        effect.setPattern(this);
        this._reindexEffects();
        for (Listener listener : this.listeners) {
            listener.effectAdded(this, effect);
        }
        return this;
    }

    public final LXPattern removeEffect(LXEffect effect) {
        int index = this.mutableEffects.indexOf(effect);
        if (index >= 0) {
            effect.setIndex(-1);
            this.mutableEffects.remove(index);
            while (index < this.mutableEffects.size()) {
                this.mutableEffects.get(index).setIndex(index);
                ++index;
            }
            for (Listener listener : this.listeners) {
                listener.effectRemoved(this, effect);
            }
            effect.dispose();
        }
        return this;
    }

    public LXPattern reloadEffect(LXEffect effect) {
        if (!this.effects.contains(effect)) {
            throw new IllegalStateException("Cannot reload effect not on a pattern");
        }
        int index = effect.getIndex();
        JsonObject effectObj = new JsonObject();
        effect.save(this.getLX(), effectObj);
        this.removeEffect(effect);
        this.loadEffect(effectObj, index);
        return this;
    }

    private void _reindexEffects() {
        int i = 0;
        for (LXEffect e : this.mutableEffects) {
            e.setIndex(i++);
        }
    }

    public LXPattern moveEffect(LXEffect effect, int index) {
        if (index < 0 || index >= this.mutableEffects.size()) {
            throw new IllegalArgumentException("Cannot move effect to invalid index: " + index);
        }
        if (!this.mutableEffects.contains(effect)) {
            throw new IllegalStateException("Cannot move effect that is not on pattern: " + this + " " + effect);
        }
        this.mutableEffects.remove(effect);
        this.mutableEffects.add(index, effect);
        this._reindexEffects();
        for (Listener listener : this.listeners) {
            listener.effectMoved(this, effect);
        }
        return this;
    }

    public final List<LXEffect> getEffects() {
        return this.effects;
    }

    public LXEffect getEffect(int i) {
        return this.effects.get(i);
    }

    public LXEffect getEffect(String label) {
        for (LXEffect effect : this.effects) {
            if (!effect.getLabel().equals(label)) continue;
            return effect;
        }
        return null;
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        if (path.equals(PATH_EFFECT)) {
            String effectId = parts[index + 1];
            if (effectId.matches("\\d+")) {
                return this.effects.get(Integer.parseInt(effectId) - 1).handleOscMessage(message, parts, index + 2);
            }
            for (LXEffect effect : this.effects) {
                if (!effect.getOscLabel().equals(effectId)) continue;
                return effect.handleOscMessage(message, parts, index + 2);
            }
            LXOscEngine.error("Pattern " + this.getLabel() + " does not have effect at path: " + effectId + " (" + message + ")");
            return false;
        }
        return super.handleOscMessage(message, parts, index);
    }

    @Override
    protected final void onLoop(double deltaMs) {
        if (!this.isActive) {
            this.isActive = true;
            this.onActive();
        }
        long runStart = System.nanoTime();
        this.runMs += deltaMs;
        this.run(deltaMs);
        this.profiler.runNanos = System.nanoTime() - runStart;
        long effectStart = System.nanoTime();
        if (!this.mutableEffects.isEmpty()) {
            for (LXEffect effect : this.mutableEffects) {
                effect.setBuffer(this.getBuffer());
                effect.setModel(effect.getModelView());
                effect.loop(deltaMs);
            }
        }
        this.profiler.effectNanos = System.nanoTime() - effectStart;
    }

    protected abstract void run(double var1);

    public final void activate(LXMixerEngine.PatternFriendAccess lock) {
        if (lock == null) {
            throw new IllegalStateException("Only the LXMixerEngine may call LXPattern.activate()");
        }
        this._activate();
    }

    private void _activate() {
    }

    public final void deactivate(LXMixerEngine.PatternFriendAccess lock) {
        if (lock == null) {
            throw new IllegalStateException("Only the LXMixerEngine may call LXPattern.activate()");
        }
        this._deactivate();
    }

    private void _deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.onInactive();
        }
    }

    protected void onActive() {
    }

    protected void onInactive() {
    }

    public void onTransitionStart() {
    }

    public void onTransitionEnd() {
    }

    @Override
    public void midiDispatch(LXShortMessage message) {
        super.midiDispatch(message);
        for (LXEffect effect : this.effects) {
            effect.midiDispatch(message);
        }
    }

    private void removeEffects() {
        for (int i = this.mutableEffects.size() - 1; i >= 0; --i) {
            this.removeEffect(this.mutableEffects.get(i));
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_EFFECTS, (JsonElement)LXSerializable.Utils.toArray(lx, this.mutableEffects));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.removeEffects();
        if (obj.has(KEY_EFFECTS)) {
            JsonArray effectsArray = obj.getAsJsonArray(KEY_EFFECTS);
            for (JsonElement effectElement : effectsArray) {
                JsonObject effectObj = (JsonObject)effectElement;
                this.loadEffect(effectObj, -1);
            }
        }
        super.load(lx, obj);
        this.compositeDampingLevel = this.enabled.isOn() ? 1.0 : 0.0;
    }

    private LXEffect loadEffect(JsonObject effectObj, int index) {
        LXEffect effect;
        String effectClass = effectObj.get("class").getAsString();
        try {
            effect = this.lx.instantiateEffect(effectClass);
        }
        catch (LX.InstantiationException x) {
            LX.error("Using placeholder class for missing effect: " + effectClass);
            effect = new LXEffect.Placeholder(this.lx, x);
            this.lx.pushError(x, effectClass + " could not be loaded. " + x.getMessage());
        }
        effect.load(this.lx, effectObj);
        this.addEffect(effect, index);
        return effect;
    }

    @Override
    public void dispose() {
        this.removeEffects();
        this.enabled.removeListener(this.onEnabled);
        this.compositeMode.removeListener(this.onCompositeMode);
        super.dispose();
    }

    public class Profiler {
        public long runNanos = 0L;
        public long effectNanos = 0L;
    }

    public static interface Listener {
        public void effectAdded(LXPattern var1, LXEffect var2);

        public void effectRemoved(LXPattern var1, LXEffect var2);

        public void effectMoved(LXPattern var1, LXEffect var2);
    }

    public static class Placeholder
    extends LXPattern
    implements LXComponent.Placeholder {
        private final LX.InstantiationException instantiationException;
        private String placeholderClassName;
        private JsonObject patternObj = null;

        public Placeholder(LX lx, LX.InstantiationException instantiationException) {
            super(lx);
            this.instantiationException = instantiationException;
        }

        @Override
        public String getPlaceholderTypeName() {
            return "Pattern";
        }

        @Override
        public String getPlaceholderClassName() {
            return this.placeholderClassName;
        }

        @Override
        public LX.InstantiationException getInstantiationException() {
            return this.instantiationException;
        }

        @Override
        public void save(LX lx, JsonObject object) {
            super.save(lx, object);
            if (this.patternObj != null) {
                for (Map.Entry entry : this.patternObj.entrySet()) {
                    object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        @Override
        public void load(LX lx, JsonObject object) {
            super.load(lx, object);
            this.placeholderClassName = object.get("class").getAsString();
            this.patternObj = object;
        }

        @Override
        protected void run(double deltaMs) {
        }
    }
}

