/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.color.LXColor;
import heronarts.lx.model.GridModel;
import heronarts.lx.pattern.LXModelPattern;
import heronarts.lx.utils.LXUtils;
import java.util.HashMap;

@Deprecated
@LXCategory(value="Form")
public class LifePattern
extends LXModelPattern<GridModel> {
    private CellState[] state;
    private CellState[] newState;
    private int spawnCounter = 0;
    private final HashMap<String, Integer> stateCount = new HashMap();

    public LifePattern(LX lx) {
        super(lx);
        this.state = new CellState[((GridModel)this.model).size];
        this.newState = new CellState[((GridModel)this.model).size];
        this.spawn();
    }

    private boolean isLiveState(CellState state) {
        return state == CellState.BIRTHING || state == CellState.ALIVE;
    }

    private void respawn() {
        boolean anyAlive = false;
        for (int i = 0; i < this.state.length; ++i) {
            if (!this.isLiveState(this.state[i])) continue;
            anyAlive = true;
            this.state[i] = CellState.DYING;
        }
        this.spawnCounter = anyAlive ? 2 : 1;
    }

    private void spawn() {
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = LXUtils.random(0.0, 100.0) > 70.0 ? CellState.BIRTHING : CellState.DEAD;
        }
    }

    private int neighborsAlive(int i) {
        int x = i % ((GridModel)this.model).width;
        int y = i / ((GridModel)this.model).width;
        return this.isAlive(x - 1, y - 1) + this.isAlive(x, y - 1) + this.isAlive(x + 1, y - 1) + this.isAlive(x - 1, y) + this.isAlive(x + 1, y) + this.isAlive(x - 1, y + 1) + this.isAlive(x, y + 1) + this.isAlive(x + 1, y + 1);
    }

    private int isAlive(int x, int y) {
        if (x < 0 || x >= ((GridModel)this.model).width) {
            return 0;
        }
        if (y < 0 || y >= ((GridModel)this.model).height) {
            return 0;
        }
        int idx = x + y * ((GridModel)this.model).width;
        if (this.isLiveState(this.state[idx])) {
            return 1;
        }
        return 0;
    }

    private void transition() {
        block4: for (int i = 0; i < this.state.length; ++i) {
            int nA = this.neighborsAlive(i);
            switch (this.state[i]) {
                case DEAD: 
                case DYING: {
                    this.newState[i] = nA == 3 ? CellState.BIRTHING : CellState.DEAD;
                    continue block4;
                }
                case ALIVE: 
                case BIRTHING: {
                    this.newState[i] = nA == 2 || nA == 3 ? CellState.ALIVE : CellState.DYING;
                }
            }
        }
        CellState[] tmp = this.state;
        this.state = this.newState;
        this.newState = tmp;
        String stateSerial = "";
        for (int i = 0; i < this.state.length; ++i) {
            stateSerial = stateSerial + (this.isLiveState(this.state[i]) ? "1" : "0");
        }
        Integer count = 0;
        if (this.stateCount.containsKey(stateSerial)) {
            count = this.stateCount.get(stateSerial);
        }
        if (count.equals(3)) {
            this.stateCount.clear();
            this.respawn();
        } else {
            this.stateCount.put(stateSerial, count + 1);
        }
    }

    @Override
    public void run(double deltaMs) {
        if (this.lx.engine.tempo.beat()) {
            if (this.spawnCounter > 0 && --this.spawnCounter == 0) {
                this.spawn();
            } else {
                this.transition();
            }
        }
        double basis = this.lx.engine.tempo.basis();
        for (int i = 0; i < ((GridModel)this.model).size; ++i) {
            double b = 0.0;
            switch (this.state[i]) {
                case ALIVE: {
                    b = 100.0;
                    break;
                }
                case BIRTHING: {
                    b = basis * 100.0;
                    break;
                }
                case DEAD: {
                    b = 0.0;
                    break;
                }
                case DYING: {
                    b = 100.0 * (1.0 - basis);
                }
            }
            this.colors[i] = LXColor.gray(b);
        }
    }

    private static enum CellState {
        DEAD,
        BIRTHING,
        ALIVE,
        DYING;

    }
}

