/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern.color;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.color.GradientUtils;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXDynamicColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.transform.LXParameterizedMatrix;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Color")
public class GradientPattern
extends LXPattern
implements GradientUtils.GradientFunction {
    public final EnumParameter<ColorMode> colorMode = new EnumParameter<ColorMode>("Color Mode", ColorMode.LINKED).setDescription("Which source the gradient selects colors from");
    public final EnumParameter<GradientUtils.BlendMode> blendMode = new EnumParameter<GradientUtils.BlendMode>("Blend Mode", GradientUtils.BlendMode.HSV).setDescription("How to blend between colors in the gradient");
    public final ColorParameter fixedColor = new ColorParameter("Fixed", -65536).setDescription("Fixed color to start the gradient from");
    public final ColorParameter secondaryColor = new ColorParameter("Secondary", -65536).setDescription("Secondary color that the gradient blends to");
    public final DiscreteParameter paletteIndex = new LXPalette.IndexSelector("Index").setDescription("Which index in the palette to start from");
    public final DiscreteParameter paletteStops = new DiscreteParameter("Stops", 5, 2, 6).setDescription("How many color stops to use in the palette");
    public final CompoundParameter gradient = new CompoundParameter("Amount", 0.0, -1.0, 1.0).setDescription("Amount of color gradient").setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter gradientRange = new CompoundParameter("Range", 360.0, 0.0, 3600.0).setUnits(LXParameter.Units.DEGREES).setDescription("Range of total possible color hue gradient");
    public final CompoundParameter saturationRange = new CompoundParameter("Saturation Range", 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Range of total possible saturation gradient");
    public final CompoundParameter brightnessRange = new CompoundParameter("Brightness Range", 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Range of total possible brightness gradient");
    public final EnumParameter<CoordinateMode> xMode = new EnumParameter<CoordinateMode>("X Mode", CoordinateMode.NORMAL).setDescription("Which coordinate mode the X-dimension uses");
    public final EnumParameter<CoordinateMode> yMode = new EnumParameter<CoordinateMode>("Y Mode", CoordinateMode.NORMAL).setDescription("Which coordinate mode the Y-dimension uses");
    public final EnumParameter<CoordinateMode> zMode = new EnumParameter<CoordinateMode>("Z Mode", CoordinateMode.NORMAL).setDescription("Which coordinate mode the Z-dimension uses");
    public final CompoundParameter xAmount = new CompoundParameter("X-Amt", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the amount of hue spread on the X axis").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter yAmount = new CompoundParameter("Y-Amt", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the amount of hue spread on the Y axis").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter zAmount = new CompoundParameter("Z-Amt", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the amount of hue spread on the Z axis").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter xOffset = new CompoundParameter("X-Off", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the offset of the hue spread point on the X axis").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter yOffset = new CompoundParameter("Y-Off", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the offset of the hue spread point on the Y axis").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter zOffset = new CompoundParameter("Z-Off", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the offset of the hue spread point on the Z axis").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final BooleanParameter rotate = new BooleanParameter("Rotate", false).setDescription("Whether to rotate the geometry");
    public final CompoundParameter yaw = new CompoundParameter("Yaw", 0.0, 360.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setDescription("Yaw rotation");
    public final CompoundParameter pitch = new CompoundParameter("Pitch", 0.0, 360.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setDescription("Pitch rotation");
    public final CompoundParameter roll = new CompoundParameter("Roll", 0.0, 360.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setDescription("Roll rotation");
    private final LXParameterizedMatrix transform = new LXParameterizedMatrix();
    private final GradientUtils.ColorStops colorStops = new GradientUtils.ColorStops();

    public GradientPattern(LX lx) {
        super(lx);
        this.addParameter("xAmount", this.xAmount);
        this.addParameter("yAmount", this.yAmount);
        this.addParameter("zAmount", this.zAmount);
        this.addParameter("xOffset", this.xOffset);
        this.addParameter("yOffset", this.yOffset);
        this.addParameter("zOffset", this.zOffset);
        this.addParameter("colorMode", this.colorMode);
        this.addParameter("blendMode", this.blendMode);
        this.addParameter("gradient", this.gradient);
        this.addParameter("fixedColor", this.fixedColor);
        this.addParameter("xMode", this.xMode);
        this.addParameter("yMode", this.yMode);
        this.addParameter("zMode", this.zMode);
        this.addParameter("paletteIndex", this.paletteIndex);
        this.addParameter("paletteStops", this.paletteStops);
        this.addParameter("gradientRange", this.gradientRange);
        this.addParameter("saturationRange", this.saturationRange);
        this.addParameter("brightnessRange", this.brightnessRange);
        this.addTransformParameter("rotate", this.rotate);
        this.addTransformParameter("yaw", this.yaw);
        this.addTransformParameter("pitch", this.pitch);
        this.addTransformParameter("roll", this.roll);
    }

    private void addTransformParameter(String key, LXParameter parameter) {
        this.addParameter(key, parameter);
        this.transform.addParameter(parameter);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (this.gradient == p || this.gradientRange == p || this.saturationRange == p || this.brightnessRange == p || this.colorMode == p || this.paletteIndex == p || this.fixedColor.hue == p || this.fixedColor.saturation == p || this.fixedColor.brightness == p) {
            this.setSecondaryColor();
        }
    }

    public LXDynamicColor getLinkedColor() {
        return this.lx.engine.palette.getSwatchColor(this.paletteIndex.getValuei() - 1);
    }

    private void setSecondaryColor() {
        double gradient = this.gradient.getValue();
        double hueGradient = gradient * this.gradientRange.getValue();
        double satGradient = gradient * this.saturationRange.getValue();
        double brtGradient = gradient * this.brightnessRange.getValue();
        switch (this.colorMode.getEnum()) {
            case FIXED: {
                this.secondaryColor.setColor(LXColor.hsb(this.fixedColor.hue.getValue() + hueGradient, LXUtils.constrain(this.fixedColor.saturation.getValue() + satGradient, 0.0, 100.0), LXUtils.constrain(this.fixedColor.brightness.getValue() + brtGradient, 0.0, 100.0)));
                break;
            }
            case LINKED: {
                LXDynamicColor linked = this.getLinkedColor();
                int c = linked.getColor();
                this.secondaryColor.setColor(LXColor.hsb(linked.getHue() + hueGradient, LXUtils.constrain((double)LXColor.s(c) + satGradient, 0.0, 100.0), LXUtils.constrain((double)LXColor.b(c) + brtGradient, 0.0, 100.0)));
                break;
            }
        }
    }

    private void setColorStops() {
        float gradientf = this.gradient.getValuef();
        float huef = gradientf * this.gradientRange.getValuef();
        float satf = gradientf * this.saturationRange.getValuef();
        float brtf = gradientf * this.brightnessRange.getValuef();
        switch (this.colorMode.getEnum()) {
            case FIXED: {
                this.colorStops.stops[0].set(this.fixedColor);
                this.colorStops.stops[1].set(this.fixedColor, huef, satf, brtf);
                this.colorStops.setNumStops(2);
                break;
            }
            case LINKED: {
                LXDynamicColor swatchColor = this.getLinkedColor();
                this.colorStops.stops[0].set(swatchColor);
                this.colorStops.stops[1].set(swatchColor, huef, satf, brtf);
                this.colorStops.setNumStops(2);
                this.setSecondaryColor();
                break;
            }
            case PALETTE: {
                this.colorStops.setPaletteGradient(this.lx.engine.palette, this.paletteIndex.getValuei() - 1, this.paletteStops.getValuei());
            }
        }
    }

    @Override
    public int getGradientColor(float lerp) {
        return this.colorStops.getColor(lerp, this.blendMode.getEnum().function);
    }

    @Override
    public void run(double deltaMs) {
        this.setColorStops();
        float xAmount = this.xAmount.getValuef();
        float yAmount = this.yAmount.getValuef();
        float zAmount = this.zAmount.getValuef();
        float total = Math.abs(xAmount) + Math.abs(yAmount) + Math.abs(zAmount);
        if (total > 1.0f) {
            xAmount /= total;
            yAmount /= total;
            zAmount /= total;
        }
        float xOffset = this.xOffset.getValuef();
        float yOffset = this.yOffset.getValuef();
        float zOffset = this.zOffset.getValuef();
        CoordinateMode xMode = this.xMode.getEnum();
        CoordinateMode yMode = this.yMode.getEnum();
        CoordinateMode zMode = this.zMode.getEnum();
        CoordinateFunction xFunction = xAmount < 0.0f ? xMode.invert : xMode.function;
        CoordinateFunction yFunction = yAmount < 0.0f ? yMode.invert : yMode.function;
        CoordinateFunction zFunction = zAmount < 0.0f ? zMode.invert : zMode.function;
        GradientUtils.BlendFunction blendFunction = this.blendMode.getEnum().function;
        if (this.rotate.isOn()) {
            this.transform.update(matrix -> matrix.translate(0.5f, 0.5f, 0.5f).rotateZ((float)Math.toRadians(-this.roll.getValue())).rotateX((float)Math.toRadians(-this.pitch.getValue())).rotateY((float)Math.toRadians(-this.yaw.getValue())).translate(-0.5f, -0.5f, -0.5f));
            for (LXPoint p : this.model.points) {
                float xn = this.transform.xn(p);
                float yn = this.transform.yn(p);
                float zn = this.transform.zn(p);
                float lerp = (float)(this.colorStops.numStops - 1) * LXUtils.clampf(xAmount * xFunction.getCoordinate(p, xn, xOffset) + yAmount * yFunction.getCoordinate(p, yn, yOffset) + zAmount * zFunction.getCoordinate(p, zn, zOffset), 0.0f, 1.0f);
                int stop = (int)Math.floor(lerp);
                this.colors[p.index] = blendFunction.blend(this.colorStops.stops[stop], this.colorStops.stops[stop + 1], lerp - (float)stop);
            }
        } else {
            for (LXPoint p : this.model.points) {
                float lerp = (float)(this.colorStops.numStops - 1) * LXUtils.clampf(xAmount * xFunction.getCoordinate(p, p.xn, xOffset) + yAmount * yFunction.getCoordinate(p, p.yn, yOffset) + zAmount * zFunction.getCoordinate(p, p.zn, zOffset), 0.0f, 1.0f);
                int stop = (int)Math.floor(lerp);
                this.colors[p.index] = blendFunction.blend(this.colorStops.stops[stop], this.colorStops.stops[stop + 1], lerp - (float)stop);
            }
        }
    }

    public static enum ColorMode {
        FIXED("Fixed"),
        LINKED("Linked"),
        PALETTE("Palette");

        public final String label;

        private ColorMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum CoordinateMode {
        NORMAL("Normal", (p, normalized, offset) -> normalized - offset),
        CENTER("Center", (p, normalized, offset) -> 2.0f * Math.abs(normalized - (0.5f + offset * 0.5f))),
        RADIAL("Radial", (p, normalized, offset) -> p.rcn - offset);

        public final String name;
        public final CoordinateFunction function;
        public final CoordinateFunction invert;

        private CoordinateMode(String name, CoordinateFunction function) {
            this.name = name;
            this.function = function;
            this.invert = (p, normalized, offset) -> function.getCoordinate(p, normalized, offset) - 1.0f;
        }

        public String toString() {
            return this.name;
        }
    }

    private static interface CoordinateFunction {
        public float getCoordinate(LXPoint var1, float var2, float var3);
    }
}

