/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern.strip;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.Tempo;
import heronarts.lx.color.LXColor;
import heronarts.lx.model.LXPoint;
import heronarts.lx.modulator.LXWaveshape;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Strip")
public class ChasePattern
extends LXPattern {
    private static final LXWaveshape[] WAVESHAPES = new LXWaveshape[]{LXWaveshape.SIN, LXWaveshape.TRI, LXWaveshape.UP, LXWaveshape.DOWN};
    public final ObjectParameter<LXWaveshape> waveshape = new ObjectParameter<LXWaveshape>("Waveshape", WAVESHAPES).setDescription("What waveshape to use");
    public final CompoundParameter skew = new CompoundParameter("Skew", 0.0, -1.0, 1.0).setDescription("Sets a skew coefficient for the waveshape").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter exp = new CompoundParameter("Exp", 0.0, -1.0, 1.0).setDescription("Applies exponential scaling to the waveshape").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final DiscreteParameter minChunk = new DiscreteParameter("Min Chunk", 2, 2, 100).setDescription("Minimum swarm chunk size");
    public final DiscreteParameter maxChunk = new DiscreteParameter("Max Chunk", 100, 10, 1000).setDescription("Maximum swarm chunk size");
    public final CompoundParameter chunkSize = new CompoundParameter("Chunk Size", 50.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Chunk size within range");
    public final CompoundParameter shift = new CompoundParameter("Shift", 0.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Amount the position of motion is shifted on each chunk");
    public final BoundedParameter shiftRange = new BoundedParameter("Shift Range", 100.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Maximum range of the shift knob");
    public final BooleanParameter interlace = new BooleanParameter("Interlace", false).setDescription("Whether to interlace opposite chase direction every other pixel");
    public final BooleanParameter alternateChunk = new BooleanParameter("Alternate", false).setDescription("Whether to alternate chase direction every other chunk");
    public final EnumParameter<WrapMode> wrap = new EnumParameter<WrapMode>("Wrap", WrapMode.ABS).setDescription("Whether to wrap distance calculations within chunk");
    public final CompoundParameter speed = new CompoundParameter("Speed", 50.0, -100.0, 100.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT).setDescription("Speed of chase motion");
    public final BoundedParameter speedRange = new BoundedParameter("Range", 1.0, 0.0, 10.0).setUnits(LXParameter.Units.HERTZ).setDescription("Maximum range of the speed control in Hz");
    public final BooleanParameter tempoSync = new BooleanParameter("Sync", false).setDescription("Whether this modulator syncs to a tempo");
    public final EnumParameter<Tempo.Division> tempoDivision = new EnumParameter<Tempo.Division>("Division", Tempo.Division.QUARTER).setDescription("Tempo division when in sync mode");
    public final BooleanParameter reverse = new BooleanParameter("Reverse", false).setDescription("Whether to reverse the direction of motion");
    public final CompoundParameter size = new CompoundParameter("Size", 50.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Size of core motion");
    public final CompoundParameter fade = new CompoundParameter("Fade", 50.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Fade size of motion");
    public final CompoundParameter level = new CompoundParameter("Level", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Output level");
    public final CompoundParameter invert = new CompoundParameter("Invert", 0.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Invert the levels");
    public final BooleanParameter swarmOn = new BooleanParameter("Swarm-On").setDescription("Whether the swarming effect is on");
    public final CompoundParameter swarmX = new CompoundParameter("X", 0.5).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Swarm center X position");
    public final CompoundParameter swarmY = new CompoundParameter("Y", 0.5).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Swarm center Y position");
    public final CompoundParameter swarmSize = new CompoundParameter("Size", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Swarm strength");
    public final CompoundParameter swarmFade = new CompoundParameter(">Fade", 50.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("How much the swarm affects the fade shape");
    public final CompoundParameter swarmBrightness = new CompoundParameter(">Brt", 50.0, -100.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("How much the swarm affects the brightness");
    public final CompoundParameter swarmPolarity = new CompoundParameter("Polarity", 0.0).setDescription("Swarm polarity");
    private double basis = 0.0;

    public ChasePattern(LX lx) {
        super(lx);
        this.addParameter("minChunk", this.minChunk);
        this.addParameter("maxChunk", this.maxChunk);
        this.addParameter("chunkSize", this.chunkSize);
        this.addParameter("shift", this.shift);
        this.addParameter("shiftRange", this.shiftRange);
        this.addLegacyParameter("alternate", this.interlace);
        this.addParameter("interlace", this.interlace);
        this.addParameter("alternateChunk", this.alternateChunk);
        this.addParameter("waveshape", this.waveshape);
        this.addParameter("skew", this.skew);
        this.addParameter("exp", this.exp);
        this.addParameter("speed", this.speed);
        this.addParameter("speedRange", this.speedRange);
        this.addParameter("tempoSync", this.tempoSync);
        this.addParameter("tempoDivision", this.tempoDivision);
        this.addParameter("reverse", this.reverse);
        this.addParameter("wrap", this.wrap);
        this.addParameter("size", this.size);
        this.addParameter("fade", this.fade);
        this.addParameter("level", this.level);
        this.addParameter("invert", this.invert);
        this.addParameter("swarmOn", this.swarmOn);
        this.addParameter("swarmX", this.swarmX);
        this.addParameter("swarmY", this.swarmY);
        this.addParameter("swarmSize", this.swarmSize);
        this.addParameter("swarmFade", this.swarmFade);
        this.addParameter("swarmBrightness", this.swarmBrightness);
        this.addParameter("swarmPolarity", this.swarmPolarity);
        this.setRemoteControls(this.chunkSize, this.shift, this.size, this.fade, this.invert, this.swarmOn, this.swarmX, this.swarmY, this.swarmSize, this.swarmFade, this.swarmBrightness);
    }

    @Override
    protected void run(double deltaMs) {
        double expPower;
        double skew;
        double skewPower;
        this.basis = this.tempoSync.isOn() ? this.lx.engine.tempo.getBasis(this.tempoDivision.getEnum()) : (this.basis += deltaMs * 0.001 * this.speed.getValue() * this.speedRange.getValue() * 0.01);
        double basis = (float)(this.basis - Math.floor(this.basis));
        if (this.reverse.isOn()) {
            basis = (1.0 - basis) % 1.0;
        }
        double d = skewPower = (skew = this.skew.getValue()) >= 0.0 ? 1.0 + 3.0 * skew : 1.0 / (1.0 - 3.0 * skew);
        if (skewPower != 1.0) {
            basis = Math.pow(basis, skewPower);
        }
        double wave = this.waveshape.getObject().compute(basis);
        double exp = this.exp.getValue();
        double d2 = expPower = exp >= 0.0 ? 1.0 + 3.0 * exp : 1.0 / (1.0 - 3.0 * exp);
        if (expPower != 1.0) {
            wave = Math.pow(wave, expPower);
        }
        float chunkSize = LXUtils.lerpf(this.minChunk.getValuef(), this.maxChunk.getValuef(), this.chunkSize.getValuef() * 0.01f);
        int chunkSizei = (int)chunkSize;
        float motion = (float)wave * chunkSize;
        float size = this.size.getValuef() * 0.01f;
        float fade = this.fade.getValuef() * 0.01f;
        float invert = this.invert.getValuef() * 0.01f;
        float sizePixels = chunkSize * size;
        float fadePixels = chunkSize * fade;
        boolean interlace = this.interlace.isOn();
        boolean alternateChunk = this.alternateChunk.isOn();
        WrapMode wrap = this.wrap.getEnum();
        boolean swarmOn = this.swarmOn.isOn();
        float swarmSize = 0.01f + this.swarmSize.getValuef();
        float swarmX = this.swarmX.getValuef();
        float swarmY = this.swarmY.getValuef();
        float swarmFade = this.swarmFade.getValuef() * 0.01f;
        float swarmFadeAbs = Math.abs(swarmFade);
        float swarmBrightness = this.swarmBrightness.getValuef() * 0.01f;
        float swarmBrightnessAbs = Math.abs(swarmBrightness);
        float shift = this.shift.getValuef() * 0.01f * this.shiftRange.getValuef() * 0.01f * chunkSize;
        float level = this.level.getValuef();
        float minSizePixels = LXUtils.lerpf(0.0f, chunkSize + sizePixels, invert);
        float minFadePixels = LXUtils.lerpf(0.0f, chunkSize + sizePixels, invert);
        if (swarmFade < 0.0f) {
            minSizePixels = chunkSize - minSizePixels;
            minSizePixels = chunkSize - minFadePixels;
        }
        boolean even = false;
        int i = 0;
        for (LXPoint p : this.model.points) {
            float swarmBrightnessLerp;
            boolean evenChunk;
            int chunkIndex = i / chunkSizei;
            float pos = (float)i % chunkSize;
            if ((even && interlace) ^ (evenChunk = chunkIndex % 2 == 0) & alternateChunk) {
                pos = (chunkSize - pos) % chunkSize;
            }
            float motion2 = (motion + (float)chunkIndex * shift) % chunkSize;
            float dist = wrap.distance.compute(pos, motion2, chunkSize);
            float swarmDistance = swarmOn ? LXUtils.distf(swarmX, swarmY, p.xn, p.yn) / swarmSize : 0.0f;
            float swarmFadeLerp = LXUtils.minf(1.0f, swarmDistance * swarmFadeAbs);
            float sizePixels2 = LXUtils.lerpf(sizePixels, minSizePixels, swarmFadeLerp);
            float fadePixels2 = LXUtils.lerpf(fadePixels, minFadePixels, swarmFadeLerp);
            float falloff = 100.0f / fadePixels2;
            float btop = LXUtils.constrainf((sizePixels2 + fadePixels2 - 1.0f) * 100.0f, 0.0f, 100.0f);
            float b = dist <= sizePixels2 ? btop : LXUtils.maxf(0.0f, btop - falloff * (dist - sizePixels2));
            b = LXUtils.lerpf(b, 100.0f - b, invert);
            if (swarmBrightness >= 0.0f) {
                swarmBrightnessLerp = LXUtils.constrainf(swarmDistance * swarmBrightnessAbs, 0.0f, 1.0f);
                b = LXUtils.lerpf(b, 0.0f, swarmBrightnessLerp);
            } else {
                swarmBrightnessLerp = LXUtils.constrainf((1.414f - swarmDistance) * swarmBrightnessAbs, 0.0f, 1.0f);
                b = LXUtils.lerpf(b, 0.0f, swarmBrightnessLerp);
            }
            this.colors[p.index] = LXColor.gray(level * b);
            ++i;
            even = !even;
        }
    }

    public static enum WrapMode {
        ABS("Abs", (pos, motion, chunkSize) -> 2.0f * LXUtils.wrapdistf(pos, motion, chunkSize)),
        POS("Pos", (pos, motion, chunkSize) -> pos > motion ? pos - motion : pos + chunkSize - motion),
        NEG("Neg", (pos, motion, chunkSize) -> motion > pos ? motion - pos : motion + chunkSize - pos),
        CLIP("Clip", (pos, motion, chunkSize) -> 2.0f * Math.abs(pos - motion)),
        CLIP_POS("Clip+", (pos, motion, chunkSize) -> pos > motion ? pos - motion : Float.MAX_VALUE),
        CLIP_NEG("Clip-", (pos, motion, chunkSize) -> motion > pos ? motion - pos : Float.MAX_VALUE);

        private final String label;
        public final DistanceFunction distance;

        private WrapMode(String label, DistanceFunction distance) {
            this.label = label;
            this.distance = distance;
        }

        public String toString() {
            return this.label;
        }
    }

    public static interface DistanceFunction {
        public float compute(float var1, float var2, float var3);
    }
}

