/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern.texture;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.color.GradientUtils;
import heronarts.lx.model.LXPoint;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LinearEnvelope;
import heronarts.lx.modulator.SawLFO;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;
import heronarts.lx.utils.Noise;

@LXCategory(value="Texture")
public class NoisePattern
extends LXPattern {
    public final EnumParameter<Algorithm> algorithm = new EnumParameter<Algorithm>("Algorithm", Algorithm.PERLIN);
    public final DiscreteParameter seed = new DiscreteParameter("Seed", 0, 256).setDescription("Seed value supplied to the noise function");
    public final CompoundParameter level = new CompoundParameter("Level", 50.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Midpoint brightness level for the noise generation");
    public final CompoundParameter contrast = new CompoundParameter("Contrast", 100.0, 0.0, 500.0).setExponent(2.0).setUnits(LXParameter.Units.PERCENT).setDescription("Dynamic contrast of noise generation");
    public final CompoundParameter minLevel = new CompoundParameter("Min", 0.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Minimum output level");
    public final CompoundParameter maxLevel = new CompoundParameter("Max", 100.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Maximum output level");
    public final CompoundParameter invert = new CompoundParameter("Invert", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("How much to invert the brightness output");
    public final EnumParameter<CoordinateMode> xMode = new EnumParameter<CoordinateMode>("X Mode", CoordinateMode.NORMAL).setDescription("Which coordinate mode the X-dimension uses");
    public final EnumParameter<CoordinateMode> yMode = new EnumParameter<CoordinateMode>("Y Mode", CoordinateMode.NORMAL).setDescription("Which coordinate mode the Y-dimension uses");
    public final EnumParameter<CoordinateMode> zMode = new EnumParameter<CoordinateMode>("Z Mode", CoordinateMode.NORMAL).setDescription("Which coordinate mode the Z-dimension uses");
    public final CompoundParameter xOffset = new CompoundParameter("X-Pos", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("The coordinate offset on the X-axis");
    public final CompoundParameter yOffset = new CompoundParameter("Y-Pos", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("The coordinate offset on the Y-axis");
    public final CompoundParameter zOffset = new CompoundParameter("Z-Pos", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("The coordinate offset on the Z-axis");
    public final CompoundParameter scale = new CompoundParameter("Scale", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Scale factor for the size of the noise variation");
    public final BoundedParameter minScale = new BoundedParameter("Min Scale", 1.0, 0.1, 100.0).setExponent(2.0).setDescription("Minimum scaling value for noise variation");
    public final BoundedParameter maxScale = new BoundedParameter("Max Scale", 10.0, 1.0, 1000.0).setExponent(2.0).setDescription("Maximum scaling value for noise variation");
    public final CompoundParameter xScale = new CompoundParameter("X-Scale", 1.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of scaling applied to the X-axis");
    public final CompoundParameter yScale = new CompoundParameter("Y-Scale", 1.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of scaling applied to the Y-axis");
    public final CompoundParameter zScale = new CompoundParameter("Z-Scale", 1.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of scaling applied to the Z-axis");
    public final BooleanParameter motion = new BooleanParameter("Motion", true).setDescription("Whether motion is applied to the noise");
    public final CompoundParameter motionSpeed = new CompoundParameter("Speed", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Maximum motion speed");
    public final BoundedParameter motionSpeedRange = new BoundedParameter("Speed Range", 128.0, 1.0, 256.0).setDescription("Range of the speed control");
    public final CompoundParameter xMotion = new CompoundParameter("X-Motion", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Rate of motion on the X-axis");
    public final CompoundParameter yMotion = new CompoundParameter("Y-Motion", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Rate of motion on the Y-axis");
    public final CompoundParameter zMotion = new CompoundParameter("Z-Motion", 1.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Rate of motion on the Z-axis");
    private final LinearEnvelope motionDamped = this.addModulator(new LinearEnvelope(this.motion.isOn() ? 1.0 : 0.0, 1.0, 250.0));
    private final LXModulator xModulation = this.startModulator(new SawLFO(0.0, 256.0, (LXParameter)new MotionSpeedParameter(this.xMotion)));
    private final LXModulator yModulation = this.startModulator(new SawLFO(0.0, 256.0, (LXParameter)new MotionSpeedParameter(this.yMotion)));
    private final LXModulator zModulation = this.startModulator(new SawLFO(0.0, 256.0, (LXParameter)new MotionSpeedParameter(this.zMotion)));
    public final DiscreteParameter octaves = new DiscreteParameter("Octaves", 3, 1, 9).setDescription("Number of octaves of perlin noise to sum");
    public final BoundedParameter lacunarity = new BoundedParameter("Lacunarity", 2.0, 0.0, 4.0).setDescription("Spacing between successive octaves (use exactly 2.0 for wrapping output)");
    public final BoundedParameter gain = new BoundedParameter("Gain", 0.5, 0.0, 1.0).setDescription("Relative weighting applied to each successive octave");
    public final BoundedParameter ridgeOffset = new BoundedParameter("Ridge", 0.9, 0.0, 2.0).setDescription("Used to invert the feedback ridges");
    private final GradientUtils.GrayTable invertLUT = new GradientUtils.GrayTable((LXNormalizedParameter)this.invert, 256);

    public NoisePattern(LX lx) {
        super(lx);
        this.addParameter("midpoint", this.level);
        this.addParameter("contrast", this.contrast);
        this.addParameter("minLevel", this.minLevel);
        this.addParameter("maxLevel", this.maxLevel);
        this.addParameter("invert", this.invert);
        this.addParameter("xOffset", this.xOffset);
        this.addParameter("yOffset", this.yOffset);
        this.addParameter("zOffset", this.zOffset);
        this.addParameter("scale", this.scale);
        this.addParameter("minScale", this.minScale);
        this.addParameter("maxScale", this.maxScale);
        this.addParameter("xScale", this.xScale);
        this.addParameter("yScale", this.yScale);
        this.addParameter("zScale", this.zScale);
        this.addParameter("motion", this.motion);
        this.addParameter("motionSpeed", this.motionSpeed);
        this.addParameter("motionSpeedRange", this.motionSpeedRange);
        this.addParameter("xMotion", this.xMotion);
        this.addParameter("yMotion", this.yMotion);
        this.addParameter("zMotion", this.zMotion);
        this.addParameter("algorithm", this.algorithm);
        this.addParameter("seed", this.seed);
        this.addParameter("octaves", this.octaves);
        this.addParameter("lacunarity", this.lacunarity);
        this.addParameter("gain", this.gain);
        this.addParameter("ridgeOffset", this.ridgeOffset);
        this.addParameter("xMode", this.xMode);
        this.addParameter("yMode", this.yMode);
        this.addParameter("zMode", this.zMode);
        this.setRemoteControls(this.scale, this.level, this.contrast, this.motionSpeed, this.xMotion, this.yMotion, this.zMotion, this.motionSpeedRange, this.invert, this.minLevel, this.maxLevel, this.xOffset, this.yOffset, this.zOffset);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (this.motion == p) {
            if (this.motion.isOn()) {
                this.motionDamped.setRangeFromHereTo(1.0).trigger();
            } else {
                this.motionDamped.setRangeFromHereTo(0.0).trigger();
            }
        }
    }

    @Override
    public void run(double deltaMs) {
        this.invertLUT.update();
        switch (this.algorithm.getEnum()) {
            case PERLIN: 
            case FBM: 
            case RIDGE: 
            case TURBULENCE: {
                this.runPerlin(deltaMs, this.algorithm.getEnum());
                break;
            }
            case STATIC: {
                this.runStatic(deltaMs);
            }
        }
    }

    private void runPerlin(double deltaMs, Algorithm algorithm) {
        block5: {
            float gain;
            float lacunarity;
            int octaves;
            CoordinateFunction zMode;
            CoordinateFunction yMode;
            CoordinateFunction xMode;
            float level;
            float maxLevel;
            float minLevel;
            float contrast;
            float zs;
            float ys;
            float xs;
            float zo;
            float yo;
            float xo;
            float za;
            float ya;
            float xa;
            block7: {
                block6: {
                    block4: {
                        int seed = this.seed.getValuei();
                        float scale = LXUtils.lerpf(this.minScale.getValuef(), this.maxScale.getValuef(), this.scale.getValuef());
                        xa = this.xModulation.getValuef();
                        ya = this.yModulation.getValuef();
                        za = this.zModulation.getValuef();
                        xo = this.xOffset.getValuef();
                        yo = this.yOffset.getValuef();
                        zo = this.zOffset.getValuef();
                        xs = scale * this.xScale.getValuef();
                        ys = scale * this.yScale.getValuef();
                        zs = scale * this.zScale.getValuef();
                        contrast = this.contrast.getValuef();
                        minLevel = this.minLevel.getValuef();
                        maxLevel = this.maxLevel.getValuef();
                        level = LXUtils.lerpf(minLevel, maxLevel, (this.level.getValuef() - contrast / 4.0f) * 0.01f);
                        xMode = this.xMode.getEnum().function;
                        yMode = this.yMode.getEnum().function;
                        zMode = this.zMode.getEnum().function;
                        if (!algorithm.equals((Object)Algorithm.PERLIN)) break block4;
                        for (LXPoint p : this.model.points) {
                            float xd = xMode.getCoordinate(p, p.xn, xo);
                            float yd = yMode.getCoordinate(p, p.yn, yo);
                            float zd = zMode.getCoordinate(p, p.zn, zo);
                            float b = level + contrast * Noise.stb_perlin_noise3_seed(xa + xs * xd, ya + ys * yd, za + zs * zd, 0, 0, 0, seed);
                            this.colors[p.index] = this.invertLUT.lut[(int)(2.559 * LXUtils.clamp(b, minLevel, maxLevel))];
                        }
                        break block5;
                    }
                    octaves = this.octaves.getValuei();
                    lacunarity = this.lacunarity.getValuef();
                    gain = this.gain.getValuef();
                    if (!algorithm.equals((Object)Algorithm.RIDGE)) break block6;
                    float ridgeOffset = this.ridgeOffset.getValuef();
                    for (LXPoint p : this.model.points) {
                        float xd = xMode.getCoordinate(p, p.xn, xo);
                        float yd = yMode.getCoordinate(p, p.yn, yo);
                        float zd = zMode.getCoordinate(p, p.zn, zo);
                        float b = level + contrast * Noise.stb_perlin_ridge_noise3(xa + xs * xd, ya + ys * yd, za + zs * zd, lacunarity, gain, ridgeOffset, octaves);
                        this.colors[p.index] = this.invertLUT.lut[(int)(2.559 * LXUtils.clamp(b, minLevel, maxLevel))];
                    }
                    break block5;
                }
                if (!algorithm.equals((Object)Algorithm.FBM)) break block7;
                for (LXPoint p : this.model.points) {
                    float xd = xMode.getCoordinate(p, p.xn, xo);
                    float yd = yMode.getCoordinate(p, p.yn, yo);
                    float zd = zMode.getCoordinate(p, p.zn, zo);
                    float b = level + contrast * Noise.stb_perlin_fbm_noise3(xa + xs * xd, ya + ys * yd, za + zs * zd, lacunarity, gain, octaves);
                    this.colors[p.index] = this.invertLUT.lut[(int)(2.559 * LXUtils.clamp(b, minLevel, maxLevel))];
                }
                break block5;
            }
            if (!algorithm.equals((Object)Algorithm.TURBULENCE)) break block5;
            for (LXPoint p : this.model.points) {
                float xd = xMode.getCoordinate(p, p.xn, xo);
                float yd = yMode.getCoordinate(p, p.yn, yo);
                float zd = zMode.getCoordinate(p, p.zn, zo);
                float b = level + contrast * Noise.stb_perlin_turbulence_noise3(xa + xs * xd, ya + ys * yd, za + zs * zd, lacunarity, gain, octaves);
                this.colors[p.index] = this.invertLUT.lut[(int)(2.559 * LXUtils.clamp(b, minLevel, maxLevel))];
            }
        }
    }

    private void runStatic(double deltaMs) {
        float minLevel = this.minLevel.getValuef();
        float maxLevel = this.maxLevel.getValuef();
        float level = LXUtils.lerpf(minLevel, maxLevel, this.level.getValuef() * 0.01f);
        float contrast = this.contrast.getValuef();
        for (LXPoint p : this.model.points) {
            float b = level + contrast * (-1.0f + 2.0f * (float)Math.random());
            this.colors[p.index] = this.invertLUT.lut[(int)(2.559 * LXUtils.clamp(b, minLevel, maxLevel))];
        }
    }

    public static enum Algorithm {
        PERLIN("Perlin", false),
        RIDGE("Ridge", true),
        FBM("FBM", true),
        TURBULENCE("Turbulence", true),
        STATIC("Static", false);

        private final String name;
        private boolean isPerlinFeedback;

        private Algorithm(String name, boolean isPerlinFeedback) {
            this.name = name;
            this.isPerlinFeedback = isPerlinFeedback;
        }

        public boolean isPerlinFeedback() {
            return this.isPerlinFeedback;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum CoordinateMode {
        NORMAL("Normal", (p, normalized, offset) -> normalized + offset),
        CENTER("Center", (p, normalized, offset) -> Math.abs(normalized - 0.5f * (1.0f + offset))),
        RADIAL("Radial", (p, normalized, offset) -> p.rcn + offset * normalized),
        NONE("None", (p, normalized, offset) -> 0.5f + offset);

        public final String name;
        public final CoordinateFunction function;

        private CoordinateMode(String name, CoordinateFunction function) {
            this.name = name;
            this.function = function;
        }

        public String toString() {
            return this.name;
        }
    }

    private class MotionSpeedParameter
    extends FunctionalParameter {
        private final LXParameter amount;

        private MotionSpeedParameter(LXParameter amount) {
            this.amount = amount;
        }

        @Override
        public double getValue() {
            double ms = NoisePattern.this.motionSpeed.getValue();
            return 6000000.0 / (NoisePattern.this.motionSpeedRange.getValue() * ms * Math.abs(ms) * NoisePattern.this.motionDamped.getValue() * this.amount.getValue());
        }
    }

    private static interface CoordinateFunction {
        public float getCoordinate(LXPoint var1, float var2, float var3);
    }
}

