/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.scheduler;

import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.scheduler.LXScheduler;
import java.io.File;

public class LXScheduledProject
extends LXComponent
implements LXComponent.Renamable {
    public final BooleanParameter enabled = new BooleanParameter("Enabled", false).setDescription("Whether this schedule entry is enabled");
    public final StringParameter projectFile = new StringParameter("Project").setDescription("The project file that will be opened");
    public final DiscreteParameter hours = new DiscreteParameter("Hours", 0, 24).setUnits(LXParameter.Units.CLOCK).setDescription("The hour of day the project will open on");
    public final DiscreteParameter minutes = new DiscreteParameter("Minutes", 0, 60).setUnits(LXParameter.Units.CLOCK).setDescription("The minute of hour the project will open on");
    public final DiscreteParameter seconds = new DiscreteParameter("Seconds", 0, 60).setUnits(LXParameter.Units.CLOCK).setDescription("The second of the minute the project will open on");
    private int index = 0;

    public LXScheduledProject(LXScheduler scheduler) {
        super(scheduler.getLX());
        this.setParent(scheduler);
        this.addParameter("enabled", this.enabled);
        this.addParameter("projectFile", this.projectFile);
        this.addParameter("hours", this.hours);
        this.addParameter("minutes", this.minutes);
        this.addParameter("seconds", this.seconds);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        this.lx.scheduler.dirty.setValue(true);
    }

    public void setProject(File projectFile) {
        this.projectFile.setValue(this.lx.getMediaPath(LX.Media.PROJECTS, projectFile));
        this.label.setValue(projectFile.getName());
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void open() {
        this.lx.scheduler.openEntry(this);
    }
}

