/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.snapshot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXLoopTask;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.LXClip;
import heronarts.lx.command.LXCommand;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.modulator.LinearEnvelope;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.snapshot.LXGlobalSnapshot;
import heronarts.lx.snapshot.LXSnapshot;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class LXSnapshotEngine
extends LXComponent
implements LXOscComponent,
LXLoopTask {
    private static final int NO_SNAPSHOT_INDEX = -1;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<LXGlobalSnapshot> mutableSnapshots = new ArrayList<LXGlobalSnapshot>();
    private final List<LXComponent> mutableGlobalComponents = new ArrayList<LXComponent>();
    final List<LXComponent> globalComponents = Collections.unmodifiableList(this.mutableGlobalComponents);
    public final List<LXGlobalSnapshot> snapshots = Collections.unmodifiableList(this.mutableSnapshots);
    public final BooleanParameter recallMixer = new BooleanParameter("Mixer", true).setDescription("Whether mixer settings are recalled");
    public final BooleanParameter recallPattern = new BooleanParameter("Pattern", true).setDescription("Whether pattern settings are recalled");
    public final BooleanParameter recallEffect = new BooleanParameter("Effects", true).setDescription("Whether effect settings are recalled");
    public final BooleanParameter recallModulation = new BooleanParameter("Modulation", true).setDescription("Whether global modulation settings are recalled");
    public final BooleanParameter recallMaster = new BooleanParameter("Master", true).setDescription("Whether master fader settings are recalled");
    public final BooleanParameter recallOutput = new BooleanParameter("Output", false).setDescription("Whether output settings are recalled");
    public final EnumParameter<MissingChannelMode> missingChannelMode = new EnumParameter<MissingChannelMode>("Missing Channel", MissingChannelMode.IGNORE).setDescription("How to handle channels that are not present in the snapshot");
    public final EnumParameter<ChannelMode> channelMode = new EnumParameter<ChannelMode>("Channel Mode", ChannelMode.FADE).setDescription("How to handle turning channels on/off");
    public final BooleanParameter autoCycleEnabled = new BooleanParameter("Auto-Cycle", false).setDescription("When enabled, the engine will automatically cycle through snapshots");
    public final EnumParameter<AutoCycleMode> autoCycleMode = new EnumParameter<AutoCycleMode>("Auto-Cycle Mode", AutoCycleMode.NEXT).setDescription("Mode of auto cycling");
    public final BoundedParameter autoCycleTimeSecs = new BoundedParameter("Cycle Time", 60.0, 0.1, 14400.0).setDescription("Sets the number of seconds after which the engine cycles to the next snapshot").setUnits(LXParameter.Units.SECONDS);
    public final BoundedParameter transitionTimeSecs = new BoundedParameter("Transition Time", 5.0, 0.1, 180.0).setDescription("Sets the duration of interpolated transitions between snapshots").setUnits(LXParameter.Units.SECONDS);
    public final BooleanParameter transitionEnabled = new BooleanParameter("Transitions", false).setDescription("When enabled, transitions between snapshots use interpolation");
    public final TriggerParameter triggerSnapshotCycle = new TriggerParameter("Trigger Cycle", this::doSnapshotCycle).setDescription("Triggers a snapshot change");
    private LXGlobalSnapshot inTransition = null;
    private LinearEnvelope transition = new LinearEnvelope(0.0, 1.0, (LXParameter)new FunctionalParameter(){

        @Override
        public double getValue() {
            if (((LXSnapshotEngine)LXSnapshotEngine.this).inTransition.hasCustomTransitionTime.isOn()) {
                return 1000.0 * ((LXSnapshotEngine)LXSnapshotEngine.this).inTransition.transitionTimeSecs.getValue();
            }
            return 1000.0 * LXSnapshotEngine.this.transitionTimeSecs.getValue();
        }
    });
    private double autoCycleProgress = 0.0;
    public final DiscreteParameter autoCycleCursor = new DiscreteParameter("Auto-Cycle", -1, -1, 0).setDescription("Index for the auto-cycle parameter");
    private final List<LXSnapshot.View> recallViews = new ArrayList<LXSnapshot.View>();
    public static final String PATH_SNAPSHOT = "snapshot";
    private static final String KEY_SNAPSHOTS = "snapshots";

    public LXSnapshotEngine(LX lx) {
        super(lx, "Snapshots");
        this.addArray(PATH_SNAPSHOT, this.snapshots);
        this.addParameter("recallMixer", this.recallMixer);
        this.addParameter("recallModulation", this.recallModulation);
        this.addParameter("recallPattern", this.recallPattern);
        this.addParameter("recallEffect", this.recallEffect);
        this.addParameter("recallMaster", this.recallMaster);
        this.addParameter("recallOutput", this.recallOutput);
        this.addParameter("channelMode", this.channelMode);
        this.addParameter("missingChannelMode", this.missingChannelMode);
        this.addParameter("transitionEnabled", this.transitionEnabled);
        this.addParameter("transitionTimeSecs", this.transitionTimeSecs);
        this.addParameter("autoCycleEnabled", this.autoCycleEnabled);
        this.addParameter("autoCycleMode", this.autoCycleMode);
        this.addParameter("autoCycleTimeSecs", this.autoCycleTimeSecs);
        this.addParameter("autoCycleCursor", this.autoCycleCursor);
        this.addParameter("triggerSnapshotCycle", this.triggerSnapshotCycle);
    }

    public LXSnapshotEngine registerGlobal(LXComponent component) {
        this.mutableGlobalComponents.add(component);
        return this;
    }

    @Override
    public void onParameterChanged(LXParameter parameter) {
        super.onParameterChanged(parameter);
        if (parameter == this.autoCycleEnabled) {
            this.autoCycleProgress = 0.0;
        } else if (parameter == this.transitionEnabled && !this.transitionEnabled.isOn()) {
            this.finishTransition();
        }
    }

    public LXSnapshotEngine addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXSnapshotEngine.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXSnapshotEngine.Listener: " + listener);
        }
        this.listeners.add(listener);
        return this;
    }

    public LXSnapshotEngine removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-existent LXSnapshotEngine.Listener: " + listener);
        }
        this.listeners.remove(listener);
        return this;
    }

    private void _reindexSnapshots() {
        int i = 0;
        for (LXGlobalSnapshot snapshot : this.snapshots) {
            snapshot.setIndex(i++);
        }
    }

    public LXGlobalSnapshot addSnapshot() {
        LXGlobalSnapshot snapshot = new LXGlobalSnapshot(this.lx);
        snapshot.initialize();
        snapshot.label.setValue("Snapshot-" + (this.snapshots.size() + 1));
        this.addSnapshot(snapshot);
        return snapshot;
    }

    public LXSnapshotEngine addSnapshot(LXGlobalSnapshot snapshot) {
        return this.addSnapshot(snapshot, -1);
    }

    public LXSnapshotEngine addSnapshot(LXGlobalSnapshot snapshot, int index) {
        Objects.requireNonNull(snapshot, "May not LXSnapshotEngine.addSnapshot(null)");
        if (this.snapshots.contains(snapshot)) {
            throw new IllegalStateException("May not add same snapshot instance twice: " + snapshot);
        }
        if (index < 0) {
            this.mutableSnapshots.add(snapshot);
            snapshot.setIndex(this.mutableSnapshots.size() - 1);
        } else {
            this.mutableSnapshots.add(index, snapshot);
            this._reindexSnapshots();
        }
        this.autoCycleCursor.setRange(-1, this.snapshots.size());
        if (index >= 0 && index <= this.autoCycleCursor.getValuei()) {
            this.autoCycleCursor.increment();
        }
        for (Listener listener : this.listeners) {
            listener.snapshotAdded(this, snapshot);
        }
        return this;
    }

    public LXSnapshotEngine removeSnapshot(LXGlobalSnapshot snapshot) {
        if (!this.snapshots.contains(snapshot)) {
            throw new IllegalStateException("Cannot remove snapshot that is not present: " + snapshot);
        }
        int index = this.mutableSnapshots.indexOf(snapshot);
        this.mutableSnapshots.remove(snapshot);
        this._reindexSnapshots();
        for (Listener listener : this.listeners) {
            listener.snapshotRemoved(this, snapshot);
        }
        if (index <= this.autoCycleCursor.getValuei()) {
            this.autoCycleCursor.decrement();
        }
        this.autoCycleCursor.setRange(-1, this.snapshots.size());
        snapshot.dispose();
        return this;
    }

    public LXSnapshotEngine moveSnapshot(LXGlobalSnapshot snapshot, int index) {
        if (!this.snapshots.contains(snapshot)) {
            throw new IllegalArgumentException("Cannot move snapshot not in engine: " + snapshot);
        }
        LXGlobalSnapshot autoCycleSnapshot = null;
        int auto = this.autoCycleCursor.getValuei();
        if (auto >= 0 && auto < this.snapshots.size()) {
            autoCycleSnapshot = this.snapshots.get(auto);
        }
        this.mutableSnapshots.remove(snapshot);
        this.mutableSnapshots.add(index, snapshot);
        this._reindexSnapshots();
        for (Listener listener : this.listeners) {
            listener.snapshotMoved(this, snapshot);
        }
        if (autoCycleSnapshot != null) {
            this.autoCycleCursor.setValue(this.snapshots.indexOf(autoCycleSnapshot));
        }
        return this;
    }

    public LXGlobalSnapshot getCursorSnapshot() {
        int cursorIndex = this.autoCycleCursor.getValuei();
        if (cursorIndex >= 0 && cursorIndex < this.snapshots.size()) {
            return this.snapshots.get(cursorIndex);
        }
        return null;
    }

    public boolean recall(LXGlobalSnapshot snapshot) {
        return this.recall(snapshot, null);
    }

    public boolean recall(LXGlobalSnapshot snapshot, List<LXCommand> commands) {
        if (this.inTransition == snapshot) {
            this.finishTransition();
            return false;
        }
        boolean mixer = this.recallMixer.isOn();
        boolean pattern = this.recallPattern.isOn();
        boolean effect = this.recallEffect.isOn();
        boolean modulation = this.recallModulation.isOn();
        boolean output = this.recallOutput.isOn();
        boolean master = this.recallMaster.isOn();
        boolean transition = false;
        this.autoCycleProgress = 0.0;
        if (commands != null) {
            commands.add(new LXCommand.Parameter.SetValue(this.autoCycleCursor, this.autoCycleCursor.getValuei()));
        }
        this.autoCycleCursor.setValue(snapshot.getIndex());
        this.recallViews.clear();
        this.recallViews.addAll(snapshot.views);
        if (this.transitionEnabled.isOn()) {
            transition = true;
            this.inTransition = snapshot;
        }
        if (this.missingChannelMode.getEnum() == MissingChannelMode.DISABLE) {
            for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
                if (!channel.enabled.isOn() || snapshot.hasChannelFaderView(channel)) continue;
                this.recallViews.add(snapshot.getMissingChannelView(channel));
            }
        }
        Iterator<LXSerializable> iterator = this.recallViews.iterator();
        while (iterator.hasNext()) {
            LXSnapshot.View view;
            (view = (LXSnapshot.View)iterator.next()).activeFlag = this.isValidView(view, mixer, pattern, effect, modulation, output, master);
            if (!(view = (LXSnapshot.View)iterator.next()).activeFlag) continue;
            if (transition) {
                view.startTransition();
            } else {
                view.recall();
            }
            if (commands == null) continue;
            commands.add(view.getCommand());
        }
        if (transition) {
            this.transition.trigger();
        }
        return true;
    }

    private boolean isValidView(LXSnapshot.View view, boolean mixer, boolean pattern, boolean effect, boolean modulation, boolean output, boolean master) {
        if (!view.enabled.isOn()) {
            return false;
        }
        switch (view.scope) {
            case EFFECTS: {
                return effect;
            }
            case MODULATION: {
                return modulation;
            }
            case PATTERNS: {
                return pattern;
            }
            case OUTPUT: {
                return output;
            }
            case MIXER: {
                return mixer;
            }
            case GLOBAL: {
                return true;
            }
            case MASTER: {
                return master;
            }
        }
        return false;
    }

    public double getTransitionProgress() {
        return this.inTransition != null ? this.transition.getValue() : 0.0;
    }

    public double getAutoCycleProgress() {
        return this.autoCycleProgress;
    }

    private void doSnapshotCycle() {
        switch (this.autoCycleMode.getEnum()) {
            case NEXT: {
                this.goNextSnapshot();
                break;
            }
            case RANDOM: {
                this.goRandomSnapshot();
            }
        }
    }

    @Override
    public void loop(double deltaMs) {
        if (this.inTransition != null) {
            this.transition.loop(deltaMs);
            if (this.transition.finished()) {
                this.finishTransition();
            } else {
                for (LXSnapshot.View view : this.recallViews) {
                    if (!view.activeFlag) continue;
                    view.interpolate(this.transition.getValue());
                }
            }
            this.autoCycleProgress = 0.0;
        } else if (this.autoCycleEnabled.isOn()) {
            LXGlobalSnapshot cursorSnapshot = this.getCursorSnapshot();
            double cycleSecs = cursorSnapshot != null && cursorSnapshot.hasCustomCycleTime.isOn() ? cursorSnapshot.cycleTimeSecs.getValue() : this.autoCycleTimeSecs.getValue();
            this.autoCycleProgress += deltaMs / (1000.0 * cycleSecs);
            if (this.autoCycleProgress >= 1.0) {
                this.autoCycleProgress = 1.0;
                this.doSnapshotCycle();
            }
        }
    }

    private void finishTransition() {
        if (this.inTransition != null) {
            for (LXSnapshot.View view : this.recallViews) {
                if (!view.activeFlag) continue;
                view.finishTransition();
            }
            this.inTransition = null;
        }
    }

    private void goNextSnapshot() {
        if (this.snapshots.size() <= 1) {
            return;
        }
        int startIndex = this.autoCycleCursor.getValuei();
        int nextIndex = (startIndex + 1) % this.snapshots.size();
        while (nextIndex != startIndex) {
            if (startIndex < 0) {
                startIndex = 0;
            }
            LXGlobalSnapshot next = this.snapshots.get(nextIndex);
            if (next.autoCycleEligible.isOn()) {
                this.recall(next);
                return;
            }
            nextIndex = (nextIndex + 1) % this.snapshots.size();
        }
    }

    private void goRandomSnapshot() {
        if (this.snapshots.size() <= 1) {
            return;
        }
        ArrayList<LXGlobalSnapshot> eligible = new ArrayList<LXGlobalSnapshot>();
        int autoIndex = this.autoCycleCursor.getValuei();
        for (int i = 0; i < this.snapshots.size(); ++i) {
            if (i == autoIndex) continue;
            LXGlobalSnapshot test = this.snapshots.get(i);
            if (!test.autoCycleEligible.isOn()) continue;
            eligible.add(test);
        }
        int numEligible = eligible.size();
        if (numEligible > 0) {
            LXGlobalSnapshot random = (LXGlobalSnapshot)eligible.get(LXUtils.constrain((int)LXUtils.random(0.0, numEligible), 0, numEligible - 1));
            this.recall(random);
        }
    }

    public void clear() {
        for (int i = this.snapshots.size() - 1; i >= 0; --i) {
            this.removeSnapshot(this.snapshots.get(i));
        }
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        for (LXGlobalSnapshot snapshot : this.snapshots) {
            if (!path.equals(snapshot.getOscPath())) continue;
            return snapshot.handleOscMessage(message, parts, index + 1);
        }
        return super.handleOscMessage(message, parts, index);
    }

    public List<LXSnapshot.View> findSnapshotViews(LXComponent component) {
        List<LXSnapshot.View> views = null;
        for (LXGlobalSnapshot lXGlobalSnapshot : this.snapshots) {
            views = this.findSnapshotViews(views, component, lXGlobalSnapshot);
        }
        for (LXBus lXBus : this.lx.engine.mixer.channels) {
            views = this.findSnapshotViews(views, component, lXBus);
        }
        views = this.findSnapshotViews(views, component, this.lx.engine.mixer.masterBus);
        return views;
    }

    private List<LXSnapshot.View> findSnapshotViews(List<LXSnapshot.View> views, LXComponent component, LXBus bus) {
        for (LXClip clip : bus.clips) {
            if (clip == null) continue;
            views = this.findSnapshotViews(views, component, clip.snapshot);
        }
        return views;
    }

    private List<LXSnapshot.View> findSnapshotViews(List<LXSnapshot.View> views, LXComponent component, LXSnapshot snapshot) {
        for (LXSnapshot.View view : snapshot.views) {
            if (!view.isDependentOf(component)) continue;
            if (views == null) {
                views = new ArrayList<LXSnapshot.View>();
            }
            views.add(view);
        }
        return views;
    }

    public List<LXSnapshot.View> findSnapshotParameterViews(LXParameter parameter) {
        List<LXSnapshot.View> views = null;
        for (LXGlobalSnapshot lXGlobalSnapshot : this.snapshots) {
            views = this.findSnapshotParameterViews(views, parameter, lXGlobalSnapshot);
        }
        for (LXBus lXBus : this.lx.engine.mixer.channels) {
            views = this.findSnapshotParameterViews(views, parameter, lXBus);
        }
        views = this.findSnapshotParameterViews(views, parameter, this.lx.engine.mixer.masterBus);
        return views;
    }

    private List<LXSnapshot.View> findSnapshotParameterViews(List<LXSnapshot.View> views, LXParameter parameter, LXBus bus) {
        for (LXClip clip : bus.clips) {
            if (clip == null) continue;
            views = this.findSnapshotParameterViews(views, parameter, clip.snapshot);
        }
        return views;
    }

    private List<LXSnapshot.View> findSnapshotParameterViews(List<LXSnapshot.View> views, LXParameter parameter, LXSnapshot snapshot) {
        for (LXSnapshot.View view : snapshot.views) {
            if (!(view instanceof LXSnapshot.ParameterView) || ((LXSnapshot.ParameterView)view).getParameter() != parameter) continue;
            if (views == null) {
                views = new ArrayList<LXSnapshot.View>();
            }
            views.add(view);
        }
        return views;
    }

    public void removeSnapshotViews(LXComponent component) {
        List<LXSnapshot.View> removeViews = this.findSnapshotViews(component);
        if (removeViews != null) {
            for (LXSnapshot.View view : removeViews) {
                view.getSnapshot().removeView(view);
            }
        }
    }

    public void removeSnapshotParameterViews(LXParameter parameter) {
        List<LXSnapshot.View> removeViews = this.findSnapshotParameterViews(parameter);
        if (removeViews != null) {
            for (LXSnapshot.View view : removeViews) {
                view.getSnapshot().removeView(view);
            }
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_SNAPSHOTS, (JsonElement)LXSerializable.Utils.toArray(lx, this.snapshots));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.clear();
        super.load(lx, obj);
        if (obj.has(KEY_SNAPSHOTS)) {
            JsonArray snapshotArr = obj.getAsJsonArray(KEY_SNAPSHOTS);
            for (JsonElement snapshotElement : snapshotArr) {
                JsonObject snapshotObj = snapshotElement.getAsJsonObject();
                try {
                    LXGlobalSnapshot snapshot = new LXGlobalSnapshot(this.lx);
                    snapshot.load(lx, snapshotObj);
                    this.addSnapshot(snapshot);
                }
                catch (Exception x) {
                    LX.error(x, "Could not load snapshot " + snapshotObj.toString());
                }
            }
        }
    }

    public static enum MissingChannelMode {
        IGNORE("Ignore"),
        DISABLE("Disable");

        public final String label;

        private MissingChannelMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum ChannelMode {
        TOGGLE("Toggle"),
        FADE("Fade");

        public final String label;

        private ChannelMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum AutoCycleMode {
        NEXT,
        RANDOM;


        public String toString() {
            switch (this) {
                case NEXT: {
                    return "Next";
                }
            }
            return "Random";
        }
    }

    public static interface Listener {
        public void snapshotAdded(LXSnapshotEngine var1, LXGlobalSnapshot var2);

        public void snapshotRemoved(LXSnapshotEngine var1, LXGlobalSnapshot var2);

        public void snapshotMoved(LXSnapshotEngine var1, LXGlobalSnapshot var2);
    }
}

