/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.structure.LXBasicFixture;
import heronarts.lx.structure.LXFixture;
import heronarts.lx.transform.LXMatrix;
import heronarts.lx.transform.LXTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@LXCategory(value="Core")
public class GridFixture
extends LXBasicFixture {
    public final DiscreteParameter numRows = new DiscreteParameter("Rows", 10, 1, 257).setUnits(LXParameter.Units.INTEGER).setDescription("Number of rows in the grid");
    public final DiscreteParameter numColumns = new DiscreteParameter("Columns", 10, 1, 257).setUnits(LXParameter.Units.INTEGER).setDescription("Number of columns in the grid");
    public final BoundedParameter rowSpacing = new BoundedParameter("Row Spacing", 10.0, 0.0, 1000000.0).setDescription("Spacing between rows in the grid");
    public final BoundedParameter columnSpacing = new BoundedParameter("Column Spacing", 10.0, 0.0, 1000000.0).setDescription("Spacing between columns in the grid");
    public final EnumParameter<PositionMode> positionMode = new EnumParameter<PositionMode>("Mode", PositionMode.CORNER).setDescription("Whether the arc is positioned by its starting point or center");
    public final EnumParameter<Wiring> wiring = new EnumParameter<Wiring>("Wiring", Wiring.ROWS_L2R_B2T).setDescription("How the strips in the grid are sequentially wired");
    public final StringParameter rowTags = new StringParameter("Row Tags", "row").setDescription("Tags to be applied to rows in model");
    public final StringParameter columnTags = new StringParameter("Column Tags", "column").setDescription("Tags to be applied to columns in model");

    public GridFixture(LX lx) {
        super(lx, "Grid");
        this.addMetricsParameter("numRows", this.numRows);
        this.addMetricsParameter("numColumns", this.numColumns);
        this.addGeometryParameter("rowSpacing", this.rowSpacing);
        this.addGeometryParameter("columnSpacing", this.columnSpacing);
        this.addGeometryParameter("positionMode", this.positionMode);
        this.addOutputParameter("wiring", this.wiring);
        this.addTagParameter("rowTags", this.rowTags);
        this.addTagParameter("columnTags", this.columnTags);
    }

    private String[] tagArray(StringParameter parameter) {
        ArrayList<String> validTags = new ArrayList<String>();
        String tagString = parameter.getString();
        if (tagString != null && !tagString.isEmpty()) {
            for (String tag : tagString.trim().split("\\s+")) {
                if ((tag = tag.trim()).isEmpty() || !LXModel.Tag.isValid(tag)) continue;
                validTags.add(tag);
            }
        }
        return validTags.toArray(new String[0]);
    }

    @Override
    public LXFixture.Submodel[] toSubmodels() {
        int numRows = this.numRows.getValuei();
        int numColumns = this.numColumns.getValuei();
        int i = 0;
        LXFixture.Submodel[] submodels = new LXFixture.Submodel[numRows + numColumns];
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("numPoints", String.valueOf(numColumns));
        metaData.put("spacing", String.valueOf(this.columnSpacing.getValue()));
        String[] rowTags = this.tagArray(this.rowTags);
        String[] columnTags = this.tagArray(this.columnTags);
        for (int r = 0; r < numRows; ++r) {
            metaData.put("rowIndex", String.valueOf(r));
            submodels[i++] = (LXFixture)this.new LXFixture.Submodel(r * numColumns, numColumns, 1, metaData, rowTags);
        }
        metaData.clear();
        metaData.put("numPoints", String.valueOf(numRows));
        metaData.put("spacing", String.valueOf(this.rowSpacing.getValue()));
        for (int c = 0; c < numColumns; ++c) {
            metaData.put("columnIndex", String.valueOf(c));
            submodels[i++] = (LXFixture)this.new LXFixture.Submodel(c, numRows, numColumns, metaData, columnTags);
        }
        return submodels;
    }

    @Override
    protected void computePointGeometry(LXMatrix matrix, List<LXPoint> points) {
        if (this.positionMode.getEnum() == PositionMode.CENTER) {
            matrix.translate(-0.5f * (float)(this.numColumns.getValuei() - 1) * this.columnSpacing.getValuef(), -0.5f * (float)(this.numRows.getValuei() - 1) * this.rowSpacing.getValuef(), 0.0f);
        }
        LXTransform transform = new LXTransform(matrix);
        int numRows = this.numRows.getValuei();
        int numColumns = this.numColumns.getValuei();
        float rowSpacing = this.rowSpacing.getValuef();
        float columnSpacing = this.columnSpacing.getValuef();
        int pi = 0;
        for (int r = 0; r < numRows; ++r) {
            transform.push();
            for (int c = 0; c < numColumns; ++c) {
                points.get(pi++).set(transform);
                transform.translateX(columnSpacing);
            }
            transform.pop();
            transform.translateY(rowSpacing);
        }
    }

    @Override
    protected int size() {
        return this.numRows.getValuei() * this.numColumns.getValuei();
    }

    @Override
    protected String[] getDefaultTags() {
        return new String[]{"grid"};
    }

    private int[] getWiringIndexBuffer() {
        int size = this.size();
        int numRows = this.numRows.getValuei();
        int numColumns = this.numColumns.getValuei();
        int[] indexBuffer = new int[size];
        int i = 0;
        switch (this.wiring.getEnum()) {
            case COLUMNS_B2T_L2R: {
                for (int x = 0; x < numColumns; ++x) {
                    for (int y = 0; y < numRows; ++y) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case COLUMNS_B2T_R2L: {
                for (int x = 0; x < numColumns; ++x) {
                    for (int y = numRows - 1; y >= 0; --y) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case COLUMNS_T2B_L2R: {
                for (int x = numColumns - 1; x >= 0; --x) {
                    for (int y = 0; y < numRows; ++y) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case COLUMNS_T2B_R2L: {
                for (int x = numColumns - 1; x >= 0; --x) {
                    for (int y = numRows - 1; y >= 0; --y) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ROWS_L2R_B2T: {
                for (int y = 0; y < numRows; ++y) {
                    for (int x = 0; x < numColumns; ++x) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ROWS_L2R_T2B: {
                for (int y = numRows - 1; y >= 0; --y) {
                    for (int x = 0; x < numColumns; ++x) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ROWS_R2L_B2T: {
                for (int y = 0; y < numRows; ++y) {
                    for (int x = numColumns - 1; x >= 0; --x) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ROWS_R2L_T2B: {
                for (int y = numRows - 1; y >= 0; --y) {
                    for (int x = numColumns - 1; x >= 0; --x) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ZIGZAG_HORIZ_BL: {
                for (int y = 0; y < numRows; ++y) {
                    int x;
                    if (y % 2 == 0) {
                        for (x = 0; x < numColumns; ++x) {
                            indexBuffer[i++] = x + y * numColumns;
                        }
                        continue;
                    }
                    for (x = numColumns - 1; x >= 0; --x) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ZIGZAG_HORIZ_BR: {
                for (int y = 0; y < numRows; ++y) {
                    int x;
                    if (y % 2 != 0) {
                        for (x = 0; x < numColumns; ++x) {
                            indexBuffer[i++] = x + y * numColumns;
                        }
                        continue;
                    }
                    for (x = numColumns - 1; x >= 0; --x) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ZIGZAG_HORIZ_TL: {
                for (int y = numRows - 1; y >= 0; --y) {
                    int x;
                    if (y % 2 != numRows % 2) {
                        for (x = 0; x < numColumns; ++x) {
                            indexBuffer[i++] = x + y * numColumns;
                        }
                        continue;
                    }
                    for (x = numColumns - 1; x >= 0; --x) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ZIGZAG_HORIZ_TR: {
                for (int y = numRows - 1; y >= 0; --y) {
                    int x;
                    if (y % 2 == numRows % 2) {
                        for (x = 0; x < numColumns; ++x) {
                            indexBuffer[i++] = x + y * numColumns;
                        }
                        continue;
                    }
                    for (x = numColumns - 1; x >= 0; --x) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ZIGZAG_VERT_BL: {
                for (int x = 0; x < numColumns; ++x) {
                    int y;
                    if (x % 2 == 0) {
                        for (y = 0; y < numRows; ++y) {
                            indexBuffer[i++] = x + y * numColumns;
                        }
                        continue;
                    }
                    for (y = numRows - 1; y >= 0; --y) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ZIGZAG_VERT_BR: {
                for (int x = numColumns - 1; x >= 0; --x) {
                    int y;
                    if (x % 2 != numColumns % 2) {
                        for (y = 0; y < numRows; ++y) {
                            indexBuffer[i++] = x + y * numColumns;
                        }
                        continue;
                    }
                    for (y = numRows - 1; y >= 0; --y) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ZIGZAG_VERT_TL: {
                for (int x = 0; x < numColumns; ++x) {
                    int y;
                    if (x % 2 == 0) {
                        for (y = numRows - 1; y >= 0; --y) {
                            indexBuffer[i++] = x + y * numColumns;
                        }
                        continue;
                    }
                    for (y = 0; y < numRows; ++y) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            case ZIGZAG_VERT_TR: {
                for (int x = numColumns - 1; x >= 0; --x) {
                    int y;
                    if (x % 2 == numColumns % 2) {
                        for (y = 0; y < numRows; ++y) {
                            indexBuffer[i++] = x + y * numColumns;
                        }
                        continue;
                    }
                    for (y = numRows - 1; y >= 0; --y) {
                        indexBuffer[i++] = x + y * numColumns;
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Grid Wiring has non-existed enum value: " + this.wiring);
            }
        }
        return indexBuffer;
    }

    @Override
    protected LXFixture.Segment buildSegment() {
        return (LXFixture)this.new LXFixture.Segment(this.getWiringIndexBuffer(), (LXBufferOutput.ByteEncoder)this.byteOrder.getEnum());
    }

    @Override
    public void addModelMetaData(Map<String, String> metaData) {
        metaData.put("numRows", String.valueOf(this.numRows.getValuei()));
        metaData.put("numColumns", String.valueOf(this.numColumns.getValuei()));
        metaData.put("rowSpacing", String.valueOf(this.rowSpacing.getValue()));
        metaData.put("columnSpacing", String.valueOf(this.columnSpacing.getValue()));
        metaData.put("positionMode", this.positionMode.getEnum().toString());
    }

    public static enum PositionMode {
        CORNER("Corner"),
        CENTER("Center");

        private final String str;

        private PositionMode(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum Wiring {
        ROWS_L2R_B2T("Rows - Left\u2192Right - Bot\u2192Top"),
        ROWS_L2R_T2B("Rows - Left\u2192Right - Top\u2192Bot"),
        ROWS_R2L_B2T("Rows - Right\u2192Left - Bot\u2192Top"),
        ROWS_R2L_T2B("Rows - Right\u2192Left - Top\u2192Bot"),
        COLUMNS_B2T_L2R("Cols - Bot\u2192Top - Left\u2192Right"),
        COLUMNS_B2T_R2L("Cols - Bot\u2192Top - Right\u2192Left"),
        COLUMNS_T2B_L2R("Cols - Top\u2192Bot - Left\u2192Right"),
        COLUMNS_T2B_R2L("Cols - Top\u2192Bot - Right\u2192Left"),
        ZIGZAG_HORIZ_BL("ZigZag - Horiz - Bot Left"),
        ZIGZAG_HORIZ_TL("ZigZag - Horiz - Top Left"),
        ZIGZAG_HORIZ_BR("ZigZag - Horiz - Bot Right"),
        ZIGZAG_HORIZ_TR("ZigZag - Horiz - Top Right"),
        ZIGZAG_VERT_BL("ZigZag - Vert - Bot Left"),
        ZIGZAG_VERT_TL("ZigZag - Vert - Top Left"),
        ZIGZAG_VERT_BR("ZigZag - Vert - Bot Right"),
        ZIGZAG_VERT_TR("ZigZag - Vert - Top Right");

        private final String description;

        private Wiring(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

