/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.MalformedJsonException;
import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.output.ArtSyncDatagram;
import heronarts.lx.output.KinetDatagram;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXOutput;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.structure.ArcFixture;
import heronarts.lx.structure.LXFixture;
import heronarts.lx.structure.PointFixture;
import heronarts.lx.structure.PointListFixture;
import heronarts.lx.structure.StripFixture;
import heronarts.lx.transform.LXMatrix;
import heronarts.lx.transform.LXVector;
import heronarts.lx.utils.LXUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonFixture
extends LXFixture {
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    private static final String KEY_LABEL = "label";
    private static final String KEY_TAG = "tag";
    private static final String KEY_TAGS = "tags";
    private static final String KEY_MODEL_KEY = "modelKey";
    private static final String KEY_MODEL_KEYS = "modelKeys";
    private static final String KEY_X = "x";
    private static final String KEY_Y = "y";
    private static final String KEY_Z = "z";
    private static final String KEY_YAW = "yaw";
    private static final String KEY_PITCH = "pitch";
    private static final String KEY_ROLL = "roll";
    private static final String KEY_ROTATE_X = "rotateX";
    private static final String KEY_ROTATE_Y = "rotateY";
    private static final String KEY_ROTATE_Z = "rotateZ";
    private static final String KEY_SCALE_X = "scaleX";
    private static final String KEY_SCALE_Y = "scaleY";
    private static final String KEY_SCALE_Z = "scaleZ";
    private static final String KEY_SCALE = "scale";
    private static final String KEY_DIRECTION = "direction";
    private static final String KEY_NORMAL = "normal";
    private static final String KEY_TRANSFORMS = "transforms";
    private static final String KEY_BRIGHTNESS = "brightness";
    private static final String KEY_POINTS = "points";
    private static final String KEY_COORDINATES = "coords";
    private static final String KEY_STRIPS = "strips";
    private static final String KEY_NUM_POINTS = "numPoints";
    private static final String KEY_SPACING = "spacing";
    private static final String KEY_ARCS = "arcs";
    private static final String KEY_RADIUS = "radius";
    private static final String KEY_DEGREES = "degrees";
    private static final String KEY_ARC_MODE = "mode";
    private static final String VALUE_ARC_MODE_ORIGIN = "origin";
    private static final String VALUE_ARC_MODE_CENTER = "center";
    private static final String KEY_COMPONENTS = "components";
    private static final String KEY_CHILDREN = "children";
    private static final String KEY_TYPE = "type";
    private static final String KEY_ID = "id";
    private static final String KEY_INSTANCES = "instances";
    private static final String KEY_INSTANCE = "instance";
    private static final int MAX_INSTANCES = 4096;
    private static final String TYPE_POINT = "point";
    private static final String TYPE_POINTS = "points";
    private static final String TYPE_STRIP = "strip";
    private static final String TYPE_ARC = "arc";
    private static final String KEY_PARAMETERS = "parameters";
    private static final String KEY_PARAMETER_LABEL = "label";
    private static final String KEY_PARAMETER_DESCRIPTION = "description";
    private static final String KEY_PARAMETER_TYPE = "type";
    private static final String KEY_PARAMETER_DEFAULT = "default";
    private static final String KEY_PARAMETER_MIN = "min";
    private static final String KEY_PARAMETER_MAX = "max";
    private static final String KEY_PARAMETER_OPTIONS = "options";
    private static final String KEY_OUTPUT = "output";
    private static final String KEY_OUTPUTS = "outputs";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_FPS = "fps";
    private static final String KEY_PROTOCOL = "protocol";
    private static final String KEY_TRANSPORT = "transport";
    private static final String KEY_HOST = "host";
    private static final String KEY_PORT = "port";
    private static final String KEY_BYTE_ORDER = "byteOrder";
    private static final String KEY_UNIVERSE = "universe";
    private static final String KEY_DDP_DATA_OFFSET = "dataOffset";
    private static final String KEY_KINET_PORT = "kinetPort";
    private static final String KEY_KINET_VERSION = "kinetVersion";
    private static final String KEY_OPC_CHANNEL = "channel";
    private static final String KEY_CHANNEL = "channel";
    private static final String KEY_PRIORITY = "priority";
    private static final String KEY_SEQUENCE_ENABLED = "sequenceEnabled";
    private static final String KEY_OFFSET = "offset";
    private static final String KEY_START = "start";
    private static final String KEY_COMPONENT_INDEX = "componentIndex";
    private static final String KEY_COMPONENT_ID = "componentId";
    private static final String KEY_NUM = "num";
    private static final String KEY_STRIDE = "stride";
    private static final String KEY_REPEAT = "repeat";
    private static final String KEY_DUPLICATE = "duplicate";
    private static final String KEY_REVERSE = "reverse";
    private static final String KEY_SEGMENTS = "segments";
    private static final String KEY_META = "meta";
    private static final String LABEL_PLACEHOLDER = "UNKNOWN";
    private final StringParameter fixtureType = new StringParameter("Fixture File").setDescription("Fixture definition path");
    public final BooleanParameter error = new BooleanParameter("Error", false).setDescription("Whether there was an error loading this fixture");
    public final StringParameter errorMessage = new StringParameter("Error Message", "").setDescription("Message describing the error from loading");
    public final BooleanParameter warning = new BooleanParameter("Warning", false).setDescription("Whether there are warnings from the loading of the JSON file");
    public final MutableParameter parametersDisposed = (MutableParameter)new MutableParameter("Dispose").setDescription("Monitor for when fixture parameters are disposed");
    public final MutableParameter parametersReloaded = (MutableParameter)new MutableParameter("Reload").setDescription("Monitor for when fixture parameters are reloaded");
    public final List<String> warnings = new CopyOnWriteArrayList<String>();
    private final List<JsonOutputDefinition> definedOutputs = new ArrayList<JsonOutputDefinition>();
    private final Map<String, List<LXFixture>> componentsById = new HashMap<String, List<LXFixture>>();
    private final List<List<LXFixture>> componentsByIndex = new ArrayList<List<LXFixture>>();
    private final LinkedHashMap<String, ParameterDefinition> definedParameters = new LinkedHashMap();
    private final LinkedHashMap<String, ParameterDefinition> reloadParameterValues = new LinkedHashMap();
    private final JsonFixture jsonParameterContext;
    private final boolean isJsonSubfixture;
    private JsonObject jsonParameterValues = new JsonObject();
    private int currentNumInstances = -1;
    private int currentChildInstance = -1;
    private boolean isLoaded = false;
    private static final Pattern parameterPattern = Pattern.compile("\\$\\{?([a-zA-Z0-9]+)\\}?");
    private static final char[][] SIMPLE_EXPRESSION_OPERATORS = new char[][]{{'+', '-'}, {'*', '/', '%'}, {'^'}};
    private static final char[] SIMPLE_BOOLEAN_OPERATORS = new char[]{'|', '&'};
    private static final String[] TRANSFORM_TRANSLATE = new String[]{"x", "y", "z"};
    private static final String[] TRANSFORM_ROTATE = new String[]{"yaw", "pitch", "roll", "rotateX", "rotateY", "rotateZ"};
    private static final String[] TRANSFORM_SCALE = new String[]{"scale", "scaleX", "scaleY", "scaleZ"};
    private static final String[] SEGMENT_KEYS = new String[]{"num", "start", "componentIndex", "componentId", "stride", "reverse"};
    private static final String KEY_FIXTURE_TYPE = "jsonFixtureType";
    private static final String KEY_JSON_PARAMETERS = "jsonParameters";

    public JsonFixture(LX lx) {
        this(lx, null);
    }

    public JsonFixture(LX lx, String fixtureType) {
        super(lx, LABEL_PLACEHOLDER);
        this.isJsonSubfixture = false;
        this.jsonParameterContext = this;
        this.addParameter("fixtureType", this.fixtureType);
        if (fixtureType != null) {
            this.fixtureType.setValue(fixtureType);
        }
    }

    private JsonFixture(LX lx, JsonFixture parentFixture, JsonObject subFixture, String fixtureType) {
        super(lx, LABEL_PLACEHOLDER);
        this.jsonParameterContext = parentFixture;
        this.jsonParameterValues = subFixture;
        this.isJsonSubfixture = true;
        this.addParameter("fixtureType", this.fixtureType);
        this.fixtureType.setValue(fixtureType);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.fixtureType) {
            this.loadFixture(true);
        } else if (p == this.enabled) {
            for (LXFixture child : this.children) {
                child.enabled.setValue(this.enabled.isOn());
            }
        }
        super.onParameterChanged(p);
    }

    private void addJsonParameter(ParameterDefinition parameter) {
        if (this.definedParameters.containsKey(parameter.name)) {
            this.addWarning("Cannot define two parameters of same name: " + parameter.name);
            return;
        }
        this.definedParameters.put(parameter.name, parameter);
    }

    public Collection<ParameterDefinition> getJsonParameters() {
        return Collections.unmodifiableCollection(this.definedParameters.values());
    }

    private void removeJsonParameters() {
        this.parametersDisposed.bang();
        for (ParameterDefinition parameter : this.definedParameters.values()) {
            parameter.dispose();
        }
        this.definedParameters.clear();
    }

    public void reload() {
        this.reloadParameterValues.clear();
        for (Map.Entry<String, ParameterDefinition> entry : this.definedParameters.entrySet()) {
            this.reloadParameterValues.put(entry.getKey(), entry.getValue());
        }
        this.reload(true);
        this.reloadParameterValues.clear();
    }

    private void reload(boolean reloadParameters) {
        if (reloadParameters) {
            this.removeJsonParameters();
        }
        this.warnings.clear();
        this.warning.setValue(false);
        this.errorMessage.setValue("");
        this.error.setValue(false);
        this.definedOutputs.clear();
        this.metaData.clear();
        for (LXFixture child : this.children) {
            child.dispose();
        }
        this.mutableChildren.clear();
        this.componentsById.clear();
        this.componentsByIndex.clear();
        this.clearTransforms();
        this.isLoaded = false;
        this.loadFixture(reloadParameters);
        this.regenerate();
    }

    private File getFixtureFile(String fixtureType) {
        return this.lx.getMediaFile(LX.Media.FIXTURES, fixtureType.replace(PATH_SEPARATOR, File.separator) + ".lxf", false);
    }

    private void loadFixture(boolean loadParameters) {
        if (this.isLoaded) {
            LX.error(new Exception(), "Trying to load JsonFixture twice, why?");
            return;
        }
        this.isLoaded = true;
        String fixtureType = this.fixtureType.getString();
        File fixtureFile = this.getFixtureFile(fixtureType);
        if (!fixtureFile.exists()) {
            this.setError("Invalid fixture type, could not find file: " + fixtureFile);
            return;
        }
        if (!fixtureFile.isFile()) {
            this.setError("Invalid fixture type, not a normal file: " + fixtureFile);
            return;
        }
        try (FileReader fr = new FileReader(fixtureFile);){
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
            if (loadParameters) {
                this.loadLabel(obj);
                this.loadTags(this, obj, true, true, false);
                this.loadParameters(obj);
                this.parametersReloaded.bang();
            }
            this.loadTransforms(this, obj);
            this.loadLegacyPoints(obj);
            this.loadLegacyStrips(obj);
            this.loadLegacyArcs(obj);
            this.loadLegacyChildren(obj);
            this.loadComponents(obj);
            this.loadMetaData(obj, this.metaData);
            this.loadOutputs(this, obj);
        }
        catch (JsonParseException jpx) {
            String message = jpx.getLocalizedMessage();
            Throwable cause = jpx.getCause();
            if (cause instanceof MalformedJsonException) {
                message = "Invalid JSON in " + fixtureFile.getName() + ": " + ((MalformedJsonException)cause).getLocalizedMessage();
            }
            this.setError((Exception)((Object)jpx), message);
            this.setErrorLabel(fixtureType);
        }
        catch (Exception x) {
            this.setError(x, "Error loading fixture from " + fixtureFile.getName() + ": " + x.getLocalizedMessage());
            this.setErrorLabel(fixtureType);
        }
    }

    private void setError(String error) {
        this.setError(null, error);
    }

    private void setError(Exception x, String error) {
        this.errorMessage.setValue(error);
        this.error.setValue(true);
        LX.error(x, "Fixture " + this.fixtureType.getString() + ".lxf: " + error);
    }

    private void addWarning(String warning) {
        this.warnings.add(warning);
        if (this.warning.isOn()) {
            this.warning.bang();
        } else {
            this.warning.setValue(true);
        }
        LX.error("Fixture " + this.fixtureType.getString() + ".lxf: " + warning);
    }

    private void warnDuplicateKeys(JsonObject obj, String ... keys) {
        String found = null;
        for (String key : keys) {
            if (!obj.has(key)) continue;
            if (found != null) {
                this.addWarning("Should use only one of " + found + " or " + key + " - " + found + " will be ignored.");
            }
            found = key;
        }
    }

    private String replaceVariables(String key, String expression, ParameterType returnType) {
        StringBuilder result = new StringBuilder();
        int index = 0;
        Matcher matcher = parameterPattern.matcher(expression);
        while (matcher.find()) {
            String parameterName = matcher.group(1);
            String parameterValue = "";
            if (KEY_INSTANCE.equals(parameterName)) {
                if (returnType == ParameterType.BOOLEAN) {
                    this.addWarning("Cannot load non-boolean parameter $" + parameterName + " into a boolean type: " + key);
                    return null;
                }
                if (this.currentChildInstance < 0) {
                    this.addWarning("Cannot reference variable $" + parameterName + " when \"" + KEY_INSTANCES + "\" has not been declared");
                    return null;
                }
                parameterValue = String.valueOf(this.currentChildInstance);
            } else if (KEY_INSTANCES.equals(parameterName)) {
                parameterValue = String.valueOf(this.currentNumInstances);
                if (returnType == ParameterType.BOOLEAN) {
                    this.addWarning("Cannot load non-boolean parameter $" + parameterName + " into a boolean type: " + key);
                    return null;
                }
            } else {
                ParameterDefinition parameter = this.definedParameters.get(parameterName);
                if (parameter == null) {
                    this.addWarning("Illegal reference in " + key + ", there is no parameter: " + parameterName);
                    return null;
                }
                parameter.isReferenced = true;
                switch (returnType) {
                    case FLOAT: {
                        if (parameter.type == ParameterType.FLOAT || parameter.type == ParameterType.INT) {
                            parameterValue = String.valueOf(parameter.parameter.getValue());
                            break;
                        }
                        this.addWarning("Cannot load non-numeric parameter $" + parameterName + " into a float type: " + key);
                        return null;
                    }
                    case INT: {
                        if (parameter.type == ParameterType.INT) {
                            parameterValue = String.valueOf(parameter.intParameter.getValuei());
                            break;
                        }
                        if (parameter.type == ParameterType.FLOAT) {
                            parameterValue = String.valueOf(parameter.floatParameter.getValue());
                            break;
                        }
                        this.addWarning("Cannot load non-numeric parameter $" + parameterName + " into an integer type: " + key);
                        return null;
                    }
                    case STRING: 
                    case STRING_SELECT: {
                        parameterValue = parameter.getValueAsString();
                        break;
                    }
                    case BOOLEAN: {
                        if (parameter.type == ParameterType.BOOLEAN) {
                            parameterValue = String.valueOf(parameter.booleanParameter.isOn());
                            break;
                        }
                        this.addWarning("Cannot load non-boolean parameter $" + parameterName + " into a boolean type: " + key);
                        return null;
                    }
                }
            }
            result.append(expression, index, matcher.start());
            result.append(parameterValue);
            index = matcher.end();
        }
        if (index < expression.length()) {
            result.append(expression, index, expression.length());
        }
        return result.toString();
    }

    private float evaluateVariableExpression(JsonObject obj, String key, String expression, ParameterType type) {
        String substitutedExpression = this.replaceVariables(key, expression, type);
        if (substitutedExpression == null) {
            return 0.0f;
        }
        try {
            float value = this._evaluateSimpleExpression(obj, key, substitutedExpression.replaceAll("\\s", ""));
            if (Float.isNaN(value)) {
                this.addWarning("Variable expression produces NaN: " + expression);
                return 0.0f;
            }
            if (Float.isInfinite(value)) {
                this.addWarning("Variable expression produces infinite value: " + expression);
                return 0.0f;
            }
            return value;
        }
        catch (Exception nfx) {
            this.addWarning("Bad formatting in variable expression: " + expression);
            nfx.printStackTrace();
            return 0.0f;
        }
    }

    private static boolean isOperator(char ch, char[] operators) {
        for (char operator : operators) {
            if (ch != operator) continue;
            return true;
        }
        return false;
    }

    private static boolean isSimpleOperator(char ch) {
        for (char[] operators : SIMPLE_EXPRESSION_OPERATORS) {
            if (!JsonFixture.isOperator(ch, operators)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnaryMinus(char[] chars, int index) {
        if (chars[index] != '-') {
            return false;
        }
        if (JsonFixture.isSimpleOperator(chars[index - 1])) {
            return true;
        }
        for (SimpleFunction function : SimpleFunction.values()) {
            String name = function.name();
            int len = name.length();
            if (index < len || !new String(chars, index - len, len).equals(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private float _evaluateSimpleExpression(JsonObject obj, String key, String expression) {
        void var6_7;
        char[] chars = expression.toCharArray();
        int openParen = -1;
        boolean bl = false;
        while (var6_7 < chars.length) {
            if (chars[var6_7] == '(') {
                openParen = var6_7;
            } else if (chars[var6_7] == ')') {
                if (openParen < 0) {
                    throw new IllegalArgumentException("Mismatched parentheses in expression: " + expression);
                }
                String substitutedExpression = expression.substring(0, openParen) + this._evaluateSimpleExpression(obj, key, expression.substring(openParen + 1, (int)var6_7)) + expression.substring((int)(var6_7 + true));
                return this._evaluateSimpleExpression(obj, key, substitutedExpression);
            }
            ++var6_7;
        }
        for (char[] operators : SIMPLE_EXPRESSION_OPERATORS) {
            for (int index = chars.length - 2; index > 0; --index) {
                if (!JsonFixture.isOperator(chars[index], operators) || JsonFixture.isUnaryMinus(chars, index)) continue;
                float left = this._evaluateSimpleExpression(obj, key, expression.substring(0, index));
                float right = this._evaluateSimpleExpression(obj, key, expression.substring(index + 1));
                switch (chars[index]) {
                    case '+': {
                        return left + right;
                    }
                    case '-': {
                        return left - right;
                    }
                    case '*': {
                        return left * right;
                    }
                    case '/': {
                        return left / right;
                    }
                    case '%': {
                        return left % right;
                    }
                    case '^': {
                        return (float)Math.pow(left, right);
                    }
                }
            }
        }
        if (chars[0] == '-') {
            return -this._evaluateSimpleExpression(obj, key, expression.substring(1));
        }
        for (SimpleFunction function : SimpleFunction.values()) {
            String name = function.name();
            if (!expression.startsWith(name)) continue;
            return function.compute.compute(this._evaluateSimpleExpression(obj, key, expression.substring(name.length())));
        }
        return Float.parseFloat(expression);
    }

    private boolean evaluateBooleanExpression(JsonObject obj, String key, String expression) {
        String substitutedExpression = this.replaceVariables(key, expression, ParameterType.BOOLEAN);
        if (substitutedExpression == null) {
            return false;
        }
        try {
            return this._evaluateBooleanExpression(obj, key, substitutedExpression);
        }
        catch (Exception x) {
            this.addWarning("Bad formatting in boolean expression: " + expression);
            x.printStackTrace();
            return false;
        }
    }

    private boolean _evaluateBooleanExpression(JsonObject obj, String key, String expression) {
        char[] chars = expression.toCharArray();
        int openParen = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '(') {
                openParen = i;
                continue;
            }
            if (chars[i] != ')') continue;
            if (openParen < 0) {
                throw new IllegalArgumentException("Mismatched parentheses in expression: " + expression);
            }
            String substitutedExpression = expression.substring(0, openParen) + this._evaluateBooleanExpression(obj, key, expression.substring(openParen + 1, i)) + expression.substring(i + 1);
            return this._evaluateBooleanExpression(obj, key, substitutedExpression);
        }
        for (char operator : SIMPLE_BOOLEAN_OPERATORS) {
            int index = expression.indexOf(operator);
            if (index <= 0 || index >= expression.length() - 1) continue;
            boolean left = this._evaluateBooleanExpression(obj, key, expression.substring(0, index));
            boolean right = this._evaluateBooleanExpression(obj, key, expression.substring(index + 1));
            switch (operator) {
                case '&': {
                    return left && right;
                }
                case '|': {
                    return left || right;
                }
            }
        }
        String trimmed = expression.trim();
        if (!trimmed.isEmpty() && trimmed.charAt(0) == '!') {
            return !this._evaluateBooleanExpression(obj, key, trimmed.substring(1));
        }
        return Boolean.parseBoolean(trimmed);
    }

    private float loadFloat(JsonObject obj, String key, boolean variablesAllowed) {
        return this.loadFloat(obj, key, variablesAllowed, key + " should be primitive float value");
    }

    private float loadFloat(JsonObject obj, String key, boolean variablesAllowed, String warning) {
        if (obj.has(key)) {
            JsonElement floatElem = obj.get(key);
            if (floatElem.isJsonPrimitive()) {
                JsonPrimitive floatPrimitive = floatElem.getAsJsonPrimitive();
                if (variablesAllowed && floatPrimitive.isString()) {
                    return this.evaluateVariableExpression(obj, key, floatPrimitive.getAsString(), ParameterType.FLOAT);
                }
                return floatElem.getAsFloat();
            }
            this.addWarning(warning);
        }
        return 0.0f;
    }

    private boolean loadBoolean(JsonObject obj, String key, boolean variablesAllowed, String warning) {
        if (obj.has(key)) {
            JsonElement boolElem = obj.get(key);
            if (boolElem.isJsonPrimitive()) {
                JsonPrimitive boolPrimitive = boolElem.getAsJsonPrimitive();
                if (variablesAllowed && boolPrimitive.isString()) {
                    return this.evaluateBooleanExpression(obj, key, boolPrimitive.getAsString());
                }
                return boolElem.getAsBoolean();
            }
            this.addWarning(warning);
        }
        return false;
    }

    private int loadInt(JsonObject obj, String key, boolean variablesAllowed, String warning) {
        if (obj.has(key)) {
            JsonElement intElem = obj.get(key);
            if (intElem.isJsonPrimitive()) {
                JsonPrimitive intPrimitive = intElem.getAsJsonPrimitive();
                if (variablesAllowed && intPrimitive.isString()) {
                    return (int)this.evaluateVariableExpression(obj, key, intPrimitive.getAsString(), ParameterType.INT);
                }
                return intElem.getAsInt();
            }
            this.addWarning(warning);
        }
        return 0;
    }

    private LXVector loadVector(JsonObject obj, String warning) {
        if (!(obj.has(KEY_X) || obj.has(KEY_Y) || obj.has(KEY_Z))) {
            this.addWarning(warning);
        }
        return new LXVector(this.loadFloat(obj, KEY_X, true), this.loadFloat(obj, KEY_Y, true), this.loadFloat(obj, KEY_Z, true));
    }

    private String loadString(JsonObject obj, String key, boolean variablesAllowed, String warning) {
        if (obj.has(key)) {
            JsonElement stringElem = obj.get(key);
            if (stringElem.isJsonPrimitive() && stringElem.getAsJsonPrimitive().isString()) {
                if (variablesAllowed) {
                    return this.replaceVariables(key, stringElem.getAsString(), ParameterType.STRING);
                }
                return stringElem.getAsString();
            }
            this.addWarning(warning);
        }
        return null;
    }

    private JsonArray loadArray(JsonObject obj, String key) {
        return this.loadArray(obj, key, key + " must be a JSON array");
    }

    private JsonArray loadArray(JsonObject obj, String key, String warning) {
        if (obj.has(key)) {
            JsonElement arrayElem = obj.get(key);
            if (arrayElem.isJsonArray()) {
                return arrayElem.getAsJsonArray();
            }
            this.addWarning(warning);
        }
        return null;
    }

    private JsonObject loadObject(JsonObject obj, String key, String warning) {
        if (obj.has(key)) {
            JsonElement objElem = obj.get(key);
            if (objElem.isJsonObject()) {
                return objElem.getAsJsonObject();
            }
            this.addWarning(warning);
        }
        return null;
    }

    private void loadGeometry(LXFixture fixture, JsonObject obj) {
        this.loadTransforms(fixture, obj);
        if (obj.has(KEY_X)) {
            fixture.x.setValue(this.loadFloat(obj, KEY_X, true));
        }
        if (obj.has(KEY_Y)) {
            fixture.y.setValue(this.loadFloat(obj, KEY_Y, true));
        }
        if (obj.has(KEY_Z)) {
            fixture.z.setValue(this.loadFloat(obj, KEY_Z, true));
        }
        if (obj.has(KEY_YAW)) {
            fixture.yaw.setValue(this.loadFloat(obj, KEY_YAW, true));
        }
        if (obj.has(KEY_PITCH)) {
            fixture.pitch.setValue(this.loadFloat(obj, KEY_PITCH, true));
        }
        if (obj.has(KEY_ROLL)) {
            fixture.roll.setValue(this.loadFloat(obj, KEY_ROLL, true));
        }
        if (obj.has(KEY_SCALE)) {
            fixture.scale.setValue(this.loadFloat(obj, KEY_SCALE, true));
        }
    }

    private void loadTransforms(LXFixture fixture, JsonObject obj) {
        JsonArray transformsArr = this.loadArray(obj, KEY_TRANSFORMS, "transforms must be an array");
        if (transformsArr == null) {
            return;
        }
        for (JsonElement transformElem : transformsArr) {
            if (transformElem.isJsonObject()) {
                this.loadTransform(fixture, transformElem.getAsJsonObject());
                continue;
            }
            if (transformElem.isJsonNull()) continue;
            this.addWarning("transforms should only contain transform elements in JSON object format, found invalid: " + transformElem);
        }
    }

    private static final boolean isTransform(JsonObject obj, String[] keys) {
        for (String key : keys) {
            if (!obj.has(key)) continue;
            return true;
        }
        return false;
    }

    private void loadTransform(LXFixture fixture, JsonObject obj) {
        boolean isRotate;
        boolean enabled;
        if (obj.has(KEY_ENABLED) && !(enabled = this.loadBoolean(obj, KEY_ENABLED, true, "Transform must specify boolean expression for enabled"))) {
            return;
        }
        int rotateCount = 0;
        for (String key : TRANSFORM_ROTATE) {
            if (!obj.has(key)) continue;
            ++rotateCount;
        }
        if (rotateCount > 1) {
            this.addWarning("Transform may not contain multiple rotations: " + obj);
            return;
        }
        boolean isTranslate = JsonFixture.isTransform(obj, TRANSFORM_TRANSLATE);
        boolean isScale = JsonFixture.isTransform(obj, TRANSFORM_SCALE);
        boolean bl = isRotate = rotateCount > 0;
        if (isTranslate) {
            if (isRotate) {
                this.addWarning("Transform may not contain both translation and rotation: " + obj);
                return;
            }
            if (isScale) {
                this.addWarning("Transform may not contain both translation and scaling: " + obj);
                return;
            }
        } else if (isRotate && isScale) {
            this.addWarning("Transform may not contain both rotation and scaling: " + obj);
            return;
        }
        if (obj.has(KEY_X)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.TRANSLATE_X, this.loadFloat(obj, KEY_X, true)));
        }
        if (obj.has(KEY_Y)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.TRANSLATE_Y, this.loadFloat(obj, KEY_Y, true)));
        }
        if (obj.has(KEY_Z)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.TRANSLATE_Z, this.loadFloat(obj, KEY_Z, true)));
        }
        if (obj.has(KEY_YAW)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.ROTATE_Y, this.loadFloat(obj, KEY_YAW, true)));
        }
        if (obj.has(KEY_PITCH)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.ROTATE_X, this.loadFloat(obj, KEY_PITCH, true)));
        }
        if (obj.has(KEY_ROLL)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.ROTATE_Z, this.loadFloat(obj, KEY_ROLL, true)));
        }
        if (obj.has(KEY_ROTATE_X)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.ROTATE_X, this.loadFloat(obj, KEY_ROTATE_X, true)));
        }
        if (obj.has(KEY_ROTATE_Y)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.ROTATE_Y, this.loadFloat(obj, KEY_ROTATE_Y, true)));
        }
        if (obj.has(KEY_ROTATE_Z)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.ROTATE_Z, this.loadFloat(obj, KEY_ROTATE_Z, true)));
        }
        if (obj.has(KEY_SCALE)) {
            JsonElement scaleElem = obj.get(KEY_SCALE);
            if (scaleElem.isJsonObject()) {
                JsonObject scale = scaleElem.getAsJsonObject();
                if (scale.has(KEY_X)) {
                    fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.SCALE_X, this.loadFloat(scale, KEY_X, true)));
                }
                if (scale.has(KEY_Y)) {
                    fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.SCALE_Y, this.loadFloat(scale, KEY_Y, true)));
                }
                if (scale.has(KEY_Z)) {
                    fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.SCALE_Z, this.loadFloat(scale, KEY_Z, true)));
                }
            } else if (scaleElem.isJsonPrimitive()) {
                float scale = this.loadFloat(obj, KEY_SCALE, true);
                fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.SCALE, scale));
            } else {
                this.addWarning("Transform element scale must be a float or JSON object: " + scaleElem);
                return;
            }
        }
        if (obj.has(KEY_SCALE_X)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.SCALE_X, this.loadFloat(obj, KEY_SCALE_X, true)));
        }
        if (obj.has(KEY_SCALE_Y)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.SCALE_Y, this.loadFloat(obj, KEY_SCALE_Y, true)));
        }
        if (obj.has(KEY_SCALE_Z)) {
            fixture.addTransform(new LXFixture.Transform(LXFixture.Transform.Type.SCALE_Z, this.loadFloat(obj, KEY_SCALE_Z, true)));
        }
    }

    private void loadLabel(JsonObject obj) {
        if (!this.label.getString().equals(LABEL_PLACEHOLDER)) {
            return;
        }
        String validLabel = this.fixtureType.getString();
        String testLabel = this.loadString(obj, "label", false, "label should contain a string");
        if (testLabel != null) {
            if ((testLabel = testLabel.trim()).isEmpty()) {
                this.addWarning("label should contain a non-empty string");
            } else {
                validLabel = testLabel;
            }
        }
        this.label.setValue(validLabel);
    }

    private void setErrorLabel(String fixtureType) {
        if (this.label.getString().equals(LABEL_PLACEHOLDER)) {
            int lastSeparator = fixtureType.lastIndexOf(PATH_SEPARATOR);
            if (lastSeparator >= 0) {
                fixtureType = fixtureType.substring(lastSeparator + 1);
            }
            this.label.setValue(fixtureType);
        }
    }

    private void loadTags(LXFixture fixture, JsonObject obj, boolean required, boolean includeParent, boolean replaceVariables) {
        List<String> validTags = this._loadTags(obj, required, replaceVariables, this);
        if (includeParent) {
            for (String tag : this._loadTags(this.jsonParameterValues, false, true, this.jsonParameterContext)) {
                if (validTags.contains(tag)) {
                    this.addWarning("Parent JSON fixture redundantly specifies tag: " + tag);
                    continue;
                }
                validTags.add(tag);
            }
        }
        fixture.setTags(validTags);
    }

    private List<String> _loadTags(JsonObject obj, boolean required, boolean replaceVariables, JsonFixture variableContext) {
        this.warnDuplicateKeys(obj, KEY_MODEL_KEY, KEY_MODEL_KEYS, KEY_TAG, KEY_TAGS);
        String keyTags = obj.has(KEY_TAGS) ? KEY_TAGS : KEY_MODEL_KEYS;
        String keyTag = obj.has(KEY_TAG) ? KEY_TAG : KEY_MODEL_KEY;
        ArrayList<String> validTags = new ArrayList<String>();
        if (obj.has(KEY_MODEL_KEY) || obj.has(KEY_MODEL_KEYS)) {
            this.addWarning("modelKey/modelKeys are deprecated, please update to tag/tags");
        }
        if (obj.has(keyTags)) {
            JsonArray tagsArr = this.loadArray(obj, keyTags);
            for (JsonElement tagElem : tagsArr) {
                if (!tagElem.isJsonPrimitive() || !tagElem.getAsJsonPrimitive().isString()) {
                    this.addWarning(keyTags + " may only contain strings");
                    continue;
                }
                String tag = tagElem.getAsString().trim();
                if (replaceVariables) {
                    tag = variableContext.replaceVariables(keyTags, tag, ParameterType.STRING);
                }
                if (tag == null || tag.isEmpty()) {
                    this.addWarning(keyTags + " should not contain empty string values");
                    continue;
                }
                if (!LXModel.Tag.isValid(tag)) {
                    this.addWarning("Ignoring invalid tag, should only contain [A-Za-z0-9_.-]: " + tag);
                    continue;
                }
                validTags.add(tag);
            }
        } else if (obj.has(keyTag)) {
            String tag = this.loadString(obj, keyTag, false, keyTag + " should contain a single string value");
            if (tag != null) {
                tag = tag.trim();
                if (replaceVariables) {
                    tag = variableContext.replaceVariables(keyTag, tag, ParameterType.STRING);
                }
                if (tag == null || tag.isEmpty()) {
                    this.addWarning(keyTag + " must contain a non-empty string value");
                } else if (!LXModel.Tag.isValid(tag)) {
                    this.addWarning("Ignoring invalid tag, should only contain [A-Za-z0-9_.-]: " + tag);
                } else {
                    validTags.add(tag);
                }
            }
        } else if (required) {
            this.addWarning("Fixture definition must specify one of tag/tags");
        }
        return validTags;
    }

    private void loadParameters(JsonObject obj) {
        JsonObject parametersObj = this.loadObject(obj, KEY_PARAMETERS, "parameters must be a JSON object");
        if (parametersObj == null) {
            return;
        }
        for (String parameterName : parametersObj.keySet()) {
            ParameterDefinition reloadDefinition;
            if (!parameterName.matches("^[a-zA-Z0-9]+$")) {
                this.addWarning("Invalid parameter name, must be non-empty only containing ASCII alphanumerics: " + parameterName);
                continue;
            }
            if (parameterName.equals(KEY_INSTANCES) || parameterName.equals(KEY_INSTANCE)) {
                this.addWarning("Invalid parameter name, keyword is reserved: " + parameterName);
                continue;
            }
            String parameterLabel = parameterName;
            if (this.definedParameters.containsKey(parameterName)) {
                this.addWarning("Parameter cannot be defined twice: " + parameterName);
                continue;
            }
            JsonElement parameterElem = parametersObj.get(parameterName);
            if (!parameterElem.isJsonObject()) {
                this.addWarning("Definition for parameter " + parameterName + " must be a JSON object specifying " + "type" + " and " + KEY_PARAMETER_DEFAULT);
                continue;
            }
            JsonObject parameterObj = parameterElem.getAsJsonObject();
            if (parameterObj.has("label")) {
                String rawLabel = this.loadString(parameterObj, "label", false, "Parameter label must be valid String");
                if (!rawLabel.matches("^[a-zA-Z0-9 ]+$")) {
                    this.addWarning("Invalid parameter label, must be non-empty only containing ASCII alphanumerics: " + rawLabel);
                } else {
                    parameterLabel = rawLabel;
                }
            }
            String parameterDescription = this.loadString(parameterObj, KEY_PARAMETER_DESCRIPTION, false, "Parameter description must be strign value.");
            if (!parameterObj.has(KEY_PARAMETER_DEFAULT)) {
                this.addWarning("Parameter " + parameterName + " must specify " + KEY_PARAMETER_DEFAULT);
                continue;
            }
            JsonElement defaultElem = parameterObj.get(KEY_PARAMETER_DEFAULT);
            if (!defaultElem.isJsonPrimitive()) {
                this.addWarning("Parameter " + parameterName + " must specify primitive value for " + KEY_PARAMETER_DEFAULT);
                continue;
            }
            String typeStr = this.loadString(parameterObj, "type", false, "Parameter " + parameterName + " must specify valid type string");
            ParameterType type = ParameterType.get(typeStr);
            if (type == null) {
                this.addWarning("Parameter " + parameterName + " must specify valid type string");
                continue;
            }
            if (type == ParameterType.STRING && parameterObj.has(KEY_PARAMETER_OPTIONS)) {
                type = ParameterType.STRING_SELECT;
            }
            if ((reloadDefinition = this.reloadParameterValues.get(parameterName)) != null && reloadDefinition.type != type) {
                reloadDefinition = null;
            }
            switch (type) {
                case FLOAT: {
                    float floatValue = defaultElem.getAsFloat();
                    if (this.jsonParameterValues.has(parameterName)) {
                        floatValue = this.jsonParameterContext.loadFloat(this.jsonParameterValues, parameterName, true);
                    } else if (reloadDefinition != null) {
                        floatValue = reloadDefinition.floatParameter.getValuef();
                    }
                    float minFloat = -3.4028235E38f;
                    float maxFloat = Float.MAX_VALUE;
                    if (parameterObj.has(KEY_PARAMETER_MIN)) {
                        minFloat = this.loadFloat(parameterObj, KEY_PARAMETER_MIN, false, "Parameter min value must be a float");
                    }
                    if (parameterObj.has(KEY_PARAMETER_MAX)) {
                        maxFloat = this.loadFloat(parameterObj, KEY_PARAMETER_MAX, false, "Parameter min value must be a float");
                    }
                    if (minFloat > maxFloat) {
                        this.addWarning("Parameter minimum may not be greater than maximum: " + minFloat + ">" + maxFloat);
                        break;
                    }
                    this.addJsonParameter(new ParameterDefinition(parameterName, parameterLabel, parameterDescription, floatValue, minFloat, maxFloat));
                    break;
                }
                case INT: {
                    int minInt = 0;
                    int maxInt = 65536;
                    if (parameterObj.has(KEY_PARAMETER_MIN)) {
                        minInt = this.loadInt(parameterObj, KEY_PARAMETER_MIN, false, "Parameter min value must be an integer");
                    }
                    if (parameterObj.has(KEY_PARAMETER_MAX)) {
                        maxInt = this.loadInt(parameterObj, KEY_PARAMETER_MAX, false, "Parameter min value must be an integer");
                    }
                    if (minInt > maxInt) {
                        this.addWarning("Parameter minimum may not be greater than maximum: " + minInt + ">" + maxInt);
                        break;
                    }
                    int intValue = defaultElem.getAsInt();
                    if (this.jsonParameterValues.has(parameterName)) {
                        intValue = this.jsonParameterContext.loadInt(this.jsonParameterValues, parameterName, true, "Child parameter should be an int: " + parameterName);
                    } else if (reloadDefinition != null) {
                        intValue = LXUtils.constrain(reloadDefinition.intParameter.getValuei(), minInt, maxInt);
                    }
                    this.addJsonParameter(new ParameterDefinition(parameterName, parameterLabel, parameterDescription, intValue, minInt, maxInt));
                    break;
                }
                case STRING: {
                    String stringValue = defaultElem.getAsString();
                    if (this.jsonParameterValues.has(parameterName)) {
                        stringValue = this.jsonParameterContext.loadString(this.jsonParameterValues, parameterName, true, "Child parameter should be an string: " + parameterName);
                    } else if (reloadDefinition != null) {
                        stringValue = reloadDefinition.stringParameter.getString();
                    }
                    this.addJsonParameter(new ParameterDefinition(parameterName, parameterLabel, parameterDescription, stringValue));
                    break;
                }
                case STRING_SELECT: {
                    String stringSelectValue = defaultElem.getAsString();
                    if (this.jsonParameterValues.has(parameterName)) {
                        stringSelectValue = this.jsonParameterContext.loadString(this.jsonParameterValues, parameterName, true, "Child parameter should be an string: " + parameterName);
                    } else if (reloadDefinition != null) {
                        stringSelectValue = reloadDefinition.stringSelectParameter.getObject();
                    }
                    ArrayList<String> stringOptions = new ArrayList<String>();
                    JsonArray optionsArray = this.loadArray(parameterObj, KEY_PARAMETER_OPTIONS);
                    for (JsonElement optionElem : optionsArray) {
                        if (optionElem.isJsonPrimitive()) {
                            stringOptions.add(optionElem.getAsString());
                            continue;
                        }
                        this.addWarning("options should only string options");
                    }
                    if (stringOptions.isEmpty()) {
                        this.addWarning("options must not be empty");
                        break;
                    }
                    if (!stringOptions.contains(stringSelectValue)) {
                        this.addWarning("options must contain default value " + stringSelectValue);
                        String string = (String)stringOptions.get(0);
                    }
                    this.addJsonParameter(new ParameterDefinition(parameterName, parameterLabel, parameterDescription, stringSelectValue, stringOptions));
                    break;
                }
                case BOOLEAN: {
                    boolean booleanValue = defaultElem.getAsBoolean();
                    if (this.jsonParameterValues.has(parameterName)) {
                        booleanValue = this.jsonParameterContext.loadBoolean(this.jsonParameterValues, parameterName, true, "Child parameter should be a boolean: " + parameterName);
                    } else if (reloadDefinition != null) {
                        booleanValue = reloadDefinition.booleanParameter.isOn();
                    }
                    this.addJsonParameter(new ParameterDefinition(parameterName, parameterLabel, parameterDescription, booleanValue));
                }
            }
        }
    }

    @Deprecated
    private void loadLegacyPoints(JsonObject obj) {
        JsonArray pointsArr = this.loadArray(obj, "points");
        if (pointsArr == null) {
            return;
        }
        this.addWarning("points is deprecated. Define an element of type points in the components array");
        for (JsonElement pointElem : pointsArr) {
            if (pointElem.isJsonObject()) {
                this.loadChild(pointElem.getAsJsonObject(), ChildType.POINT, null);
                continue;
            }
            if (pointElem.isJsonNull()) continue;
            this.addWarning("points should only contain point elements in JSON object format, found invalid: " + pointElem);
        }
    }

    @Deprecated
    private void loadLegacyStrips(JsonObject obj) {
        JsonArray stripsArr = this.loadArray(obj, KEY_STRIPS);
        if (stripsArr == null) {
            return;
        }
        this.addWarning("strips is deprecated. Define elements of type strip in the components array");
        for (JsonElement stripElem : stripsArr) {
            if (stripElem.isJsonObject()) {
                this.loadChild(stripElem.getAsJsonObject(), ChildType.STRIP, null);
                continue;
            }
            if (stripElem.isJsonNull()) continue;
            this.addWarning("strips should only contain strip elements in JSON object format, found invalid: " + stripElem);
        }
    }

    @Deprecated
    private void loadLegacyArcs(JsonObject obj) {
        JsonArray arcsArr = this.loadArray(obj, KEY_ARCS);
        if (arcsArr == null) {
            return;
        }
        this.addWarning("arcs is deprecated. Define elements of type arc in the components array");
        for (JsonElement arcElem : arcsArr) {
            if (arcElem.isJsonObject()) {
                this.loadChild(arcElem.getAsJsonObject(), ChildType.ARC, null);
                continue;
            }
            if (arcElem.isJsonNull()) continue;
            this.addWarning("arcs should only contain arc elements in JSON object format, found invalid: " + arcElem);
        }
    }

    @Deprecated
    private void loadLegacyChildren(JsonObject obj) {
        JsonArray childrenArr = this.loadArray(obj, KEY_CHILDREN);
        if (childrenArr == null) {
            return;
        }
        this.addWarning("children is deprecated. Define elements of specific type in the components array");
        for (JsonElement childElem : childrenArr) {
            if (childElem.isJsonObject()) {
                this.loadChild(childElem.getAsJsonObject());
                continue;
            }
            if (childElem.isJsonNull()) continue;
            this.addWarning("children should only contain child elements in JSON object format, found invalid: " + childElem);
        }
    }

    private PointListFixture loadPoints(JsonObject pointsObj) {
        JsonArray coordsArr = this.loadArray(pointsObj, KEY_COORDINATES);
        if (coordsArr == null) {
            this.addWarning("Points must specify coords");
            return null;
        }
        ArrayList<LXVector> coords = new ArrayList<LXVector>();
        for (JsonElement coordElem : coordsArr) {
            if (coordElem.isJsonObject()) {
                coords.add(this.loadVector(coordElem.getAsJsonObject(), "Coordinate should specify at least one x/y/z value"));
                continue;
            }
            if (coordElem.isJsonNull()) continue;
            this.addWarning("coords should only contain point elements in JSON object format, found invalid: " + coordElem);
        }
        if (coords.isEmpty()) {
            this.addWarning("Points must specify non-empty array of coords");
            return null;
        }
        return new PointListFixture(this.lx, coords);
    }

    private StripFixture loadStrip(JsonObject stripObj) {
        if (!stripObj.has(KEY_NUM_POINTS)) {
            this.addWarning("Strip must specify numPoints");
            return null;
        }
        int numPoints = this.loadInt(stripObj, KEY_NUM_POINTS, true, "Strip must specify a positive integer for numPoints");
        if (numPoints <= 0) {
            this.addWarning("Strip must specify positive integer value for numPoints");
            return null;
        }
        if (numPoints > 4096) {
            this.addWarning("Single strip may not define more than 4096 points, tried to define " + numPoints);
            return null;
        }
        StripFixture strip = new StripFixture(this.lx);
        strip.numPoints.setValue(numPoints);
        float spacing = 1.0f;
        if (stripObj.has(KEY_DIRECTION)) {
            JsonObject directionObj;
            if (stripObj.has(KEY_YAW) || stripObj.has(KEY_PITCH) || stripObj.has(KEY_ROLL)) {
                this.addWarning("Strip object should not specify both direction and yaw/pitch/roll, only using direction");
            }
            if ((directionObj = this.loadObject(stripObj, KEY_DIRECTION, "Strip direction should be a vector object")) != null) {
                LXVector direction = this.loadVector(directionObj, "Strip direction should specify at least one x/y/z value");
                if (direction.isZero()) {
                    this.addWarning("Strip direction vector should not be all 0");
                } else {
                    spacing = direction.mag();
                    strip.yaw.setValue(Math.toDegrees(Math.atan2(-direction.z, direction.x)));
                    strip.roll.setValue(Math.toDegrees(Math.asin(direction.y / spacing)));
                    strip.pitch.setValue(0.0);
                }
            }
        }
        if (stripObj.has(KEY_SPACING)) {
            float testSpacing = this.loadFloat(stripObj, KEY_SPACING, true, "Strip must specify a positive spacing");
            if (testSpacing >= 0.0f) {
                spacing = testSpacing;
            } else {
                this.addWarning("Strip may not specify a negative spacing");
            }
        }
        strip.spacing.setValue(spacing);
        return strip;
    }

    private ArcFixture loadArc(JsonObject arcObj) {
        if (!arcObj.has(KEY_NUM_POINTS)) {
            this.addWarning("Arc must specify numPoints, key was not found");
            return null;
        }
        int numPoints = this.loadInt(arcObj, KEY_NUM_POINTS, true, "Arc must specify a positive integer for numPoints");
        if (numPoints <= 0) {
            this.addWarning("Arc must specify positive integer value for numPoints");
            return null;
        }
        if (numPoints > 4096) {
            this.addWarning("Single arc may not define more than 4096 points");
            return null;
        }
        float radius = this.loadFloat(arcObj, KEY_RADIUS, true, "Arc must specify radius");
        if (radius <= 0.0f) {
            this.addWarning("Arc must specify positive value for radius");
            return null;
        }
        float degrees = this.loadFloat(arcObj, KEY_DEGREES, true, "Arc must specify number of degrees to cover");
        if (degrees <= 0.0f) {
            this.addWarning("Arc must specify positive value for degrees");
            return null;
        }
        ArcFixture arc = new ArcFixture(this.lx);
        arc.numPoints.setValue(numPoints);
        arc.radius.setValue(radius);
        arc.degrees.setValue(degrees);
        ArcFixture.PositionMode positionMode = ArcFixture.PositionMode.ORIGIN;
        if (arcObj.has(KEY_ARC_MODE)) {
            String arcMode = this.loadString(arcObj, KEY_ARC_MODE, true, "Arc mode must be a string");
            if (VALUE_ARC_MODE_CENTER.equals(arcMode)) {
                positionMode = ArcFixture.PositionMode.CENTER;
            } else if (VALUE_ARC_MODE_ORIGIN.equals(arcMode)) {
                positionMode = ArcFixture.PositionMode.ORIGIN;
            } else if (arcMode != null) {
                this.addWarning("Arc mode must be one of center or origin - invalid value " + arcMode);
            }
        }
        arc.positionMode.setValue((Object)positionMode);
        if (arcObj.has(KEY_NORMAL)) {
            JsonObject normalObj;
            if (arcObj.has(KEY_DIRECTION) || arcObj.has(KEY_YAW) || arcObj.has(KEY_PITCH)) {
                this.addWarning("Arc object should not specify both normal and direction/yaw/pitch, only using normal");
            }
            if ((normalObj = this.loadObject(arcObj, KEY_NORMAL, "Arc normal should be a vector object")) != null) {
                LXVector normal = this.loadVector(normalObj, "Arc normal should specify at least one x/y/z value");
                if (normal.isZero()) {
                    this.addWarning("Arc normal vector should not be all 0");
                } else {
                    arc.yaw.setValue(Math.toDegrees(Math.atan2(normal.x, normal.z)));
                    arc.pitch.setValue(Math.toDegrees(Math.asin(normal.y / normal.mag())));
                    arc.roll.setValue(Math.toRadians(this.loadFloat(arcObj, KEY_ROLL, true)));
                }
            }
        } else if (arcObj.has(KEY_DIRECTION)) {
            JsonObject directionObj;
            if (arcObj.has(KEY_YAW) || arcObj.has(KEY_ROLL) || arcObj.has(KEY_NORMAL)) {
                this.addWarning("Arc object should not specify both direction and yaw/roll/normal, only using direction");
            }
            if ((directionObj = this.loadObject(arcObj, KEY_DIRECTION, "Arc direction should be a vector object")) != null) {
                LXVector direction = this.loadVector(directionObj, "Arc direction should specify at least one x/y/z value");
                if (direction.isZero()) {
                    this.addWarning("Arc direction vector should not be all 0");
                } else {
                    arc.yaw.setValue(Math.toDegrees(Math.atan2(-direction.z, direction.x)));
                    arc.pitch.setValue(Math.toDegrees(Math.toRadians(this.loadFloat(arcObj, KEY_PITCH, true))));
                    arc.roll.setValue(Math.toDegrees(Math.asin(direction.y / direction.mag())));
                }
            }
        }
        return arc;
    }

    private void loadComponents(JsonObject obj) {
        JsonArray componentsArr = this.loadArray(obj, KEY_COMPONENTS);
        if (componentsArr == null) {
            return;
        }
        for (JsonElement componentElem : componentsArr) {
            if (componentElem.isJsonObject()) {
                this.componentsByIndex.add(null);
                this.loadChild(componentElem.getAsJsonObject());
                continue;
            }
            if (componentElem.isJsonNull()) continue;
            this.addWarning("components should only contain child elements in JSON object format, found invalid: " + componentElem);
        }
    }

    private void loadChild(JsonObject childObj) {
        boolean enabled;
        if (!childObj.has("type")) {
            this.addWarning("Child object must specify type");
            return;
        }
        String type = this.loadString(childObj, "type", true, "Child object must specify string type");
        if (type == null || type.isEmpty()) {
            this.addWarning("Child object must specify valid non-empty type: " + type);
            return;
        }
        if (childObj.has(KEY_ENABLED) && !(enabled = this.loadBoolean(childObj, KEY_ENABLED, true, "Child object must specify boolean expression for enabled"))) {
            return;
        }
        if (childObj.has(KEY_INSTANCES)) {
            int numInstances = this.loadInt(childObj, KEY_INSTANCES, true, "Child object must specify positive number of instances");
            if (numInstances <= 0) {
                this.addWarning("Child object specifies illegal number of instances: " + numInstances);
                return;
            }
            if (numInstances >= 4096) {
                this.addWarning("Child object specifies too many instances: " + numInstances + " >= " + 4096);
                return;
            }
            this.currentNumInstances = numInstances;
            int i = 0;
            while (i < numInstances) {
                this.currentChildInstance = i++;
                JsonObject instanceObj = childObj.deepCopy();
                instanceObj.remove(KEY_INSTANCES);
                this.loadChild(instanceObj);
            }
            this.currentNumInstances = -1;
            this.currentChildInstance = -1;
        } else if (TYPE_POINT.equals(type)) {
            this.loadChild(childObj, ChildType.POINT, null);
        } else if ("points".equals(type)) {
            this.loadChild(childObj, ChildType.POINTS, null);
        } else if (TYPE_STRIP.equals(type)) {
            this.loadChild(childObj, ChildType.STRIP, null);
        } else if (TYPE_ARC.equals(type)) {
            this.loadChild(childObj, ChildType.ARC, null);
        } else {
            this.loadChild(childObj, ChildType.JSON, type);
        }
    }

    private String getChildPrefix() {
        String fixtureType = this.fixtureType.getString();
        if (fixtureType == null || fixtureType.isEmpty()) {
            return null;
        }
        int pathIndex = fixtureType.lastIndexOf(47);
        if (pathIndex > 0) {
            return fixtureType.substring(0, pathIndex);
        }
        return null;
    }

    private void loadChild(JsonObject childObj, ChildType type, String jsonType) {
        LXFixture child = null;
        switch (type) {
            case POINT: {
                child = new PointFixture(this.lx);
                break;
            }
            case POINTS: {
                child = this.loadPoints(childObj);
                break;
            }
            case STRIP: {
                child = this.loadStrip(childObj);
                break;
            }
            case ARC: {
                child = this.loadArc(childObj);
                break;
            }
            case JSON: {
                if (jsonType == null || jsonType.isEmpty() || jsonType.equals(PATH_SEPARATOR)) {
                    throw new IllegalArgumentException("May not create JsonFixture with null or empty type");
                }
                if (jsonType.charAt(0) == '/') {
                    jsonType = jsonType.substring(0);
                } else {
                    String prefixedType;
                    File file;
                    String prefix = this.getChildPrefix();
                    if (prefix != null && (file = this.getFixtureFile(prefixedType = prefix + PATH_SEPARATOR + jsonType)).exists()) {
                        jsonType = prefixedType;
                    }
                }
                JsonFixture jsonChild = new JsonFixture(this.lx, this, childObj, jsonType);
                child = jsonChild;
                if (jsonChild.error.isOn()) {
                    this.setError(jsonChild.errorMessage.getString());
                    return;
                }
                if (!jsonChild.warning.isOn()) break;
                this.warnings.addAll(jsonChild.warnings);
                if (this.warning.isOn()) {
                    this.warning.bang();
                    break;
                }
                this.warning.setValue(true);
            }
        }
        if (child != null) {
            List<LXFixture> list;
            this.loadGeometry(child, childObj);
            this.loadBrightness(child, childObj);
            if (type != ChildType.JSON) {
                this.loadTags(child, childObj, false, false, true);
            }
            this.loadMetaData(childObj, child.metaData);
            this.loadOutputs(child, childObj);
            child.enabled.setValue(this.enabled.isOn());
            String childId = this.loadString(childObj, KEY_ID, true, "Component ID must be a valid string");
            if (childId != null) {
                boolean duplicated = false;
                if (this.currentChildInstance <= 0) {
                    if (this.componentsById.containsKey(childId)) {
                        this.addWarning("Cannot duplicate component ID already in use: " + childId);
                        duplicated = true;
                    } else {
                        ArrayList<PointListFixture> children = new ArrayList<PointListFixture>();
                        children.add((PointListFixture)child);
                        this.componentsById.put(childId, children);
                    }
                }
                if (!duplicated && this.currentChildInstance >= 0) {
                    if (this.currentChildInstance > 0) {
                        this.componentsById.get(childId).add(child);
                    }
                    this.componentsById.putIfAbsent(childId + "[" + this.currentChildInstance + "]", Arrays.asList(child));
                }
            }
            if ((list = this.componentsByIndex.get(this.componentsByIndex.size() - 1)) == null) {
                list = new ArrayList<LXFixture>();
                this.componentsByIndex.set(this.componentsByIndex.size() - 1, list);
            }
            list.add(child);
            this.addChild(child, true);
        }
    }

    private void loadOutputs(LXFixture fixture, JsonObject obj) {
        JsonArray outputsArr;
        JsonObject outputObj;
        if (obj.has(KEY_OUTPUT) && obj.has(KEY_OUTPUTS)) {
            this.addWarning("Should not have both output and outputs");
        }
        if ((outputObj = this.loadObject(obj, KEY_OUTPUT, "output must be an output object")) != null) {
            this.loadOutput(fixture, outputObj);
        }
        if ((outputsArr = this.loadArray(obj, KEY_OUTPUTS, "outputs must be an array of outputs")) != null) {
            for (JsonElement outputElem : outputsArr) {
                if (outputElem.isJsonObject()) {
                    this.loadOutput(fixture, outputElem.getAsJsonObject());
                    continue;
                }
                if (outputElem.isJsonNull()) continue;
                this.addWarning("outputs should only contain output elements in JSON object format, found invalid: " + outputElem);
            }
        }
    }

    private void loadOutput(LXFixture fixture, JsonObject outputObj) {
        String key;
        String universeKey;
        int universe;
        InetAddress address;
        String host;
        JsonProtocolDefinition protocol;
        boolean enabled;
        if (outputObj.has(KEY_ENABLED) && !(enabled = this.loadBoolean(outputObj, KEY_ENABLED, true, "Output field 'enabled' must be a valid boolean expression"))) {
            return;
        }
        float fps = 0.0f;
        if (outputObj.has(KEY_FPS) && ((fps = this.loadFloat(outputObj, KEY_FPS, true, "Output should specify valid FPS limit")) < 0.0f || fps > 300.0f)) {
            this.addWarning("Output FPS must be between 0-300.0");
            fps = 0.0f;
        }
        if ((protocol = JsonProtocolDefinition.get(this.loadString(outputObj, KEY_PROTOCOL, true, "Output must specify a valid protocol"))) == null) {
            this.addWarning("Output definition must define a valid protocol");
            return;
        }
        JsonTransportDefinition transport = JsonTransportDefinition.UDP;
        if (outputObj.has(KEY_TRANSPORT)) {
            if (protocol == JsonProtocolDefinition.OPC) {
                transport = JsonTransportDefinition.get(this.loadString(outputObj, KEY_TRANSPORT, true, "Output must specify valid transport"));
                if (transport == null) {
                    transport = JsonTransportDefinition.UDP;
                    this.addWarning("Output should define a valid transport");
                }
            } else {
                this.addWarning("Output transport may only be defined for OPC protocol, not " + (Object)((Object)protocol));
            }
        }
        if ((host = this.loadString(outputObj, KEY_HOST, true, "Output must specify a valid host")) == null || host.isEmpty()) {
            this.addWarning("Output must define a valid, non-empty host");
            return;
        }
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException uhx) {
            this.addWarning("Cannot send output to invalid host: " + host);
            return;
        }
        int port = -1;
        if (outputObj.has(KEY_PORT)) {
            port = this.loadInt(outputObj, KEY_PORT, true, "Output must specify a valid host");
            if (port <= 0) {
                this.addWarning("Output port number must be positive: " + port);
                return;
            }
        } else if (protocol.requiresExplicitPort()) {
            this.addWarning("Protcol " + (Object)((Object)protocol) + " requires an expicit port number to be specified");
            return;
        }
        if ((universe = this.loadInt(outputObj, universeKey = protocol.universeKey, true, "Output " + universeKey + " must be a valid integer")) < 0) {
            this.addWarning("Output " + universeKey + " may not be negative");
            return;
        }
        String channelKey = protocol.channelKey;
        int channel = this.loadInt(outputObj, channelKey, true, "Output " + channelKey + " must be a valid integer");
        if (channel < 0) {
            this.addWarning("Output " + channelKey + " may not be negative");
            return;
        }
        if (channel >= ((JsonProtocolDefinition)protocol).protocol.maxChannels) {
            this.addWarning("Output " + channelKey + " may not be greater than " + (Object)((Object)protocol.protocol) + " limit " + channel + " > " + ((JsonProtocolDefinition)protocol).protocol.maxChannels);
            return;
        }
        int priority = 100;
        if (outputObj.has(KEY_PRIORITY)) {
            int jsonPriority = this.loadInt(outputObj, KEY_PRIORITY, true, "Output priority must be a valid integer");
            if (jsonPriority < 0 || jsonPriority > 200) {
                this.addWarning("Output priority must be within range [0-200], ignoring value: " + jsonPriority);
            } else {
                priority = jsonPriority;
            }
        }
        KinetDatagram.Version kinetVersion = KinetDatagram.Version.PORTOUT;
        if (protocol == JsonProtocolDefinition.KINET && outputObj.has(KEY_KINET_VERSION) && (key = this.loadString(outputObj, KEY_KINET_VERSION, true, "Output must specify valid KiNET version of PORTOUT or DMXOUT")) != null) {
            try {
                kinetVersion = KinetDatagram.Version.valueOf(key.toUpperCase());
            }
            catch (Exception x) {
                this.addWarning("Output specifies an invalid KiNET version: " + key);
            }
        }
        boolean sequenceEnabled = this.loadBoolean(outputObj, KEY_SEQUENCE_ENABLED, true, "Output sequenceEnabled must be a valid boolean");
        JsonByteEncoderDefinition byteOrder = this.loadByteOrder(outputObj, JsonByteEncoderDefinition.RGB);
        ArrayList<JsonSegmentDefinition> segments = new ArrayList<JsonSegmentDefinition>();
        this.loadSegments(fixture, segments, outputObj, byteOrder);
        this.definedOutputs.add(new JsonOutputDefinition(fixture, protocol, transport, byteOrder, address, port, universe, channel, priority, sequenceEnabled, kinetVersion, fps, segments));
    }

    private void loadBrightness(LXFixture child, JsonObject childObj) {
        if (childObj.has(KEY_BRIGHTNESS)) {
            float brightness = this.loadFloat(childObj, KEY_BRIGHTNESS, true);
            if (brightness < 0.0f || brightness > 1.0f) {
                this.addWarning("Component brightness must be in the range 0-1, invalid: " + brightness);
            } else {
                child.brightness.setValue(brightness);
            }
        }
    }

    private void loadMetaData(JsonObject obj, Map<String, String> metaData) {
        JsonObject metaDataObj = this.loadObject(obj, KEY_META, "meta must be a JSON object");
        if (metaDataObj != null) {
            for (Map.Entry entry : metaDataObj.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (!value.isJsonPrimitive()) {
                    this.addWarning("Meta data values must be primtives, key has invalid type: " + key);
                    continue;
                }
                metaData.put(key, this.replaceVariables(key, value.getAsJsonPrimitive().getAsString(), ParameterType.STRING));
            }
        }
    }

    private void loadSegments(LXFixture fixture, List<JsonSegmentDefinition> segments, JsonObject outputObj, JsonByteEncoderDefinition defaultByteOrder) {
        if (outputObj.has(KEY_SEGMENTS)) {
            for (String segmentKey : SEGMENT_KEYS) {
                if (!outputObj.has(segmentKey)) continue;
                this.addWarning("output specifies segments, may not also specify " + segmentKey + ", will be ignored");
            }
            JsonArray segmentsArr = this.loadArray(outputObj, KEY_SEGMENTS, "segments must be an array of segments");
            if (segmentsArr != null) {
                for (JsonElement segmentElem : segmentsArr) {
                    if (segmentElem.isJsonObject()) {
                        this.loadSegment(fixture, segments, segmentElem.getAsJsonObject(), defaultByteOrder, false);
                        continue;
                    }
                    if (segmentElem.isJsonNull()) continue;
                    this.addWarning("segments should only contain segment elements in JSON object format, found invalid: " + segmentElem);
                }
            }
        } else {
            this.loadSegment(fixture, segments, outputObj, defaultByteOrder, true);
        }
    }

    private void loadSegment(LXFixture fixture, List<JsonSegmentDefinition> segments, JsonObject segmentObj, JsonByteEncoderDefinition outputByteOrder, boolean isOutput) {
        int offset;
        List<LXFixture> childComponents;
        int num = -1;
        int start = this.loadInt(segmentObj, KEY_START, true, "Output start must be a valid integer");
        if (start < 0) {
            this.addWarning("Output start may not be negative");
            return;
        }
        if (segmentObj.has(KEY_COMPONENT_ID)) {
            if (!(fixture instanceof JsonFixture)) {
                this.addWarning("Output componentId may only be used on custom fixtures");
                return;
            }
            String componentId = this.loadString(segmentObj, KEY_COMPONENT_ID, true, "Output componentId must be a valid string");
            if (componentId == null) {
                this.addWarning("Output componentId may not be empty");
                return;
            }
            childComponents = ((JsonFixture)fixture).componentsById.get(componentId);
            if (childComponents == null) {
                this.addWarning("Output componentId does not exist: " + componentId);
                return;
            }
            offset = start;
            start = ((JsonFixture)fixture).getFixtureOffset(childComponents.get(0));
            num = 0;
            for (LXFixture childFixture : childComponents) {
                num += childFixture.totalSize();
            }
            if (offset >= num) {
                this.addWarning("Output componentIndex start value " + offset + " exceeds size " + num);
                return;
            }
            start += offset;
            num -= offset;
        } else if (segmentObj.has(KEY_COMPONENT_INDEX)) {
            if (!(fixture instanceof JsonFixture)) {
                this.addWarning("Output componentIndex may only be used on custom fixtures");
                return;
            }
            int componentIndex = this.loadInt(segmentObj, KEY_COMPONENT_INDEX, true, "Output componentIndex must be a valid integer");
            if (componentIndex < 0) {
                this.addWarning("Output componentIndex may not be negative (" + componentIndex + ")");
                return;
            }
            if (componentIndex >= ((JsonFixture)fixture).componentsByIndex.size()) {
                this.addWarning("Output componentIndex is out of fixture range (" + componentIndex + ")");
                return;
            }
            childComponents = ((JsonFixture)fixture).componentsByIndex.get(componentIndex);
            if (childComponents == null) {
                this.addWarning("Output componentIndex in invalid or disabled (" + componentIndex + ")");
                return;
            }
            offset = start;
            start = ((JsonFixture)fixture).getFixtureOffset(childComponents.get(0));
            num = 0;
            for (LXFixture childFixture : childComponents) {
                num += childFixture.totalSize();
            }
            if (offset >= num) {
                this.addWarning("Output componentIndex start value " + offset + " exceeds size " + num);
                return;
            }
            start += offset;
            num -= offset;
        }
        if (segmentObj.has(KEY_NUM) && (num = this.loadInt(segmentObj, KEY_NUM, true, "Output num must be a valid integer")) < 0) {
            this.addWarning("Output num may not be negative");
            return;
        }
        int stride = 1;
        if (segmentObj.has(KEY_STRIDE) && (stride = this.loadInt(segmentObj, KEY_STRIDE, true, "Output stride must be a valid integer")) <= 0) {
            this.addWarning("Output stride must be a positive value, use 'reverse: true' to invert pixel order");
            return;
        }
        int repeat = 1;
        if (segmentObj.has(KEY_REPEAT) && (repeat = this.loadInt(segmentObj, KEY_REPEAT, true, "Output repeat must be a valid integer")) <= 0) {
            this.addWarning("Output repeat must be a positive value");
            return;
        }
        boolean reverse = this.loadBoolean(segmentObj, KEY_REVERSE, true, "Output reverse must be a valid boolean");
        JsonByteEncoderDefinition segmentByteOrder = null;
        if (!isOutput) {
            segmentByteOrder = this.loadByteOrder(segmentObj, null);
        }
        int duplicate = 1;
        if (segmentObj.has(KEY_DUPLICATE) && (duplicate = this.loadInt(segmentObj, KEY_DUPLICATE, true, "Output duplicate must be a valid integer")) <= 0) {
            this.addWarning("Output duplicate must be a positive value");
            return;
        }
        JsonSegmentDefinition segment = new JsonSegmentDefinition(start, num, stride, repeat, reverse, segmentByteOrder);
        for (int i = 0; i < duplicate; ++i) {
            segments.add(segment);
        }
    }

    private JsonByteEncoderDefinition loadByteOrder(JsonObject obj, JsonByteEncoderDefinition defaultByteOrder) {
        JsonByteEncoderDefinition byteOrder = defaultByteOrder;
        String byteOrderStr = this.loadString(obj, KEY_BYTE_ORDER, true, "Output must specify a valid string byteOrder");
        if (byteOrderStr != null) {
            if (byteOrderStr.isEmpty()) {
                this.addWarning("Output must specify non-empty string value for byteOrder");
            } else {
                JsonByteEncoderDefinition definedByteOrder = JsonByteEncoderDefinition.get(this.lx, byteOrderStr);
                if (definedByteOrder == null) {
                    this.addWarning("Unrecognized byte order type: " + byteOrderStr);
                } else {
                    byteOrder = definedByteOrder;
                }
            }
        }
        return byteOrder;
    }

    @Override
    protected void buildOutputs() {
        for (JsonOutputDefinition output : this.definedOutputs) {
            this.buildOutput(output);
        }
    }

    private int getFixtureOffset(LXFixture child) {
        int offset = this.size();
        for (LXFixture fixture : this.children) {
            if (child == fixture) {
                return offset;
            }
            offset += fixture.totalSize();
        }
        return 0;
    }

    private void buildOutput(JsonOutputDefinition output) {
        if (output.protocol == JsonProtocolDefinition.ARTSYNC) {
            this.buildArtSyncDatagram(output);
            return;
        }
        int fixtureOffset = this.getFixtureOffset(output.fixture);
        int fixtureSize = output.fixture.totalSize();
        ArrayList<LXFixture.Segment> segments = new ArrayList<LXFixture.Segment>();
        for (JsonSegmentDefinition segment : output.segments) {
            int num;
            if (segment.start < 0 || segment.start >= fixtureSize) {
                this.addWarning("Output specifies invalid start position: " + segment.start + " should be between [0, " + (fixtureSize - 1) + "]");
                return;
            }
            int n = num = segment.num == -1 ? fixtureSize : segment.num;
            if (segment.start + segment.stride * (num - 1) >= fixtureSize) {
                this.addWarning("Output specifies excessive size beyond fixture limits: start=" + segment.start + " num=" + num + " stride=" + segment.stride + " fixtureSize=" + fixtureSize);
                return;
            }
            segments.add(new LXFixture.Segment(segment.start + fixtureOffset, num, segment.stride, segment.repeat, segment.reverse, segment.byteEncoder != null ? segment.byteEncoder.byteEncoder : output.byteEncoder.byteEncoder));
        }
        this.addOutputDefinition(new LXFixture.OutputDefinition(output.protocol.protocol, output.transport.transport, output.address, output.port == -1 ? ((JsonProtocolDefinition)((JsonOutputDefinition)output).protocol).protocol.defaultPort : output.port, output.universe, output.channel, output.priority, output.sequenceEnabled, output.kinetVersion, output.fps, segments.toArray(new LXFixture.Segment[0])));
    }

    private void buildArtSyncDatagram(JsonOutputDefinition output) {
        ArtSyncDatagram artSync = new ArtSyncDatagram(this.lx);
        if (output.port != -1) {
            artSync.setPort(output.port);
        }
        artSync.setAddress(output.address);
        artSync.framesPerSecond.setValue(output.fps);
        this.addOutputDirect(artSync);
    }

    @Override
    protected int size() {
        return 0;
    }

    @Override
    protected void computePointGeometry(LXMatrix matrix, List<LXPoint> points) {
    }

    @Override
    protected void addModelMetaData(Map<String, String> metaData) {
        for (ParameterDefinition parameter : this.definedParameters.values()) {
            metaData.put(parameter.name, parameter.getValueAsString());
        }
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        if (this.isJsonSubfixture) {
            throw new IllegalStateException("Should never be loading/saving a child JsonSubfixture");
        }
        this.jsonParameterValues = obj.has(KEY_JSON_PARAMETERS) ? obj.get(KEY_JSON_PARAMETERS).getAsJsonObject() : new JsonObject();
        super.load(lx, obj);
        this.jsonParameterValues = new JsonObject();
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        if (this.isJsonSubfixture) {
            throw new IllegalStateException("Should never be loading/saving a child JsonSubfixture");
        }
        obj.addProperty(KEY_FIXTURE_TYPE, this.fixtureType.getString());
        JsonObject jsonParameters = new JsonObject();
        for (ParameterDefinition parameter : this.definedParameters.values()) {
            switch (parameter.type) {
                case FLOAT: {
                    jsonParameters.addProperty(parameter.name, (Number)parameter.floatParameter.getValue());
                    break;
                }
                case INT: {
                    jsonParameters.addProperty(parameter.name, (Number)parameter.intParameter.getValuei());
                    break;
                }
                case STRING: {
                    jsonParameters.addProperty(parameter.name, parameter.stringParameter.getString());
                    break;
                }
                case STRING_SELECT: {
                    jsonParameters.addProperty(parameter.name, parameter.stringSelectParameter.getObject());
                    break;
                }
                case BOOLEAN: {
                    jsonParameters.addProperty(parameter.name, Boolean.valueOf(parameter.booleanParameter.isOn()));
                }
            }
        }
        obj.add(KEY_JSON_PARAMETERS, (JsonElement)jsonParameters);
        super.save(lx, obj);
    }

    private class JsonOutputDefinition {
        private static final int ALL_POINTS = -1;
        private static final int DEFAULT_PORT = -1;
        private final LXFixture fixture;
        private final JsonProtocolDefinition protocol;
        private final JsonTransportDefinition transport;
        private final JsonByteEncoderDefinition byteEncoder;
        private final InetAddress address;
        private final int port;
        private final int universe;
        private final int channel;
        private final int priority;
        private final boolean sequenceEnabled;
        private final KinetDatagram.Version kinetVersion;
        private final float fps;
        private final List<JsonSegmentDefinition> segments;

        private JsonOutputDefinition(LXFixture fixture, JsonProtocolDefinition protocol, JsonTransportDefinition transport, JsonByteEncoderDefinition byteOrder, InetAddress address, int port, int universe, int channel, int priority, boolean sequenceEnabled, KinetDatagram.Version kinetVersion, float fps, List<JsonSegmentDefinition> segments) {
            this.fixture = fixture;
            this.protocol = protocol;
            this.transport = transport;
            this.byteEncoder = byteOrder;
            this.address = address;
            this.port = port;
            this.universe = universe;
            this.channel = channel;
            this.priority = priority;
            this.sequenceEnabled = sequenceEnabled;
            this.kinetVersion = kinetVersion;
            this.fps = fps;
            this.segments = segments;
        }
    }

    public class ParameterDefinition
    implements LXParameterListener {
        public final String name;
        public final String label;
        public final String description;
        public final ParameterType type;
        public final LXListenableParameter parameter;
        public final DiscreteParameter intParameter;
        public final BoundedParameter floatParameter;
        public final StringParameter stringParameter;
        public final BooleanParameter booleanParameter;
        public final ObjectParameter<String> stringSelectParameter;
        private boolean isReferenced = false;

        private ParameterDefinition(String name, String label, String description, ParameterType type, LXListenableParameter parameter) {
            this.name = name;
            this.label = label;
            this.description = description;
            this.type = type;
            this.parameter = parameter;
            if (description != null) {
                parameter.setDescription(description);
            }
            switch (type) {
                case STRING: {
                    this.stringParameter = (StringParameter)parameter;
                    this.intParameter = null;
                    this.floatParameter = null;
                    this.booleanParameter = null;
                    this.stringSelectParameter = null;
                    break;
                }
                case INT: {
                    this.stringParameter = null;
                    this.intParameter = (DiscreteParameter)parameter;
                    this.floatParameter = null;
                    this.booleanParameter = null;
                    this.stringSelectParameter = null;
                    break;
                }
                case FLOAT: {
                    this.stringParameter = null;
                    this.intParameter = null;
                    this.floatParameter = (BoundedParameter)parameter;
                    this.booleanParameter = null;
                    this.stringSelectParameter = null;
                    break;
                }
                case BOOLEAN: {
                    this.stringParameter = null;
                    this.intParameter = null;
                    this.floatParameter = null;
                    this.booleanParameter = (BooleanParameter)parameter;
                    this.stringSelectParameter = null;
                    break;
                }
                case STRING_SELECT: {
                    this.stringSelectParameter = (ObjectParameter)parameter;
                    this.stringParameter = null;
                    this.intParameter = null;
                    this.floatParameter = null;
                    this.booleanParameter = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown ParameterType: " + (Object)((Object)type));
                }
            }
            parameter.addListener(this);
        }

        private ParameterDefinition(String name, String label, String description, String defaultStr) {
            this(name, label, description, ParameterType.STRING, new StringParameter(label, defaultStr));
        }

        private ParameterDefinition(String name, String label, String description, int defaultInt, int minInt, int maxInt) {
            this(name, label, description, ParameterType.INT, new DiscreteParameter(label, defaultInt, minInt, maxInt + 1));
        }

        private ParameterDefinition(String name, String label, String description, float defaultFloat, float minFloat, float maxFloat) {
            this(name, label, description, ParameterType.FLOAT, new BoundedParameter(label, defaultFloat, minFloat, maxFloat));
        }

        private ParameterDefinition(String name, String label, String description, boolean defaultBoolean) {
            this(name, label, description, ParameterType.BOOLEAN, new BooleanParameter(label, defaultBoolean));
        }

        private ParameterDefinition(String name, String label, String description, String defaultStr, List<String> stringOptions) {
            this(name, label, description, ParameterType.STRING_SELECT, new ObjectParameter<String>(label, stringOptions.toArray(new String[0]), defaultStr));
        }

        private void dispose() {
            this.parameter.removeListener(this);
            this.parameter.dispose();
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            if (this.isReferenced) {
                JsonFixture.this.reload(false);
            }
        }

        public String getValueAsString() {
            switch (this.type) {
                case BOOLEAN: {
                    return String.valueOf(this.booleanParameter.isOn());
                }
                case FLOAT: {
                    return String.valueOf(this.floatParameter.getValue());
                }
                case INT: {
                    return String.valueOf(this.intParameter.getValuei());
                }
                case STRING: {
                    return this.stringParameter.getString();
                }
                case STRING_SELECT: {
                    return this.stringSelectParameter.getObject();
                }
            }
            return "";
        }
    }

    public static enum ParameterType {
        STRING("string"),
        INT("int"),
        FLOAT("float"),
        BOOLEAN("boolean"),
        STRING_SELECT(null);

        private final String key;

        private ParameterType(String key) {
            this.key = key;
        }

        private static ParameterType get(String str) {
            for (ParameterType type : ParameterType.values()) {
                if (!str.toLowerCase().equals(type.key)) continue;
                return type;
            }
            return null;
        }
    }

    private static enum SimpleFunction {
        sin(f -> (float)Math.sin(Math.toRadians(f))),
        cos(f -> (float)Math.cos(Math.toRadians(f))),
        tan(f -> (float)Math.tan(Math.toRadians(f))),
        asin(f -> (float)Math.toDegrees(Math.asin(f))),
        acos(f -> (float)Math.toDegrees(Math.acos(f))),
        atan(f -> (float)Math.toDegrees(Math.atan(f))),
        deg(f -> (float)Math.toDegrees(f)),
        rad(f -> (float)Math.toRadians(f)),
        abs(f -> Math.abs(f)),
        sqrt(f -> (float)Math.sqrt(f));

        private final Compute compute;

        private SimpleFunction(Compute compute) {
            this.compute = compute;
        }

        private static interface Compute {
            public float compute(float var1);
        }
    }

    public static enum ChildType {
        POINT,
        POINTS,
        STRIP,
        ARC,
        JSON;

    }

    private static enum JsonProtocolDefinition {
        ARTNET(LXFixture.Protocol.ARTNET, "universe", "channel", "artnet", "artdmx"),
        ARTSYNC(LXFixture.Protocol.ARTNET, null, null, "artsync"),
        SACN(LXFixture.Protocol.SACN, "universe", "channel", "sacn", "e131"),
        DDP(LXFixture.Protocol.DDP, "dataOffset", null, "ddp"),
        OPC(LXFixture.Protocol.OPC, "channel", "offset", "opc"),
        KINET(LXFixture.Protocol.KINET, "kinetPort", "channel", "kinet");

        private final LXFixture.Protocol protocol;
        private final String universeKey;
        private final String channelKey;
        private final String[] protocolKeys;

        private JsonProtocolDefinition(LXFixture.Protocol protocol, String universeKey, String channelKey, String ... protocolKeys) {
            this.protocol = protocol;
            this.universeKey = universeKey;
            this.channelKey = channelKey;
            this.protocolKeys = protocolKeys;
        }

        public boolean requiresExplicitPort() {
            return this == OPC;
        }

        private static JsonProtocolDefinition get(String key) {
            for (JsonProtocolDefinition protocol : JsonProtocolDefinition.values()) {
                for (String protocolKey : protocol.protocolKeys) {
                    if (!protocolKey.equals(key)) continue;
                    return protocol;
                }
            }
            return null;
        }
    }

    private static enum JsonTransportDefinition {
        UDP(LXFixture.Transport.UDP, "udp"),
        TCP(LXFixture.Transport.TCP, "tcp");

        private final LXFixture.Transport transport;
        private final String transportKey;

        private JsonTransportDefinition(LXFixture.Transport transport, String transportKey) {
            this.transport = transport;
            this.transportKey = transportKey;
        }

        private static JsonTransportDefinition get(String key) {
            for (JsonTransportDefinition protocol : JsonTransportDefinition.values()) {
                if (!protocol.transportKey.equals(key)) continue;
                return protocol;
            }
            return null;
        }
    }

    private static class JsonByteEncoderDefinition {
        private static final JsonByteEncoderDefinition RGB = new JsonByteEncoderDefinition(LXBufferOutput.ByteOrder.RGB);
        private static final Map<String, JsonByteEncoderDefinition> instances = new HashMap<String, JsonByteEncoderDefinition>();
        private final LXBufferOutput.ByteEncoder byteEncoder;

        private JsonByteEncoderDefinition(LXBufferOutput.ByteEncoder byteEncoder) {
            this.byteEncoder = byteEncoder;
        }

        private JsonByteEncoderDefinition(LX lx, String className) throws NoSuchMethodException, ClassNotFoundException {
            final Class<?> cls = lx.instantiateStatic(className.replace('/', '$'));
            final Method getNumBytes = cls.getMethod("getNumBytes", new Class[0]);
            final Method writeBytes = cls.getMethod("writeBytes", Integer.TYPE, LXOutput.GammaTable.Curve.class, byte[].class, Integer.TYPE);
            this.byteEncoder = new LXBufferOutput.ByteEncoder(){

                @Override
                public int getNumBytes() {
                    try {
                        return (Integer)getNumBytes.invoke(null, new Object[0]);
                    }
                    catch (Throwable t) {
                        LX.error("ByteEncoderClass " + cls + " error on getNumBytes: " + t.getMessage());
                        return 0;
                    }
                }

                @Override
                public void writeBytes(int argb, LXOutput.GammaTable.Curve gamma, byte[] output, int offset) {
                    try {
                        writeBytes.invoke(null, argb, gamma, output, offset);
                    }
                    catch (Throwable t) {
                        LX.error("ByteEncoderClass " + cls + " error on writeBytes: " + t.getMessage());
                    }
                }
            };
        }

        private static JsonByteEncoderDefinition get(LX lx, String order) {
            JsonByteEncoderDefinition instance = instances.get(order);
            if (instance != null) {
                return instance;
            }
            for (LXBufferOutput.ByteOrder byteOrder : LXBufferOutput.ByteOrder.values()) {
                if (!order.equalsIgnoreCase(byteOrder.name())) continue;
                instance = new JsonByteEncoderDefinition(byteOrder);
                instances.put(order, instance);
                return instance;
            }
            try {
                final Class<?> cls = lx.instantiateStatic(order.replace('/', '$'));
                final Method getNumBytes = cls.getMethod("getNumBytes", new Class[0]);
                final Method writeBytes = cls.getMethod("writeBytes", Integer.TYPE, LXOutput.GammaTable.Curve.class, byte[].class, Integer.TYPE);
                instance = new JsonByteEncoderDefinition(new LXBufferOutput.ByteEncoder(){

                    @Override
                    public int getNumBytes() {
                        try {
                            return (Integer)getNumBytes.invoke(null, new Object[0]);
                        }
                        catch (Throwable t) {
                            LX.error("JsonByteEncoder " + cls + " error on getNumBytes: " + t.getMessage());
                            return 0;
                        }
                    }

                    @Override
                    public void writeBytes(int argb, LXOutput.GammaTable.Curve gamma, byte[] output, int offset) {
                        try {
                            writeBytes.invoke(null, argb, gamma, output, offset);
                        }
                        catch (Throwable t) {
                            LX.error("JsonByteEncoder " + cls + " error on writeBytes: " + t.getMessage());
                        }
                    }
                });
                instances.put(order, instance);
                return instance;
            }
            catch (Throwable x) {
                LX.error(x, "Could not instantiate JsonByteEncoder " + order + ": " + x.getMessage());
                return null;
            }
        }
    }

    private class JsonSegmentDefinition {
        private final int start;
        private final int num;
        private final int stride;
        private final int repeat;
        private final boolean reverse;
        private final JsonByteEncoderDefinition byteEncoder;

        private JsonSegmentDefinition(int start, int num, int stride, int repeat, boolean reverse, JsonByteEncoderDefinition byteEncoder) {
            this.start = start;
            this.num = num;
            this.stride = stride;
            this.repeat = repeat;
            this.reverse = reverse;
            this.byteEncoder = byteEncoder;
        }
    }
}

