/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.command.LXCommand;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXNormalizationBounds;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.structure.JsonFixture;
import heronarts.lx.structure.LXFixture;
import heronarts.lx.structure.LXFixtureContainer;
import heronarts.lx.structure.LXStructureOutput;
import heronarts.lx.structure.view.LXViewDefinition;
import heronarts.lx.structure.view.LXViewEngine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LXStructure
extends LXComponent
implements LXFixtureContainer {
    private static final String PROJECT_MODEL = "<Embedded in Project>";
    private ModelListener modelListener;
    private File modelFile = null;
    public final StringParameter modelName = new StringParameter("Model Name", "<Embedded in Project>").setDescription("Displays the name of the loaded model, may be a class or an .lxm file");
    public final BooleanParameter isStatic = new BooleanParameter("Static Model", false).setDescription("Whether a static model class is being used");
    public final BooleanParameter syncModelFile = new BooleanParameter("Sync Model File", false).setDescription("Keep the project model in sync with the model file. Saving the project automatically writes to the model file.");
    public final StringParameter outputError = new StringParameter("Output Error", null);
    public final BooleanParameter allWhite = new BooleanParameter("White", false).setDescription("Output full white to all pixels");
    public final BooleanParameter mute = new BooleanParameter("Mute", false).setDescription("Send black to all pixels");
    public final EnumParameter<NormalizationMode> normalizationMode = new EnumParameter<NormalizationMode>("Normalization", NormalizationMode.AUTOMATIC).setDescription("Whether the normalization space is defined by the model or manually");
    public final BoundedParameter normalizationX = new BoundedParameter("X", 0.0, -1000000.0, 1000000.0).setDescription("Manual X position of the normalization center");
    public final BoundedParameter normalizationY = new BoundedParameter("Y", 0.0, -1000000.0, 1000000.0).setDescription("Manual Y position of the normalization center");
    public final BoundedParameter normalizationZ = new BoundedParameter("Z", 0.0, -1000000.0, 1000000.0).setDescription("Manual Z position of the normalization center");
    public final BoundedParameter normalizationWidth = new BoundedParameter("Width", 1000.0, 0.0, 1000000.0).setDescription("With of the normalization space");
    public final BoundedParameter normalizationHeight = new BoundedParameter("Height", 1000.0, 0.0, 1000000.0).setDescription("Height of the normalization space");
    public final BoundedParameter normalizationDepth = new BoundedParameter("Depth", 1000.0, 0.0, 1000000.0).setDescription("Depth of the normalization space");
    public final BooleanParameter showNormalizationBounds = new BooleanParameter("Show Normalization Bounds", false).setDescription("Outline the normalization bounds in the preview window");
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<LXFixture> mutableFixtures = new ArrayList<LXFixture>();
    public final List<LXFixture> fixtures = Collections.unmodifiableList(this.mutableFixtures);
    private LXModel model;
    private LXModel staticModel = null;
    private boolean isDirty = false;
    private final boolean isImmutable;
    public final LXStructureOutput output;
    public final LXViewEngine views;
    private final LXParameter.Collection normalizationParameters = new LXParameter.Collection();
    private boolean isLoading = false;
    private static final String KEY_FIXTURES = "fixtures";
    private static final String KEY_NORMALIZATION = "normalization";
    private static final String KEY_STATIC_MODEL = "staticModel";
    private static final String KEY_FILE = "file";
    private static final String KEY_OUTPUT = "output";

    public LXStructure(LX lx, LXModel immutable, ModelListener modelListener) {
        super(lx);
        this.addParameter("syncModelFile", this.syncModelFile);
        this.addParameter("allWhite", this.allWhite);
        this.addParameter("mute", this.mute);
        this.addNormalizationParameter("normalizationMode", this.normalizationMode);
        this.addNormalizationParameter("normalizationX", this.normalizationX);
        this.addNormalizationParameter("normalizationY", this.normalizationY);
        this.addNormalizationParameter("normalizationZ", this.normalizationZ);
        this.addNormalizationParameter("normalizationWidth", this.normalizationWidth);
        this.addNormalizationParameter("normalizationHeight", this.normalizationHeight);
        this.addNormalizationParameter("normalizationDepth", this.normalizationDepth);
        this.addInternalParameter("showNormalizationBounds", this.showNormalizationBounds);
        this.views = new LXViewEngine(lx);
        this.addChild("views", this.views);
        if (immutable != null) {
            this.isImmutable = true;
            this.staticModel = this.model = immutable.normalizePoints();
            this.isStatic.setValue(true);
        } else {
            this.isImmutable = false;
            this.model = new LXModel();
        }
        LXStructureOutput output = null;
        try {
            output = new LXStructureOutput(lx, this);
        }
        catch (SocketException sx) {
            lx.pushError(sx, "Serious network error, could not create output socket. Program will continue with no network output.\n" + sx.getLocalizedMessage());
            LX.error(sx, "Failed to create datagram socket for structure datagram output, will continue with no network output: " + sx.getLocalizedMessage());
        }
        this.output = output;
        this.modelListener = modelListener;
    }

    private void addNormalizationParameter(String path, LXListenableParameter p) {
        this.normalizationParameters.put(path, p);
        this.addParameter(path, p);
        p.addListener(this::normalizationChanged);
    }

    private void normalizationChanged(LXParameter p) {
        if (p == this.normalizationMode || this.normalizationMode.getEnum() == NormalizationMode.MANUAL) {
            this.regenerateModel(false);
        }
    }

    private LXNormalizationBounds generateManualNormalizationBounds() {
        if (this.normalizationMode.getEnum() == NormalizationMode.AUTOMATIC) {
            return null;
        }
        LXNormalizationBounds bounds = new LXNormalizationBounds();
        bounds.cx = this.normalizationX.getValuef();
        bounds.cy = this.normalizationY.getValuef();
        bounds.cz = this.normalizationZ.getValuef();
        bounds.xRange = this.normalizationWidth.getValuef();
        bounds.yRange = this.normalizationHeight.getValuef();
        bounds.zRange = this.normalizationDepth.getValuef();
        bounds.xMin = bounds.cx - 0.5f * bounds.xRange;
        bounds.xMax = bounds.cx + 0.5f * bounds.xRange;
        bounds.yMin = bounds.cy - 0.5f * bounds.yRange;
        bounds.yMax = bounds.cy + 0.5f * bounds.yRange;
        bounds.zMin = bounds.cz - 0.5f * bounds.zRange;
        bounds.zMax = bounds.cz + 0.5f * bounds.zRange;
        return bounds;
    }

    @Override
    public String getPath() {
        return "structure";
    }

    public File getModelFile() {
        return this.modelFile;
    }

    public LXModel getModel() {
        return this.model;
    }

    public LXStructure addListener(Listener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXStructure.Listener: " + listener);
        }
        this.listeners.add(listener);
        return this;
    }

    public LXStructure removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-registered LXStructure.Listener: " + listener);
        }
        this.listeners.remove(listener);
        return this;
    }

    private void checkStaticModel(boolean isStatic, String error) {
        if (this.staticModel != null != isStatic) {
            throw new IllegalStateException(error);
        }
    }

    public LXStructure addFixture(LXFixture fixture) {
        return this.addFixture(fixture, -1);
    }

    public LXStructure addFixture(LXFixture fixture, int index) {
        this.checkStaticModel(false, "Cannot invoke addFixture when static model is in use");
        if (this.mutableFixtures.contains(fixture)) {
            throw new IllegalStateException("LXStructure may not contain two copies of same fixture");
        }
        if (index > this.fixtures.size()) {
            throw new IllegalArgumentException("Illegal LXStructure.addFixture() index: " + index + " > " + this.fixtures.size());
        }
        if (index < 0) {
            index = this.fixtures.size();
        }
        this.mutableFixtures.add(index, fixture);
        this._reindexFixtures();
        this.selectFixture(fixture);
        fixture.setStructure(this);
        for (Listener l : this.listeners) {
            l.fixtureAdded(fixture);
        }
        return this;
    }

    private void _reindexFixtures() {
        int i = 0;
        for (LXFixture fixture : this.fixtures) {
            fixture.setIndex(i++);
        }
    }

    public LXStructure moveFixture(LXFixture fixture, int index) {
        this.checkStaticModel(false, "Cannot invoke setFixtureIndex when static model is in use");
        if (!this.mutableFixtures.contains(fixture)) {
            throw new IllegalStateException("Cannot set index on fixture not in structure: " + fixture);
        }
        this.mutableFixtures.remove(fixture);
        this.mutableFixtures.add(index, fixture);
        this._reindexFixtures();
        for (Listener l : this.listeners) {
            l.fixtureMoved(fixture, index);
        }
        this.regenerateModel(false);
        this.regenerateOutputs();
        return this;
    }

    public LXStructure selectFixtureRange(LXFixture fixture) {
        int targetIndex;
        int minIndex = targetIndex = fixture.getIndex();
        int maxIndex = targetIndex;
        for (LXFixture f : this.fixtures) {
            int index = f.getIndex();
            if (!f.selected.isOn()) continue;
            if (index < minIndex) {
                minIndex = index;
            }
            if (index <= maxIndex) continue;
            maxIndex = index;
        }
        fixture.selected.setValue(true);
        for (int i = minIndex + 1; i < maxIndex; ++i) {
            this.fixtures.get((int)i).selected.setValue(true);
        }
        return this;
    }

    public LXStructure selectAllFixtures() {
        for (LXFixture fixture : this.fixtures) {
            fixture.selected.setValue(true);
        }
        return this;
    }

    public LXStructure selectFixture(LXFixture fixture) {
        return this.selectFixture(fixture, false);
    }

    public LXStructure selectFixture(LXFixture fixture, boolean isMultipleSelection) {
        if (isMultipleSelection) {
            fixture.selected.setValue(true);
        } else {
            for (LXFixture f : this.fixtures) {
                f.selected.setValue(fixture == f);
            }
        }
        return this;
    }

    public LXStructure soloFixture(LXFixture fixture) {
        for (LXFixture f : this.fixtures) {
            f.solo.setValue(f == fixture);
        }
        return this;
    }

    public List<LXFixture> getSelectedFixtures() {
        ArrayList<LXFixture> selected = new ArrayList<LXFixture>();
        for (LXFixture fixture : this.fixtures) {
            if (!fixture.selected.isOn()) continue;
            selected.add(fixture);
        }
        return selected;
    }

    public LXStructure removeFixtures(List<LXFixture> fixtures) {
        this.checkStaticModel(false, "Cannot invoke removeFixtures when static model is in use");
        ArrayList<LXFixture> removed = new ArrayList<LXFixture>();
        for (LXFixture fixture : fixtures) {
            if (!this.mutableFixtures.remove(fixture)) {
                throw new IllegalStateException("Cannot remove fixture not present in structure");
            }
            removed.add(fixture);
        }
        this._reindexFixtures();
        for (LXFixture fixture : removed) {
            for (Listener l : this.listeners) {
                l.fixtureRemoved(fixture);
            }
            fixture.dispose();
        }
        this.fixtureRemoved();
        return this;
    }

    public LXStructure removeSelectedFixtures() {
        this.checkStaticModel(false, "Cannot invoke removeSelectedFixture when static model is in use");
        ArrayList<LXFixture> removed = new ArrayList<LXFixture>();
        for (int i = this.mutableFixtures.size() - 1; i >= 0; --i) {
            LXFixture fixture = this.mutableFixtures.get(i);
            if (!fixture.selected.isOn()) continue;
            this.mutableFixtures.remove(i);
            removed.add(fixture);
        }
        this._reindexFixtures();
        for (LXFixture fixture : removed) {
            for (Listener l : this.listeners) {
                l.fixtureRemoved(fixture);
            }
            fixture.dispose();
        }
        this.fixtureRemoved();
        return this;
    }

    public LXStructure removeFixture(LXFixture fixture) {
        this.checkStaticModel(false, "Cannot invoke removeFixture when static model is in use");
        if (!this.mutableFixtures.contains(fixture)) {
            throw new IllegalStateException("LXStructure does not contain fixture: " + fixture);
        }
        this.mutableFixtures.remove(fixture);
        this._reindexFixtures();
        for (Listener l : this.listeners) {
            l.fixtureRemoved(fixture);
        }
        fixture.dispose();
        this.fixtureRemoved();
        return this;
    }

    private void removeAllFixtures() {
        this.checkStaticModel(false, "Cannot invoke removeAllFixtures when static model is in use");
        for (int i = this.mutableFixtures.size() - 1; i >= 0; --i) {
            LXFixture fixture = this.mutableFixtures.remove(i);
            for (Listener l : this.listeners) {
                l.fixtureRemoved(fixture);
            }
            fixture.dispose();
        }
        this.fixtureRemoved();
    }

    public LXStructure translateSelectedFixtures(float tx, float ty, float tz) {
        return this.translateSelectedFixtures(tx, ty, tz, null);
    }

    public LXStructure translateSelectedFixtures(float tx, float ty, float tz, LXCommand.Structure.ModifyFixturePositions action) {
        for (LXFixture fixture : this.fixtures) {
            if (!fixture.selected.isOn()) continue;
            if (tx != 0.0f) {
                if (action != null) {
                    action.update(this.lx, fixture.x, tx);
                } else {
                    fixture.x.incrementValue(tx);
                }
            }
            if (ty != 0.0f) {
                if (action != null) {
                    action.update(this.lx, fixture.y, ty);
                } else {
                    fixture.y.incrementValue(ty);
                }
            }
            if (tz == 0.0f) continue;
            if (action != null) {
                action.update(this.lx, fixture.z, tz);
                continue;
            }
            fixture.z.incrementValue(tz);
        }
        return this;
    }

    public LXStructure rotateSelectedFixtures(float theta, float phi) {
        return this.rotateSelectedFixtures(theta, phi, null);
    }

    public LXStructure rotateSelectedFixtures(float theta, float phi, LXCommand.Structure.ModifyFixturePositions action) {
        for (LXFixture fixture : this.fixtures) {
            if (!fixture.selected.isOn()) continue;
            if (theta != 0.0f) {
                if (action != null) {
                    action.update(this.lx, fixture.yaw, (double)(theta * 180.0f) / Math.PI);
                } else {
                    fixture.yaw.incrementValue((double)(theta * 180.0f) / Math.PI);
                }
            }
            if (phi == 0.0f) continue;
            if (action != null) {
                action.update(this.lx, fixture.pitch, (double)(phi * 180.0f) / Math.PI);
                continue;
            }
            fixture.pitch.incrementValue((double)(phi * 180.0f) / Math.PI);
        }
        return this;
    }

    public LXStructure adjustSelectedFixtureBrightness(float delta) {
        for (LXFixture fixture : this.fixtures) {
            if (!fixture.selected.isOn()) continue;
            fixture.brightness.setNormalized(fixture.brightness.getNormalized() + (double)delta);
        }
        return this;
    }

    public LXStructure enableSelectedFixtures(boolean enabled) {
        for (LXFixture fixture : this.fixtures) {
            if (!fixture.selected.isOn()) continue;
            fixture.enabled.setValue(enabled);
        }
        return this;
    }

    public LXStructure identifySelectedFixtures(boolean identify) {
        for (LXFixture fixture : this.fixtures) {
            if (!fixture.selected.isOn()) continue;
            fixture.identify.setValue(identify);
        }
        return this;
    }

    public LXStructure newDynamicModel() {
        this.isLoading = true;
        this.reset(false);
        this.isLoading = false;
        this.regenerateModel(true);
        return this;
    }

    public LXStructure setStaticModel(LXModel model) {
        model.reindexPoints();
        model.normalizePoints();
        this.model = this.staticModel = model;
        this.modelFile = null;
        this.modelName.setValue(model.getClass().getSimpleName() + ".class");
        this.isStatic.setValue(true);
        this.modelListener.structureChanged(this.model);
        return this;
    }

    private LXStructure reset(boolean fromSync) {
        this.staticModel = null;
        this.removeAllFixtures();
        if (!fromSync) {
            this.syncModelFile.setValue(false);
            this.modelFile = null;
            this.modelName.setValue(PROJECT_MODEL);
        }
        this.isStatic.setValue(false);
        if (this.output != null) {
            this.output.clear();
        }
        System.gc();
        return this;
    }

    private void regenerateModel(boolean fromLoad) {
        if (this.isImmutable) {
            throw new IllegalStateException("Cannot regenerate LXStructure model when in immutable mode");
        }
        if (this.staticModel != null) {
            throw new IllegalStateException("Cannot regenerate LXStructure model when static model is set: " + this.staticModel);
        }
        if (this.isLoading) {
            return;
        }
        int activeFixtures = 0;
        for (LXFixture fixture : this.fixtures) {
            if (fixture.deactivate.isOn()) continue;
            ++activeFixtures;
        }
        LXModel[] submodels = new LXModel[activeFixtures];
        int pointIndex = 0;
        int fixtureIndex = 0;
        for (LXFixture fixture : this.fixtures) {
            if (fixture.deactivate.isOn()) continue;
            fixture.reindex(pointIndex);
            LXModel fixtureModel = fixture.toModel();
            pointIndex += fixtureModel.size;
            submodels[fixtureIndex++] = fixtureModel;
        }
        this.model = new LXModel(submodels, this.generateManualNormalizationBounds()).normalizePoints();
        this.modelListener.structureChanged(this.model);
        if (!fromLoad) {
            this.setDirty();
        }
    }

    private void regenerateOutputs() {
        if (this.isLoading) {
            return;
        }
        if (this.output != null) {
            this.output.rebuildOutputs();
        }
    }

    private void fixtureRemoved() {
        this.fixtureGenerationChanged(null);
    }

    @Override
    public void fixtureGenerationChanged(LXFixture fixture) {
        this.regenerateModel(false);
        this.regenerateOutputs();
    }

    @Override
    public void fixtureGeometryChanged(LXFixture fixture) {
        this.model.update(true, true);
        this.modelListener.structureGenerationChanged(this.model);
        this.setDirty();
    }

    @Override
    public void fixtureOutputChanged(LXFixture fixture) {
        this.regenerateOutputs();
        this.setDirty();
    }

    @Override
    public void fixtureTagsChanged(LXFixture fixture) {
        this.regenerateModel(false);
    }

    private void setDirty() {
        if (this.modelFile != null) {
            this.modelName.setValue(this.modelFile.getName() + "*");
        }
        this.isDirty = true;
    }

    public boolean isExternalModel() {
        return !this.isImmutable && this.staticModel == null && this.modelFile != null;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void reload() {
        if (this.isImmutable) {
            return;
        }
        this.isLoading = true;
        for (LXFixture fixture : this.fixtures) {
            if (!(fixture instanceof JsonFixture)) continue;
            ((JsonFixture)fixture).reload();
        }
        this.isLoading = false;
        if (this.staticModel == null) {
            this.regenerateModel(true);
        }
        this.regenerateOutputs();
        this.lx.pushStatusMessage("Model reloaded");
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        if (this.isImmutable) {
            this.views.reset();
            LXSerializable.Utils.loadObject(this.lx, this.views, obj, this.views.getPath());
            return;
        }
        this.isLoading = true;
        this.views.reset();
        this.reset(false);
        super.load(lx, obj);
        if (obj.has(KEY_STATIC_MODEL)) {
            JsonObject modelObj = obj.get(KEY_STATIC_MODEL).getAsJsonObject();
            String className = modelObj.get("class").getAsString();
            LXModel model = null;
            try {
                model = lx.instantiateModel(className);
                model.load(lx, modelObj);
            }
            catch (LX.InstantiationException x) {
                lx.pushError(x, "Could not instantiate model class " + className + ". Check that content files are present?");
            }
            if (model == null) {
                model = new LXModel();
            }
            this.setStaticModel(model);
        } else {
            File loadModelFile = null;
            if (obj.has(KEY_FILE)) {
                loadModelFile = this.lx.getMediaFile(LX.Media.MODELS, obj.get(KEY_FILE).getAsString(), false);
            }
            if (this.syncModelFile.isOn()) {
                if (loadModelFile == null) {
                    LX.error("Project specifies external model sync, but no file name was found");
                } else if (!loadModelFile.exists()) {
                    LX.error("Referenced external model file does not exist: " + loadModelFile.toURI());
                } else {
                    this.importModel(loadModelFile, true);
                }
            } else {
                this.modelName.setValue(PROJECT_MODEL);
                this.loadFixtures(lx, obj);
            }
        }
        this.isLoading = false;
        if (this.staticModel == null) {
            this.regenerateModel(true);
        }
        this.regenerateOutputs();
        if (this.output != null) {
            if (obj.has(KEY_OUTPUT)) {
                LXSerializable.Utils.loadObject(lx, this.output, obj, KEY_OUTPUT);
            } else {
                LXSerializable.Utils.resetObject(lx, this.output);
            }
        }
        this.isDirty = false;
    }

    private void loadFixtures(LX lx, JsonObject obj) {
        if (obj.has(KEY_FIXTURES)) {
            for (JsonElement fixtureElement : obj.getAsJsonArray(KEY_FIXTURES)) {
                JsonObject fixtureObj = fixtureElement.getAsJsonObject();
                try {
                    LXFixture fixture = this.lx.instantiateFixture(fixtureObj.get("class").getAsString());
                    fixture.load(lx, fixtureObj);
                    this.addFixture(fixture);
                }
                catch (LX.InstantiationException x) {
                    LX.error(x, "Could not instantiate fixture " + fixtureObj.toString());
                }
            }
            this.regenerateOutputs();
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        if (this.isImmutable) {
            return;
        }
        if (this.output != null) {
            obj.add(KEY_OUTPUT, (JsonElement)LXSerializable.Utils.toObject(lx, this.output));
        }
        if (this.staticModel != null) {
            obj.add(KEY_STATIC_MODEL, (JsonElement)LXSerializable.Utils.toObject(lx, this.staticModel));
        }
        this.saveFixtures(lx, obj);
        if (this.modelFile != null) {
            obj.addProperty(KEY_FILE, this.lx.getMediaPath(LX.Media.MODELS, this.modelFile));
            if (this.syncModelFile.isOn()) {
                this.exportModel(this.modelFile);
            }
        }
    }

    private void saveFixtures(LX lx, JsonObject obj) {
        obj.add(KEY_FIXTURES, (JsonElement)LXSerializable.Utils.toArray(lx, this.fixtures));
    }

    public LXStructure importModel(File file) {
        return this.importModel(file, false);
    }

    private LXStructure importModel(File file, boolean fromSync) {
        boolean wasLoading = this.isLoading;
        this.isLoading = true;
        this.lx.setModelImportFlag(true);
        try (FileReader fr = new FileReader(file);){
            this.reset(fromSync);
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
            this.loadFixtures(this.lx, obj);
            if (obj.has(KEY_NORMALIZATION)) {
                LXStructure.loadParameters(this, obj.get(KEY_NORMALIZATION).getAsJsonObject(), this.normalizationParameters);
            }
            this.modelFile = file;
            this.modelName.setValue(file.getName());
            this.isStatic.bang();
        }
        catch (FileNotFoundException fnfx) {
            LX.error("Model file does not exist: " + file);
            this.lx.pushError(fnfx, "Model file does not exist:" + file);
        }
        catch (IOException iox) {
            LX.error(iox, "IO error importing model file: " + file);
            this.lx.pushError(iox, "IO error importing model file " + file + ": " + iox.getMessage());
        }
        catch (Throwable x) {
            LX.error(x, "Exception importing model file: " + file);
            this.lx.pushError(x, "Error importing model file " + file + ": " + x.getMessage());
        }
        this.lx.setModelImportFlag(false);
        this.isLoading = wasLoading;
        if (!wasLoading) {
            this.regenerateModel(true);
            this.regenerateOutputs();
        }
        this.isDirty = false;
        return this;
    }

    public LXStructure exportModel(File file) {
        if (!this.lx.permissions.canSave()) {
            return this;
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("version", "1.0.0");
        obj.addProperty("timestamp", (Number)System.currentTimeMillis());
        this.saveFixtures(this.lx, obj);
        obj.add(KEY_NORMALIZATION, (JsonElement)LXSerializable.Utils.saveParameters(this.normalizationParameters));
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));){
            writer.setIndent("  ");
            new GsonBuilder().create().toJson((JsonElement)obj, writer);
            this.modelFile = file;
            this.modelName.setValue(file.getName());
            this.isDirty = false;
            this.isStatic.bang();
            LX.log("Model exported successfully to " + file);
        }
        catch (IOException iox) {
            LX.error(iox, "Exception writing model file to " + file);
        }
        return this;
    }

    public void exportViews(File file) {
        JsonObject obj = LXSerializable.Utils.toObject(this.lx, this.views, true);
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));){
            writer.setIndent("  ");
            new GsonBuilder().create().toJson((JsonElement)obj, writer);
            LX.log("Views saved successfully to " + file.toString());
        }
        catch (IOException iox) {
            LX.error(iox, "Could not export views to file: " + file.toString());
        }
    }

    public List<LXViewDefinition> importViews(File file) {
        List<LXViewDefinition> list;
        FileReader fr = new FileReader(file);
        try {
            list = this.views.addViews(this.lx, (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iox) {
                LX.error(iox, "Could not import views from file: " + file.toString());
                return null;
            }
        }
        fr.close();
        return list;
    }

    public static enum NormalizationMode {
        AUTOMATIC("Auto"),
        MANUAL("Manual");

        public final String label;

        private NormalizationMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static interface ModelListener {
        public void structureChanged(LXModel var1);

        public void structureGenerationChanged(LXModel var1);
    }

    public static interface Listener {
        public void fixtureAdded(LXFixture var1);

        public void fixtureRemoved(LXFixture var1);

        public void fixtureMoved(LXFixture var1, int var2);
    }
}

