/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import heronarts.lx.LX;
import heronarts.lx.output.ArtNetDatagram;
import heronarts.lx.output.DDPDatagram;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.KinetDatagram;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXOutput;
import heronarts.lx.output.OPCDatagram;
import heronarts.lx.output.OPCSocket;
import heronarts.lx.output.StreamingACNDatagram;
import heronarts.lx.structure.LXFixture;
import heronarts.lx.structure.LXStructure;
import heronarts.lx.utils.LXUtils;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;

public class LXStructureOutput
extends LXOutput {
    private final LXStructure structure;
    private final List<LXOutput> generatedOutputs = new ArrayList<LXOutput>();
    private final List<String> outputErrors = new ArrayList<String>();
    private final List<Packet> packets = new ArrayList<Packet>();

    private Packet findPacket(LXFixture.Protocol protocol, LXFixture.Transport transport, InetAddress address, int port, int universe, int priority, boolean sequenceEnabled, KinetDatagram.Version kinetVersion) {
        for (Packet packet : this.packets) {
            if (packet.protocol != protocol || packet.transport != transport || !packet.address.equals(address) || packet.port != port || packet.universe != universe || packet.kinetVersion != kinetVersion) continue;
            packet.priority = LXUtils.max(packet.priority, priority);
            packet.sequenceEnabled = packet.sequenceEnabled || sequenceEnabled;
            return packet;
        }
        Packet packet = new Packet(protocol, transport, address, port, universe, priority, sequenceEnabled, kinetVersion);
        this.packets.add(packet);
        return packet;
    }

    LXStructureOutput(LX lx, LXStructure structure) throws SocketException {
        super(lx);
        this.structure = structure;
        this.gammaMode.setValue((Object)LXOutput.GammaMode.DIRECT);
    }

    void clear() {
        this.packets.clear();
        for (LXOutput output : this.generatedOutputs) {
            output.dispose();
        }
        this.generatedOutputs.clear();
        this.outputErrors.clear();
        this.structure.outputError.setValue(null);
    }

    void rebuildOutputs() {
        this.clear();
        for (LXFixture fixture : this.structure.fixtures) {
            this.rebuildFixtureOutputs(fixture);
        }
        for (Packet packet : this.packets) {
            this.generatedOutputs.add(packet.toOutput());
        }
        if (!this.outputErrors.isEmpty()) {
            String str = "Output errors detected.";
            for (String err : this.outputErrors) {
                str = str + "\n" + err;
            }
            this.structure.outputError.setValue(str);
        }
    }

    private void rebuildFixtureOutputs(LXFixture fixture) {
        if (fixture.deactivate.isOn() || !fixture.enabled.isOn()) {
            return;
        }
        for (LXFixture child : fixture.children) {
            this.rebuildFixtureOutputs(child);
        }
        for (LXFixture.OutputDefinition output : fixture.outputDefinitions) {
            this.rebuildFixtureOutput(fixture, output);
        }
    }

    private void rebuildFixtureOutput(LXFixture fixture, LXFixture.OutputDefinition output) {
        LXFixture.Protocol protocol = output.protocol;
        LXFixture.Transport transport = output.transport;
        InetAddress address = output.address;
        int port = output.port;
        int universe = output.universe;
        int channel = output.channel;
        int priority = output.priority;
        boolean sequenceEnabled = output.sequenceEnabled;
        KinetDatagram.Version kinetVersion = output.kinetVersion;
        float fps = output.fps;
        boolean overflow = false;
        Packet packet = this.findPacket(protocol, transport, address, port, universe, priority, sequenceEnabled, kinetVersion);
        for (LXFixture.Segment segment : output.segments) {
            if (overflow) {
                if (!packet.checkOverflow()) {
                    return;
                }
                overflow = false;
                channel = 0;
                packet = this.findPacket(protocol, transport, address, port, ++universe, priority, sequenceEnabled, kinetVersion);
            }
            int chunkStart = 0;
            int chunkLength = segment.length;
            int availableBytes = protocol.maxChannels - channel;
            if (availableBytes <= 0) {
                this.outputErrors.add(protocol.toString() + address.toString() + " - invalid channel " + channel + " > " + protocol.maxChannels);
                return;
            }
            while (availableBytes < chunkLength * segment.byteEncoder.getNumBytes()) {
                int chunkLimit = availableBytes / segment.byteEncoder.getNumBytes();
                if (chunkLimit > 0) {
                    packet.addSegment(segment, channel, chunkStart, chunkLimit, fps);
                    chunkStart += chunkLimit;
                    chunkLength -= chunkLimit;
                }
                if (!packet.checkOverflow()) {
                    return;
                }
                channel = 0;
                availableBytes = protocol.maxChannels;
                packet = this.findPacket(protocol, transport, address, port, ++universe, priority, sequenceEnabled, kinetVersion);
            }
            packet.addSegment(segment, channel, chunkStart, chunkLength, fps);
            overflow = (channel += chunkLength * segment.byteEncoder.getNumBytes()) >= protocol.maxChannels;
        }
    }

    @Override
    protected void onSend(int[] colors, LXOutput.GammaTable glut, double brightness) {
        for (LXOutput output : this.generatedOutputs) {
            output.setGammaDelegate(this);
            output.send(colors, brightness);
        }
        for (LXFixture fixture : this.structure.fixtures) {
            this.onSendFixture(fixture, colors, brightness);
        }
    }

    private void onSendFixture(LXFixture fixture, int[] colors, double brightness) {
        if (!fixture.deactivate.isOn() && fixture.enabled.isOn()) {
            brightness *= fixture.brightness.getValue();
            for (LXFixture child : fixture.children) {
                this.onSendFixture(child, colors, brightness);
            }
            for (LXOutput output : fixture.outputsDirect) {
                output.setGammaDelegate(this);
                output.send(colors, brightness);
            }
        }
    }

    private class Packet {
        private final LXFixture.Protocol protocol;
        private final LXFixture.Transport transport;
        private final InetAddress address;
        private final int port;
        private final int universe;
        private int priority;
        private boolean sequenceEnabled;
        private final KinetDatagram.Version kinetVersion;
        private float fps = 0.0f;
        private final List<IndexBuffer.Segment> segments = new ArrayList<IndexBuffer.Segment>();

        private Packet(LXFixture.Protocol protocol, LXFixture.Transport transport, InetAddress address, int port, int universe, int priority, boolean sequenceEnabled, KinetDatagram.Version kinetVersion) {
            this.protocol = protocol;
            this.transport = transport;
            this.address = address;
            this.port = port;
            this.universe = universe;
            this.priority = priority;
            this.sequenceEnabled = sequenceEnabled;
            this.kinetVersion = kinetVersion;
        }

        private boolean checkOverflow() {
            switch (this.protocol) {
                case ARTNET: 
                case SACN: {
                    if (this.universe >= 32768) {
                        LXStructureOutput.this.outputErrors.add(this.protocol.toString() + this.address.toString() + " - overflow univ " + this.universe);
                        return false;
                    }
                    return true;
                }
                case KINET: {
                    if (this.universe >= 255) {
                        LXStructureOutput.this.outputErrors.add(this.protocol.toString() + this.address.toString() + " - overflow port" + this.universe);
                        return false;
                    }
                    return true;
                }
            }
            LXStructureOutput.this.outputErrors.add(this.protocol.toString() + this.address.toString() + " - data length overflow");
            return false;
        }

        private void segmentCollision(int collisionStart, int collisionEnd) {
            String err = this.protocol.toString() + this.address.toString() + " - duplicated ";
            switch (this.protocol) {
                case ARTNET: 
                case SACN: {
                    err = err + "univ " + this.universe + (collisionStart == collisionEnd ? " channel " + collisionStart : " channels " + collisionStart + "-" + collisionEnd);
                    break;
                }
                case KINET: {
                    err = err + "port " + this.universe + (collisionStart == collisionEnd ? " channel " + collisionStart : " channels " + collisionStart + "-" + collisionEnd);
                    break;
                }
                case DDP: {
                    err = err + "data offset " + this.universe;
                    break;
                }
                case OPC: {
                    err = err + "channel " + this.universe + (collisionStart == collisionEnd ? " offset " + collisionStart : " offsets " + collisionStart + "-" + collisionEnd);
                    break;
                }
            }
            LXStructureOutput.this.outputErrors.add(err);
        }

        private void addSegment(LXFixture.Segment segment, int startChannel, int chunkStart, int chunkLength, float fps) {
            int endChannel = startChannel + segment.numChannels - 1;
            for (IndexBuffer.Segment existing : this.segments) {
                if (startChannel < existing.startChannel) {
                    if (endChannel < existing.startChannel) continue;
                    this.segmentCollision(existing.startChannel, LXUtils.min(endChannel, existing.endChannel));
                    continue;
                }
                if (startChannel > existing.endChannel) continue;
                this.segmentCollision(startChannel, LXUtils.min(endChannel, existing.endChannel));
            }
            this.segments.add(new IndexBuffer.Segment(segment.toIndexBuffer(chunkStart, chunkLength), segment.byteEncoder, startChannel, segment.getBrightness()));
            if (fps > 0.0f && (this.fps == 0.0f || fps < this.fps)) {
                this.fps = fps;
            }
        }

        private IndexBuffer toIndexBuffer() {
            return new IndexBuffer(this.segments);
        }

        private LXOutput toOutput() {
            LXBufferOutput output = null;
            switch (this.protocol) {
                case ARTNET: {
                    output = new ArtNetDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), this.universe).setSequenceEnabled(this.sequenceEnabled);
                    break;
                }
                case SACN: {
                    output = new StreamingACNDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), this.universe).setPriority(this.priority);
                    break;
                }
                case KINET: {
                    output = new KinetDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), this.universe, this.kinetVersion);
                    break;
                }
                case OPC: {
                    if (this.transport == LXFixture.Transport.TCP) {
                        output = new OPCSocket(LXStructureOutput.this.lx, this.toIndexBuffer(), (byte)this.universe);
                        break;
                    }
                    output = new OPCDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), (byte)this.universe);
                    break;
                }
                case DDP: {
                    output = new DDPDatagram(LXStructureOutput.this.lx, this.toIndexBuffer(), this.universe);
                    break;
                }
            }
            if (output instanceof LXOutput.InetOutput) {
                ((LXOutput.InetOutput)((Object)output)).setAddress(this.address).setPort(this.port);
            }
            if (output != null && this.fps > 0.0f) {
                output.framesPerSecond.setValue(this.fps);
            }
            return output;
        }
    }
}

