/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import heronarts.lx.LX;
import heronarts.lx.model.LXPoint;
import heronarts.lx.structure.LXBasicFixture;
import heronarts.lx.transform.LXMatrix;
import heronarts.lx.transform.LXVector;
import java.util.ArrayList;
import java.util.List;

public class PointListFixture
extends LXBasicFixture {
    private final List<LXVector> coordinates;

    public PointListFixture(LX lx, List<LXVector> coordinates) {
        super(lx, "Points");
        this.coordinates = new ArrayList<LXVector>(coordinates);
    }

    @Override
    protected void computePointGeometry(LXMatrix transform, List<LXPoint> points) {
        int i = 0;
        for (LXPoint p : points) {
            LXVector c = this.coordinates.get(i++);
            transform.translate(c.x, c.y, c.z);
            p.set(transform);
            transform.translate(-c.x, -c.y, -c.z);
        }
    }

    @Override
    protected int size() {
        return this.coordinates.size();
    }

    @Override
    public String[] getDefaultTags() {
        return new String[]{"points"};
    }
}

