/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.structure;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.structure.LXBasicFixture;
import heronarts.lx.transform.LXMatrix;
import java.util.List;
import java.util.Map;

@LXCategory(value="Core")
public class SpiralFixture
extends LXBasicFixture {
    public static final int MAX_POINTS = 4096;
    public final DiscreteParameter numPoints = new DiscreteParameter("Num", 170, 1, 4097).setUnits(LXParameter.Units.INTEGER).setDescription("Number of points in the spiral");
    public final BoundedParameter numTurns = new BoundedParameter("Turns", 10.0, 0.0, 100.0).setDescription("How many turns of the spiral");
    public final BoundedParameter radius = new BoundedParameter("Radius", 100.0, 0.0, 1000000.0).setDescription("Radius of the spiral");
    public final BoundedParameter length = new BoundedParameter("Length", 800.0, 0.0, 1000000.0).setDescription("Length of the spiral");

    public SpiralFixture(LX lx) {
        super(lx, "Spiral");
        this.addMetricsParameter("numPoints", this.numPoints);
        this.addMetricsParameter("numTurns", this.numTurns);
        this.addGeometryParameter("radius", this.radius);
        this.addGeometryParameter("length", this.length);
    }

    @Override
    protected void computePointGeometry(LXMatrix transform, List<LXPoint> points) {
        float radius = this.radius.getValuef();
        float length = this.length.getValuef();
        float numTurns = this.numTurns.getValuef();
        float rotation = numTurns * ((float)Math.PI * 2) / (float)this.points.size();
        float translate = length / (float)this.points.size();
        for (LXPoint p : this.points) {
            transform.translateY(-radius);
            p.set(transform);
            transform.translateY(radius);
            transform.rotateZ(rotation);
            transform.translateZ(translate);
        }
    }

    @Override
    protected int size() {
        return this.numPoints.getValuei();
    }

    @Override
    protected String[] getDefaultTags() {
        return new String[]{"strip", "spiral"};
    }

    @Override
    public void addModelMetaData(Map<String, String> metaData) {
        metaData.put("numPoints", String.valueOf(this.numPoints.getValuei()));
        metaData.put("numTurns", String.valueOf(this.numTurns.getValue()));
        metaData.put("radius", String.valueOf(this.radius.getValue()));
        metaData.put("length", String.valueOf(this.length.getValue()));
    }
}

