/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.transform;

import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.transform.LXVector;
import java.util.Arrays;
import java.util.Iterator;

public class LXProjection
implements Iterable<LXVector> {
    private final LXVector[] vectors;
    private final LXModel model;

    @Override
    public Iterator<LXVector> iterator() {
        return Arrays.asList(this.vectors).iterator();
    }

    public LXProjection(LXModel model) {
        this.vectors = new LXVector[model.points.length];
        int i = 0;
        for (LXPoint point : model.points) {
            this.vectors[i++] = new LXVector(point);
        }
        this.model = model;
    }

    public LXProjection reset() {
        int i = 0;
        for (LXPoint point : this.model.points) {
            this.vectors[i].x = point.x;
            this.vectors[i].y = point.y;
            this.vectors[i].z = point.z;
            ++i;
        }
        return this;
    }

    public LXProjection scale(float sx, float sy, float sz) {
        for (LXVector v : this.vectors) {
            v.x *= sx;
            v.y *= sy;
            v.z *= sz;
        }
        return this;
    }

    public LXProjection translate(float tx, float ty, float tz) {
        for (LXVector v : this.vectors) {
            v.x += tx;
            v.y += ty;
            v.z += tz;
        }
        return this;
    }

    public LXProjection center() {
        return this.translate(-this.model.cx, -this.model.cy, -this.model.cz);
    }

    public LXProjection translateCenter(float tx, float ty, float tz) {
        return this.translate(-this.model.cx + tx, -this.model.cy + ty, -this.model.cz + tz);
    }

    public LXProjection reflectX() {
        for (LXVector v : this.vectors) {
            v.x = -v.x;
        }
        return this;
    }

    public LXProjection reflectY() {
        for (LXVector v : this.vectors) {
            v.y = -v.y;
        }
        return this;
    }

    public LXProjection reflectZ() {
        for (LXVector v : this.vectors) {
            v.z = -v.z;
        }
        return this;
    }

    public LXProjection rotate(float angle, float l, float m, float n) {
        float ss = l * l + m * m + n * n;
        if (ss != 1.0f) {
            float sr = (float)Math.sqrt(ss);
            l /= sr;
            m /= sr;
            n /= sr;
        }
        float sinv = (float)Math.sin(angle);
        float cosv = (float)Math.cos(angle);
        float a1 = l * l * (1.0f - cosv) + cosv;
        float a2 = l * m * (1.0f - cosv) - n * sinv;
        float a3 = l * n * (1.0f - cosv) + m * sinv;
        float b1 = l * m * (1.0f - cosv) + n * sinv;
        float b2 = m * m * (1.0f - cosv) + cosv;
        float b3 = m * n * (1.0f - cosv) - l * sinv;
        float c1 = l * n * (1.0f - cosv) - m * sinv;
        float c2 = m * n * (1.0f - cosv) + l * sinv;
        float c3 = n * n * (1.0f - cosv) + cosv;
        for (LXVector v : this.vectors) {
            float xp = v.x * a1 + v.y * a2 + v.z * a3;
            float yp = v.x * b1 + v.y * b2 + v.z * b3;
            float zp = v.x * c1 + v.y * c2 + v.z * c3;
            v.x = xp;
            v.y = yp;
            v.z = zp;
        }
        return this;
    }

    public LXProjection rotateX(float angle) {
        return this.rotate(angle, 1.0f, 0.0f, 0.0f);
    }

    public LXProjection rotateY(float angle) {
        return this.rotate(angle, 0.0f, 1.0f, 0.0f);
    }

    public LXProjection rotateZ(float angle) {
        return this.rotate(angle, 0.0f, 0.0f, 1.0f);
    }
}

