/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import heronarts.lx.LXComponent;
import heronarts.lx.LXEngine;
import heronarts.lx.LXLicense;
import heronarts.lx.LXPlugin;
import heronarts.lx.LXPreferences;
import heronarts.lx.LXPresetComponent;
import heronarts.lx.LXRegistry;
import heronarts.lx.LXSerializable;
import heronarts.lx.blend.LXBlend;
import heronarts.lx.clipboard.LXClipboard;
import heronarts.lx.color.LXColor;
import heronarts.lx.command.LXCommandEngine;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.model.LXModel;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.output.LXOutput;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.pattern.color.SolidPattern;
import heronarts.lx.scheduler.LXScheduler;
import heronarts.lx.structure.LXFixture;
import heronarts.lx.structure.LXStructure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LX {
    public static final String VERSION = "1.1.0";
    public static final double HALF_PI = 1.5707963267948966;
    public static final double TWO_PI = Math.PI * 2;
    public static final float PIf = (float)Math.PI;
    public static final float HALF_PIf = 1.5707964f;
    public static final float TWO_PIf = (float)Math.PI * 2;
    public static final InitProfiler initProfiler = new InitProfiler();
    private static boolean LOG_INIT_PROFILER = false;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<ProjectListener> projectListeners = new ArrayList<ProjectListener>();
    final LXComponent.Registry componentRegistry = new LXComponent.Registry();
    public final LXPreferences preferences;
    public final Flags flags;
    public final Permissions permissions = this.getPermissions();
    private final Queue<Error> errorQueue = new ArrayDeque<Error>();
    public final MutableParameter errorChanged = new MutableParameter("Error");
    public StringParameter failure = new StringParameter("Failure", null);
    public final StringParameter statusMessage = new StringParameter("Status Message", "");
    public final LXStructure structure;
    protected LXModel model;
    public final LXClipboard clipboard = new LXClipboard(this);
    public final LXEngine engine;
    public final LXCommandEngine command;
    public final LXRegistry registry;
    public final LXScheduler scheduler;
    private final Map<String, LXSerializable> externals = new HashMap<String, LXSerializable>();
    public static final String KEY_VERSION = "version";
    public static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_MODEL = "model";
    private static final String KEY_ENGINE = "engine";
    private static final String KEY_EXTERNALS = "externals";
    private File file;
    private static final Pattern versionPattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-([\\w.-]+))?$");
    public static boolean LOG_WARNINGS = false;
    public static boolean LOG_DEBUG = false;
    private static final DateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final String LOG_PREFIX = "LX";
    static File EXPLICIT_LOG_FILE = null;
    private static PrintStream EXPLICIT_LOG_STREAM = null;

    public static String version() {
        return VERSION;
    }

    public static void logInitProfiler() {
        LOG_INIT_PROFILER = true;
    }

    protected Permissions getPermissions() {
        return Permissions.UNRESTRICTED;
    }

    public LX() {
        this(new Flags());
    }

    public LX(LXModel model) {
        this(new Flags(), model);
    }

    public LX(Flags flags) {
        this(flags, null);
    }

    public LX(Flags flags, LXModel model) {
        initProfiler.init();
        this.flags = flags;
        this.flags.immutableModel = model != null;
        this.structure = new LXStructure(this, model, new LXStructure.ModelListener(){

            @Override
            public void structureChanged(LXModel model) {
                LX.this.setModel(model);
            }

            @Override
            public void structureGenerationChanged(LXModel model) {
                for (Listener listener : LX.this.listeners) {
                    listener.modelGenerationChanged(LX.this, model);
                }
            }
        });
        this.model = model == null ? this.structure.getModel() : model;
        initProfiler.log("Model");
        this.registry = this.instantiateRegistry(this);
        this.registry.initialize();
        initProfiler.log("Registry");
        this.preferences = new LXPreferences(this);
        if (this.flags.loadPreferences) {
            this.preferences.load();
        } else {
            this.preferences.loadEULA();
        }
        this.scheduler = new LXScheduler(this);
        this.engine = new LXEngine(this);
        this.command = new LXCommandEngine(this);
        initProfiler.log("Engine");
        this.engine.tempo.initialize();
        this.engine.midi.initialize();
        if (this instanceof LXPlugin && flags.initialize != this) {
            ((LXPlugin)((Object)this)).initialize(this);
        }
        if (this.flags.initialize != null) {
            this.flags.initialize.initialize(this);
        }
        this.registry.initializePlugins();
    }

    protected void fail(Throwable x) {
        String logLocation = "the console output.";
        if (EXPLICIT_LOG_FILE != null) {
            logLocation = EXPLICIT_LOG_FILE.getAbsolutePath();
        }
        String message = "A serious and unexpected fatal error has occured. The program cannot continue and the UI may no longer be responsive. Please report this issue.\n\nDetails of the error have been logged to " + logLocation + "\n\n";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (StringWriter sw = new StringWriter();){
                x.printStackTrace(new PrintWriter(sw));
                String stackTrace = sw.toString();
                message = message + stackTrace;
                this.setSystemClipboardString(stackTrace);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.failure.setValue(message);
    }

    public LX pushError(Throwable exception) {
        return this.pushError(new Error(exception));
    }

    public LX pushError(Throwable exception, String message) {
        return this.pushError(new Error(exception, message));
    }

    public LX pushError(String message) {
        return this.pushError(new Error(message));
    }

    public LX pushError(Error error) {
        this.errorQueue.add(error);
        this.errorChanged.bang();
        return this;
    }

    public LX popError() {
        if (!this.errorQueue.isEmpty()) {
            this.errorQueue.remove();
            this.errorChanged.bang();
        }
        return this;
    }

    public Error getError() {
        return this.errorQueue.peek();
    }

    public LX pushStatusMessage(String message) {
        LX.log(message);
        this.statusMessage.setValue(message, true);
        return this;
    }

    protected LXRegistry instantiateRegistry(LX lx) {
        return new LXRegistry(this);
    }

    public LX addListener(Listener listener) {
        Objects.requireNonNull(listener);
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LX.Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public LX removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("May not remove non-registered LX.Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    public Listener onModelChanged(ModelListener listener) {
        return this.onModelChanged(listener, false);
    }

    public Listener onModelChanged(final ModelListener listener, boolean fire) {
        Listener ret = new Listener(){

            @Override
            public void modelChanged(LX lx, LXModel model) {
                listener.modelChanged(model);
            }

            @Override
            public void modelGenerationChanged(LX lx, LXModel model) {
                listener.modelChanged(model);
            }
        };
        this.addListener(ret);
        if (fire) {
            listener.modelChanged(this.getModel());
        }
        return ret;
    }

    public LX addProjectListener(ProjectListener listener) {
        Objects.requireNonNull(listener);
        if (this.projectListeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LX.ProjectListener: " + String.valueOf(listener));
        }
        this.projectListeners.add(listener);
        return this;
    }

    public LX removeProjectListener(ProjectListener listener) {
        if (!this.projectListeners.contains(listener)) {
            throw new IllegalStateException("Trying to remove non-registered LX.ProjectListener: " + String.valueOf(listener));
        }
        this.projectListeners.remove(listener);
        return this;
    }

    public LXComponent getComponent(int componentId) {
        return this.componentRegistry.getComponent(componentId);
    }

    public LXComponent getProjectComponent(int projectId) {
        return this.componentRegistry.getProjectComponent(projectId);
    }

    public LXModel getModel() {
        return this.model;
    }

    private LX setModel(LXModel model) {
        Objects.requireNonNull(model, "May not set null model on LX instance");
        if (this.model == model) {
            throw new IllegalStateException("Cannot reset same model instance: " + String.valueOf(model));
        }
        LXModel oldModel = this.model;
        this.model = model;
        for (Listener listener : this.listeners) {
            listener.modelChanged(this, model);
        }
        for (Listener listener : this.listeners) {
            listener.modelGenerationChanged(this, model);
        }
        if (oldModel != null) {
            oldModel.dispose();
        }
        return this;
    }

    public static void dispose(LXComponent component) {
        component.dispose();
        LXComponent.assertDisposed(component);
    }

    public void dispose() {
        LX.dispose(this.engine);
    }

    public static int hsb(float h, float s, float b) {
        return LXColor.hsb(h, s, b);
    }

    public static int hsa(float h, float s, float a) {
        return LXColor.hsba(h, s, 100.0f, a);
    }

    public static int rgb(int r, int g, int b) {
        return LXColor.rgb(r, g, b);
    }

    public LX setSpeed(double speed) {
        this.engine.setSpeed(speed);
        return this;
    }

    public LX addEffects(LXEffect[] effects) {
        LXEffect[] lXEffectArray = effects;
        int n = effects.length;
        int n2 = 0;
        while (n2 < n) {
            LXEffect effect = lXEffectArray[n2];
            this.addEffect(effect);
            ++n2;
        }
        return this;
    }

    public LX addEffect(LXEffect effect) {
        this.engine.mixer.masterBus.addEffect(effect);
        return this;
    }

    public LX removeEffect(LXEffect effect) {
        this.engine.mixer.masterBus.removeEffect(effect);
        return this;
    }

    public LX setPaused(boolean paused) {
        this.engine.setPaused(paused);
        return this;
    }

    public boolean isPaused() {
        return this.engine.isPaused();
    }

    public LX togglePaused() {
        return this.setPaused(!this.engine.isPaused());
    }

    private LXChannel getChannel() {
        for (LXAbstractChannel channel : this.engine.mixer.channels) {
            if (!(channel instanceof LXChannel)) continue;
            return (LXChannel)channel;
        }
        return null;
    }

    public LX goPrev() {
        LXChannel channel = this.getChannel();
        if (channel != null) {
            channel.goPreviousPattern();
        }
        return this;
    }

    public LX goNext() {
        LXChannel channel = this.getChannel();
        if (channel != null) {
            channel.goNextPattern();
        }
        return this;
    }

    public LX goPattern(LXPattern pattern) {
        LXChannel channel = this.getChannel();
        if (channel != null) {
            channel.goPattern(pattern);
        }
        return this;
    }

    public LX goIndex(int i) {
        LXChannel channel = this.getChannel();
        if (channel != null) {
            channel.goPatternIndex(i);
        }
        return this;
    }

    public LX disableAutoCycle() {
        LXChannel channel = this.getChannel();
        if (channel != null) {
            channel.disableAutoCycle();
        }
        return this;
    }

    public LX enableAutoCycle(int autoCycleThreshold) {
        LXChannel channel = this.getChannel();
        if (channel != null) {
            channel.enableAutoCycle(autoCycleThreshold);
        }
        return this;
    }

    public LX addOutput(LXOutput output) {
        this.engine.addOutput(output);
        return this;
    }

    public LX setPatterns(LXPattern[] patterns) {
        LXChannel channel = this.getChannel();
        if (channel != null) {
            channel.setPatterns(patterns);
        }
        return this;
    }

    public List<LXPattern> getPatterns() {
        LXChannel channel = this.getChannel();
        if (channel != null) {
            return channel.getPatterns();
        }
        return null;
    }

    protected void setProject(File file, ProjectListener.Change change) {
        this.file = file;
        for (ProjectListener projectListener : this.projectListeners) {
            projectListener.projectChanged(file, change);
        }
        this.preferences.setProject(file);
        System.gc();
    }

    public File getProject() {
        return this.file;
    }

    private File getAutoSaveFile() {
        if (this.file != null) {
            return this.getMediaFile(Media.AUTOSAVE, this.file.getName());
        }
        return this.getMediaFile(Media.AUTOSAVE, "default.lxp");
    }

    public void autoSaveProject() {
        if (!this.permissions.canSave()) {
            return;
        }
        File autosave = this.getAutoSaveFile();
        if (autosave != null) {
            JsonObject obj = this.saveProjectJson();
            new Thread(() -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(autosave));){
                        writer.setIndent("  ");
                        new GsonBuilder().create().toJson((JsonElement)obj, writer);
                        LX.debug("Project auto-saved successfully to " + autosave.toString());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iox) {
                    LX.error(iox, "Could not auto-save project to output file: " + autosave.toString());
                }
            }).start();
        }
    }

    public void saveProject() {
        if (this.file != null) {
            this.saveProject(this.file);
        }
    }

    public void saveProject(File file) {
        if (!this.permissions.canSave()) {
            return;
        }
        JsonObject obj = this.saveProjectJson();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));){
                writer.setIndent("  ");
                new GsonBuilder().create().toJson((JsonElement)obj, writer);
                LX.log("Project saved successfully to " + file.toString());
                this.componentRegistry.resetProject();
                this.setProject(file, ProjectListener.Change.SAVE);
                this.command.setDirty(false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iox) {
            LX.error(iox, "Could not write project to output file: " + file.toString());
        }
        this.confirmModelSaved();
    }

    private JsonObject saveProjectJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty(KEY_VERSION, VERSION);
        obj.addProperty(KEY_TIMESTAMP, (Number)System.currentTimeMillis());
        obj.add(KEY_MODEL, (JsonElement)LXSerializable.Utils.toObject(this, this.structure));
        obj.add(KEY_ENGINE, (JsonElement)LXSerializable.Utils.toObject(this, this.engine));
        JsonObject externalsObj = new JsonObject();
        for (String key : this.externals.keySet()) {
            externalsObj.add(key, (JsonElement)LXSerializable.Utils.toObject(this, this.externals.get(key)));
        }
        obj.add(KEY_EXTERNALS, (JsonElement)externalsObj);
        return obj;
    }

    public LX registerExternal(String key, LXSerializable serializable) {
        if (this.externals.containsKey(key)) {
            throw new IllegalStateException("Duplicate external for key: " + key + " (already: " + String.valueOf(serializable) + ")");
        }
        this.externals.put(key, serializable);
        return this;
    }

    int getMaxId(JsonObject obj, int max) {
        for (Map.Entry entry : obj.entrySet()) {
            if (((String)entry.getKey()).equals("id")) {
                int id = ((JsonElement)entry.getValue()).getAsInt();
                if (id <= max) continue;
                max = id;
                continue;
            }
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                for (JsonElement arrElement : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!arrElement.isJsonObject()) continue;
                    max = this.getMaxId(arrElement.getAsJsonObject(), max);
                }
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            max = this.getMaxId(((JsonElement)entry.getValue()).getAsJsonObject(), max);
        }
        return max;
    }

    public boolean isLoading() {
        return this.componentRegistry.projectLoading;
    }

    public void newProject() {
        this.confirmChangesSaved("create a new project", () -> {
            this.closeProject();
            if (!this.flags.immutableModel) {
                this.structure.load(this, new JsonObject());
            }
            this.engine.load(this, new JsonObject());
            for (LXSerializable external : this.externals.values()) {
                LXSerializable.Utils.resetObject(this, external);
            }
            LXChannel channel = this.engine.mixer.addChannel(new LXPattern[]{new SolidPattern(this, -65536)});
            this.engine.mixer.selectChannel(channel);
            this.engine.mixer.setFocusedChannel(channel);
            channel.fader.setValue(1.0);
            this.setProject(null, ProjectListener.Change.NEW);
        });
    }

    public void openProject(File file) {
        this.openProject(file, false);
    }

    private boolean isNewerVersion(String version) {
        return LX.compareVersion(VERSION, version) < 0;
    }

    public static int compareVersion(String thisVersion, String thatVersion) {
        try {
            int minorCompare;
            int majorCompare;
            Matcher thisMatcher = versionPattern.matcher(thisVersion);
            Matcher thatMatcher = versionPattern.matcher(thatVersion);
            if (!thisMatcher.matches()) {
                throw new IllegalArgumentException("Couldn't parse: " + thisVersion);
            }
            if (!thatMatcher.matches()) {
                throw new IllegalArgumentException("Couldn't parse: " + thatVersion);
            }
            int thisMajor = Integer.valueOf(thisMatcher.group(1));
            int thisMinor = Integer.valueOf(thisMatcher.group(2));
            int thisPatch = Integer.valueOf(thisMatcher.group(3));
            int thatMajor = Integer.valueOf(thatMatcher.group(1));
            int thatMinor = Integer.valueOf(thatMatcher.group(2));
            int thatPatch = Integer.valueOf(thatMatcher.group(3));
            int n = thisMajor < thatMajor ? -1 : (majorCompare = thisMajor == thatMajor ? 0 : 1);
            if (majorCompare != 0) {
                return majorCompare;
            }
            int n2 = thisMinor < thatMinor ? -1 : (minorCompare = thisMinor == thatMinor ? 0 : 1);
            if (minorCompare != 0) {
                return minorCompare;
            }
            return thisPatch < thatPatch ? -1 : (thisPatch == thatPatch ? 0 : 1);
        }
        catch (Exception x) {
            LX.error(x, "Failed to parse LX version identifier");
            return 0;
        }
    }

    public void openProject(File file, boolean checkVersion) {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileReader fr = new FileReader(file);){
                String fileVersion;
                JsonObject obj = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
                String string = fileVersion = obj.has(KEY_VERSION) ? obj.get(KEY_VERSION).getAsString() : null;
                if (fileVersion != null && this.isNewerVersion(fileVersion)) {
                    LX.warning(file.getName() + ": project version " + fileVersion + " is newer than app version 1.1.0");
                    if (checkVersion) {
                        this.showConfirmDialog("Project version: " + fileVersion + "\nApp version: 1.1.0\n\nThe project may not load properly, proceed?", () -> this._openProject(file, obj));
                        return;
                    }
                }
                this._openProject(file, obj);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fnfx) {
            LX.error(fnfx, "Project file not found: " + fnfx.getLocalizedMessage());
            this.pushError(fnfx, "Project file not found: " + fnfx.getLocalizedMessage());
        }
        catch (IOException iox) {
            LX.error("Could not read project file: " + iox.getLocalizedMessage());
            this.pushError(iox, "Could not read project file: " + iox.getLocalizedMessage());
        }
    }

    private void _openProject(File file, JsonObject obj) {
        for (ProjectListener projectListener : this.projectListeners) {
            projectListener.projectChanged(file, ProjectListener.Change.TRY);
        }
        try {
            try {
                this.closeProject();
                this.componentRegistry.projectLoading = true;
                this.componentRegistry.setIdCounter(this.getMaxId(obj, this.componentRegistry.getIdCounter()) + 1);
                if (!this.flags.immutableModel) {
                    LXSerializable.Utils.loadObject(this, this.structure, obj, KEY_MODEL, true);
                }
                this.engine.load(this, obj.getAsJsonObject(KEY_ENGINE));
                JsonObject externalsObj = obj.has(KEY_EXTERNALS) ? obj.getAsJsonObject(KEY_EXTERNALS) : new JsonObject();
                for (String key : this.externals.keySet()) {
                    if (externalsObj.has(key)) {
                        LXSerializable.Utils.loadObject(this, this.externals.get(key), externalsObj, key);
                        continue;
                    }
                    LXSerializable.Utils.resetObject(this, this.externals.get(key));
                }
                this.componentRegistry.projectLoading = false;
                this.setProject(file, ProjectListener.Change.OPEN);
                LX.log("Project loaded successfully from " + file.toString());
            }
            catch (Exception x) {
                LX.error(x, "Exception in openProject: " + x.getLocalizedMessage());
                this.pushError(x, "Exception in openProject: " + x.getLocalizedMessage());
                this.componentRegistry.projectLoading = false;
                System.gc();
            }
        }
        finally {
            this.componentRegistry.projectLoading = false;
            System.gc();
        }
    }

    private void closeProject() {
        this.command.clear();
        this.command.setDirty(false);
        this.componentRegistry.resetProject();
    }

    public void setModelImportFlag(boolean modelImport) {
        this.componentRegistry.modelImporting = modelImport;
    }

    public void setScheduleLoadingFlag(boolean scheduleLoading) {
        this.componentRegistry.scheduleLoading = scheduleLoading;
    }

    protected final void confirmChangesSaved(String message, Runnable confirm) {
        if (this.command.isDirty()) {
            this.showConfirmUnsavedProjectDialog(message, confirm);
        } else {
            confirm.run();
        }
    }

    public void showConfirmDialog(String message, Runnable confirm) {
        confirm.run();
    }

    protected void showConfirmUnsavedProjectDialog(String message, Runnable confirm) {
        confirm.run();
    }

    protected final void confirmModelSaved() {
        if (this.structure.isExternalModel() && this.structure.isDirty()) {
            File file = this.structure.getModelFile();
            this.showConfirmUnsavedModelDialog(file, () -> this.structure.exportModel(file));
        }
    }

    protected void showConfirmUnsavedModelDialog(File file, Runnable confirm) {
    }

    public String getMediaPath() {
        return this.flags.mediaPath;
    }

    public String getMediaPath(Media type, File file) {
        return this.getMediaFolder(type).getAbsoluteFile().toURI().relativize(file.getAbsoluteFile().toURI()).getPath();
    }

    public File getMediaFolder(Media type) {
        return this.getMediaFolder(type, true);
    }

    public File getMediaFolder(Media type, boolean create) {
        File folder = new File(this.getMediaPath(), type.getDirName());
        if (folder.exists()) {
            if (folder.isFile()) {
                throw new IllegalStateException("LX media folder already exists, but contains a plain file: " + String.valueOf(folder));
            }
        } else if (create) {
            folder.mkdir();
        }
        return folder;
    }

    public File getMediaFile(Media type, String path) {
        return this.getMediaFile(type, path, true);
    }

    public File getMediaFile(Media type, String path, boolean create) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getMediaFolder(type, create), path);
    }

    public File getMediaFile(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getMediaPath(), path);
    }

    public File getPresetFolder(LXComponent device) {
        File deviceFolder;
        File presetFolder = this.getMediaFolder(Media.PRESETS);
        Class<?> deviceClass = device.getClass();
        if (device instanceof LXPresetComponent) {
            deviceClass = ((LXPresetComponent)((Object)device)).getPresetClass();
        }
        if (!(deviceFolder = new File(presetFolder, deviceClass.getName())).exists()) {
            deviceFolder.mkdir();
        }
        return deviceFolder;
    }

    public File getPresetFile(LXComponent device, String name) {
        return new File(this.getPresetFolder(device), name != null ? name : "default.lxd");
    }

    public boolean canInstantiate(Class<? extends LXComponent> clz) {
        LXLicense license = clz.getAnnotation(LXLicense.class);
        if (license != null && !this.permissions.hasPackageLicense(license.value())) {
            return false;
        }
        LXComponent.PluginRequired pluginRequired = clz.getAnnotation(LXComponent.PluginRequired.class);
        return pluginRequired == null || this.registry.isPluginClassEnabled(pluginRequired.value());
    }

    public LXModel instantiateModel(String className) throws InstantiationException {
        try {
            Class<LXModel> cls = Class.forName(className, true, this.registry.classLoader).asSubclass(LXModel.class);
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception x) {
            LX.error(x, "Exception in instantiateModel: " + x.getMessage());
            throw new InstantiationException(x, "Model " + className + " could not be loaded. Check that all required content files are present and constructor is public.");
        }
    }

    public <T extends LXComponent> T instantiateComponent(String className, Class<T> type) throws InstantiationException {
        Class<T> cls = null;
        try {
            cls = Class.forName(className, true, this.registry.classLoader).asSubclass(type);
        }
        catch (Exception x) {
            LX.error(x, "Exception in instantiateComponent: " + x.getMessage());
            throw new InstantiationException(x, className + " could not be loaded. Check that all required content files are present and constructor is public.");
        }
        return this.instantiateComponent(cls, type);
    }

    public <T extends LXComponent> T instantiateComponent(Class<? extends T> cls, Class<T> type) throws InstantiationException {
        Class<? extends LXPlugin> pluginClass;
        String pkg;
        LXLicense license = cls.getAnnotation(LXLicense.class);
        if (license != null && !this.permissions.hasPackageLicense(pkg = license.value())) {
            throw new InstantiationException(InstantiationException.Type.LICENSE, "Class requires valid license for package: " + pkg);
        }
        LXComponent.PluginRequired pluginRequired = cls.getAnnotation(LXComponent.PluginRequired.class);
        if (pluginRequired != null && !this.registry.isPluginClassEnabled(pluginClass = pluginRequired.value())) {
            throw new InstantiationException(InstantiationException.Type.PLUGIN, LXComponent.getComponentName(cls) + " requires plugin " + LXPlugin.getPluginName(pluginClass));
        }
        try {
            try {
                return (T)((LXComponent)cls.getConstructor(LX.class).newInstance(this));
            }
            catch (NoSuchMethodException nsmx) {
                return (T)((LXComponent)cls.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception x) {
            LX.error(x, "Exception in instantiateComponent: " + x.getMessage());
            throw new InstantiationException(x, cls.getSimpleName() + " could not be loaded. Check that all required content files are present and constructor is public.");
        }
    }

    public LXFixture instantiateFixture(String className) throws InstantiationException {
        return this.instantiateComponent(className, LXFixture.class);
    }

    public LXFixture instantiateFixture(Class<? extends LXFixture> cls) throws InstantiationException {
        return this.instantiateComponent(cls, LXFixture.class);
    }

    public LXModulator instantiateModulator(String className) throws InstantiationException {
        return this.instantiateComponent(className, LXModulator.class);
    }

    public LXModulator instantiateModulator(Class<? extends LXModulator> cls) throws InstantiationException {
        return this.instantiateComponent(cls, LXModulator.class);
    }

    public LXPattern instantiatePattern(String className) throws InstantiationException {
        return this.instantiateComponent(className, LXPattern.class);
    }

    public LXPattern instantiatePattern(Class<? extends LXPattern> cls) throws InstantiationException {
        return this.instantiateComponent(cls, LXPattern.class);
    }

    public LXEffect instantiateEffect(String className) throws InstantiationException {
        return this.instantiateComponent(className, LXEffect.class);
    }

    public LXEffect instantiateEffect(Class<? extends LXEffect> cls) throws InstantiationException {
        return this.instantiateComponent(cls, LXEffect.class);
    }

    public LXBlend instantiateBlend(String className) throws InstantiationException {
        return this.instantiateComponent(className, LXBlend.class);
    }

    public LXBlend instantiateBlend(Class<? extends LXBlend> cls) throws InstantiationException {
        return this.instantiateComponent(cls, LXBlend.class);
    }

    public Class<?> instantiateStatic(String className) throws ClassNotFoundException {
        return Class.forName(className, true, this.registry.classLoader);
    }

    public void setSystemClipboardString(String str) {
    }

    protected static void bootstrapMediaPath(Flags flags) {
        LX.bootstrapMediaPath(flags, "LXStudio");
    }

    protected static File bootstrapMediaPath(Flags flags, String dirName) {
        File studioDir = new File(System.getProperty("user.home"), dirName);
        if (!studioDir.exists()) {
            LX.log("Creating directory: " + String.valueOf(studioDir));
            studioDir.mkdir();
        }
        if (studioDir.isDirectory()) {
            flags.mediaPath = studioDir.getPath();
            Media[] mediaArray = Media.values();
            int n = mediaArray.length;
            int n2 = 0;
            while (n2 < n) {
                File contentDir;
                Media type = mediaArray[n2];
                if (type.isBootstrap() && !(contentDir = new File(studioDir, type.getDirName())).exists()) {
                    LX.log("Creating directory: " + String.valueOf(contentDir));
                    contentDir.mkdir();
                }
                ++n2;
            }
        } else {
            LX.error("~/" + dirName + " already exists but is not a directory, this will not go well.");
        }
        return studioDir;
    }

    public static void log(String message) {
        LX._log(System.out, message);
    }

    public static void warning(String message) {
        if (LOG_WARNINGS) {
            LX._log(System.out, "<WARNING> " + message);
        }
    }

    public static void debug(String message) {
        if (LOG_DEBUG) {
            LX._log(System.out, "<DEBUG> " + message);
        }
    }

    public static void error(String message) {
        LX._log(System.err, message);
    }

    public static void error(Throwable x) {
        Throwable cause = x.getCause();
        if (cause != null) {
            x = cause;
        }
        LX.error(x, x.getClass().getName() + ":" + x.getLocalizedMessage());
    }

    public static void error(Throwable x, String message) {
        LX._log(System.err, x, LOG_PREFIX, message);
    }

    public static void error(String message, boolean trace) {
        if (trace) {
            LX.error(new Exception(message));
        } else {
            LX.error(message);
        }
    }

    protected static void _log(String prefix, String message) {
        LX._log(System.out, null, prefix, message);
    }

    protected static void _error(String prefix, Exception x, String message) {
        LX._log(System.err, x, prefix, message);
    }

    protected static void _error(String prefix, String message) {
        LX._log(System.err, null, prefix, message);
    }

    protected static void _log(PrintStream stream, String message) {
        LX._log(stream, null, LOG_PREFIX, message);
    }

    protected static void _log(PrintStream stream, Throwable throwable, String prefix, String message) {
        String logMsg = "[" + prefix + " " + LOG_DATE_FORMAT.format(Calendar.getInstance().getTime()) + "] " + message;
        stream.println(logMsg);
        if (throwable != null) {
            throwable.printStackTrace(stream);
        }
        if (EXPLICIT_LOG_STREAM != null) {
            try {
                EXPLICIT_LOG_STREAM.println(logMsg);
                if (throwable != null) {
                    throwable.printStackTrace(EXPLICIT_LOG_STREAM);
                }
            }
            catch (Exception x) {
                EXPLICIT_LOG_STREAM = null;
                LX.error(x, "Exception writing log file to disk: " + x.getLocalizedMessage());
            }
        }
    }

    public static File getLogFile() {
        return EXPLICIT_LOG_FILE;
    }

    public static void setLogFile(File file) {
        try {
            EXPLICIT_LOG_FILE = file;
            EXPLICIT_LOG_STREAM = new PrintStream(new FileOutputStream(file, true));
        }
        catch (Exception x) {
            EXPLICIT_LOG_FILE = null;
            EXPLICIT_LOG_STREAM = null;
            LX.error(x, "Log file cannot be used: " + String.valueOf(file.toURI()) + " - " + x.getLocalizedMessage());
        }
    }

    public static void main(String[] args) {
        Flags flags = new Flags();
        LX.bootstrapMediaPath(flags);
        File projectFile = null;
        int i = 0;
        while (i < args.length) {
            if ("--log".equals(args[i])) {
                if (++i < args.length) {
                    LX.setLogFile(new File(args[i]));
                }
            } else if ("-zc".equals(args[i]) || "--zeroconf".equals(args[i])) {
                flags.zeroconf = true;
            } else if (args[i].endsWith(".lxp") || args[i].endsWith(".lxs")) {
                projectFile = new File(args[i]);
            }
            ++i;
        }
        LX.headless(flags, projectFile);
    }

    public static void headless(Flags flags, File projectFile) {
        LX.log("Starting LX headless engine 1.1.0...");
        LX lx = new LX(flags);
        if (projectFile != null) {
            boolean isSchedule = projectFile.getName().endsWith(".lxs");
            if (!projectFile.exists()) {
                LX.error((isSchedule ? "Schedule" : "Project") + " file does not exist: " + String.valueOf(projectFile));
            } else if (isSchedule) {
                lx.preferences.schedulerEnabled.setValue(true);
                LX.log("Opening schedule file: " + String.valueOf(projectFile));
                lx.scheduler.openSchedule(projectFile, true);
            } else {
                LX.log("Opening initial project file: " + String.valueOf(projectFile));
                lx.openProject(projectFile);
            }
        }
        lx.engine.start();
    }

    public static class Error {
        public final Throwable cause;
        public final String message;

        private Error(String message) {
            this(null, message);
        }

        private Error(Throwable cause) {
            this(cause, cause.getLocalizedMessage());
        }

        private Error(Throwable cause, String message) {
            this.cause = cause;
            this.message = message;
        }

        /*
         * Loose catch block
         */
        public String getStackTrace() {
            if (this.cause != null) {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try {
                        String string;
                        PrintWriter pw;
                        StringWriter sw;
                        block19: {
                            sw = new StringWriter();
                            pw = new PrintWriter(sw);
                            this.cause.printStackTrace(pw);
                            string = sw.toString();
                            if (pw != null) {
                                pw.close();
                            }
                            if (sw == null) break block19;
                            sw.close();
                        }
                        return string;
                        {
                            catch (Throwable throwable2) {
                                try {
                                    if (pw != null) {
                                        pw.close();
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    if (sw != null) {
                                        sw.close();
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class Flags {
        public boolean isP4LX = false;
        public boolean immutableModel = false;
        public boolean focusChannelOnCue = false;
        public boolean focusActivePattern = false;
        public boolean sendCueToOutput = false;
        public boolean autosave = false;
        public long autosaveIntervalMs = 15000L;
        public boolean zeroconf = false;
        public String zeroconfServiceName = "LX";
        public LXEngine.ThreadMode threadMode = LXEngine.ThreadMode.SCHEDULED_EXECUTOR_SERVICE;
        public int engineThreadPriority = 10;
        public String mediaPath = ".";
        public LXPlugin initialize = null;
        public boolean loadPreferences = true;
        public List<String> enabledPlugins = new ArrayList<String>();
        public List<String> classpathPlugins = new ArrayList<String>();
        public OutputMode outputMode = OutputMode.PROJECT;

        public static enum OutputMode {
            PROJECT,
            ACTIVE,
            INACTIVE;

        }
    }

    public static class InitProfiler {
        private long lastTime;

        protected void init() {
            this.lastTime = System.nanoTime();
        }

        public void log(String label) {
            long thisTime = System.nanoTime();
            if (LOG_INIT_PROFILER) {
                LX.log(String.format("init: %s: %.2fms", label, (double)(thisTime - this.lastTime) / 1000000.0));
            }
            this.lastTime = thisTime;
        }
    }

    public static class InstantiationException
    extends Exception {
        private static final long serialVersionUID = 2L;
        public final Type type;

        public InstantiationException(Type type, String message) {
            super(message);
            this.type = type;
        }

        public InstantiationException(Exception underlying, String message) {
            super(message, underlying);
            this.type = Type.EXCEPTION;
        }

        public static enum Type {
            EXCEPTION,
            LICENSE,
            PLUGIN;

        }
    }

    public static interface Listener {
        default public void modelChanged(LX lx, LXModel model) {
        }

        default public void modelGenerationChanged(LX lx, LXModel model) {
        }
    }

    public static enum Media {
        PACKAGES("Packages"),
        FIXTURES("Fixtures"),
        PROJECTS("Projects"),
        MODELS("Models"),
        VIEWS("Views"),
        PRESETS("Presets"),
        SCRIPTS("Scripts"),
        COLORS("Colors"),
        MIDI_MAPPINGS("MIDI Mappings"),
        LOGS("Logs"),
        AUTOSAVE("Autosave"),
        DELETED("Deleted");

        private final String dirName;

        private Media(String dirName) {
            this.dirName = dirName;
        }

        public String getDirName() {
            return this.dirName;
        }

        private boolean isBootstrap() {
            switch (this) {
                case AUTOSAVE: {
                    return false;
                }
                case DELETED: {
                    return false;
                }
            }
            return true;
        }
    }

    public static interface ModelListener {
        public void modelChanged(LXModel var1);
    }

    public static interface Permissions {
        public static final int UNLIMITED_POINTS = -1;
        public static final Permissions UNRESTRICTED = new Permissions(){

            @Override
            public boolean isEulaRequired() {
                return false;
            }

            @Override
            public boolean canSave() {
                return true;
            }

            @Override
            public int getMaxOutputPoints() {
                return -1;
            }

            @Override
            public int getMaxRenderPoints() {
                return -1;
            }

            @Override
            public boolean canRunPlugins() {
                return true;
            }

            @Override
            public boolean hasPackageLicense(String packageName) {
                return false;
            }
        };

        public boolean isEulaRequired();

        public boolean canSave();

        public int getMaxOutputPoints();

        public int getMaxRenderPoints();

        public boolean canRunPlugins();

        public boolean hasPackageLicense(String var1);
    }

    public static interface ProjectListener {
        public void projectChanged(File var1, Change var2);

        public static enum Change {
            TRY,
            NEW,
            SAVE,
            OPEN;

        }
    }
}

