/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class LXClassLoader
extends URLClassLoader {
    static final String PACKAGE_DESCRIPTOR_FILE_NAME = "lx.package";
    private final LX lx;
    private final List<Class<?>> classes = new ArrayList();
    private final List<File> jarFiles;

    private static List<File> defaultJarFiles(LX lx) {
        ArrayList<File> jarFiles = new ArrayList<File>();
        LXClassLoader.collectJarFiles(jarFiles, lx.getMediaFolder(LX.Media.PACKAGES, false));
        return jarFiles;
    }

    private static void collectJarFiles(List<File> jarFiles, File folder) {
        try {
            if (folder.exists() && folder.isDirectory()) {
                File[] fileArray = folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isHidden()) {
                        if (file.isDirectory()) {
                            LXClassLoader.collectJarFiles(jarFiles, file);
                        } else if (file.isFile() && file.getName().endsWith(".jar")) {
                            jarFiles.add(file);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception x) {
            LX.error(x, "Unhandled exception loading custom content dir: " + String.valueOf(folder));
        }
    }

    private static URL[] fileListToURLArray(List<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LX.error(e, "Bad URL in file list: " + String.valueOf(file));
            }
        }
        return urls.toArray(new URL[0]);
    }

    protected LXClassLoader(LX lx) {
        this(lx, LXClassLoader.defaultJarFiles(lx));
    }

    protected LXClassLoader(LX lx, List<File> jarFiles) {
        super(LXClassLoader.fileListToURLArray(jarFiles), lx.getClass().getClassLoader());
        this.lx = lx;
        this.jarFiles = jarFiles;
    }

    protected void load() {
        for (File jarFile : this.jarFiles) {
            this.loadJarFile(jarFile);
        }
    }

    protected void dispose() {
        for (Class<?> clz : this.classes) {
            this.lx.registry.removeClass(clz);
        }
        this.classes.clear();
    }

    private void loadJarFile(File file) {
        LX.log("Loading package content from: " + String.valueOf(file));
        Package pack = new Package(file);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (JarFile jarFile = new JarFile(file);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String fileName = entry.getName();
                    if (PACKAGE_DESCRIPTOR_FILE_NAME.equals(fileName)) {
                        this.loadPackageMetadata(pack, jarFile, entry);
                        continue;
                    }
                    if (!fileName.endsWith(".class")) continue;
                    this.loadClassEntry(pack, jarFile, LXClassLoader.className(fileName).replaceAll("/", "\\."));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iox) {
            LX.error(iox, "IOException unpacking JAR file " + String.valueOf(file) + " - " + iox.getLocalizedMessage());
            pack.setError(iox);
        }
        catch (Throwable e) {
            LX.error(e, "Unhandled exception loading JAR file " + String.valueOf(file) + " - " + e.getLocalizedMessage());
            pack.setError(e);
        }
        if (pack.version == null) {
            LX.error("Package does not contain any version information: " + file.getName());
        }
        this.lx.registry.addPackage(pack);
    }

    private void loadPackageMetadata(Package pack, JarFile jarFile, JarEntry jarEntry) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader isr = new InputStreamReader(jarFile.getInputStream(jarEntry));){
                JsonObject obj = (JsonObject)new Gson().fromJson((Reader)isr, JsonObject.class);
                String name = "unknown";
                String version = "unknown";
                String lxVersion = "unknown";
                Object buildTimestamp = "";
                if (obj.has("name")) {
                    name = pack.name = obj.get("name").getAsString();
                }
                if (obj.has("author")) {
                    pack.author = obj.get("author").getAsString();
                }
                if (obj.has("url")) {
                    pack.url = obj.get("url").getAsString();
                }
                if (obj.has("build")) {
                    JsonObject buildObj = obj.get("build").getAsJsonObject();
                    if (buildObj.has("version")) {
                        version = pack.version = buildObj.get("version").getAsString();
                    }
                    if (buildObj.has("lxVersion")) {
                        lxVersion = buildObj.get("lxVersion").getAsString();
                        pack.setLXVersion(this.lx, lxVersion);
                    }
                    if (buildObj.has("buildTimestamp")) {
                        buildTimestamp = " buildTimestamp:" + buildObj.get("buildTimestamp").getAsString();
                    }
                }
                LX.log("Package:" + name + " version:" + version + " lxVersion:" + lxVersion + (String)buildTimestamp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable x) {
            LX.error(x, "Exception reading lx.package contents for: " + String.valueOf(jarFile));
        }
    }

    private static String className(String fileName) {
        return fileName.substring(0, fileName.length() - ".class".length());
    }

    private void loadClassEntry(Package pack, JarFile jarFile, String className) {
        try {
            Class<?> clz = this.loadClass(className, false);
            int modifiers = clz.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers)) {
                LXRegistry.ComponentType componentType = this.lx.registry.getInstantiableComponentType(clz);
                if (componentType != null) {
                    clz.getSimpleName();
                    switch (componentType) {
                        case EFFECT: {
                            ++pack.numEffects;
                            break;
                        }
                        case FIXTURE: {
                            ++pack.numFixtures;
                            break;
                        }
                        case MODULATOR: {
                            ++pack.numModulators;
                            break;
                        }
                        case PATTERN: {
                            ++pack.numPatterns;
                            break;
                        }
                        case PLUGIN: {
                            ++pack.numPlugins;
                        }
                    }
                }
                ++pack.numClasses;
                this.classes.add(clz);
                this.lx.registry.addClass(clz, pack);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfx) {
            LX.error(cnfx, "Dependency class not found, required by JAR file: " + className + " " + jarFile.getName());
            ++pack.numFailedClasses;
        }
        catch (Throwable x) {
            LX.error(x, "Unhandled exception in class loading: " + className);
        }
    }

    public static class Package {
        final File jarFile;
        private String name;
        private String author = "Unknown Author";
        private String url = null;
        private String version = null;
        private int versionCompare = 0;
        private String lxVersion = null;
        private Throwable error = null;
        private int numPatterns = 0;
        private int numEffects = 0;
        private int numModulators = 0;
        private int numFixtures = 0;
        private int numPlugins = 0;
        private int numClasses = 0;
        private int numFailedClasses = 0;

        private Package(File jarFile) {
            this.jarFile = jarFile;
            this.name = jarFile.getName();
            if (this.name.endsWith(".jar")) {
                this.name = this.name.substring(0, this.name.length() - ".jar".length());
            }
        }

        public String getFileName() {
            return this.jarFile.getName();
        }

        public String getName() {
            return this.name;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getURL() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public void setLXVersion(LX lx, String lxVersion) {
            this.lxVersion = lxVersion;
            this.versionCompare = LX.compareVersion("1.1.0", lxVersion);
            if (this.isNewerThanApp()) {
                String err = "Package " + this.getName() + " was built for a newer version of Chromatik (" + lxVersion + "). You are running 1.1.0. Content in this package may not behave correctly.";
                lx.pushError(err);
                LX.error(err);
            }
            if (this.isOutOfDate()) {
                LX.error("Package " + this.getName() + " was built for an older version of Chromatik (" + lxVersion + "). You are running 1.1.0. Content in this package may not behave correctly.");
            }
        }

        public String getLXVersion() {
            return this.lxVersion;
        }

        private void setError(Throwable error) {
            this.error = error;
        }

        public int getNumClasses() {
            return this.numClasses;
        }

        public int getNumFailedClasses() {
            return this.numFailedClasses;
        }

        public int getNumComponents(LXRegistry.ComponentType componentType) {
            return switch (componentType) {
                case LXRegistry.ComponentType.EFFECT -> this.numEffects;
                case LXRegistry.ComponentType.FIXTURE -> this.numFixtures;
                case LXRegistry.ComponentType.MODULATOR -> this.numModulators;
                case LXRegistry.ComponentType.PATTERN -> this.numPatterns;
                case LXRegistry.ComponentType.PLUGIN -> this.numPlugins;
                default -> throw new MatchException(null, null);
            };
        }

        public boolean isOutOfDate() {
            return this.versionCompare > 0;
        }

        public boolean isNewerThanApp() {
            return this.versionCompare < 0;
        }

        public boolean hasError() {
            return this.error != null;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

