/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXLayeredComponent;
import heronarts.lx.LXPath;
import heronarts.lx.LXPresetComponent;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiFilterParameter;
import heronarts.lx.midi.MidiPanic;
import heronarts.lx.midi.surface.LXMidiSurface;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXMasterBus;
import heronarts.lx.model.LXModel;
import heronarts.lx.modulation.LXModulationContainer;
import heronarts.lx.modulation.LXModulationEngine;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.structure.view.LXViewDefinition;
import heronarts.lx.structure.view.LXViewEngine;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class LXDeviceComponent
extends LXLayeredComponent
implements LXPresetComponent,
LXModulationContainer,
LXOscComponent,
LXMidiListener {
    public static final Comparator<Class<? extends LXDeviceComponent>> DEVICE_CATEGORY_NAME_SORT = new Comparator<Class<? extends LXDeviceComponent>>(){

        @Override
        public int compare(Class<? extends LXDeviceComponent> cls1, Class<? extends LXDeviceComponent> cls2) {
            String category2;
            String category1 = LXDeviceComponent.getCategory(cls1);
            if (category1.equals(category2 = LXDeviceComponent.getCategory(cls2))) {
                return LXComponent.getComponentName(cls1).compareToIgnoreCase(LXComponent.getComponentName(cls2));
            }
            if (category1.equals("Test")) {
                return 1;
            }
            if (category2.equals("Test")) {
                return -1;
            }
            return category1.compareToIgnoreCase(category2);
        }
    };
    protected static final int DEVICE_VERSION_UNSPECIFIED = -1;
    public final LXModulationEngine modulation;
    private LXListenableNormalizedParameter[] defaultRemoteControls = null;
    private LXListenableNormalizedParameter[] customRemoteControls = null;
    public MutableParameter remoteControlsChanged = new MutableParameter("Remote Control Monitor");
    private Throwable crash = null;
    public final BooleanParameter crashed = new BooleanParameter("Crashed", false).setDescription("Set to true by the engine if this component fails in an unexpected way");
    public final BooleanParameter controlsExpanded = new BooleanParameter("Expanded", true).setDescription("Whether the device controls are expanded");
    public final BooleanParameter controlsExpandedCue = new BooleanParameter("Expanded Cue", true).setDescription("Whether the device controls are expanded in cue view");
    public final BooleanParameter controlsExpandedAux = new BooleanParameter("Expanded Aux", true).setDescription("Whether the device controls are expanded in aux view");
    public final BooleanParameter modulationExpanded = new BooleanParameter("Modulation Expanded", false).setDescription("Whether the device modulation section is expanded");
    public final MidiFilterParameter midiFilter = new MidiFilterParameter("MIDI Filter", true).setDescription("MIDI filter settings for this device");
    public final LXViewEngine.Selector view;
    public final LXViewEngine.Selector viewPriority;
    private final LXParameterListener viewListener;
    private final LXParameterListener viewPriorityListener;
    private final LinkedHashMap<String, LXComponent> mutableAutomationChildren = new LinkedHashMap();
    public final Map<String, LXComponent> automationChildren = Collections.unmodifiableMap(this.mutableAutomationChildren);
    public final MutableParameter controlSurfaceSemaphore = new MutableParameter("Control-Surfaces", 0.0).setDescription("How many control surfaces are controlling this component");
    private final CopyOnWriteArraySet<LXMidiSurface> controlSurfaces = new CopyOnWriteArraySet();
    protected static final String KEY_DEVICE_VERSION = "deviceVersion";
    private static final String KEY_REMOTE_CONTROLS = "remoteControls";

    protected LXDeviceComponent(LX lx) {
        this(lx, (String)null);
    }

    protected LXDeviceComponent(LX lx, String label) {
        super(lx, label);
        this.modulation = new LXModulationEngine(lx);
        this.addChild("modulation", this.modulation);
        this.addInternalParameter("expanded", this.controlsExpanded);
        this.addInternalParameter("expandedCue", this.controlsExpandedCue);
        this.addInternalParameter("expandedAux", this.controlsExpandedAux);
        this.addInternalParameter("modulationExpanded", this.modulationExpanded);
        this.addParameter("midiFilter", this.midiFilter);
        this.view = lx.structure.views.newViewSelector("View", "Model view selector for this device");
        this.addParameter("view", this.view);
        this.viewPriority = lx.structure.views.newViewSelectorPriority("View", "Priority model view selector for this device");
        this.addParameter("viewPriority", this.viewPriority);
        this.viewListener = p -> {
            LXViewDefinition view = (LXViewDefinition)this.view.getObject();
            if (view == null || view.priority.isOn()) {
                this.viewPriority.setValue(view);
            }
        };
        this.view.addListener(this.viewListener);
        this.viewPriorityListener = p -> this.view.setValue(this.viewPriority.getObject());
        this.viewPriority.addListener(this.viewPriorityListener);
        this.setDescription(LXDeviceComponent.getDeviceDescription(this.getClass()));
    }

    protected LXDeviceComponent addAutomationChild(String path, LXComponent child) {
        this.addChild(path, child);
        this.mutableAutomationChildren.put(path, child);
        return this;
    }

    public static String getDeviceDescription(Class<? extends LXDeviceComponent> cls) {
        String name = LXComponent.getComponentName(cls);
        String description = LXComponent.getComponentDescription(cls);
        if (description != null) {
            return name + ": " + description;
        }
        return name;
    }

    public LXModel getModelView() {
        LXViewDefinition view = (LXViewDefinition)this.view.getObject();
        if (view != null) {
            return view.getModelView();
        }
        LXComponent parent = this.getParent();
        if (parent instanceof LXAbstractChannel) {
            return ((LXAbstractChannel)parent).getModelView();
        }
        if (parent instanceof LXMasterBus) {
            return this.lx.model;
        }
        return this.getModel();
    }

    private void validateRemoteControls(LXListenableNormalizedParameter ... remoteControls) {
        LXListenableNormalizedParameter[] lXListenableNormalizedParameterArray = remoteControls;
        int n = remoteControls.length;
        int n2 = 0;
        while (n2 < n) {
            LXListenableNormalizedParameter control = lXListenableNormalizedParameterArray[n2];
            if (control != null && !control.isDescendant(this)) {
                throw new IllegalArgumentException("Cannot add remote control that does not belong to this component: " + String.valueOf(control));
            }
            ++n2;
        }
    }

    protected void setRemoteControls(LXListenableNormalizedParameter ... remoteControls) {
        this.validateRemoteControls(remoteControls);
        this.defaultRemoteControls = remoteControls;
    }

    public void clearCustomRemoteControls() {
        if (this.customRemoteControls != null) {
            this.customRemoteControls = null;
            this.remoteControlsChanged.bang();
        }
    }

    public void setCustomRemoteControls(LXListenableNormalizedParameter ... remoteControls) {
        this.validateRemoteControls(remoteControls);
        this.customRemoteControls = remoteControls;
        this.remoteControlsChanged.bang();
    }

    protected LXComponent removeCustomRemoteControl(LXParameter parameter) {
        if (this.customRemoteControls != null) {
            int i = 0;
            while (i < this.customRemoteControls.length) {
                if (this.customRemoteControls[i] == parameter) {
                    this.customRemoteControls[i] = null;
                }
                ++i;
            }
        }
        return this;
    }

    public LXListenableNormalizedParameter[] getCustomRemoteControls() {
        return this.customRemoteControls;
    }

    public boolean isSnapshotControl(LXParameter parameter) {
        return parameter != this.label && parameter != this.midiFilter && parameter != this.viewPriority;
    }

    public boolean isHiddenControl(LXParameter parameter) {
        return parameter == this.midiFilter || parameter == this.view || parameter == this.viewPriority;
    }

    protected LXDeviceComponent resetRemoteControls() {
        this.defaultRemoteControls = null;
        this.remoteControlsChanged.bang();
        return this;
    }

    public final LXListenableNormalizedParameter[] getRemoteControls() {
        if (this.customRemoteControls != null) {
            return this.customRemoteControls;
        }
        if (this.defaultRemoteControls == null) {
            ArrayList<LXListenableNormalizedParameter> remoteControls = new ArrayList<LXListenableNormalizedParameter>();
            for (LXParameter parameter : this.getParameters()) {
                if (this.isHiddenControl(parameter) || parameter.getParentParameter() != null) continue;
                if (parameter instanceof AggregateParameter) {
                    LXListenableNormalizedParameter subparameter = ((AggregateParameter)parameter).getRemoteControl();
                    if (subparameter == null) continue;
                    remoteControls.add(subparameter);
                    continue;
                }
                if (!(parameter instanceof LXListenableNormalizedParameter)) continue;
                remoteControls.add((LXListenableNormalizedParameter)parameter);
            }
            this.defaultRemoteControls = remoteControls.toArray(new LXListenableNormalizedParameter[0]);
        }
        return this.defaultRemoteControls;
    }

    public LXComponent addControlSurface(LXMidiSurface surface) {
        if (this.controlSurfaces.contains(surface)) {
            throw new IllegalStateException("Cannot add same control surface to device twice: " + String.valueOf(surface));
        }
        this.controlSurfaces.add(surface);
        this.controlSurfaceSemaphore.increment();
        return this;
    }

    public LXComponent removeControlSurface(LXMidiSurface surface) {
        if (!this.controlSurfaces.contains(surface)) {
            throw new IllegalStateException("Cannot remove control surface that is not added: " + String.valueOf(surface));
        }
        this.controlSurfaces.remove(surface);
        this.controlSurfaceSemaphore.decrement();
        return this;
    }

    public Set<LXMidiSurface> getControlSurfaces() {
        return this.controlSurfaces;
    }

    public int getDeviceVersion() {
        return -1;
    }

    @Override
    public void loop(double deltaMs) {
        if (!this.crashed.isOn()) {
            try {
                this.modulation.loop(deltaMs);
                super.loop(deltaMs);
            }
            catch (Throwable x) {
                LX.error(x, "Unexpected error in device loop " + this.getClass().getName() + ": " + x.getLocalizedMessage());
                this.lx.pushError(x, "Device " + LXComponent.getComponentName(this.getClass()) + " crashed due to an unexpected error.\n" + x.getLocalizedMessage());
                this.crash = x;
                this.crashed.setValue(true);
            }
        }
    }

    public Throwable getCrash() {
        return this.crash;
    }

    public String getCrashStackTrace() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringWriter sw = new StringWriter();){
                this.crash.printStackTrace(new PrintWriter(sw));
                return sw.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iox) {
            return null;
        }
    }

    @Override
    public LXModulationEngine getModulationEngine() {
        return this.modulation;
    }

    @Override
    public BooleanParameter getModulationExpanded() {
        return this.modulationExpanded;
    }

    public void midiDispatch(LXShortMessage message) {
        if (message instanceof MidiPanic) {
            this.midiFilter.midiPanic();
            message.dispatch(this);
        } else if (this.midiFilter.filter(message)) {
            message.dispatch(this);
        }
        this.getModulationEngine().midiDispatch(message);
    }

    @Override
    public void dispose() {
        this.view.removeListener(this.viewListener);
        this.viewPriority.removeListener(this.viewPriorityListener);
        super.dispose();
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.addProperty(KEY_DEVICE_VERSION, (Number)this.getDeviceVersion());
        if (this.customRemoteControls != null) {
            JsonArray remoteControls = new JsonArray();
            LXListenableNormalizedParameter[] lXListenableNormalizedParameterArray = this.customRemoteControls;
            int n = this.customRemoteControls.length;
            int n2 = 0;
            while (n2 < n) {
                LXListenableNormalizedParameter control = lXListenableNormalizedParameterArray[n2];
                remoteControls.add(control != null ? control.getCanonicalPath(this) : null);
                ++n2;
            }
            obj.add(KEY_REMOTE_CONTROLS, (JsonElement)remoteControls);
        }
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (obj.has(KEY_REMOTE_CONTROLS)) {
            JsonArray remoteControls = obj.get(KEY_REMOTE_CONTROLS).getAsJsonArray();
            LXListenableNormalizedParameter[] customRemoteControls = new LXListenableNormalizedParameter[remoteControls.size()];
            int i = 0;
            while (i < remoteControls.size()) {
                LXParameter parameter;
                JsonElement elem = remoteControls.get(i);
                if (!elem.isJsonNull() && (parameter = LXPath.getParameter(this, remoteControls.get(i).getAsString())) instanceof LXListenableNormalizedParameter) {
                    customRemoteControls[i] = (LXListenableNormalizedParameter)parameter;
                }
                ++i;
            }
            this.setCustomRemoteControls(customRemoteControls);
        }
    }

    public static interface Midi {
    }
}

