/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXBuffer;
import heronarts.lx.LXComponent;
import heronarts.lx.LXLoopTask;
import heronarts.lx.LXMappingEngine;
import heronarts.lx.Tempo;
import heronarts.lx.audio.LXAudioEngine;
import heronarts.lx.clip.LXClipEngine;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.dmx.LXDmxEngine;
import heronarts.lx.midi.LXMidiEngine;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.mixer.LXMixerEngine;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.modulation.LXModulationContainer;
import heronarts.lx.modulation.LXModulationEngine;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.output.LXOutput;
import heronarts.lx.output.LXOutputGroup;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.snapshot.LXSnapshotEngine;
import heronarts.lx.structure.LXFixture;
import heronarts.lx.structure.view.LXViewDefinition;
import java.io.File;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class LXEngine
extends LXComponent
implements LXOscComponent,
LXModulationContainer {
    public final LXPalette palette;
    public final Tempo tempo;
    public final LXClipEngine clips;
    public final LXMixerEngine mixer;
    public final LXMidiEngine midi;
    public final LXAudioEngine audio;
    public final LXMappingEngine mapping;
    public final LXOscEngine osc;
    public final LXDmxEngine dmx;
    private Dispatch inputDispatch = null;
    private boolean inLoopTasks = false;
    private final List<LXLoopTask> loopTasks = new ArrayList<LXLoopTask>();
    private final List<LXLoopTask> removedLoopTasks = new ArrayList<LXLoopTask>();
    private final AtomicBoolean hasTask = new AtomicBoolean(false);
    private final List<Runnable> threadSafeTaskQueue = Collections.synchronizedList(new ArrayList());
    private final List<Runnable> engineThreadTaskQueue = new ArrayList<Runnable>();
    public final Output output;
    public final BoundedParameter framesPerSecond = new BoundedParameter("FPS", 60.0, 1.0, 300.0).setMappable(false).setOscMode(LXNormalizedParameter.OscMode.ABSOLUTE).setDescription("Number of frames per second the engine runs at");
    public final BoundedParameter speed = new BoundedParameter("Speed", 1.0, 0.0, 2.0).setDescription("Overall speed adjustement to the entire engine (does not apply to master tempo and audio)");
    public final BooleanParameter performanceMode = new BooleanParameter("Performance", false).setDescription("Whether performance mode UI is enabled");
    public final BooleanParameter restricted = new BooleanParameter("Restricted", false).setDescription("Whether rendering is disabled due to license restrictions");
    public final LXModulationEngine modulation;
    public final LXSnapshotEngine snapshots;
    private boolean logProfiler = false;
    private float actualFrameRate = 0.0f;
    private float cpuLoad = 0.0f;
    public final Profiler profiler = new Profiler();
    private final DoubleBuffer buffer;
    public final BooleanParameter isMultithreaded = new BooleanParameter("Threaded", false).setMappable(false).setDescription("Whether the engine and UI are on separate threads");
    public final BooleanParameter isChannelMultithreaded = new BooleanParameter("Channel Threaded", false).setMappable(false).setDescription("Whether the engine is multi-threaded per channel");
    public final BooleanParameter isNetworkMultithreaded = new BooleanParameter("Network Threaded", false).setMappable(false).setDescription("Whether the network output is on a separate thread");
    private Thread engineThread = null;
    private final ExecutorService engineExecutorService;
    private boolean isNetworkThreadStarted = false;
    public final NetworkThread networkThread;
    boolean hasStarted = false;
    private boolean paused = false;
    private static final long INIT_RUN = -1L;
    private long lastMillis = -1L;
    private long lastNanoTime = -1L;
    private long autoSaveMillis = -1L;
    private double fixedDeltaMs = 0.0;
    public long nowNanoTime = System.nanoTime();
    public long nowMillis = System.currentTimeMillis();
    private static final long NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final long NANOS_INTERVAL_60FPS = NANOS_PER_SECOND / 60L;
    private final EngineSampler sampler = new EngineSampler();
    private boolean runFailed = false;
    public static final String PATH_FRAMERATE = "framerate";
    public static final String PATH_OPEN_PROJECT = "openProject";
    private static final String KEY_MIDI = "midi";
    private static final String KEY_MODULATION = "modulation";

    LXEngine(LX lx) {
        super(lx, 1, "Engine");
        LX.initProfiler.log("Engine: Init");
        this.buffer = new DoubleBuffer(lx);
        this.engineExecutorService = new ExecutorService();
        this.networkThread = new NetworkThread(lx);
        this.mapping = new LXMappingEngine();
        this.palette = new LXPalette(lx);
        this.addChild("palette", this.palette);
        LX.initProfiler.log("Engine: Palette");
        this.tempo = new Tempo(lx);
        this.addChild("tempo", this.tempo);
        LX.initProfiler.log("Engine: Tempo");
        this.clips = new LXClipEngine(lx);
        this.addChild("clips", this.clips);
        LX.initProfiler.log("Engine: Clips");
        this.audio = new LXAudioEngine(lx);
        this.addChild("audio", this.audio);
        LX.initProfiler.log("Engine: Audio");
        this.mixer = new LXMixerEngine(lx);
        this.addChild("mixer", this.mixer);
        LX.initProfiler.log("Engine: Mixer");
        this.modulation = new LXModulationEngine(lx);
        this.addChild(KEY_MODULATION, this.modulation);
        LX.initProfiler.log("Engine: Modulation");
        this.output = new Output(lx);
        this.addChild("output", this.output);
        if (lx.structure.output != null) {
            this.output.addChild(lx.structure.output);
        }
        LX.initProfiler.log("Engine: Output");
        this.snapshots = new LXSnapshotEngine(lx);
        this.addChild("snapshots", this.snapshots);
        LX.initProfiler.log("Engine: Snapshots");
        this.dmx = new LXDmxEngine(lx);
        this.addChild("dmx", this.dmx);
        LX.initProfiler.log("Engine: DMX");
        this.midi = new LXMidiEngine(lx);
        this.addChild(KEY_MIDI, this.midi);
        LX.initProfiler.log("Engine: Midi");
        this.osc = new LXOscEngine(lx);
        this.addChild("osc", this.osc);
        LX.initProfiler.log("Engine: Osc");
        this.addParameter("multithreaded", this.isMultithreaded);
        this.addParameter("channelMultithreaded", this.isChannelMultithreaded);
        this.addParameter("networkMultithreaded", this.isNetworkMultithreaded);
        this.addParameter("framesPerSecond", this.framesPerSecond);
        this.addParameter("speed", this.speed);
        this.addParameter("performanceMode", this.performanceMode);
        this.restricted.addListener(p -> {
            if (this.restricted.isOn()) {
                LX.error("Rendering engine disabled due to license restrictions.");
            } else {
                LX.log("Rendering engine restored within license limits.");
            }
        });
    }

    public void logProfiler() {
        this.logProfiler = true;
    }

    @Override
    public String getPath() {
        return "lx";
    }

    public LXEngine setInputDispatch(Dispatch inputDispatch) {
        this.inputDispatch = inputDispatch;
        return this;
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.isNetworkMultithreaded) {
            if (this.isNetworkMultithreaded.isOn()) {
                this.buffer.sync();
                if (!this.isNetworkThreadStarted) {
                    this.isNetworkThreadStarted = true;
                    this.networkThread.start();
                }
            }
        } else if (p == this.framesPerSecond) {
            this.engineExecutorService.updateFramerate();
        }
    }

    public float getActualFrameRate() {
        return this.actualFrameRate;
    }

    public float getCpuLoad() {
        return this.cpuLoad;
    }

    public LXEngine setFixedDeltaMs(double deltaMs) {
        this.fixedDeltaMs = deltaMs;
        return this;
    }

    public void start() {
        if (this.lx.flags.isP4LX) {
            throw new IllegalStateException("LXEngine start() may not be used from P4LX, call setThreaded() instead");
        }
        this.isMultithreaded.setValue(true);
        this._setThreaded(true);
    }

    public void stop() {
        if (this.lx.flags.isP4LX) {
            throw new IllegalStateException("LXEngine stop() may not be used from P4LX, call setThreaded() instead");
        }
        this.isMultithreaded.setValue(false);
        this._setThreaded(false);
    }

    public boolean isThreaded() {
        return this.engineThread != null;
    }

    public LXEngine setThreaded(boolean threaded) {
        if (!this.lx.flags.isP4LX) {
            throw new IllegalStateException("LXEngine.setThreaded() should not be used outside P4LX, call start() / stop() instead");
        }
        this.isMultithreaded.setValue(threaded);
        return this;
    }

    public LXEngine onP4DidDispose() {
        if (!this.lx.flags.isP4LX) {
            throw new IllegalStateException("LXEngine.onP4DidDispose() should only be called from Processing dispose() method");
        }
        if (this.isThreaded()) {
            this._setThreaded(false);
        }
        return this;
    }

    public void beforeP4LXDraw() {
        if (this.isThreaded() != this.isMultithreaded.isOn()) {
            this._setThreaded(this.isMultithreaded.isOn());
            if (!this.isMultithreaded.isOn()) {
                this.processInputEvents();
            }
        }
    }

    private synchronized void _setThreaded(boolean threaded) {
        if (threaded == this.isThreaded()) {
            throw new IllegalStateException("Cannot set thread state to current state: " + threaded);
        }
        if (!threaded) {
            if (Thread.currentThread() == this.engineThread) {
                throw new IllegalStateException("Cannot call to stop engine thread from itself");
            }
            if (this.lx.flags.threadMode == ThreadMode.SCHEDULED_EXECUTOR_SERVICE) {
                this.engineExecutorService.stop();
            } else {
                this.engineThread.interrupt();
            }
            try {
                this.engineThread.join();
            }
            catch (InterruptedException ix) {
                throw new IllegalThreadStateException("Interrupted waiting to join LXEngine thread");
            }
            this.engineThread = null;
        } else {
            this.buffer.sync();
            this.buffer.flip();
            if (this.lx.flags.threadMode == ThreadMode.SCHEDULED_EXECUTOR_SERVICE) {
                this.engineExecutorService.start();
            } else {
                this.engineThread = new EngineThread();
                this.engineThread.start();
            }
        }
    }

    public LXEngine setSpeed(double speed) {
        this.speed.setValue(speed);
        return this;
    }

    public LXEngine setPaused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public LXEngine registerComponent(String path, LXComponent component) {
        this.addChild(path, component);
        return this;
    }

    public LXEngine addTask(Runnable runnable) {
        this.threadSafeTaskQueue.add(runnable);
        this.hasTask.set(true);
        return this;
    }

    public LXEngine addLoopTask(LXLoopTask loopTask) {
        if (this.loopTasks.contains(loopTask)) {
            throw new IllegalStateException("Cannot add task to engine twice: " + String.valueOf(loopTask));
        }
        this.loopTasks.add(loopTask);
        return this;
    }

    public LXEngine removeLoopTask(LXLoopTask loopTask) {
        if (this.inLoopTasks) {
            this.removedLoopTasks.add(loopTask);
        } else {
            this.loopTasks.remove(loopTask);
        }
        return this;
    }

    public Timer addTimeout(double timerMs, Runnable runnable) {
        Timer timer = new Timer(timerMs, runnable, false);
        this.addLoopTask(timer);
        return timer;
    }

    public Timer addInterval(double intervalMs, Runnable runnable) {
        Timer timer = new Timer(intervalMs, runnable, true);
        this.addLoopTask(timer);
        return timer;
    }

    public LXEngine addOutput(LXOutput output) {
        this.output.addChild(output);
        return this;
    }

    @Override
    public LXModulationEngine getModulationEngine() {
        return this.modulation;
    }

    public void run() {
        this.run(false);
    }

    private void run(boolean fromEngineThread) {
        if (this.runFailed) {
            return;
        }
        try {
            this._run(fromEngineThread);
        }
        catch (Throwable x) {
            this.runFailed = true;
            LX.error(x, "FATAL ERROR IN LXEngine.run(): " + x.getLocalizedMessage());
            this.lx.fail(x);
        }
    }

    private void processInputEvents() {
        try {
            this._processInputEvents();
        }
        catch (Throwable x) {
            LX.error(x, "FATAL ERROR IN LXEngine.processInputEvents(): " + x.getLocalizedMessage());
            this.lx.fail(x);
        }
    }

    private void _processInputEvents() {
        long midiStart = System.nanoTime();
        this.midi.dispatch();
        this.profiler.midiNanos = System.nanoTime() - midiStart;
        long oscStart = System.nanoTime();
        this.osc.dispatch();
        this.profiler.oscNanos = System.nanoTime() - oscStart;
        if (this.inputDispatch == null) {
            this.profiler.inputNanos = 0L;
        } else {
            long inputStart = System.nanoTime();
            this.inputDispatch.dispatch();
            this.profiler.inputNanos = System.nanoTime() - inputStart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _run(boolean fromEngineThread) {
        boolean isDoubleBuffering;
        double deltaMs;
        this.hasStarted = true;
        long runStart = this.nowNanoTime = System.nanoTime();
        this.nowMillis = System.currentTimeMillis();
        if (this.lastMillis == -1L) {
            this.lastNanoTime = this.nowNanoTime - (long)(1.0E9 / this.framesPerSecond.getValue());
            this.autoSaveMillis = this.lastMillis = this.nowMillis - (long)(1000.0f / this.framesPerSecond.getValuef());
        }
        if ((deltaMs = (double)(this.nowNanoTime - this.lastNanoTime) / 1000000.0) < 0.0) {
            LX.error("Negative system clock change detected from System.nanoTime(): " + this.nowNanoTime);
            deltaMs = 1000.0 / this.framesPerSecond.getValue();
        } else if (deltaMs > 60000.0) {
            LX.error("System.nanoTime() clock moved over 60s in a frame, resetting clock timer: " + this.nowNanoTime);
            deltaMs = 1000.0 / this.framesPerSecond.getValue();
        }
        this.lastMillis = this.nowMillis;
        this.lastNanoTime = this.nowNanoTime;
        if (this.fixedDeltaMs > 0.0) {
            deltaMs = this.fixedDeltaMs;
        }
        if (this.paused) {
            this.profiler.channelNanos = 0L;
            ((LXBus.Profiler)this.mixer.masterBus.profiler).effectNanos = 0L;
            this.profiler.runNanos = System.nanoTime() - runStart;
            return;
        }
        if (!fromEngineThread) {
            this.processInputEvents();
        }
        if (this.hasTask.compareAndSet(true, false)) {
            this.engineThreadTaskQueue.clear();
            List<Runnable> list = this.threadSafeTaskQueue;
            synchronized (list) {
                this.engineThreadTaskQueue.addAll(this.threadSafeTaskQueue);
                this.threadSafeTaskQueue.clear();
            }
            for (Runnable runnable : this.engineThreadTaskQueue) {
                runnable.run();
            }
        }
        this.lx.scheduler.loop(deltaMs);
        this.buffer.render.setModel(this.lx.model);
        boolean eulaAccepted = !this.lx.permissions.isEulaRequired() || this.lx.preferences.eulaAccepted.isOn();
        int maxOutputPoints = this.lx.permissions.getMaxOutputPoints();
        int maxRenderPoints = this.lx.permissions.getMaxRenderPoints();
        this.restricted.setValue(maxRenderPoints >= 0 && this.buffer.render.main.length > maxRenderPoints);
        this.output.restricted.setValue(maxOutputPoints >= 0 && this.buffer.render.main.length > maxOutputPoints);
        this.lx.engine.tempo.loop(deltaMs);
        this.audio.loop(deltaMs);
        this.modulation.loop(deltaMs *= this.speed.getValue());
        this.snapshots.loop(deltaMs);
        this.lx.engine.palette.loop(deltaMs);
        this.inLoopTasks = true;
        for (LXLoopTask loopTask : this.loopTasks) {
            loopTask.loop(deltaMs);
        }
        this.inLoopTasks = false;
        for (LXLoopTask loopTask : this.removedLoopTasks) {
            this.removeLoopTask(loopTask);
        }
        this.removedLoopTasks.clear();
        if (eulaAccepted && !this.restricted.isOn()) {
            this.mixer.loop(this.buffer.render, deltaMs);
        } else {
            Arrays.fill(this.buffer.render.main, -16777216);
            Arrays.fill(this.buffer.render.cue, -16777216);
            Arrays.fill(this.buffer.render.aux, -16777216);
        }
        for (LXViewDefinition view : this.lx.structure.views.views) {
            if (!view.cueActive.isOn() || view.getView() == null) continue;
            Arrays.fill(this.buffer.render.cue, -16777216);
            LXPoint[] lXPointArray = view.getView().points;
            int n = view.getView().points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                this.buffer.render.cue[p.index] = -1;
                ++n2;
            }
            this.buffer.render.setCueOn(true);
            break;
        }
        int identifyColor = LXColor.hsb(0.0f, 100.0f, Math.abs(-100L + runStart / 8000000L % 200L));
        for (LXFixture fixture : this.lx.structure.fixtures) {
            int end;
            int start;
            if (fixture.deactivate.isOn()) continue;
            if (fixture.mute.isOn()) {
                start = fixture.getIndexBufferOffset();
                end = start + fixture.totalSize();
                if (end > start) {
                    int i = start;
                    while (i < end) {
                        this.buffer.render.main[i] = -16777216;
                        this.buffer.render.cue[i] = -16777216;
                        this.buffer.render.aux[i] = -16777216;
                        ++i;
                    }
                }
            } else if (fixture.identify.isOn() && (end = (start = fixture.getIndexBufferOffset()) + fixture.totalSize()) > start) {
                int i = start;
                while (i < end) {
                    this.buffer.render.main[i] = identifyColor;
                    this.buffer.render.cue[i] = identifyColor;
                    this.buffer.render.aux[i] = identifyColor;
                    ++i;
                }
            }
            if (fixture.solo.isOn() && (end = (start = fixture.getIndexBufferOffset()) + fixture.totalSize()) > start) {
                int i = 0;
                while (i < this.buffer.render.main.length) {
                    if (i < start || i >= end) {
                        this.buffer.render.main[i] = -16777216;
                        this.buffer.render.cue[i] = -16777216;
                        this.buffer.render.aux[i] = -16777216;
                    }
                    ++i;
                }
            }
            if (this.lx.structure.mute.isOn()) {
                Arrays.fill(this.buffer.render.main, -16777216);
                Arrays.fill(this.buffer.render.cue, -16777216);
                Arrays.fill(this.buffer.render.aux, -16777216);
                continue;
            }
            if (!this.lx.structure.allWhite.isOn()) continue;
            Arrays.fill(this.buffer.render.main, -1);
            Arrays.fill(this.buffer.render.cue, -1);
            Arrays.fill(this.buffer.render.aux, -1);
        }
        boolean isNetworkMultithreaded = this.isNetworkMultithreaded.isOn();
        boolean bl = isDoubleBuffering = this.isThreaded() || isNetworkMultithreaded;
        if (isDoubleBuffering) {
            this.buffer.flip();
        }
        if (eulaAccepted && !this.output.restricted.isOn()) {
            if (isNetworkMultithreaded) {
                NetworkThread start = this.networkThread;
                synchronized (start) {
                    this.networkThread.notify();
                }
                this.profiler.outputNanos = 0L;
            } else {
                long outputStart = System.nanoTime();
                Frame sendFrame = isDoubleBuffering ? this.buffer.copy : this.buffer.render;
                int[] sendColors = this.lx.flags.sendCueToOutput && sendFrame.cueOn ? sendFrame.cue : sendFrame.main;
                this.output.send(sendColors);
                this.profiler.outputNanos = System.nanoTime() - outputStart;
            }
        } else {
            this.profiler.outputNanos = 0L;
        }
        this.profiler.runNanos = System.nanoTime() - runStart;
        if (this.logProfiler) {
            this._logProfiler();
            this.logProfiler = false;
        }
        if (this.lx.flags.autosave && this.nowMillis - this.autoSaveMillis > this.lx.flags.autosaveIntervalMs) {
            if (this.lx.command.isDirty(this.autoSaveMillis)) {
                this.lx.autoSaveProject();
            }
            this.autoSaveMillis = this.nowMillis;
        }
    }

    private void _logProfiler() {
        StringBuilder sb = new StringBuilder();
        sb.append("LXEngine::run() " + (int)(this.profiler.runNanos / 1000000L) + "ms\n");
        sb.append("LXEngine::run()::channels " + (int)(this.profiler.channelNanos / 1000000L) + "ms\n");
        for (LXAbstractChannel channel : this.mixer.channels) {
            sb.append("LXEngine::" + channel.getLabel() + "::loop() " + (int)(channel.profiler.loopNanos / 1000000L) + "ms\n");
            if (!(channel instanceof LXChannel)) continue;
            LXPattern pattern = ((LXChannel)channel).getActivePattern();
            sb.append("LXEngine::" + channel.getLabel() + "::" + pattern.getLabel() + "::run() " + (int)(pattern.profiler.runNanos / 1000000L) + "ms\n");
        }
        LX.log(sb.toString());
    }

    public void copyFrameThreadSafe(Frame frame) {
        this.buffer.copyTo(frame);
    }

    public void getFrameNonThreadSafe(Frame frame) {
        frame.copyFrom(this.buffer.render);
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        if (path.equals(PATH_FRAMERATE)) {
            this.osc.sendMessage(this.getOscAddress() + "/framerate", this.actualFrameRate);
            return true;
        }
        if (path.equals(PATH_OPEN_PROJECT)) {
            String fileName = message.getString();
            File projectFile = this.lx.getMediaFile(LX.Media.PROJECTS, fileName);
            if (!projectFile.exists()) {
                LXOscEngine.error("Requested non-existent project file: " + String.valueOf(projectFile));
                return false;
            }
            if (projectFile.equals(this.lx.getProject())) {
                LXOscEngine.log("Requested project file is already open, ignoring: " + String.valueOf(projectFile));
                return false;
            }
            try {
                LXOscEngine.log("Opening project file: " + String.valueOf(projectFile));
                this.lx.openProject(projectFile);
                return true;
            }
            catch (Throwable x) {
                LXOscEngine.error(x, "Error opening project \"" + String.valueOf(projectFile) + "\": " + x.getMessage());
                return false;
            }
        }
        return super.handleOscMessage(message, parts, index);
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.output.enabled.setValue(false);
        this.snapshots.clear();
        this.modulation.setFlagLoadModulations(false);
        this.modulation.clear();
        this.mixer.clear();
        super.load(lx, obj);
        if (obj.has("children")) {
            JsonObject children = obj.getAsJsonObject("children");
            if (children.has(KEY_MODULATION)) {
                this.modulation.loadModulations(lx, children.getAsJsonObject(KEY_MODULATION));
            }
            if (children.has(KEY_MIDI)) {
                this.midi.loadMappings(lx, children.getAsJsonObject(KEY_MIDI));
            }
        }
        switch (lx.flags.outputMode) {
            case ACTIVE: {
                this.output.enabled.setValue(true);
                break;
            }
            case INACTIVE: {
                this.output.enabled.setValue(false);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.midi.disposeSurfaces();
        this.snapshots.clear();
        this.modulation.clear();
        this.mixer.clear();
        this.lx.registry.disposePlugins();
        LX.dispose(this.clips);
        LX.dispose(this.modulation);
        LX.dispose(this.mixer);
        LX.dispose(this.audio);
        LX.dispose(this.midi);
        LX.dispose(this.osc);
        LX.dispose(this.dmx);
        LX.dispose(this.tempo);
        NetworkThread networkThread = this.networkThread;
        synchronized (networkThread) {
            this.networkThread.interrupt();
        }
        super.dispose();
    }

    static /* synthetic */ void access$0(LXEngine lXEngine) {
        lXEngine.processInputEvents();
    }

    public static interface Dispatch {
        public void dispatch();
    }

    class DoubleBuffer {
        Frame render;
        Frame copy;

        DoubleBuffer(LX lx) {
            this.render = new Frame(lx);
            this.copy = new Frame(lx);
        }

        synchronized void sync() {
            this.copy.copyFrom(this.render);
        }

        synchronized void flip() {
            Frame tmp = this.render;
            this.render = this.copy;
            this.copy = tmp;
        }

        synchronized void copyTo(Frame that) {
            that.copyFrom(this.copy);
        }
    }

    private class EngineSampler {
        private long cpuTimeNanos = 0L;
        private long lastSampleNanos = -1L;
        private int sampleCount = 0;

        private EngineSampler() {
        }

        private void reset(long sampleTime) {
            this.cpuTimeNanos = 0L;
            this.sampleCount = 0;
            this.lastSampleNanos = sampleTime;
        }

        private void sample(long loopStart, long loopEnd) {
            this.cpuTimeNanos += loopEnd - loopStart;
            ++this.sampleCount;
            if (loopEnd - this.lastSampleNanos > 500L * NANOS_PER_MS) {
                LXEngine.this.cpuLoad = (float)this.cpuTimeNanos * LXEngine.this.framesPerSecond.getValuef() / (float)NANOS_PER_SECOND / (float)this.sampleCount;
                LXEngine.this.actualFrameRate = NANOS_PER_SECOND * (long)this.sampleCount / (loopEnd - this.lastSampleNanos);
                this.reset(loopEnd);
            }
        }
    }

    private class EngineThread
    extends Thread {
        public static final String THREAD_NAME = "LXEngine Core Thread";
        private final long SLEEP_PRECISION;
        private final long SPIN_YIELD_PRECISION;

        private EngineThread() {
            super(THREAD_NAME);
            this.SLEEP_PRECISION = TimeUnit.MILLISECONDS.toNanos(2L);
            this.SPIN_YIELD_PRECISION = TimeUnit.MILLISECONDS.toNanos(1L);
            this.setPriority(LXEngine.this.lx.flags.engineThreadPriority);
        }

        @Override
        public void run() {
            LX.log(this.getName() + " starting.");
            long nanosUntilInput = 0L;
            long nanosUntilRender = 0L;
            long minWait = 0L;
            long loopEnd = System.nanoTime();
            boolean didInput = false;
            boolean didRender = false;
            boolean didSleep = false;
            LXEngine.this.sampler.reset(loopEnd);
            while (!this.isInterrupted()) {
                long loopNanos;
                long loopStart = System.nanoTime();
                if (loopStart < loopEnd) {
                    LX.error("EngineThread detected negative System.nanoTime() change between iterations");
                    LXEngine.this.sampler.reset(loopStart);
                    nanosUntilInput = 0L;
                    nanosUntilRender = 0L;
                } else if (didSleep) {
                    long sleepNanos = loopStart - loopEnd;
                    nanosUntilInput -= sleepNanos;
                    nanosUntilRender -= sleepNanos;
                }
                if (didInput = nanosUntilInput <= 0L) {
                    LXEngine.this.processInputEvents();
                }
                if (didRender = nanosUntilRender <= 0L) {
                    LXEngine.this.run(true);
                }
                if ((loopEnd = System.nanoTime()) < loopStart) {
                    LX.error("EngineThread detected system time change during run");
                    loopStart = loopEnd - NANOS_PER_MS;
                    LXEngine.this.sampler.reset(loopEnd);
                }
                if (didInput) {
                    nanosUntilInput = NANOS_INTERVAL_60FPS;
                }
                if (didRender) {
                    nanosUntilRender = (long)((double)NANOS_PER_SECOND / LXEngine.this.framesPerSecond.getValue());
                    LXEngine.this.sampler.sample(loopStart, loopEnd);
                }
                if (!(didSleep = (minWait = Math.min(nanosUntilInput -= (loopNanos = loopEnd - loopStart), nanosUntilRender -= loopNanos)) > 0L)) continue;
                try {
                    if (LXEngine.this.lx.flags.threadMode == ThreadMode.BASIC_THREAD_SPINYIELD) {
                        this.sleepNanos(minWait);
                        continue;
                    }
                    Thread.sleep(minWait / NANOS_PER_MS, (int)(minWait % NANOS_PER_MS));
                }
                catch (InterruptedException ix) {
                    break;
                }
            }
            LX.log(this.getName() + " stopped.");
        }

        private void sleepNanos(long nanoDuration) throws InterruptedException {
            long end = System.nanoTime() + nanoDuration;
            long timeLeft = nanoDuration;
            do {
                if (timeLeft > this.SLEEP_PRECISION) {
                    Thread.sleep(1L);
                } else if (timeLeft > this.SPIN_YIELD_PRECISION) {
                    Thread.yield();
                }
                timeLeft = end - System.nanoTime();
                if (!this.isInterrupted()) continue;
                throw new InterruptedException();
            } while (timeLeft > 0L);
        }
    }

    private class ExecutorService {
        private ScheduledExecutorService service = null;
        private ScheduledFuture<?> inputFuture = null;
        private ScheduledFuture<?> runFuture = null;

        private ExecutorService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            LXEngine.this.sampler.reset(-1L);
            this.service = Executors.newSingleThreadScheduledExecutor();
            Bootstrap bootstrap = new Bootstrap();
            this.service.execute(() -> {
                LXEngine.this.engineThread = Thread.currentThread();
                LXEngine.this.engineThread.setName("LXEngine Core Thread");
                LXEngine.this.engineThread.setPriority(LXEngine.this.lx.flags.engineThreadPriority);
                LX.log("LXEngine.ExecutorService starting...");
                Bootstrap bootstrap2 = bootstrap;
                synchronized (bootstrap2) {
                    bootstrap.bootstrap = true;
                    bootstrap.notify();
                }
            });
            this.inputFuture = this.service.scheduleAtFixedRate(() -> LXEngine.access$0(LXEngine.this), 0L, NANOS_INTERVAL_60FPS, TimeUnit.NANOSECONDS);
            this.runFuture = this.service.scheduleAtFixedRate(this::runLoop, 0L, (long)((double)NANOS_PER_SECOND / LXEngine.this.framesPerSecond.getValue()), TimeUnit.NANOSECONDS);
            Bootstrap bootstrap2 = bootstrap;
            synchronized (bootstrap2) {
                if (!bootstrap.bootstrap) {
                    try {
                        bootstrap.wait();
                    }
                    catch (InterruptedException ix) {
                        throw new IllegalThreadStateException("Interrupted waiting for ExecutorService to bootstrap");
                    }
                }
            }
        }

        private void stop() {
            this.inputFuture.cancel(false);
            this.runFuture.cancel(false);
            this.service.shutdown();
            try {
                this.service.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new IllegalThreadStateException("Interrupted waiting for ExecutorService to terminate");
            }
            LX.log("LXEngine.ExecutorService has finished.");
            this.service = null;
            this.inputFuture = null;
            this.runFuture = null;
        }

        private void updateFramerate() {
            if (this.service != null) {
                this.runFuture.cancel(false);
                this.runFuture = this.service.scheduleAtFixedRate(this::runLoop, 0L, (long)((double)NANOS_PER_SECOND / LXEngine.this.framesPerSecond.getValue()), TimeUnit.NANOSECONDS);
            }
        }

        private void runLoop() {
            long loopStart = System.nanoTime();
            if (LXEngine.this.sampler.lastSampleNanos < 0L) {
                LXEngine.this.sampler.reset(loopStart);
            }
            LXEngine.this.run(true);
            long loopEnd = System.nanoTime();
            if (loopEnd < loopStart) {
                LX.error("LXEngine.ExecutorService detected system time change during run");
                loopStart = loopEnd - NANOS_PER_MS;
                LXEngine.this.sampler.reset(loopEnd);
            }
            LXEngine.this.sampler.sample(loopStart, loopEnd);
        }

        private class Bootstrap {
            boolean bootstrap = false;

            private Bootstrap() {
            }
        }
    }

    public static class Frame
    implements LXBuffer {
        private LXModel model;
        private int[] main = null;
        private int[] cue = null;
        private int[] aux = null;
        private boolean cueOn = false;
        private boolean auxOn = false;

        public Frame(LX lx) {
            this.setModel(lx.getModel());
        }

        public void setModel(LXModel model) {
            this.model = model;
            if (this.main == null || this.main.length != model.size) {
                this.main = new int[model.size];
                this.cue = new int[model.size];
                this.aux = new int[model.size];
            }
        }

        public void setCueOn(boolean cueOn) {
            this.cueOn = cueOn;
        }

        public void setAuxOn(boolean auxOn) {
            this.auxOn = auxOn;
        }

        public void copyFrom(Frame that) {
            this.setModel(that.model);
            this.cueOn = that.cueOn;
            this.auxOn = that.auxOn;
            System.arraycopy(that.main, 0, this.main, 0, this.main.length);
            System.arraycopy(that.cue, 0, this.cue, 0, this.cue.length);
            System.arraycopy(that.aux, 0, this.aux, 0, this.aux.length);
        }

        public int[] getColors(boolean aux) {
            return aux ? this.getAuxColors() : this.getColors();
        }

        public int[] getColors() {
            return this.cueOn ? this.cue : this.main;
        }

        public int[] getAuxColors() {
            return this.auxOn ? this.aux : this.main;
        }

        public LXModel getModel() {
            return this.model;
        }

        @Override
        public int[] getArray() {
            return this.main;
        }

        public int[] getMain() {
            return this.main;
        }

        public int[] getCue() {
            return this.cue;
        }

        public int[] getAux() {
            return this.aux;
        }
    }

    public class NetworkThread
    extends Thread {
        private long lastFrame;
        private float actualFrameRate;
        public final Profiler timer;
        private final Frame networkFrame;

        NetworkThread(LX lx) {
            super("LXEngine Network Thread");
            this.lastFrame = System.currentTimeMillis();
            this.actualFrameRate = 0.0f;
            this.timer = new Profiler();
            this.networkFrame = new Frame(lx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LXOutput.log("LXEngine Network Thread started");
            while (!this.isInterrupted()) {
                try {
                    NetworkThread networkThread = this;
                    synchronized (networkThread) {
                        this.wait();
                    }
                }
                catch (InterruptedException ix) {
                    break;
                }
                if (LXEngine.this.output.enabled.isOn()) {
                    long copyStart = System.nanoTime();
                    DoubleBuffer doubleBuffer = LXEngine.this.buffer;
                    synchronized (doubleBuffer) {
                        this.networkFrame.copyFrom(LXEngine.this.buffer.copy);
                    }
                    long copyEnd = System.nanoTime();
                    this.timer.copyNanos = copyEnd - copyStart;
                    try {
                        LXEngine.this.output.send(this.networkFrame.main);
                    }
                    catch (Throwable x) {
                        LX.error(x, "Error in network thread: " + x.getLocalizedMessage());
                    }
                    this.timer.sendNanos = System.nanoTime() - copyEnd;
                }
                long now = System.currentTimeMillis();
                this.actualFrameRate = 1000.0f / (float)(now - this.lastFrame);
                this.lastFrame = now;
            }
            LXOutput.log("LXEngine Network Thread finished");
        }

        public float frameRate() {
            return this.actualFrameRate;
        }

        public class Profiler {
            public long copyNanos = 0L;
            public long sendNanos = 0L;
        }
    }

    public class Output
    extends LXOutputGroup
    implements LXOscComponent {
        public final BooleanParameter restricted;

        Output(LX lx) {
            super(lx);
            this.restricted = new BooleanParameter("Restricted", false).setDescription("Whether output is disabled due to license restrictions");
            this.gammaMode.setValue((Object)LXOutput.GammaMode.DIRECT);
            try {
                this.addChild(new ModelOutput(lx));
            }
            catch (SocketException sx) {
                lx.pushError(sx, "Serious network error, could not create output socket. Program will continue with no network output.\n" + sx.getLocalizedMessage());
                LXOutput.error("Could not create output datagram socket, model will not be able to send");
            }
            this.restricted.addListener(p -> {
                if (this.restricted.isOn()) {
                    LXOutput.error("Network output is disabled due to license restrictions.");
                } else {
                    LXOutput.log("Network output restored.");
                }
            });
        }

        @Override
        public LXOutput send(int[] colors) {
            if (!this.restricted.isOn()) {
                super.send(colors, this.lx.engine.mixer.masterBus.getOutputBrightness());
            }
            return this;
        }

        private class ModelOutput
        extends LXOutputGroup
        implements LX.Listener {
            ModelOutput(LX lx) throws SocketException {
                super(lx);
                this.setModel(lx.model);
                lx.addListener(this);
            }

            @Override
            public void modelChanged(LX lx, LXModel model) {
                this.setModel(model);
            }

            private void setModel(LXModel model) {
                this.clearChildren();
                if (model != null) {
                    this.addOutputs(model);
                }
            }

            private void addOutputs(LXModel model) {
                LXModel[] lXModelArray = model.children;
                int n = model.children.length;
                int n2 = 0;
                while (n2 < n) {
                    LXModel child = lXModelArray[n2];
                    this.addOutputs(child);
                    ++n2;
                }
                for (LXOutput output : model.outputs) {
                    this.addChild(output);
                }
            }
        }
    }

    public class Profiler {
        public long runNanos = 0L;
        public long channelNanos = 0L;
        public long inputNanos = 0L;
        public long midiNanos = 0L;
        public long oscNanos = 0L;
        public long outputNanos = 0L;
    }

    public static enum ThreadMode {
        SCHEDULED_EXECUTOR_SERVICE,
        BASIC_THREAD_SLEEP,
        BASIC_THREAD_SPINYIELD;

    }

    public class Timer
    implements LXLoopTask {
        private double elapsedMs = 0.0;
        private final double timerMs;
        public final boolean isInterval;
        private final Runnable runnable;

        private Timer(double timerMs, Runnable runnable, boolean isInterval) {
            if (timerMs <= 0.0 || !Double.isFinite(timerMs)) {
                throw new IllegalArgumentException("Timer must have a finite positive value: " + timerMs);
            }
            this.timerMs = timerMs;
            this.runnable = runnable;
            this.isInterval = isInterval;
        }

        public void cancel() {
            LXEngine.this.removeLoopTask(this);
        }

        public void reset() {
            this.elapsedMs = 0.0;
        }

        @Override
        public void loop(double deltaMs) {
            this.elapsedMs += deltaMs;
            while (this.elapsedMs >= this.timerMs) {
                this.runnable.run();
                if (!this.isInterval) {
                    this.cancel();
                    return;
                }
                this.elapsedMs -= this.timerMs;
            }
        }
    }
}

