/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import heronarts.lx.LX;
import heronarts.lx.LXBuffer;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.LXLayer;
import heronarts.lx.LXLoopTask;
import heronarts.lx.LXModelComponent;
import heronarts.lx.color.LXColor;
import heronarts.lx.color.LXPalette;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class LXLayeredComponent
extends LXModelComponent
implements LXLoopTask {
    private LXBuffer buffer = null;
    protected int[] colors = null;
    private final List<LXLayer> mutableLayers = new ArrayList<LXLayer>();
    public final List<LXLayer> layers = Collections.unmodifiableList(this.mutableLayers);
    private final List<LXLayer> addLayers = new ArrayList<LXLayer>();
    private final List<LXLayer> removeLayers = new ArrayList<LXLayer>();
    protected final LXPalette palette;
    private LXLayer loopingLayer = null;

    protected LXLayeredComponent(LX lx) {
        this(lx, null, null);
    }

    protected LXLayeredComponent(LX lx, String label) {
        this(lx, label, null);
    }

    protected LXLayeredComponent(LX lx, LXDeviceComponent component) {
        this(lx, null, component.getBuffer());
    }

    protected LXLayeredComponent(LX lx, LXBuffer buffer) {
        this(lx, null, buffer);
    }

    protected LXLayeredComponent(LX lx, String label, LXBuffer buffer) {
        super(lx, label);
        this.palette = lx.engine.palette;
        if (buffer != null) {
            this.buffer = buffer;
            this.colors = buffer.getArray();
        }
        this.addArray("layer", this.layers);
    }

    protected LXBuffer getBuffer() {
        return this.buffer;
    }

    public int[] getColors() {
        return this.getBuffer().getArray();
    }

    protected LXLayeredComponent setBuffer(LXDeviceComponent component) {
        return this.setBuffer(component.getBuffer());
    }

    public LXLayeredComponent setBuffer(LXBuffer buffer) {
        this.buffer = buffer;
        this.colors = buffer.getArray();
        return this;
    }

    @Override
    public void loop(double deltaMs) {
        long loopStart = System.nanoTime();
        this.colors = this.buffer.getArray();
        super.loop(deltaMs);
        this.onLoop(deltaMs);
        try {
            Iterator<LXLayer> iterator = this.mutableLayers.iterator();
            while (iterator.hasNext()) {
                LXLayer layer2;
                this.loopingLayer = layer2 = iterator.next();
                layer2.setBuffer(this.buffer);
                layer2.setModel(this.model);
                layer2.loop(deltaMs);
            }
            this.loopingLayer = null;
        }
        catch (Throwable x) {
            this.loopingLayer = null;
            throw x;
        }
        if (!this.addLayers.isEmpty()) {
            this.addLayers.forEach(layer -> {
                LXLayer lXLayer = this.addLayer((LXLayer)layer);
            });
            this.addLayers.clear();
        }
        if (!this.removeLayers.isEmpty()) {
            this.removeLayers.forEach(layer -> {
                LXLayer lXLayer = this.removeLayer((LXLayer)layer);
            });
            this.removeLayers.clear();
        }
        this.afterLayers(deltaMs);
        this.applyEffects(deltaMs);
        this.profiler.loopNanos = System.nanoTime() - loopStart;
    }

    protected void onLoop(double deltaMs) {
    }

    protected void afterLayers(double deltaMs) {
    }

    protected void applyEffects(double deltaMs) {
    }

    private void checkForReentrancy(LXLayer target, String operation) {
        if (this.loopingLayer != null) {
            throw new IllegalStateException("LXLayeredComponent may not modify layers while looping, component: " + this.toString() + " looping: " + this.loopingLayer.toString(this) + " " + operation + ": " + (target != null ? target.toString() : "null"));
        }
    }

    private void _reindexLayers() {
        int i = 0;
        for (LXLayer layer : this.layers) {
            layer.setIndex(i++);
        }
    }

    protected final LXLayer addLayer(LXLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("Cannot add null layer");
        }
        if (this.mutableLayers.contains(layer)) {
            throw new IllegalStateException("Cannot add layer twice: " + String.valueOf(this) + " " + String.valueOf(layer));
        }
        if (this.loopingLayer != null) {
            this.addLayers.add(layer);
            return layer;
        }
        layer.setParent(this);
        this.mutableLayers.add(layer);
        this._reindexLayers();
        return layer;
    }

    protected final LXLayer removeLayer(LXLayer layer) {
        if (!this.layers.contains(layer)) {
            throw new IllegalStateException("Cannot remove layer not in component: " + String.valueOf(layer));
        }
        if (this.loopingLayer != null) {
            this.removeLayers.add(layer);
            return layer;
        }
        this.mutableLayers.remove(layer);
        this._reindexLayers();
        LX.dispose(layer);
        return layer;
    }

    public final List<LXLayer> getLayers() {
        return this.layers;
    }

    @Override
    public void dispose() {
        this.checkForReentrancy(null, "dispose");
        for (LXLayer layer : this.mutableLayers) {
            LX.dispose(layer);
        }
        this.mutableLayers.clear();
        this.addLayers.clear();
        this.removeLayers.clear();
        super.dispose();
    }

    protected int getColor(int i) {
        return this.colors[i];
    }

    protected int getColor(LXPoint p) {
        return this.colors[p.index];
    }

    protected final LXLayeredComponent setColor(int i, int c) {
        this.colors[i] = c;
        return this;
    }

    protected final LXLayeredComponent setColor(LXPoint p, int c) {
        this.colors[p.index] = c;
        return this;
    }

    protected final LXLayeredComponent blendColor(int i, int c, LXColor.Blend blendMode) {
        this.colors[i] = LXColor.blend(this.colors[i], c, blendMode);
        return this;
    }

    protected final LXLayeredComponent blendColor(LXModel model, int c, LXColor.Blend blendMode) {
        LXPoint[] lXPointArray = model.points;
        int n = model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            this.colors[p.index] = LXColor.blend(this.colors[p.index], c, blendMode);
            ++n2;
        }
        return this;
    }

    protected final LXLayeredComponent addColor(int i, int c) {
        this.colors[i] = LXColor.add(this.colors[i], c);
        return this;
    }

    protected final LXLayeredComponent addColor(LXModel model, int c) {
        LXPoint[] lXPointArray = model.points;
        int n = model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            this.colors[p.index] = LXColor.add(this.colors[p.index], c);
            ++n2;
        }
        return this;
    }

    protected final LXLayeredComponent subtractColor(int i, int c) {
        this.colors[i] = LXColor.subtract(this.colors[i], c);
        return this;
    }

    protected final LXLayeredComponent setColors(int c) {
        LXPoint[] lXPointArray = this.model.points;
        int n = this.model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            this.colors[p.index] = c;
            ++n2;
        }
        return this;
    }

    protected final LXLayeredComponent setColor(LXModel model, int c) {
        LXPoint[] lXPointArray = model.points;
        int n = model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            this.colors[p.index] = c;
            ++n2;
        }
        return this;
    }

    protected final LXLayeredComponent clearColors() {
        return this.setColors(0);
    }
}

