/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXLoopTask;
import heronarts.lx.modulator.LXModulator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class LXModulatorComponent
extends LXComponent
implements LXLoopTask {
    private final List<LXModulator> mutableModulators = new ArrayList<LXModulator>();
    public final List<LXModulator> modulators = Collections.unmodifiableList(this.mutableModulators);
    public final Profiler profiler = this.constructProfiler();
    private LXModulator loopingModulator = null;

    protected Profiler constructProfiler() {
        return new Profiler();
    }

    protected LXModulatorComponent(LX lx) {
        this(lx, null);
    }

    protected LXModulatorComponent(LX lx, String label) {
        super(lx, label);
        this.addArray("modulator", this.modulators);
    }

    private void _addModulator(LXModulator modulator, int index) {
        Objects.requireNonNull(modulator, "May not add null LXModulator: " + String.valueOf(modulator));
        if (index > this.mutableModulators.size()) {
            throw new IllegalArgumentException("Invalid modulator index: " + index);
        }
        if (index < 0) {
            index = this.mutableModulators.size();
        }
        this.checkForReentrancy(modulator, "add");
        if (this.mutableModulators.contains(modulator)) {
            throw new IllegalStateException("Cannot add modulator twice: " + String.valueOf(modulator));
        }
        modulator.setIndex(index);
        this.mutableModulators.add(index, modulator);
        this._reindexModulators();
    }

    private void _reindexModulators() {
        int i = 0;
        for (LXModulator modulator : this.modulators) {
            modulator.setIndex(i++);
        }
    }

    public <T extends LXModulator> T addModulator(String path, T modulator) {
        this._addModulator(modulator, -1);
        this.addChild(path, modulator);
        return modulator;
    }

    public final <T extends LXModulator> T addModulator(T modulator) {
        return this.addModulator(modulator, -1);
    }

    public final <T extends LXModulator> T addModulator(T modulator, JsonObject modulatorObj) {
        return this.addModulator(modulator, -1, modulatorObj);
    }

    public final <T extends LXModulator> T addModulator(T modulator, int index) {
        return this.addModulator(modulator, index, null);
    }

    public <T extends LXModulator> T addModulator(T modulator, int index, JsonObject modulatorObj) {
        this._addModulator(modulator, index);
        modulator.setParent(this);
        if (modulatorObj != null) {
            modulator.load(this.lx, modulatorObj);
        }
        return modulator;
    }

    public <T extends LXModulator> T moveModulator(T modulator, int index) {
        if (!this.modulators.contains(modulator)) {
            throw new IllegalArgumentException("Cannot move modulator not in component: " + String.valueOf(modulator));
        }
        this.mutableModulators.remove(modulator);
        this.mutableModulators.add(index, modulator);
        this._reindexModulators();
        return modulator;
    }

    public final <T extends LXModulator> T startModulator(T modulator) {
        this.addModulator(modulator).start();
        return modulator;
    }

    public <T extends LXModulator> T removeModulator(T modulator) {
        this.checkForReentrancy(modulator, "remove");
        this.mutableModulators.remove(modulator);
        LX.dispose(modulator);
        this._reindexModulators();
        return modulator;
    }

    public LXModulator getModulator(String label) {
        for (LXModulator modulator : this.modulators) {
            if (!modulator.getLabel().equals(label)) continue;
            return modulator;
        }
        return null;
    }

    public List<LXModulator> getModulators() {
        return this.modulators;
    }

    @Override
    public void dispose() {
        this.checkForReentrancy(null, "dispose");
        for (LXModulator modulator : this.mutableModulators) {
            LX.dispose(modulator);
        }
        this.mutableModulators.clear();
        super.dispose();
    }

    private void checkForReentrancy(LXModulator target, String operation) {
        if (this.loopingModulator != null) {
            throw new IllegalStateException("LXModulatorComponent may not modify modulators while looping, component: " + this.toString() + " looping: " + this.loopingModulator.toString(this) + " " + operation + ": " + (target != null ? target.toString() : "null"));
        }
    }

    @Override
    public void loop(double deltaMs) {
        Iterator<LXModulator> iterator = this.mutableModulators.iterator();
        while (iterator.hasNext()) {
            LXModulator modulator;
            this.loopingModulator = modulator = iterator.next();
            modulator.loop(deltaMs);
        }
        this.loopingModulator = null;
    }

    public class Profiler {
        public long loopNanos;

        public long renderNanos() {
            return this.loopNanos;
        }
    }
}

