/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXEngine;
import heronarts.lx.parameter.LXParameter;

public interface LXPath {
    public static final String ROOT = "lx";
    public static final String ROOT_PREFIX = "/lx/";
    public static final String ROOT_SLASH = "lx/";
    public static final String DEFAULT_SEPARATOR = " \u2022 ";

    public String getPath();

    public String getLabel();

    public String getDescription();

    public LXComponent getParent();

    default public boolean isDescendant(LXComponent root) {
        LXComponent parent = this.getParent();
        while (parent != null) {
            if (parent == root) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    default public String getCanonicalPath(LXComponent root) {
        String pathStr = "/" + this.getPath();
        LXComponent parent = this.getParent();
        while (parent != null && parent != root) {
            pathStr = "/" + parent.getPath() + pathStr;
            parent = parent.getParent();
        }
        return pathStr;
    }

    default public String getCanonicalPath() {
        return this.getCanonicalPath(null);
    }

    default public String getCanonicalLabel() {
        return this.getCanonicalLabel(null);
    }

    default public String getCanonicalLabel(LXComponent root) {
        return this.getCanonicalLabel(root, DEFAULT_SEPARATOR);
    }

    default public String getCanonicalLabel(LXComponent root, String separator) {
        Object label = this.getLabel();
        LXComponent parent = this.getParent();
        while (parent != null && parent != root && !(parent instanceof LXEngine)) {
            label = parent.getLabel() + separator + (String)label;
            parent = parent.getParent();
        }
        return label;
    }

    default public String getCanonicalLabel(LXComponent root, int limit) {
        return this.getCanonicalLabel(root, DEFAULT_SEPARATOR, limit);
    }

    default public String getCanonicalLabel(LXComponent root, String separator, int limit) {
        Object label = this.getLabel();
        LXComponent parent = this.getParent();
        int count = 1;
        while (parent != null && parent != root && !(parent instanceof LXEngine) && count++ < limit) {
            label = parent.getLabel() + separator + (String)label;
            parent = parent.getParent();
        }
        return label;
    }

    public static LXPath get(LX lx, String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.equals(ROOT)) {
            return lx.engine;
        }
        if (path.startsWith(ROOT_SLASH)) {
            path = path.substring(3);
            String[] parts = path.split("/");
            return lx.engine.path(parts, 0);
        }
        return null;
    }

    public static LXComponent getComponent(LX lx, String path) {
        LXPath component = LXPath.get(lx, path);
        if (component instanceof LXComponent) {
            return (LXComponent)component;
        }
        return null;
    }

    public static LXParameter getParameter(LX lx, String path) {
        LXPath parameter = LXPath.get(lx, path);
        if (parameter instanceof LXParameter) {
            return (LXParameter)parameter;
        }
        return null;
    }

    public static LXPath get(LXComponent root, String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return root.path(path.split("/"), 0);
    }

    public static LXComponent getComponent(LXComponent root, String path) {
        LXPath component = LXPath.get(root, path);
        if (component instanceof LXComponent) {
            return (LXComponent)component;
        }
        return null;
    }

    public static LXParameter getParameter(LXComponent root, String path) {
        LXPath parameter = LXPath.get(root, path);
        if (parameter instanceof LXParameter) {
            return (LXParameter)parameter;
        }
        return null;
    }
}

