/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import heronarts.lx.LX;
import heronarts.lx.LXRegistry;
import heronarts.lx.LXSerializable;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.StringParameter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class LXPreferences
implements LXSerializable,
LXParameterListener {
    private static final String PREFERENCES_FILE_NAME = ".lxpreferences";
    private static final String DEFAULT_PROJECT_FILE = "default.lxp";
    private final LX lx;
    private final File file;
    public final BooleanParameter eulaAccepted = new BooleanParameter("EULA Accepted", false).setDescription("Whether the EULA has been accepted");
    public final BooleanParameter focusChannelOnCue = new BooleanParameter("Focus On Cue", false).setDescription("Whether a channel should be automatically focused when its cue is set to active");
    public final BooleanParameter focusActivePattern = new BooleanParameter("Auto-Focus Pattern", false).setDescription("Whether a pattern should be automatically focused when it becomes active");
    public final BooleanParameter sendCueToOutput = new BooleanParameter("Cue applies to Live Output", false).setDescription("Whether Cue selection applies to live output, not just the preview window");
    public final DiscreteParameter uiZoom = new DiscreteParameter("UI Scale", 100, 50, 201).setDescription("Percentage by which the UI should be scaled").setUnits(LXParameter.Units.PERCENT).setMappable(false);
    public final BooleanParameter showHelpMessages = new BooleanParameter("Help Messages", true).setDescription("Whether to show contextual help messages in the status bar");
    public final BooleanParameter schedulerEnabled = new BooleanParameter("Project Scheduler Enabed", false).setDescription("Whether the project scheduler is enabled");
    public final BooleanParameter showCpuLoad = new BooleanParameter("Show CPU Load %").setDescription("Whether CPU load percentage is shown in toolbar");
    public final StringParameter uiTheme = new StringParameter("UI Theme", null).setDescription("Which UI theme is used");
    private String projectFileName = null;
    private String scheduleFileName = null;
    private int windowWidth = -1;
    private int windowHeight = -1;
    private int windowPosX = -1;
    private int windowPosY = -1;
    private boolean inLoad = false;
    private static final String KEY_VERSION = "version";
    private static final String KEY_EULA_ACCEPTED = "eulaAccepted";
    private static final String KEY_PROJECT_FILE_NAME = "projectFileName";
    private static final String KEY_SCHEDULE_FILE_NAME = "scheduleFileName";
    private static final String KEY_WINDOW_WIDTH = "windowWidth";
    private static final String KEY_WINDOW_WIDTH_LEGACY = "windwWidth";
    private static final String KEY_WINDOW_HEIGHT = "windowHeight";
    private static final String KEY_WINDOW_POS_X = "windowPosX";
    private static final String KEY_WINDOW_POS_Y = "windowPosY";
    private static final String KEY_UI_ZOOM = "uiZoom";
    private static final String KEY_UI_THEME = "uiTheme";
    private static final String KEY_FOCUS_CHANNEL_ON_CUE = "focusChannelOnCue";
    private static final String KEY_FOCUS_ACTIVE_PATTERN = "focusActivePattern";
    private static final String KEY_SEND_CUE_TO_OUTPUT = "sendCueToOutput";
    private static final String KEY_SHOW_HELP_MESSAGES = "showHelpMessages";
    private static final String KEY_SCHEDULER_ENABLED = "schedulerEnabled";
    private static final String KEY_SHOW_CPU_LOAD = "showCpuLoad";
    private static final String KEY_REGISTRY = "registry";

    protected LXPreferences(LX lx) {
        this.lx = lx;
        this.file = lx.getMediaFile(PREFERENCES_FILE_NAME);
        this.eulaAccepted.addListener(this);
        this.focusChannelOnCue.addListener(this);
        this.focusActivePattern.addListener(this);
        this.sendCueToOutput.addListener(this);
        this.uiZoom.addListener(this);
        this.uiTheme.addListener(this);
        this.showHelpMessages.addListener(this);
        this.schedulerEnabled.addListener(this);
        this.showCpuLoad.addListener(this);
        lx.registry.addListener(new LXRegistry.Listener(){

            @Override
            public void pluginChanged(LX lx, LXRegistry.Plugin plugin) {
                LXPreferences.this.save();
            }
        });
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        this.lx.flags.focusChannelOnCue = this.focusChannelOnCue.isOn();
        this.lx.flags.focusActivePattern = this.focusActivePattern.isOn();
        this.lx.flags.sendCueToOutput = this.sendCueToOutput.isOn();
        this.save();
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowSize(int windowWidth, int windowHeight) {
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
        this.save();
    }

    public void setWindowSize(int windowWidth, int windowHeight, int windowPosX, int windowPosY) {
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
        this.windowPosX = windowPosX;
        this.windowPosY = windowPosY;
        this.save();
    }

    public int getWindowPosX() {
        return this.windowPosX;
    }

    public int getWindowPosY() {
        return this.windowPosY;
    }

    public void setWindowPosition(int windowPosX, int windowPosY) {
        this.windowPosX = windowPosX;
        this.windowPosY = windowPosY;
        this.save();
    }

    protected void setProject(File project) {
        this.projectFileName = project != null ? this.lx.getMediaPath(LX.Media.PROJECTS, project) : null;
        this.save();
    }

    public void setSchedule(File schedule) {
        this.scheduleFileName = schedule != null ? this.lx.getMediaPath(LX.Media.PROJECTS, schedule) : null;
        this.save();
    }

    @Override
    public void save(LX lx, JsonObject object) {
        object.addProperty(KEY_VERSION, "1.1.0");
        if (this.projectFileName != null) {
            object.addProperty(KEY_PROJECT_FILE_NAME, this.projectFileName);
        }
        if (this.scheduleFileName != null) {
            object.addProperty(KEY_SCHEDULE_FILE_NAME, this.scheduleFileName);
        }
        object.addProperty(KEY_EULA_ACCEPTED, Boolean.valueOf(this.eulaAccepted.isOn()));
        object.addProperty(KEY_WINDOW_WIDTH, (Number)this.windowWidth);
        object.addProperty(KEY_WINDOW_HEIGHT, (Number)this.windowHeight);
        object.addProperty(KEY_WINDOW_POS_X, (Number)this.windowPosX);
        object.addProperty(KEY_WINDOW_POS_Y, (Number)this.windowPosY);
        object.addProperty(KEY_UI_ZOOM, (Number)this.uiZoom.getValuei());
        object.addProperty(KEY_UI_THEME, this.uiTheme.getString());
        object.addProperty(KEY_FOCUS_CHANNEL_ON_CUE, Boolean.valueOf(this.focusChannelOnCue.isOn()));
        object.addProperty(KEY_FOCUS_ACTIVE_PATTERN, Boolean.valueOf(this.focusActivePattern.isOn()));
        object.addProperty(KEY_SEND_CUE_TO_OUTPUT, Boolean.valueOf(this.sendCueToOutput.isOn()));
        object.addProperty(KEY_SHOW_HELP_MESSAGES, Boolean.valueOf(this.showHelpMessages.isOn()));
        object.addProperty(KEY_SCHEDULER_ENABLED, Boolean.valueOf(this.schedulerEnabled.isOn()));
        object.addProperty(KEY_SHOW_CPU_LOAD, Boolean.valueOf(this.showCpuLoad.isOn()));
        object.add(KEY_REGISTRY, (JsonElement)LXSerializable.Utils.toObject(this.lx, this.lx.registry));
    }

    @Override
    public void load(LX lx, JsonObject object) {
        LXSerializable.Utils.loadBoolean(this.eulaAccepted, object, KEY_EULA_ACCEPTED);
        LXSerializable.Utils.loadBoolean(this.focusChannelOnCue, object, KEY_FOCUS_CHANNEL_ON_CUE);
        LXSerializable.Utils.loadBoolean(this.focusActivePattern, object, KEY_FOCUS_ACTIVE_PATTERN);
        LXSerializable.Utils.loadBoolean(this.sendCueToOutput, object, KEY_SEND_CUE_TO_OUTPUT);
        LXSerializable.Utils.loadBoolean(this.showHelpMessages, object, KEY_SHOW_HELP_MESSAGES);
        LXSerializable.Utils.loadBoolean(this.schedulerEnabled, object, KEY_SCHEDULER_ENABLED);
        LXSerializable.Utils.loadBoolean(this.showCpuLoad, object, KEY_SHOW_CPU_LOAD);
        LXSerializable.Utils.loadInt(this.uiZoom, object, KEY_UI_ZOOM);
        LXSerializable.Utils.loadString(this.uiTheme, object, KEY_UI_THEME);
        if (object.has(KEY_WINDOW_WIDTH)) {
            this.windowWidth = object.get(KEY_WINDOW_WIDTH).getAsInt();
        } else if (object.has(KEY_WINDOW_WIDTH_LEGACY)) {
            this.windowWidth = object.get(KEY_WINDOW_WIDTH_LEGACY).getAsInt();
        }
        if (object.has(KEY_WINDOW_HEIGHT)) {
            this.windowHeight = object.get(KEY_WINDOW_HEIGHT).getAsInt();
        }
        if (object.has(KEY_WINDOW_POS_X)) {
            this.windowPosX = object.get(KEY_WINDOW_POS_X).getAsInt();
        }
        if (object.has(KEY_WINDOW_POS_Y)) {
            this.windowPosY = object.get(KEY_WINDOW_POS_Y).getAsInt();
        }
        this.projectFileName = object.has(KEY_PROJECT_FILE_NAME) ? object.get(KEY_PROJECT_FILE_NAME).getAsString() : null;
        this.scheduleFileName = object.has(KEY_SCHEDULE_FILE_NAME) ? object.get(KEY_SCHEDULE_FILE_NAME).getAsString() : null;
        LXSerializable.Utils.loadObject(this.lx, this.lx.registry, object, KEY_REGISTRY);
    }

    private void save() {
        if (this.inLoad) {
            return;
        }
        JsonObject obj = new JsonObject();
        this.save(this.lx, obj);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(this.file));){
                writer.setIndent("  ");
                new GsonBuilder().create().toJson((JsonElement)obj, writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iox) {
            LX.error(iox, "Exception writing the preferences file: " + String.valueOf(this.file));
        }
    }

    public void loadEULA() {
        this.inLoad = true;
        if (this.file.exists()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (FileReader fr = new FileReader(this.file);){
                    LXSerializable.Utils.loadBoolean(this.eulaAccepted, (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class), KEY_EULA_ACCEPTED);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception x) {
                LX.error(x, "Exception loading EULA state file: " + String.valueOf(this.file));
            }
        }
        this.inLoad = false;
    }

    public void load() {
        this.inLoad = true;
        if (this.file.exists()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (FileReader fr = new FileReader(this.file);){
                    this.load(this.lx, (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception x) {
                LX.error(x, "Exception loading preferences file: " + String.valueOf(this.file));
            }
        }
        this.inLoad = false;
    }

    public void loadInitialProject(File overrideProjectFile) {
        this.loadInitialProject(overrideProjectFile, null);
    }

    public void loadInitialProject(File overrideProjectFile, File fallbackProjectFile) {
        try {
            File projectFile = null;
            if (overrideProjectFile != null) {
                projectFile = overrideProjectFile;
                if (!projectFile.exists()) {
                    LX.error("Project file does not exist: " + String.valueOf(overrideProjectFile));
                    projectFile = null;
                }
            } else if (this.projectFileName != null && !(projectFile = this.lx.getMediaFile(LX.Media.PROJECTS, this.projectFileName)).exists()) {
                LX.error("Last saved project file no longer exists: " + this.projectFileName);
                projectFile = null;
            }
            if (projectFile == null) {
                if (fallbackProjectFile != null && fallbackProjectFile.exists()) {
                    projectFile = fallbackProjectFile;
                }
                if (projectFile == null) {
                    projectFile = this.lx.getMediaFile(LX.Media.PROJECTS, DEFAULT_PROJECT_FILE);
                }
            }
            if (projectFile.exists()) {
                LX.log("Opening project file: " + String.valueOf(projectFile));
                this.lx.openProject(projectFile);
            }
        }
        catch (Exception x) {
            LX.error(x, "Unhandled exception loading initial project");
        }
    }

    public void loadInitialSchedule() {
        if (this.scheduleFileName != null) {
            File scheduleFile = this.lx.getMediaFile(LX.Media.PROJECTS, this.scheduleFileName);
            if (!scheduleFile.exists()) {
                LX.error("Last saved schedule file no longer exists: " + this.scheduleFileName);
            } else {
                LX.log("Restoring schedule file: " + this.scheduleFileName);
                this.lx.scheduler.openSchedule(scheduleFile);
            }
        }
    }
}

