/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXLoopTask;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TriggerParameter;

public abstract class LXRunnableComponent
extends LXComponent
implements LXLoopTask {
    protected double runMs = 0.0;
    public final BooleanParameter running = new BooleanParameter("Running", false).setDescription("Sets whether the component is running");
    public final TriggerParameter trigger = new TriggerParameter("Trigger", this::_trigger).setDescription("Resets the cycle and starts running");

    protected LXRunnableComponent() {
        this(null, null);
    }

    protected LXRunnableComponent(String label) {
        this(null, label);
    }

    protected LXRunnableComponent(LX lx) {
        this(lx, null);
    }

    protected LXRunnableComponent(LX lx, String label) {
        super(lx, label);
        this.addParameter("running", this.running);
        this.addParameter("trigger", this.trigger);
    }

    @Override
    public void onParameterChanged(LXParameter parameter) {
        super.onParameterChanged(parameter);
        if (parameter == this.running) {
            if (this.running.isOn()) {
                this.onStart();
            } else {
                this.onStop();
            }
        }
    }

    private void _trigger() {
        this.onTrigger();
        this.onReset();
        this.start();
    }

    public final LXRunnableComponent toggle() {
        this.running.toggle();
        return this;
    }

    public final LXRunnableComponent start() {
        this.running.setValue(true);
        return this;
    }

    public final LXRunnableComponent stop() {
        this.running.setValue(false);
        return this;
    }

    public final boolean isRunning() {
        return this.running.isOn();
    }

    public final LXRunnableComponent trigger() {
        this.trigger.trigger();
        return this;
    }

    public final LXRunnableComponent reset() {
        this.stop();
        this.onReset();
        return this;
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    protected void onReset() {
    }

    protected void onTrigger() {
    }

    @Override
    public void loop(double deltaMs) {
        if (this.running.isOn()) {
            this.runMs += deltaMs;
            this.run(deltaMs);
        }
        this.postRun(deltaMs);
    }

    protected abstract void run(double var1);

    protected void postRun(double deltaMs) {
    }
}

