/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.IEnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface LXSerializable {
    public void save(LX var1, JsonObject var2);

    public void load(LX var1, JsonObject var2);

    public static class Utils {
        private static final String PATH_ENUM_NAME = "name";

        public static String getEnumNamePath(String path) {
            return path + "/name";
        }

        public static boolean hasParameter(JsonObject object, String parameter) {
            if (object.has("parameters")) {
                return object.get("parameters").getAsJsonObject().has(parameter);
            }
            return false;
        }

        public static JsonElement getParameter(JsonObject object, String parameter) {
            if (object.has("parameters")) {
                return object.get("parameters").getAsJsonObject().get(parameter);
            }
            return null;
        }

        public static JsonObject saveParameters(LXParameter.Collection parameters) {
            JsonObject obj = new JsonObject();
            Utils.saveParameters(obj, parameters);
            return obj;
        }

        public static void saveParameters(JsonObject obj, LXParameter.Collection parameters) {
            for (String path : parameters.keySet()) {
                LXParameter parameter = (LXParameter)parameters.get(path);
                if (parameter instanceof AggregateParameter) continue;
                Utils.saveParameter(parameter, obj, path);
            }
        }

        public static void saveParameter(LXParameter parameter, JsonObject obj) {
            Utils.saveParameter(parameter, obj, parameter.getPath());
        }

        public static void saveParameter(LXParameter parameter, JsonObject obj, String path) {
            if (parameter instanceof StringParameter) {
                obj.addProperty(path, ((StringParameter)parameter).getString());
            } else if (parameter instanceof BooleanParameter) {
                obj.addProperty(path, Boolean.valueOf(((BooleanParameter)parameter).isOn()));
            } else if (parameter instanceof IEnumParameter) {
                IEnumParameter enumParameter = (IEnumParameter)parameter;
                obj.addProperty(path, (Number)enumParameter.getBaseValuei());
                Object enumValue = enumParameter.getBaseEnum();
                if (enumValue != null) {
                    obj.addProperty(Utils.getEnumNamePath(path), ((Enum)enumValue).name());
                }
            } else if (parameter instanceof DiscreteParameter) {
                obj.addProperty(path, (Number)((DiscreteParameter)parameter).getBaseValuei());
            } else if (parameter instanceof ColorParameter) {
                obj.addProperty(path, (Number)((ColorParameter)parameter).getBaseColor());
            } else if (!(parameter instanceof FunctionalParameter)) {
                obj.addProperty(path, (Number)parameter.getBaseValue());
            }
        }

        public static void loadParameters(JsonObject obj, LXParameter.Collection parameters) {
            for (String path : parameters.keySet()) {
                LXParameter parameter = (LXParameter)parameters.get(path);
                if (parameter instanceof AggregateParameter) continue;
                Utils.loadParameter(parameter, obj, path);
            }
        }

        public static void loadParameter(LXParameter parameter, JsonObject obj, String path) {
            block16: {
                if (obj.has(path)) {
                    JsonElement value = obj.get(path);
                    try {
                        if (parameter instanceof FunctionalParameter) break block16;
                        if (parameter instanceof StringParameter) {
                            if (value instanceof JsonNull) {
                                ((StringParameter)parameter).setValue(null);
                            } else {
                                ((StringParameter)parameter).setValue(value.getAsString());
                            }
                            break block16;
                        }
                        if (parameter instanceof BooleanParameter) {
                            ((BooleanParameter)parameter).setValue(value.getAsBoolean());
                            break block16;
                        }
                        if (parameter instanceof IEnumParameter) {
                            IEnumParameter enumParameter = (IEnumParameter)parameter;
                            boolean fallbackInt = true;
                            String enumNamePath = Utils.getEnumNamePath(path);
                            if (obj.has(enumNamePath)) {
                                JsonElement nameElem = obj.get(enumNamePath);
                                try {
                                    enumParameter.setEnum(nameElem.getAsString());
                                    fallbackInt = false;
                                }
                                catch (Exception x) {
                                    LX.error(x, "Failed to load EnumParameter at path " + path + " by name: " + String.valueOf(nameElem));
                                }
                            }
                            if (fallbackInt) {
                                parameter.setValue(value.getAsInt());
                            }
                            break block16;
                        }
                        if (parameter instanceof DiscreteParameter) {
                            parameter.setValue(value.getAsInt());
                        } else if (parameter instanceof ColorParameter) {
                            ((ColorParameter)parameter).setColor(value.getAsInt());
                        } else {
                            parameter.setValue(value.getAsDouble());
                        }
                    }
                    catch (Exception x) {
                        LX.error(x, "Invalid format loading parameter " + String.valueOf(parameter) + " from JSON value: " + String.valueOf(value));
                    }
                }
            }
        }

        public static void loadInt(DiscreteParameter parameter, JsonObject object, String key) {
            if (object.has(key)) {
                parameter.setValue(object.get(key).getAsInt());
            }
        }

        public static void loadBoolean(BooleanParameter parameter, JsonObject object, String key) {
            if (object.has(key)) {
                parameter.setValue(object.get(key).getAsBoolean());
            }
        }

        public static void loadDouble(LXParameter parameter, JsonObject object, String key) {
            if (object.has(key)) {
                parameter.setValue(object.get(key).getAsDouble());
            }
        }

        public static void loadString(StringParameter parameter, JsonObject object, String key) {
            if (object.has(key)) {
                parameter.setValue(object.get(key).getAsString());
            }
        }

        public static void loadObject(LX lx, LXSerializable serializable, JsonObject object, String key) {
            Utils.loadObject(lx, serializable, object, key, false);
        }

        public static void loadObject(LX lx, LXSerializable serializable, JsonObject object, String key, boolean defaultEmptyObj) {
            if (object.has(key)) {
                serializable.load(lx, object.getAsJsonObject(key));
            } else if (defaultEmptyObj) {
                serializable.load(lx, new JsonObject());
            }
        }

        public static void resetObject(LX lx, LXSerializable serializable) {
            JsonObject reset = new JsonObject();
            reset.addProperty("_reset_", "_reset_");
            serializable.load(lx, reset);
        }

        public static void loadArray(LX lx, List<? extends LXSerializable> serializables, JsonObject object, String key) {
            if (object.has(key)) {
                JsonArray array = object.getAsJsonArray(key);
                int i = 0;
                while (i < array.size()) {
                    serializables.get(i).load(lx, array.get(i).getAsJsonObject());
                    ++i;
                }
            }
        }

        public static void loadArray(LX lx, LXSerializable[] serializables, JsonObject object, String key) {
            if (object.has(key)) {
                JsonArray array = object.getAsJsonArray(key);
                int i = 0;
                while (i < array.size()) {
                    serializables[i].load(lx, array.get(i).getAsJsonObject());
                    ++i;
                }
            }
        }

        public static JsonObject toObject(LXComponent component) {
            return Utils.toObject(component, false);
        }

        public static JsonObject toObject(LXComponent component, boolean stripIds) {
            return Utils.toObject(component.getLX(), component, stripIds);
        }

        public static JsonObject toObject(LX lx, LXSerializable serializable) {
            return Utils.toObject(lx, serializable, false);
        }

        public static JsonObject toObject(LX lx, LXSerializable serializable, boolean stripIds) {
            JsonObject obj = new JsonObject();
            serializable.save(lx, obj);
            if (stripIds) {
                Utils.stripIds(obj);
            }
            return obj;
        }

        public static JsonObject toObject(LX lx, Map<String, ? extends LXSerializable> serializables) {
            JsonObject map = new JsonObject();
            for (String key : serializables.keySet()) {
                JsonObject obj = new JsonObject();
                serializables.get(key).save(lx, obj);
                map.add(key, (JsonElement)obj);
            }
            return map;
        }

        public static JsonArray toArray(LX lx, LXSerializable[] serializables) {
            return Utils.toArray(lx, serializables, false);
        }

        public static JsonArray toArray(LX lx, LXSerializable[] serializables, boolean stripIds) {
            JsonArray arr = new JsonArray();
            LXSerializable[] lXSerializableArray = serializables;
            int n = serializables.length;
            int n2 = 0;
            while (n2 < n) {
                LXSerializable serializable = lXSerializableArray[n2];
                arr.add((JsonElement)Utils.toObject(lx, serializable, stripIds));
                ++n2;
            }
            return arr;
        }

        public static JsonArray toArray(LX lx, Collection<? extends LXSerializable> serializables) {
            return Utils.toArray(lx, serializables, false);
        }

        public static JsonArray toArray(LX lx, Collection<? extends LXSerializable> serializables, boolean stripIds) {
            JsonArray arr = new JsonArray();
            for (LXSerializable lXSerializable : serializables) {
                arr.add((JsonElement)Utils.toObject(lx, lXSerializable, stripIds));
            }
            return arr;
        }

        public static JsonObject stripIds(JsonObject object) {
            object.remove("id");
            for (Map.Entry entry : object.entrySet()) {
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonObject()) {
                    Utils.stripIds(value.getAsJsonObject());
                    continue;
                }
                if (!value.isJsonArray()) continue;
                for (JsonElement elem : value.getAsJsonArray()) {
                    if (!elem.isJsonObject()) continue;
                    Utils.stripIds(elem.getAsJsonObject());
                }
            }
            return object;
        }

        public static JsonObject stripParameter(JsonObject object, LXParameter parameter) {
            return Utils.stripParameter(object, parameter.getPath());
        }

        public static JsonObject stripParameter(JsonObject object, String parameter) {
            if (object.has("parameters")) {
                object.get("parameters").getAsJsonObject().remove(parameter);
            }
            return object;
        }
    }
}

