/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ADM
extends LXComponent {
    public static final int MAX_ADM_OBJECTS = 64;
    public final List<Obj> obj;
    public static final String ADM_OSC_PATH = "adm";
    public static final String ADM_OBJ_PATH = "obj";
    public static final String ADM_AZIM_PATH = "azim";
    public static final String ADM_ELEV_PATH = "elev";
    public static final String ADM_DIST_PATH = "dist";
    public static final String ADM_AED_PATH = "aed";
    public static final String ADM_X_PATH = "x";
    public static final String ADM_Y_PATH = "y";
    public static final String ADM_Z_PATH = "z";
    public static final String ADM_XYZ_PATH = "xyz";
    public static final String ADM_CONFIG_PATH = "config";
    public static final String ADM_CARTESIAN_PATH = "cartesian";

    public ADM(LX lx) {
        super(lx, "ADM");
        ArrayList<Obj> mutableObj = new ArrayList<Obj>(64);
        int i = 0;
        while (i < 64) {
            mutableObj.add(new Obj(lx, i + 1));
            ++i;
        }
        this.obj = Collections.unmodifiableList(mutableObj);
        this.addArray(ADM_OBJ_PATH, this.obj);
    }

    public boolean handleAdmOscMessage(OscMessage message, String[] parts, int index) {
        if (parts.length < 5) {
            LXOscEngine.error("ADM address pattern is incomplete: " + message.getAddressPattern().getValue());
            return false;
        }
        if (ADM_OBJ_PATH.equals(parts[2])) {
            try {
                int objIndex = Integer.parseInt(parts[3]);
                if (objIndex <= 0) {
                    throw new NumberFormatException("ADM OSC object index must be positive: " + message.getAddressPattern().getValue());
                }
                if (objIndex > 64) {
                    throw new NumberFormatException("ADM OSC object out of bounds: " + message.getAddressPattern().getValue());
                }
                Obj obj = this.obj.get(objIndex - 1);
                String field = parts[4];
                if (ADM_AED_PATH.equals(field)) {
                    obj.azimuth.setValue(message.getFloat(0));
                    obj.elevation.setValue(message.getFloat(1));
                    obj.distance.setValue(message.getFloat(2));
                } else if (ADM_AZIM_PATH.equals(field)) {
                    obj.azimuth.setValue(message.getFloat(0));
                } else if (ADM_ELEV_PATH.equals(field)) {
                    obj.elevation.setValue(message.getFloat(0));
                } else if (ADM_DIST_PATH.equals(field)) {
                    obj.distance.setValue(message.getFloat(0));
                } else if (ADM_XYZ_PATH.equals(field)) {
                    obj.x.setValue(message.getFloat(0));
                    obj.y.setValue(message.getFloat(1));
                    obj.z.setValue(message.getFloat(2));
                    obj.updatePolar();
                } else if (ADM_X_PATH.equals(field)) {
                    obj.x.setValue(message.getFloat(0));
                    obj.updatePolar();
                } else if (ADM_Y_PATH.equals(field)) {
                    obj.y.setValue(message.getFloat(0));
                    obj.updatePolar();
                } else if (ADM_Z_PATH.equals(field)) {
                    obj.z.setValue(message.getFloat(0));
                    obj.updatePolar();
                } else if (ADM_CONFIG_PATH.equals(field) && ADM_CARTESIAN_PATH.equals(parts[5])) {
                    obj.cartesian.setValue(message.getBoolean());
                }
                return true;
            }
            catch (NumberFormatException nfx) {
                LXOscEngine.error("Bad ADM object identifier: " + message.getAddressPattern().getValue());
            }
        }
        return false;
    }

    public class Obj
    extends LXComponent {
        public final int objectId;
        public final BoundedParameter azimuth;
        public final BoundedParameter elevation;
        public final BoundedParameter distance;
        public final BoundedParameter x;
        public final BoundedParameter y;
        public final BoundedParameter z;
        public final BooleanParameter cartesian;

        private Obj(LX lx, int objectId) {
            super(lx, "ADMObject-" + objectId);
            this.azimuth = new BoundedParameter("Azimuth", 0.0, -180.0, 180.0).setUnits(LXParameter.Units.DEGREES).setDescription("Azimuth about horizontal plane in degrees, counter-clockwise");
            this.elevation = new BoundedParameter("Elevation", 0.0, -90.0, 90.0).setUnits(LXParameter.Units.DEGREES).setDescription("Elevation from horizontal plane in degrees");
            this.distance = new BoundedParameter("Distance", 1.0, 0.0, 1.0).setDescription("Distance from center point, normalized 0-1");
            this.x = new BoundedParameter("X", 0.0, -1.0, 1.0).setDescription("Normalized X position, left-right");
            this.y = new BoundedParameter("Y", 0.0, -1.0, 1.0).setDescription("Normalized Y position, back-front");
            this.z = new BoundedParameter("Z", 0.0, -1.0, 1.0).setDescription("Normalized Z position, bottom-top");
            this.cartesian = new BooleanParameter("Cartesian", false).setDescription("Whether cartesian units are used");
            this.objectId = objectId;
            this.setParent(ADM.this);
            this.addParameter("azimuth", this.azimuth);
            this.addParameter("elevation", this.elevation);
            this.addParameter("distance", this.distance);
            this.addParameter(ADM.ADM_X_PATH, this.x);
            this.addParameter(ADM.ADM_Y_PATH, this.y);
            this.addParameter(ADM.ADM_Z_PATH, this.z);
            this.addParameter(ADM.ADM_CARTESIAN_PATH, this.cartesian);
        }

        protected void updatePolar() {
            double x = this.x.getValue();
            double y = this.y.getValue();
            double z = this.z.getValue();
            double dist = LXUtils.dist(x, y, z, 0.0, 0.0, 0.0);
            this.distance.setValue(dist);
            if (dist > 0.0) {
                double xydist = LXUtils.dist(x, y, 0.0, 0.0);
                if (xydist > 0.0) {
                    this.azimuth.setValue(Math.toDegrees(Math.atan2(-x, y)));
                    this.elevation.setValue(Math.atan(z / xydist));
                } else if (z != 0.0) {
                    this.elevation.setValue(z > 0.0 ? 90 : -90);
                }
            }
        }

        @Override
        public String getPath() {
            return "obj/" + this.objectId;
        }
    }
}

