/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.audio.DecibelMeter;
import heronarts.lx.audio.FourierTransform;
import heronarts.lx.audio.GraphicMeter;
import heronarts.lx.audio.LXMeterImpl;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Audio")
@LXModulator.Global(value="Band Filter")
@LXModulator.Device(value="Band Filter")
public class BandFilter
extends LXModulator
implements LXNormalizedParameter,
LXOscComponent {
    public final BoundedParameter gain = new BoundedParameter("Gain", 0.0, -48.0, 48.0).setDescription("Sets the gain of the meter in dB").setUnits(LXParameter.Units.DECIBELS);
    public final BoundedParameter range = new BoundedParameter("Range", 36.0, 6.0, 96.0).setDescription("Sets the range of the meter in dB").setUnits(LXParameter.Units.DECIBELS);
    public final BoundedParameter attack = new BoundedParameter("Attack", 10.0, 0.0, 100.0).setDescription("Sets the attack time of the meter response").setUnits(LXParameter.Units.MILLISECONDS_RAW);
    public final BoundedParameter release = new BoundedParameter("Release", 100.0, 0.0, 1000.0).setDescription("Sets the release time of the meter response").setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS_RAW);
    public final BoundedParameter slope = new BoundedParameter("Slope", 4.5, -3.0, 12.0).setDescription("Sets the slope of the meter in dB per octave").setUnits(LXParameter.Units.DECIBELS);
    public final BoundedParameter minFreq;
    public final BoundedParameter maxFreq;
    public final GraphicMeter meter;
    private double averageOctave = 1.0;
    private float averageRaw = 0.0f;
    protected double averageNorm = 0.0;
    private final LXMeterImpl impl;

    public BandFilter(LX lx) {
        this("Filter", lx);
    }

    public BandFilter(String label, LX lx) {
        this(label, lx.engine.audio.meter);
    }

    public BandFilter(String label, GraphicMeter meter) {
        super(label);
        this.impl = new LXMeterImpl(meter.numBands, meter.fft.getBandOctaveRatio());
        this.meter = meter;
        int nyquist = meter.fft.getSampleRate() / 2;
        this.minFreq = new BoundedParameter("Min Freq", 60.0, 0.0, nyquist).setDescription("Minimum frequency the gate responds to").setExponent(4.0).setUnits(LXParameter.Units.HERTZ);
        this.maxFreq = new BoundedParameter("Max Freq", 120.0, 0.0, nyquist).setDescription("Maximum frequency the gate responds to").setExponent(4.0).setUnits(LXParameter.Units.HERTZ);
        this.addParameter("gain", this.gain);
        this.addParameter("range", this.range);
        this.addParameter("attack", this.attack);
        this.addParameter("release", this.release);
        this.addParameter("slope", this.slope);
        this.addParameter("minFreq", this.minFreq);
        this.addParameter("maxFreq", this.maxFreq);
        this.setDescription("Average level metering for a frequency range");
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.minFreq) {
            if (this.minFreq.getValue() > this.maxFreq.getValue()) {
                this.minFreq.setValue(this.maxFreq.getValue());
            } else {
                this.updateAverageOctave();
            }
        } else if (p == this.maxFreq) {
            if (this.maxFreq.getValue() < this.minFreq.getValue()) {
                this.maxFreq.setValue(this.minFreq.getValue());
            } else {
                this.updateAverageOctave();
            }
        }
    }

    public BandFilter setFrequencyRange(float minHz, float maxHz) {
        this.minFreq.setValue(minHz);
        this.maxFreq.setValue(maxHz);
        return this;
    }

    public double getBand(int i) {
        return this.impl.getBand(i);
    }

    private void updateAverageOctave() {
        double averageFreq = (this.minFreq.getValue() + this.maxFreq.getValue()) / 2.0;
        this.averageOctave = Math.log(averageFreq / (double)65.41f) / (double)FourierTransform.LOG_2;
    }

    @Override
    protected double computeValue(double deltaMs) {
        float attackGain = (float)Math.exp(-deltaMs / this.attack.getValue());
        float releaseGain = (float)Math.exp(-deltaMs / this.release.getValue());
        double rangeValue = this.range.getValue();
        double gainValue = this.gain.getValue();
        double slopeValue = this.slope.getValue();
        this.impl.compute(this.meter.fft, attackGain, releaseGain, gainValue, rangeValue, slopeValue);
        float newAverage = this.meter.fft.getAverage(this.minFreq.getValuef(), this.maxFreq.getValuef()) / (float)this.meter.fft.getSize();
        float averageGain = newAverage >= this.averageRaw ? attackGain : releaseGain;
        this.averageRaw = newAverage + averageGain * (this.averageRaw - newAverage);
        double averageDb = 20.0 * Math.log(this.averageRaw) / DecibelMeter.LOG_10 + gainValue + slopeValue * this.averageOctave;
        this.averageNorm = 1.0 + averageDb / rangeValue;
        return LXUtils.constrain(this.averageNorm, 0.0, 1.0);
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("BandFilter does not support setNormalized()");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }
}

