/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.audio.BandFilter;
import heronarts.lx.audio.GraphicMeter;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.NormalizedParameter;

@LXCategory(value="Audio")
@LXModulator.Global(value="Beat Detect")
@LXModulator.Device(value="Beat Detect")
public class BandGate
extends BandFilter
implements LXNormalizedParameter,
LXTriggerSource,
LXOscComponent {
    public final BoundedParameter threshold = new BoundedParameter("Threshold", 0.8).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the level at which the band is triggered");
    public final BoundedParameter floor = new BoundedParameter("Floor", 0.75).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets the level the signal must drop below before being triggered again");
    public final BoundedParameter decay = new BoundedParameter("Decay", 400.0, 0.0, 1600.0).setDescription("Sets the decay time of the trigger signal").setUnits(LXParameter.Units.MILLISECONDS_RAW);
    public final BooleanParameter gate = new BooleanParameter("Gate").setDescription("Engages when the beat is first detected").setMode(BooleanParameter.Mode.MOMENTARY);
    public final BooleanParameter teachTempo = new BooleanParameter("Tap", false).setDescription("When enabled, each triggering of the band taps the global tempo");
    private int tapCount = 0;
    public final NormalizedParameter average = new NormalizedParameter("Average").setDescription("Computed average level of the audio within the frequency range");
    private double envelope = 0.0;
    private boolean waitingForFloor = false;

    public BandGate(LX lx) {
        this("Beat", lx);
    }

    public BandGate(String label, LX lx) {
        this(label, lx.engine.audio.meter);
    }

    public BandGate(String label, GraphicMeter meter) {
        super(label, meter);
        this.addParameter("threshold", this.threshold);
        this.addParameter("floor", this.floor);
        this.addParameter("decay", this.decay);
        this.addParameter("gate", this.gate);
        this.addParameter("average", this.average);
        this.addParameter("tap", this.teachTempo);
        this.setDescription("Envelope that fires when a beat is detected");
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.teachTempo) {
            this.tapCount = 0;
        }
    }

    public BandGate(GraphicMeter meter, float minHz, float maxHz) {
        this("Beat", meter);
        this.setFrequencyRange(minHz, maxHz);
    }

    public BandGate(String label, GraphicMeter meter, int minHz, int maxHz) {
        this(label, meter);
        this.setFrequencyRange(minHz, maxHz);
    }

    @Override
    protected double computeValue(double deltaMs) {
        boolean triggered;
        double floorValue;
        double filterAverage = super.computeValue(deltaMs);
        this.average.setValue(filterAverage);
        double thresholdValue = this.threshold.getValue();
        if (this.waitingForFloor && this.averageNorm < (floorValue = thresholdValue * this.floor.getValue())) {
            this.waitingForFloor = false;
        }
        boolean bl = triggered = !this.waitingForFloor && thresholdValue > 0.0 && this.averageNorm >= thresholdValue;
        if (triggered) {
            if (this.teachTempo.isOn()) {
                this.lx.engine.tempo.tap();
                if (++this.tapCount >= 4) {
                    this.teachTempo.setValue(false);
                }
            }
            this.waitingForFloor = true;
            this.envelope = 1.0;
        } else {
            this.envelope = Math.max(0.0, this.envelope - deltaMs / this.decay.getValue());
        }
        this.gate.setValue(triggered);
        return this.envelope;
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("BandGate does not support setNormalized()");
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.gate;
    }
}

