/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXRunnableComponent;
import heronarts.lx.Tempo;
import heronarts.lx.audio.ADM;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.NormalizedParameter;
import heronarts.lx.utils.LXUtils;

public class Envelop
extends LXRunnableComponent {
    public final Source source;
    public final Decode decode;
    public final BooleanParameter metersExpanded = new BooleanParameter("Meters Expanded", false).setDescription("Show Envelop meters in the UI");
    public static final String ENVELOP_OSC_PATH = "envelop";
    public static final String ENVELOP_METER_PATH = "meter";
    public static final String ENVELOP_SOURCE_PATH = "source";
    public static final String ENVELOP_DECODE_PATH = "decode";
    public static final String ENVELOP_SOURCE_AED = "aed";
    public static final String ENVELOP_SOURCE_XYZ = "xyz";
    public static final String ENVELOP_TEMPO_PATH = "tempo";
    public static final String ENVELOP_BEAT_PATH = "beat";
    public static final String ENVELOP_BPM_PATH = "bpm";

    public Envelop(LX lx) {
        super(lx, "Envelop");
        this.addInternalParameter("metersExpanded", this.metersExpanded);
        this.source = new Source();
        this.addChild(ENVELOP_SOURCE_PATH, this.source);
        this.decode = new Decode();
        this.addChild(ENVELOP_DECODE_PATH, this.decode);
        this.source.start();
        this.decode.start();
    }

    @Override
    public void onStop() {
        this.source.clear();
        this.decode.clear();
    }

    @Override
    public void run(double deltaMs) {
        this.source.loop(deltaMs);
        this.decode.loop(deltaMs);
    }

    public boolean handleEnvelopOscMessage(OscMessage message, String[] parts, int index) {
        if (ENVELOP_SOURCE_PATH.equals(parts[2])) {
            int sourceIndex = Integer.parseInt(parts[3]) - 1;
            if (sourceIndex < 0 || sourceIndex >= 64) {
                LXOscEngine.error("Bad Envelop source channel index: " + String.valueOf(message.getAddressPattern()));
                return false;
            }
            ADM.Obj obj = this.lx.engine.audio.adm.obj.get(sourceIndex);
            String sourceFormat = message.getString();
            if (ENVELOP_SOURCE_AED.equals(sourceFormat)) {
                float azimuth = message.getFloat();
                float elevation = message.getFloat();
                float distance = message.getFloat();
                float sign = elevation >= 0.0f ? 1 : -1;
                boolean flipAzimuth = false;
                float absElevation = Math.abs(elevation);
                if (elevation >= 270.0f) {
                    elevation = sign * (absElevation - 360.0f);
                } else if (absElevation > 90.0f) {
                    flipAzimuth = true;
                    elevation = sign * (180.0f - absElevation);
                }
                if (flipAzimuth) {
                    azimuth += 180.0f;
                }
                azimuth = (azimuth + 540.0f) % 360.0f - 180.0f;
                obj.azimuth.setValue(-azimuth);
                obj.elevation.setValue(elevation);
                obj.distance.setValue(distance);
            } else if (ENVELOP_SOURCE_XYZ.equals(sourceFormat)) {
                obj.x.setValue(message.getFloat());
                obj.y.setValue(message.getFloat());
                obj.z.setValue(message.getFloat());
                obj.updatePolar();
            } else {
                LXOscEngine.error("Bad Envelop source format: " + String.valueOf(message.getAddressPattern()));
                return false;
            }
            return true;
        }
        if (ENVELOP_METER_PATH.equals(parts[2])) {
            if (ENVELOP_SOURCE_PATH.equals(parts[3])) {
                int sourceIndex = Integer.parseInt(parts[4]) - 1;
                if (sourceIndex < 0 || sourceIndex >= 32) {
                    LXOscEngine.error("Invalid Envelop source meter index: " + String.valueOf(message.getAddressPattern()));
                } else {
                    this.source.setLevel(sourceIndex, message);
                }
            } else if (ENVELOP_DECODE_PATH.equals(parts[3])) {
                if (message.size() < 8) {
                    LXOscEngine.error("Not enough channels in Envelop decode message (expecting 8): " + message.toString());
                } else {
                    this.decode.setLevels(message);
                }
            }
            return true;
        }
        if (ENVELOP_TEMPO_PATH.equals(parts[2]) && this.lx.engine.tempo.clockSource.getEnum() == Tempo.ClockSource.OSC) {
            if (ENVELOP_BPM_PATH.equals(parts[3])) {
                if (message.size() == 0) {
                    LXOscEngine.error("Envelop bpm message missing argument: " + message.toString());
                } else {
                    this.lx.engine.tempo.bpm.setValue(message.getFloat());
                }
            } else if (ENVELOP_BEAT_PATH.equals(parts[3])) {
                if (message.size() == 0) {
                    LXOscEngine.error("Envelop beat message missing arguments: " + message.toString());
                } else {
                    int beat = message.getInt();
                    if (message.size() >= 3) {
                        int bar = message.getInt();
                        float bpm = message.getFloat();
                        if (bar >= 1 && beat >= 1) {
                            this.lx.engine.tempo.triggerBarAndBeat(bar, beat, message);
                        }
                        this.lx.engine.tempo.bpm.setValue(bpm);
                    } else {
                        this.lx.engine.tempo.triggerBeatWithinBar(beat, message);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (obj.has("_reset_")) {
            this.metersExpanded.setValue(false);
            this.stop();
        }
    }

    public class Decode
    extends MultiMeter {
        public static final int NUM_CHANNELS = 8;
        public final NormalizedParameter[] channels;

        private Decode() {
            super("Decode", 8);
            this.channels = new NormalizedParameter[8];
            int i = 0;
            while (i < this.channels.length) {
                this.channels[i] = new NormalizedParameter("Decode-" + (i + 1)).setDescription("Envelop column decode " + (i + 1));
                this.addParameter("decode-" + (i + 1), this.channels[i]);
                ++i;
            }
        }

        @Override
        public NormalizedParameter[] getChannels() {
            return this.channels;
        }
    }

    protected abstract class MultiMeter
    extends LXRunnableComponent {
        private static final double TIMEOUT = 1000.0;
        private final double[] targets;
        private final double[] timeouts;
        public final BoundedParameter gain;
        public final BoundedParameter range;
        public final BoundedParameter attack;
        public final BoundedParameter release;

        protected MultiMeter(String label, int numChannels) {
            super(label);
            this.gain = new BoundedParameter("Gain", 0.0, -24.0, 24.0).setDescription("Sets the dB gain of the meter").setUnits(LXParameter.Units.DECIBELS);
            this.range = new BoundedParameter("Range", 24.0, 6.0, 96.0).setDescription("Sets the dB range of the meter").setUnits(LXParameter.Units.DECIBELS);
            this.attack = new BoundedParameter("Attack", 0.0, 0.0, 100.0).setDescription("Sets the attack time of the meter response").setUnits(LXParameter.Units.MILLISECONDS);
            this.release = new BoundedParameter("Release", 50.0, 0.0, 500.0).setDescription("Sets the release time of the meter response").setUnits(LXParameter.Units.MILLISECONDS);
            this.targets = new double[numChannels];
            this.timeouts = new double[numChannels];
            this.addParameter("gain", this.gain);
            this.addParameter("range", this.range);
            this.addParameter("attack", this.attack);
            this.addParameter("release", this.release);
        }

        protected void clear() {
            NormalizedParameter[] normalizedParameterArray = this.getChannels();
            int n = normalizedParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                NormalizedParameter channel = normalizedParameterArray[n2];
                channel.setValue(0.0);
                ++n2;
            }
        }

        @Override
        public void run(double deltaMs) {
            double attack = this.attack.getValue();
            double release = this.release.getValue();
            NormalizedParameter[] channels = this.getChannels();
            int i = 0;
            while (i < channels.length) {
                int n = i;
                this.timeouts[n] = this.timeouts[n] + deltaMs;
                if (this.timeouts[i] > 1000.0) {
                    this.targets[i] = 0.0;
                }
                double target = this.targets[i];
                double value = channels[i].getValue();
                double gain = Math.exp(-deltaMs / (target >= value ? attack : release));
                channels[i].setValue(LXUtils.lerp(target, value, gain));
                ++i;
            }
        }

        protected void setLevel(int index, OscMessage message) {
            double gainValue = this.gain.getValue();
            double rangeValue = this.range.getValue();
            this.targets[index] = LXUtils.constrain((float)(1.0 + ((double)message.getFloat() + gainValue) / rangeValue), 0.0, 1.0);
            this.timeouts[index] = 0.0;
        }

        protected void setLevels(OscMessage message) {
            double gainValue = this.gain.getValue();
            double rangeValue = this.range.getValue();
            int i = 0;
            while (i < this.targets.length) {
                this.targets[i] = LXUtils.constrain((float)(1.0 + ((double)message.getFloat() + gainValue) / rangeValue), 0.0, 1.0);
                this.timeouts[i] = 0.0;
                ++i;
            }
        }

        protected abstract NormalizedParameter[] getChannels();
    }

    public class Source
    extends MultiMeter {
        public static final int NUM_CHANNELS = 32;
        public final NormalizedParameter[] channels;

        private Source() {
            super("Source", 32);
            this.channels = new NormalizedParameter[32];
            int i = 0;
            while (i < this.channels.length) {
                this.channels[i] = new NormalizedParameter("Source-" + (i + 1)).setDescription("Envelop source object " + (i + 1));
                this.addParameter("source-" + (i + 1), this.channels[i]);
                ++i;
            }
        }

        @Override
        public NormalizedParameter[] getChannels() {
            return this.channels;
        }
    }
}

