/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

public class LXAudioBuffer {
    protected static final float INV_16_BIT = 3.0517578E-5f;
    private final int sampleRate;
    final float[] samples;
    float rms;

    LXAudioBuffer(int bufferSize, int sampleRate) {
        this.samples = new float[bufferSize];
        this.sampleRate = sampleRate;
    }

    public int bufferSize() {
        return this.samples.length;
    }

    public int sampleRate() {
        return this.sampleRate;
    }

    public float getRms() {
        return this.rms;
    }

    protected synchronized void computeMix(LXAudioBuffer left, LXAudioBuffer right) {
        float sumSquares = 0.0f;
        int i = 0;
        while (i < this.samples.length) {
            this.samples[i] = (left.samples[i] + right.samples[i]) * 0.5f;
            sumSquares += this.samples[i] * this.samples[i];
            ++i;
        }
        this.rms = (float)Math.sqrt(sumSquares / (float)this.samples.length);
    }

    protected synchronized void putSamples(byte[] rawBytes, int offset, int dataSize, int frameSize) {
        int frameIndex = 0;
        float sumSquares = 0.0f;
        int i = 0;
        while (i < dataSize) {
            this.samples[frameIndex] = (float)(rawBytes[offset + i + 1] << 8 | rawBytes[offset + i] & 0xFF) * 3.0517578E-5f;
            sumSquares += this.samples[frameIndex] * this.samples[frameIndex];
            ++frameIndex;
            i += frameSize;
        }
        this.rms = (float)Math.sqrt(sumSquares / (float)this.samples.length);
    }

    public synchronized void getSamples(float[] dest) {
        if (this.samples.length != dest.length) {
            throw new IllegalArgumentException("LXAudioBuffer getSamples destination array must have same length");
        }
        System.arraycopy(this.samples, 0, dest, 0, dest.length);
    }
}

