/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.LX;
import heronarts.lx.audio.LXAudioComponent;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class LXAudioOutput
extends LXAudioComponent
implements LXOscComponent,
LineListener {
    private SourceDataLine line;
    private AudioFormat format;
    private AudioInputStream inputStream;
    private boolean stopped = false;
    private boolean closed = false;
    public final BooleanParameter trigger = new BooleanParameter("Trigger", false).setDescription("Triggers playback of the audio file from its beginning");
    public final BooleanParameter play = new BooleanParameter("Play", false).setDescription("Play/Pause state of the output audio file");
    public final BooleanParameter looping = new BooleanParameter("Loop", false).setDescription("Whether playback of the audio file should loop");
    public final StringParameter file = new StringParameter("File").setDescription("File for audio playback");
    private OutputThread outputThread = null;

    public LXAudioOutput(LX lx) {
        super(lx, "Output");
        this.format = STEREO;
        this.addParameter("file", this.file);
        this.addParameter("trigger", this.trigger);
        this.addParameter("looping", this.looping);
        this.addParameter("play", this.play);
    }

    public void setInputStream(File file) {
        try {
            this.setInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fnfx) {
            LX.error(fnfx, "Audio file does not exist for setInputStream: " + String.valueOf(file));
        }
    }

    public boolean setInputStream(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            return this.setAudioInputStream(AudioSystem.getAudioInputStream(inputStream));
        }
        catch (UnsupportedAudioFileException uafx) {
            LX.error(uafx);
        }
        catch (IOException iox) {
            LX.error(iox);
        }
        return false;
    }

    public boolean setAudioInputStream(AudioInputStream inputStream) {
        AudioFormat format = inputStream.getFormat();
        if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            try {
                inputStream = AudioSystem.getAudioInputStream(STEREO, inputStream);
                if (!inputStream.markSupported()) {
                    inputStream = new AudioInputStream(new BufferedInputStream(inputStream), STEREO, inputStream.getFrameLength());
                }
                format = inputStream.getFormat();
            }
            catch (Exception x) {
                LX.error(x, "Invalid audio format: " + x.getLocalizedMessage());
                return false;
            }
        }
        if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            LX.error("Audio must be decodable to PCM_SIGNED data");
            return false;
        }
        if (format.getSampleRate() != 44100.0f) {
            LX.error("Audio file must have sample rate of 44100");
            return false;
        }
        if (format.getSampleSizeInBits() != 16) {
            LX.error("Audio file must have 16 bits per sample");
            return false;
        }
        if (format.isBigEndian()) {
            LX.error("Audio file must be little endian");
            return false;
        }
        if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            LX.error("Audio file must be PCM signed");
            return false;
        }
        if (format.getChannels() > 2) {
            LX.error("Audio file has more than 2 channels");
        }
        this.inputStream = inputStream;
        if (this.inputStream.markSupported()) {
            this.inputStream.mark(Integer.MAX_VALUE);
        }
        if (this.outputThread != null) {
            this.outputThread.flush = true;
        }
        this.open();
        return true;
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.play) {
            if (this.play.isOn()) {
                if (this.line == null) {
                    this.play.setValue(false);
                } else {
                    this.start();
                }
            } else {
                this.stop();
            }
        } else if (p == this.trigger) {
            if (this.trigger.isOn()) {
                if (this.line != null) {
                    this.play.setValue(true);
                    this.outputThread.trigger = true;
                }
                this.trigger.setValue(false);
            }
        } else if (p == this.file) {
            String path = this.file.getString();
            if (path != null && path.length() > 0) {
                this.setInputStream(new File(path));
            } else {
                this.stop();
            }
        }
    }

    public String getFileName() {
        return new File(this.file.getString()).getName();
    }

    private void open() {
        if (this.line == null) {
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(STEREO_SOURCE_LINE);
                this.line.addLineListener(this);
                this.closed = false;
                this.line.open(this.format, 8192);
                this.stopped = true;
                if (this.play.isOn()) {
                    this.stopped = false;
                    this.line.start();
                }
                this.outputThread = new OutputThread(this.line);
                this.outputThread.start();
            }
            catch (Exception x) {
                LX.error(x, "Exception opening stereo output audio line");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        if (this.line != null) {
            this.stopped = false;
            this.line.start();
            OutputThread outputThread = this.outputThread;
            synchronized (outputThread) {
                this.outputThread.notify();
            }
        }
    }

    public void close() {
        if (this.line != null) {
            this.closed = true;
            this.line.close();
        }
    }

    void stop() {
        if (this.line != null) {
            this.stopped = true;
            this.line.stop();
        }
    }

    @Override
    public void update(LineEvent event) {
        LineEvent.Type type = event.getType();
        if (type == LineEvent.Type.OPEN) {
            LX.log("LXAudioOuput OPEN");
        } else if (type == LineEvent.Type.START) {
            LX.log("LXAudioOuput START");
        } else if (type == LineEvent.Type.STOP) {
            LX.log("LXAudioOuput STOP");
            if (this.line == event.getLine()) {
                this.stopped = true;
            }
        } else if (type == LineEvent.Type.CLOSE) {
            LX.log("LXAudioOuput CLOSE");
            if (this.line == event.getLine()) {
                this.closed = true;
            }
        }
    }

    void reset() {
        this.play.setValue(false);
        this.looping.setValue(false);
        this.file.setValue("");
    }

    private class OutputThread
    extends Thread {
        private final SourceDataLine line;
        private final byte[] buffer;
        private volatile boolean trigger;
        private volatile boolean flush;

        private OutputThread(SourceDataLine line) {
            super("LXAudioEngine Output Thread");
            this.buffer = new byte[2048];
            this.trigger = false;
            this.flush = false;
            this.line = line;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ** GOTO lbl61
            {
                if (LXAudioOutput.this.closed) {
                    return;
                }
                try {
                    var1_1 = this;
                    synchronized (var1_1) {
                        this.wait();
                    }
                }
                catch (InterruptedException var1_2) {
                    // empty catch block
                }
                do {
                    if (LXAudioOutput.this.stopped) continue block9;
                    try {
                        if (this.flush) {
                            this.line.flush();
                            this.flush = false;
                        }
                        if (this.trigger) {
                            if (LXAudioOutput.this.inputStream.markSupported()) {
                                LXAudioOutput.this.inputStream.reset();
                            } else {
                                LX.error("Audio format does not support reset");
                            }
                            this.trigger = false;
                        }
                        if ((len = LXAudioOutput.this.inputStream.read(this.buffer, 0, (mono = LXAudioOutput.this.inputStream.getFormat().getChannels() == 1) != false ? 1024 : 2048)) <= 0) {
                            this.line.drain();
                            this.trigger = true;
                            if (LXAudioOutput.this.looping.isOn()) continue;
                            LXAudioOutput.this.play.setValue(false);
                            continue;
                        }
                        if (mono) {
                            i = len - 2;
                            while (i >= 0) {
                                v1 = this.buffer[i];
                                this.buffer[2 * i + 2] = v1;
                                this.buffer[2 * i] = v1;
                                v2 = this.buffer[i + 1];
                                this.buffer[2 * i + 3] = v2;
                                this.buffer[2 * i + 1] = v2;
                                i -= 2;
                            }
                            len *= 2;
                        }
                        try {
                            this.line.write(this.buffer, 0, len);
                        }
                        catch (Exception x) {
                            LX.error(x, "LXAudioOutput error writing to line: " + x.getLocalizedMessage());
                            LXAudioOutput.this.play.setValue(false);
                        }
                        LXAudioOutput.this.left.putSamples(this.buffer, 0, 2048, 4);
                        LXAudioOutput.this.right.putSamples(this.buffer, 2, 2048, 4);
                        LXAudioOutput.this.mix.computeMix(LXAudioOutput.this.left, LXAudioOutput.this.right);
                    }
                    catch (IOException iox) {
                        LX.error(iox);
                        break block9;
                    }
lbl61:
                    // 4 sources

                } while (!LXAudioOutput.this.closed);
            }
            this.line.flush();
        }
    }
}

