/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.audio;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.audio.ADM;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.parameter.NormalizedParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.transform.LXVector;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@LXCategory(value="Audio")
@LXModulator.Global(value="Sound Object")
public class SoundObject
extends LXModulator
implements Comparable<SoundObject>,
LXOscComponent,
LXNormalizedParameter {
    public final BooleanParameter admSync = new BooleanParameter("ADM Sync", false).setDescription("Pull sound object position data from ADM-OSC input");
    public final DiscreteParameter admObjId = new DiscreteParameter("Object ID", 1, 65).setDescription("ADM sound object ID");
    public final EnumParameter<MeterSource> meterSource = new EnumParameter<MeterSource>("Meter Source", MeterSource.NONE).setDescription("Source of the sound object meter data");
    public final EnumParameter<AudioMeterSource> audioMeterSource = new EnumParameter<AudioMeterSource>("Audio Meter Source", AudioMeterSource.MIX).setDescription("Source of the audio meter data");
    public final DiscreteParameter envelopSource = new DiscreteParameter("Envelop Source Channel", 1, 33).setDescription("Which Envelop source channel to meter");
    public final DiscreteParameter reaperSource = new DiscreteParameter("Reaper Source Channel", 1, 33).setDescription("Which Reaper source channel to meter");
    public final NormalizedParameter input = new NormalizedParameter("Input", 0.0).setDescription("Raw input level of the sound object meter");
    public final BoundedParameter meterFloor = new BoundedParameter("Floor", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Specifies the floor of the active meter range");
    public final BoundedParameter meterCeiling = new BoundedParameter("Ceiling", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Specifies the ceiling of the active meter range");
    public final BoundedParameter attackMs = new BoundedParameter("Attack", 10.0, 0.0, 1000.0).setDescription("Attack time of the smoothed meter in milliseconds").setUnits(LXParameter.Units.MILLISECONDS_RAW);
    public final BoundedParameter releaseMs = new BoundedParameter("Release", 50.0, 0.0, 10000.0).setDescription("Release time of the smoothed meter in milliseconds").setUnits(LXParameter.Units.MILLISECONDS_RAW);
    public final CompoundParameter azimuth = new CompoundParameter("Azimuth", 0.0, -180.0, 180.0).setUnits(LXParameter.Units.DEGREES).setPolarity(LXParameter.Polarity.BIPOLAR).setWrappable(true).setDescription("Azimuth of the sound object, clockwise about the X-Z plane");
    public final CompoundParameter elevation = new CompoundParameter("Elevation", 0.0, -90.0, 90.0).setUnits(LXParameter.Units.DEGREES).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Elevation of the sound object against the X-Z plane");
    public final CompoundParameter distance = new CompoundParameter("Distance", 1.0, 0.0, 2.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Distance of the sound object");
    public final MutableParameter cartesianChanged = new MutableParameter("Cartesian Changed");
    public final BooleanParameter controlsExpanded = new BooleanParameter("Controls Expanded", true).setDescription("Whether the full controls are expanded");
    public final LXVector position = new LXVector();
    public final LXVector normalized = new LXVector();
    private final LXParameter.MultiMonitor aedMonitor = new LXParameter.MultiMonitor(this.azimuth, this.elevation, this.distance);
    private static final String NO_OBJECT = "None";
    private static List<SoundObject> soundObjects = new ArrayList<SoundObject>();
    private static SoundObject[] objects = new SoundObject[1];
    private static String[] options = new String[]{"None"};
    private static List<Selector> selectors = new ArrayList<Selector>();

    public static SoundObject get(LX lx) {
        for (LXModulator modulator : lx.engine.modulation.modulators) {
            if (!(modulator instanceof SoundObject)) continue;
            return (SoundObject)modulator;
        }
        return null;
    }

    public SoundObject(LX lx) {
        super("Sound Object");
        this.addParameter("admSync", this.admSync);
        this.addParameter("admObjId", this.admObjId);
        this.addParameter("meterSource", this.meterSource);
        this.addParameter("audioMeterSource", this.audioMeterSource);
        this.addParameter("envelopSource", this.envelopSource);
        this.addParameter("reaperSource", this.reaperSource);
        this.addParameter("input", this.input);
        this.addParameter("meterFloor", this.meterFloor);
        this.addParameter("meterCeiling", this.meterCeiling);
        this.addParameter("attackMs", this.attackMs);
        this.addParameter("releaseMs", this.releaseMs);
        this.addParameter("azimuth", this.azimuth);
        this.addParameter("elevation", this.elevation);
        this.addParameter("distance", this.distance);
        this.addInternalParameter("controlsExpanded", this.controlsExpanded);
        this.updateCartesian();
        soundObjects.add(this);
        lx.engine.audio.numSoundObjects.setValue(LXUtils.max(lx.engine.audio.numSoundObjects.getValuei(), soundObjects.size()));
        SoundObject.updateSelectors(lx);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.label) {
            if (this.lx != null) {
                SoundObject.updateSelectors(this.lx);
            }
        } else if (p == this.meterFloor) {
            double floor = this.meterFloor.getValue();
            if (this.meterCeiling.getValue() < floor) {
                this.meterCeiling.setValue(floor);
            }
        } else if (p == this.meterCeiling) {
            double ceiling = this.meterFloor.getValue();
            if (this.meterFloor.getValue() > ceiling) {
                this.meterFloor.setValue(ceiling);
            }
        }
    }

    public void updateCartesian() {
        float distance = 0.5f * this.distance.getValuef();
        double azimuth = Math.toRadians(this.azimuth.getValue());
        double elevation = Math.toRadians(this.elevation.getValue());
        float sinAzim = (float)Math.sin(azimuth);
        float cosAzim = (float)Math.cos(azimuth);
        float cosElev = (float)Math.cos(elevation);
        float sinElev = (float)Math.sin(elevation);
        this.position.set(0.5f + distance * sinAzim * cosElev, 0.5f + distance * sinElev, 0.5f + distance * cosAzim * cosElev);
        this.normalized.set(sinAzim * cosElev, sinElev, cosAzim * cosElev);
        this.cartesianChanged.bang();
    }

    @Override
    protected double computeValue(double deltaMs) {
        if (this.aedMonitor.changed()) {
            this.updateCartesian();
        }
        if (this.admSync.isOn()) {
            ADM.Obj obj = this.lx.engine.audio.adm.obj.get(this.admObjId.getValuei() - 1);
            this.azimuth.setValue(-obj.azimuth.getValue());
            this.elevation.setValue(obj.elevation.getValue());
            this.distance.setValue(obj.distance.getValue());
        }
        switch (this.meterSource.getEnum()) {
            case AUDIO: {
                switch (this.audioMeterSource.getEnum()) {
                    case MIX: {
                        this.input.setValue(this.lx.engine.audio.meter.getNormalized());
                        break;
                    }
                    case LEFT: {
                        this.input.setValue(this.lx.engine.audio.meter.left.getNormalized());
                        break;
                    }
                    case RIGHT: {
                        this.input.setValue(this.lx.engine.audio.meter.right.getNormalized());
                    }
                }
                break;
            }
            case ENVELOP: {
                this.input.setValue(this.lx.engine.audio.envelop.source.channels[this.envelopSource.getValuei() - 1].getNormalized());
                break;
            }
            case REAPER: {
                this.input.setValue(this.lx.engine.audio.reaper.meters[this.reaperSource.getValuei() - 1].level.getNormalized());
                break;
            }
        }
        double targetValue = LXUtils.constrain(LXUtils.ilerp(this.input.getValue(), this.meterFloor.getValue(), this.meterCeiling.getValue()), 0.0, 1.0);
        double currentLevel = this.getValue();
        if (targetValue > currentLevel) {
            double attackMs = this.attackMs.getValue();
            if (attackMs > 0.0) {
                return LXUtils.min(targetValue, currentLevel + deltaMs / attackMs);
            }
        } else {
            double releaseMs = this.releaseMs.getValue();
            if (releaseMs > 0.0) {
                return LXUtils.max(targetValue, currentLevel - deltaMs / releaseMs);
            }
        }
        return targetValue;
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("Cannot setNormalized on SoundObject");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }

    @Override
    public int compareTo(SoundObject that) {
        return this.getLabel().compareTo(that.getLabel());
    }

    @Override
    public void dispose() {
        soundObjects.remove(this);
        int numObjects = this.lx.engine.audio.numSoundObjects.getValuei();
        if (numObjects <= 0) {
            LX.error("LXAudioEngine sound object count was already 0 upon disposal: " + String.valueOf(this));
        } else {
            this.lx.engine.audio.numSoundObjects.setValue(numObjects - 1);
        }
        SoundObject.updateSelectors(this.lx);
        super.dispose();
    }

    static void updateSelectors(LX lx) {
        Collections.sort(soundObjects);
        int numOptions = 1 + lx.engine.audio.numSoundObjects.getValuei();
        objects = new SoundObject[numOptions];
        options = new String[numOptions];
        SoundObject.objects[0] = null;
        SoundObject.options[0] = NO_OBJECT;
        int i = 1;
        Iterator<LXNormalizedParameter> iterator = soundObjects.iterator();
        while (iterator.hasNext()) {
            SoundObject soundObject;
            SoundObject.objects[i] = soundObject = iterator.next();
            SoundObject.options[i] = soundObject.getLabel();
            ++i;
        }
        for (Selector selector : selectors) {
            SoundObject selected = (SoundObject)selector.getObject();
            selector.setObjects(objects, options);
            if (selected != null && soundObjects.contains(selected)) {
                selector.setValue(selected);
                continue;
            }
            selector.bang();
        }
    }

    public static enum AudioMeterSource {
        MIX("Mix"),
        LEFT("L"),
        RIGHT("R");

        public final String label;

        private AudioMeterSource(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum MeterSource {
        NONE("None"),
        AUDIO("Audio"),
        ENVELOP("Envelop"),
        REAPER("Reaper");

        public final String label;

        private MeterSource(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class Selector
    extends ObjectParameter<SoundObject> {
        public Selector(String label) {
            super(label, (T[])objects, options);
            selectors.add(this);
        }

        @Override
        public Selector setDescription(String description) {
            super.setDescription(description);
            return this;
        }

        @Override
        public void dispose() {
            selectors.remove(this);
            super.dispose();
        }
    }
}

