/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.LXClip;
import heronarts.lx.utils.LXUtils;
import java.util.Comparator;

public class Cursor
implements LXSerializable {
    private static final double SNAP_THRESHOLD = 0.01;
    public static final Immutable ZERO = new Immutable("ZERO", 0.0);
    public static final Immutable MIN_LOOP;
    public static final Immutable MIN_VIEW;
    public static final Immutable MIN_GRID_SPACING;
    public static final Immutable MIN_LABEL_SPACING;
    private static final Operator ABSOLUTE_OPERATOR;
    private static final Operator TEMPO_OPERATOR;
    private double millis = 0.0;
    private int beatCount = 0;
    private double beatBasis = 0.0;
    private static final String KEY_MILLIS = "millis";
    private static final String KEY_BEAT_COUNT = "beatCount";
    private static final String KEY_BEAT_BASIS = "beatBasis";

    static {
        MIN_VIEW = MIN_LOOP = new Immutable("MIN_LOOP", 125.0, 0, 0.125);
        MIN_GRID_SPACING = new Immutable("MIN_GRID_SPACING", 15.625, 0, 0.125);
        MIN_LABEL_SPACING = new Immutable("MIN_LABEL_SPACING", 15.625, 0, 0.25);
        ABSOLUTE_OPERATOR = new Operator(){

            @Override
            public boolean isZero(Cursor c) {
                return c.millis == 0.0;
            }

            @Override
            public boolean isBefore(Cursor c1, Cursor c2) {
                return c1.millis < c2.millis;
            }

            @Override
            public boolean isBeforeOrEqual(Cursor c1, Cursor c2) {
                return c1.millis <= c2.millis;
            }

            @Override
            public boolean isAfter(Cursor c1, Cursor c2) {
                return c1.millis > c2.millis;
            }

            @Override
            public boolean isAfterOrEqual(Cursor c1, Cursor c2) {
                return c1.millis >= c2.millis;
            }

            @Override
            public boolean isEqual(Cursor c1, Cursor c2) {
                return c1.millis == c2.millis;
            }

            @Override
            public boolean isInRange(Cursor c, Cursor before, Cursor after) {
                return LXUtils.inRange(c.millis, before.millis, after.millis);
            }

            @Override
            public double getRatio(Cursor c1, Cursor c2) {
                if (this.isZero(c2)) {
                    return 0.0;
                }
                return c1.millis / c2.millis;
            }

            @Override
            public double getLerpFactor(Cursor cursor, Cursor pre, Cursor post) {
                if (pre.millis == post.millis) {
                    return 0.0;
                }
                return (cursor.millis - pre.millis) / (post.millis - pre.millis);
            }

            @Override
            public double getLerpRatio(Cursor cursor, Cursor pre, Cursor post) {
                if (pre.millis == post.millis) {
                    return 1.0;
                }
                return cursor.millis / (post.millis - pre.millis);
            }

            @Override
            public int compare(Cursor o1, Cursor o2) {
                if (o1.millis == o2.millis) {
                    return 0;
                }
                return o1.millis < o2.millis ? -1 : 1;
            }

            private void _setBeatCountBasisFromMillis(Cursor cursor, LXClip clip) {
                cursor._setBeatCountBasis(cursor.millis * clip.referenceBpm.getValue() / 60000.0);
            }

            @Override
            public Cursor snap(Cursor cursor, LXClip clip, Cursor snapSize) {
                double multiple = Math.round(cursor.millis / snapSize.millis);
                cursor.millis = multiple * snapSize.millis;
                this._setBeatCountBasisFromMillis(cursor, clip);
                return cursor;
            }

            @Override
            public Cursor snapFloor(Cursor cursor, LXClip clip, Cursor snapSize) {
                double multiple = Math.floor(cursor.millis / snapSize.millis);
                cursor.millis = multiple * snapSize.millis;
                this._setBeatCountBasisFromMillis(cursor, clip);
                return cursor;
            }

            @Override
            public Cursor snapCeiling(Cursor cursor, LXClip clip, Cursor snapSize) {
                double multiple = Math.ceil(cursor.millis / snapSize.millis);
                cursor.millis = multiple * snapSize.millis;
                this._setBeatCountBasisFromMillis(cursor, clip);
                return cursor;
            }

            @Override
            public Cursor snapUp(Cursor cursor, LXClip clip, Cursor snapSize) {
                double snapUnits = cursor.millis / snapSize.millis;
                double decimal = snapUnits - (double)((long)snapUnits);
                cursor.millis = decimal < 0.01 || 1.0 - decimal < 0.01 ? (Math.ceil(snapUnits) + 1.0) * snapSize.millis : Math.ceil(snapUnits) * snapSize.millis;
                this._setBeatCountBasisFromMillis(cursor, clip);
                return cursor;
            }

            @Override
            public Cursor snapDown(Cursor cursor, LXClip clip, Cursor snapSize) {
                double snapUnits = cursor.millis / snapSize.millis;
                double decimal = snapUnits - (double)((long)snapUnits);
                if (decimal < 0.01) {
                    double multiple = LXUtils.max(0.0, Math.floor(snapUnits) - 1.0);
                    cursor.millis = multiple * snapSize.millis;
                } else {
                    cursor.millis = Math.floor(snapUnits) * snapSize.millis;
                }
                this._setBeatCountBasisFromMillis(cursor, clip);
                return cursor;
            }

            @Override
            public String formatLabel(LXClip clip, Cursor cursor, Cursor labelSpacing) {
                int seconds = (int)(cursor.millis / 1000.0);
                int minutes = seconds / 60;
                seconds -= 60 * minutes;
                if (labelSpacing.getMillis() < 1000.0) {
                    return String.format("%d:%02d:%03d", minutes, seconds, (int)(cursor.millis % 1000.0));
                }
                return String.format("%d:%02d", minutes, seconds);
            }
        };
        TEMPO_OPERATOR = new Operator(){

            @Override
            public boolean isZero(Cursor c) {
                return c.beatCount == 0 && c.beatBasis == 0.0;
            }

            @Override
            public boolean isBefore(Cursor c1, Cursor c2) {
                return (double)c1.beatCount + c1.beatBasis < (double)c2.beatCount + c2.beatBasis;
            }

            @Override
            public boolean isBeforeOrEqual(Cursor c1, Cursor c2) {
                return (double)c1.beatCount + c1.beatBasis <= (double)c2.beatCount + c2.beatBasis;
            }

            @Override
            public boolean isAfter(Cursor c1, Cursor c2) {
                return (double)c1.beatCount + c1.beatBasis > (double)c2.beatCount + c2.beatBasis;
            }

            @Override
            public boolean isAfterOrEqual(Cursor c1, Cursor c2) {
                return (double)c1.beatCount + c1.beatBasis >= (double)c2.beatCount + c2.beatBasis;
            }

            @Override
            public boolean isEqual(Cursor c1, Cursor c2) {
                return (double)c1.beatCount + c1.beatBasis == (double)c2.beatCount + c2.beatBasis;
            }

            @Override
            public boolean isInRange(Cursor c, Cursor before, Cursor after) {
                return LXUtils.inRange((double)c.beatCount + c.beatBasis, (double)before.beatCount + before.beatBasis, (double)after.beatCount + after.beatBasis);
            }

            @Override
            public double getRatio(Cursor c1, Cursor c2) {
                if (this.isZero(c2)) {
                    return 0.0;
                }
                return ((double)c1.beatCount + c1.beatBasis) / ((double)c2.beatCount + c2.beatBasis);
            }

            @Override
            public double getLerpFactor(Cursor cursor, Cursor pre, Cursor post) {
                double preBeatBasis = (double)pre.beatCount + pre.beatBasis;
                double postBeatBasis = (double)post.beatCount + post.beatBasis;
                if (preBeatBasis == postBeatBasis) {
                    return 0.0;
                }
                return ((double)cursor.beatCount + cursor.beatBasis - preBeatBasis) / (postBeatBasis - preBeatBasis);
            }

            @Override
            public double getLerpRatio(Cursor cursor, Cursor pre, Cursor post) {
                double preBeatBasis = (double)pre.beatCount + pre.beatBasis;
                double postBeatBasis = (double)post.beatCount + post.beatBasis;
                if (preBeatBasis == postBeatBasis) {
                    return 1.0;
                }
                return ((double)cursor.beatCount + cursor.beatBasis) / (postBeatBasis - preBeatBasis);
            }

            @Override
            public int compare(Cursor c1, Cursor c2) {
                double basis1 = (double)c1.beatCount + c1.beatBasis;
                double basis2 = (double)c2.beatCount + c2.beatBasis;
                if (basis1 == basis2) {
                    return 0;
                }
                return basis1 < basis2 ? -1 : 1;
            }

            private void _setMillisFromTempo(Cursor cursor, LXClip clip) {
                double millisPerBeat = 60000.0 / clip.referenceBpm.getValue();
                cursor.millis = ((double)cursor.beatCount + cursor.beatBasis) * millisPerBeat;
            }

            @Override
            public Cursor snap(Cursor cursor, LXClip clip, Cursor snapSize) {
                double snapBeatBasis = (double)snapSize.beatCount + snapSize.beatBasis;
                double multiple = Math.round(((double)cursor.beatCount + cursor.beatBasis) / snapBeatBasis);
                cursor._setBeatCountBasis(multiple * snapBeatBasis);
                this._setMillisFromTempo(cursor, clip);
                return cursor;
            }

            @Override
            public Cursor snapFloor(Cursor cursor, LXClip clip, Cursor snapSize) {
                double snapBeatBasis = (double)snapSize.beatCount + snapSize.beatBasis;
                double multiple = Math.floor(((double)cursor.beatCount + cursor.beatBasis) / snapBeatBasis);
                cursor._setBeatCountBasis(multiple * snapBeatBasis);
                this._setMillisFromTempo(cursor, clip);
                return cursor;
            }

            @Override
            public Cursor snapCeiling(Cursor cursor, LXClip clip, Cursor snapSize) {
                double snapBeatBasis = (double)snapSize.beatCount + snapSize.beatBasis;
                double multiple = Math.ceil(((double)cursor.beatCount + cursor.beatBasis) / snapBeatBasis);
                cursor._setBeatCountBasis(multiple * snapBeatBasis);
                this._setMillisFromTempo(cursor, clip);
                return cursor;
            }

            @Override
            public Cursor snapUp(Cursor cursor, LXClip clip, Cursor snapSize) {
                double snapBeatBasis = (double)snapSize.beatCount + snapSize.beatBasis;
                double snapUnits = ((double)cursor.beatCount + cursor.beatBasis) / snapBeatBasis;
                double decimal = snapUnits - (double)((long)snapUnits);
                double multiple = Math.ceil(snapUnits);
                if (decimal < 0.01 || 1.0 - decimal < 0.01) {
                    multiple += 1.0;
                }
                cursor._setBeatCountBasis(multiple * snapBeatBasis);
                this._setMillisFromTempo(cursor, clip);
                return cursor;
            }

            @Override
            public Cursor snapDown(Cursor cursor, LXClip clip, Cursor snapSize) {
                double snapBeatBasis = (double)snapSize.beatCount + snapSize.beatBasis;
                double snapUnits = ((double)cursor.beatCount + cursor.beatBasis) / snapBeatBasis;
                double decimal = snapUnits - (double)((long)snapUnits);
                double multiple = Math.floor(snapUnits);
                if (decimal < 0.01) {
                    multiple = LXUtils.max(0.0, multiple - 1.0);
                }
                cursor._setBeatCountBasis(multiple * snapBeatBasis);
                this._setMillisFromTempo(cursor, clip);
                return cursor;
            }

            @Override
            public String formatLabel(LXClip clip, Cursor cursor, Cursor labelSpacing) {
                int beatsPerBar = clip.getLX().engine.tempo.beatsPerBar.getValuei();
                int bars = 1 + cursor.beatCount / beatsPerBar;
                if (labelSpacing.getBeatCount() < beatsPerBar) {
                    int beats = 1 + cursor.beatCount % beatsPerBar;
                    int sixteenths = 1 + (int)(cursor.beatBasis / 0.25);
                    if (sixteenths > 1) {
                        return String.format("%d.%d.%d", bars, beats, sixteenths);
                    }
                    return String.format("%d.%d", bars, beats);
                }
                return String.format("%d", bars);
            }
        };
    }

    protected void assertMutable() {
    }

    public Cursor() {
    }

    protected Cursor(double millis, int beatCount, double beatBasis) {
        this._set(millis, beatCount, beatBasis);
    }

    private Cursor(Cursor that) {
        this.set(that);
    }

    public Cursor clone() {
        return new Cursor(this);
    }

    public Immutable immutable() {
        return this instanceof Immutable ? (Immutable)this : new Immutable(null, this.millis, this.beatCount, this.beatBasis);
    }

    public double getMillis() {
        return this.millis;
    }

    public int getBeatCount() {
        return this.beatCount;
    }

    public double getBeatBasis() {
        return this.beatBasis;
    }

    public Cursor constrain(LXClip clip) {
        return clip.CursorOp().constrain(this, clip);
    }

    public Cursor bound(LXClip clip) {
        return clip.CursorOp().bound(this, clip);
    }

    public void reset() {
        this.millis = 0.0;
        this.beatCount = 0;
        this.beatBasis = 0.0;
    }

    private void _setBeatCountBasis(double beatCountBasis) {
        this.beatCount = (int)beatCountBasis;
        this.beatBasis = beatCountBasis % 1.0;
    }

    private void _set(double millis, int beatCount, double beatBasis) {
        if (millis < 0.0 || beatCount < 0 || beatBasis < 0.0) {
            throw new IllegalArgumentException("May not set Cursor with negative value: " + millis + "/" + beatCount + "/" + beatBasis);
        }
        this.millis = millis;
        this.beatCount = beatCount;
        this.beatBasis = beatBasis;
    }

    public Cursor set(Cursor that) {
        this.assertMutable();
        this.millis = that.millis;
        this.beatCount = that.beatCount;
        this.beatBasis = that.beatBasis;
        return this;
    }

    public Cursor setLerp(Cursor from, Cursor to, double scale) {
        this.assertMutable();
        this.millis = LXUtils.lerp(from.millis, to.millis, scale);
        this._setBeatCountBasis(LXUtils.lerp((double)from.beatCount + from.beatBasis, (double)to.beatCount + to.beatBasis, scale));
        return this;
    }

    public Cursor scale(double factor) {
        if (factor < 0.0) {
            throw new IllegalArgumentException("May not scale Cursor by negative factor");
        }
        Cursor that = this.clone();
        that.millis = this.millis * factor;
        that._setBeatCountBasis(((double)this.beatCount + this.beatBasis) * factor);
        return that;
    }

    public Cursor scaleInt(int factor) {
        if (factor < 0) {
            throw new IllegalArgumentException("May not scale Cursor by negative factor");
        }
        Cursor that = this.clone();
        that.millis = this.millis * (double)factor;
        that.beatCount = this.beatCount * factor;
        double beatBasis = this.beatBasis * (double)factor;
        that.beatCount += (int)beatBasis;
        that.beatBasis = beatBasis % 1.0;
        return that;
    }

    public Cursor advance(Cursor that) {
        return this._add(that);
    }

    public Cursor add(Cursor that) {
        return this.clone()._add(that);
    }

    private Cursor _add(Cursor that) {
        this.assertMutable();
        this.millis += that.millis;
        this.beatCount += that.beatCount;
        this.beatBasis += that.beatBasis;
        if (this.beatBasis >= 1.0) {
            ++this.beatCount;
            this.beatBasis %= 1.0;
        }
        return this;
    }

    public Cursor inc(Cursor that, boolean add) {
        return add ? this.add(that) : this.subtract(that);
    }

    public Cursor subtract(Cursor that) {
        return this.clone()._subtract(that);
    }

    Cursor _subtract(Cursor that) {
        this.assertMutable();
        this.millis -= that.millis;
        this.beatCount -= that.beatCount;
        this.beatBasis -= that.beatBasis;
        if (this.beatBasis < 0.0) {
            --this.beatCount;
            this.beatBasis += 1.0;
        }
        if (this.millis < 0.0) {
            LX.error(new Exception("Bogus Cursor subtraction producing a negative: " + String.valueOf(this) + " - " + String.valueOf(that)));
            this.millis = 0.0;
        }
        if (this.beatCount < 0 || this.beatBasis < 0.0) {
            LX.error(new Exception("Bogus Cursor subtraction producing a negative: " + String.valueOf(this) + " - " + String.valueOf(that)));
            this.beatCount = 0;
            this.beatBasis = 0.0;
        }
        return this;
    }

    public double getDeltaMillis(Cursor that) {
        return this.millis - that.millis;
    }

    public String toString() {
        return String.format("%.2f/%d/%.2f", this.millis, this.beatCount, this.beatBasis);
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        obj.addProperty(KEY_MILLIS, (Number)this.millis);
        obj.addProperty(KEY_BEAT_COUNT, (Number)this.beatCount);
        obj.addProperty(KEY_BEAT_BASIS, (Number)this.beatBasis);
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        if (obj.has(KEY_MILLIS)) {
            this.millis = obj.get(KEY_MILLIS).getAsDouble();
        }
        if (obj.has(KEY_BEAT_COUNT)) {
            this.beatCount = obj.get(KEY_BEAT_COUNT).getAsInt();
        }
        if (obj.has(KEY_BEAT_BASIS)) {
            this.beatBasis = obj.get(KEY_BEAT_BASIS).getAsDouble();
        }
    }

    public static class Immutable
    extends Cursor {
        private final String name;

        private Immutable(String name, double millis) {
            this(name, millis, 0, 0.0);
        }

        private Immutable(String name, double millis, int beatCount, double beatBasis) {
            super(millis, beatCount, beatBasis);
            this.name = name;
        }

        @Override
        protected void assertMutable() {
            throw new UnsupportedOperationException("Cannot modify Immutable cursor: " + this.name);
        }
    }

    public static interface Operator
    extends Comparator<Cursor> {
        public boolean isZero(Cursor var1);

        public boolean isBefore(Cursor var1, Cursor var2);

        public boolean isBeforeOrEqual(Cursor var1, Cursor var2);

        public boolean isAfter(Cursor var1, Cursor var2);

        public boolean isAfterOrEqual(Cursor var1, Cursor var2);

        public boolean isEqual(Cursor var1, Cursor var2);

        public boolean isInRange(Cursor var1, Cursor var2, Cursor var3);

        public double getRatio(Cursor var1, Cursor var2);

        public double getLerpFactor(Cursor var1, Cursor var2, Cursor var3);

        public double getLerpRatio(Cursor var1, Cursor var2, Cursor var3);

        default public Cursor min(Cursor c1, Cursor c2) {
            return this.isBeforeOrEqual(c1, c2) ? c1 : c2;
        }

        default public Cursor max(Cursor c1, Cursor c2) {
            return this.isBeforeOrEqual(c1, c2) ? c2 : c1;
        }

        default public Cursor constrain(Cursor cursor, LXClip clip) {
            return this.constrain(cursor, ZERO, clip.length.cursor);
        }

        default public Cursor constrain(Cursor cursor, Cursor max) {
            return this.constrain(cursor, ZERO, max);
        }

        default public Cursor constrain(Cursor cursor, Cursor min, Cursor max) {
            if (this.isBefore(cursor, min)) {
                cursor.set(min);
            } else if (this.isAfter(cursor, max)) {
                cursor.set(max);
            }
            return cursor;
        }

        default public Cursor bound(Cursor cursor, LXClip clip) {
            return this.bound(cursor, ZERO, clip.length.cursor);
        }

        default public Cursor bound(Cursor cursor, Cursor max) {
            return this.bound(cursor, ZERO, max);
        }

        default public Cursor bound(Cursor cursor, Cursor min, Cursor max) {
            if (this.isBefore(cursor, min)) {
                return min;
            }
            if (this.isAfter(cursor, max)) {
                return max;
            }
            return cursor;
        }

        public Cursor snap(Cursor var1, LXClip var2, Cursor var3);

        public Cursor snapFloor(Cursor var1, LXClip var2, Cursor var3);

        public Cursor snapCeiling(Cursor var1, LXClip var2, Cursor var3);

        public Cursor snapUp(Cursor var1, LXClip var2, Cursor var3);

        public Cursor snapDown(Cursor var1, LXClip var2, Cursor var3);

        default public Cursor applyDelta(Cursor cursor, Cursor delta, boolean add) {
            if (!add) {
                delta = this.bound(delta, cursor);
            }
            return cursor.inc(delta, add);
        }

        public String formatLabel(LXClip var1, Cursor var2, Cursor var3);
    }

    public static enum TimeBase {
        ABSOLUTE("Absolute", ABSOLUTE_OPERATOR),
        TEMPO("Tempo", TEMPO_OPERATOR);

        public final String label;
        public final Operator operator;

        private TimeBase(String label, Operator operations) {
            this.label = label;
            this.operator = operations;
        }

        public String toString() {
            return this.label;
        }
    }
}

