/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import heronarts.lx.LX;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.MidiNoteClipLane;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.mixer.LXAbstractChannel;

public abstract class LXAbstractChannelClip
extends LXClip
implements LXAbstractChannel.MidiListener {
    public final LXAbstractChannel channel;
    public final MidiNoteClipLane midiNoteLane = new MidiNoteClipLane(this);

    protected LXAbstractChannelClip(LX lx, LXAbstractChannel channel, int index, boolean registerListener) {
        super(lx, channel, index, registerListener);
        this.channel = channel;
        this.mutableLanes.add(this.midiNoteLane);
        this.registerParameter(channel.fader);
        this.registerParameter(channel.enabled);
        channel.addMidiListener(this);
    }

    @Override
    protected void onStopPlayback() {
        super.onStopPlayback();
        this.midiNoteLane.onStopPlayback();
    }

    @Override
    protected void onStopRecording() {
        super.onStopRecording();
        this.midiNoteLane.onStopRecording();
    }

    @Override
    public void midiReceived(LXAbstractChannel channel, LXShortMessage message) {
        if (message instanceof MidiNote) {
            MidiNote note = (MidiNote)message;
            if (this.isRecording()) {
                this.midiNoteLane.recordNote(note);
            }
        }
    }

    @Override
    public void dispose() {
        this.unregisterParameter(this.channel.fader);
        this.unregisterParameter(this.channel.enabled);
        this.channel.removeMidiListener(this);
        super.dispose();
    }
}

