/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.clip.LXAbstractChannelClip;
import heronarts.lx.clip.PatternClipEvent;
import heronarts.lx.clip.PatternClipLane;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.pattern.LXPattern;

public class LXChannelClip
extends LXAbstractChannelClip
implements LXChannel.Listener {
    public final LXChannel channel;
    public final PatternClipLane patternLane;
    private final LXPattern.Listener patternEffectListener = new LXPattern.Listener(){

        @Override
        public void effectAdded(LXPattern pattern, LXEffect effect) {
            LXChannelClip.this.registerComponent(effect);
        }

        @Override
        public void effectRemoved(LXPattern pattern, LXEffect effect) {
            LXChannelClip.this.unregisterComponent(effect);
        }

        @Override
        public void effectMoved(LXPattern pattern, LXEffect effect) {
        }
    };

    public LXChannelClip(LX lx, LXChannel channel, int index) {
        super(lx, channel, index, false);
        this.channel = channel;
        this.patternLane = new PatternClipLane(this);
        this.mutableLanes.add(this.patternLane);
        channel.addListener(this);
        for (LXPattern pattern : channel.patterns) {
            this.registerPattern(pattern);
        }
    }

    protected void registerPattern(LXPattern pattern) {
        this.registerComponent(pattern);
        for (LXEffect effect : pattern.effects) {
            this.registerComponent(effect);
        }
        pattern.addListener(this.patternEffectListener);
    }

    protected void unregisterPattern(LXPattern pattern) {
        this.unregisterComponent(pattern);
        for (LXEffect effect : pattern.effects) {
            this.unregisterComponent(effect);
        }
        pattern.removeListener(this.patternEffectListener);
    }

    @Override
    public void dispose() {
        this.channel.removeListener(this);
        for (LXPattern pattern : this.channel.patterns) {
            this.unregisterPattern(pattern);
        }
        super.dispose();
    }

    @Override
    protected void onStartRecording(boolean isOverdub) {
        LXPattern targetPattern;
        if (this.channel.compositeMode.getEnum() == LXChannel.CompositeMode.PLAYLIST && (targetPattern = this.channel.getTargetPattern()) != null) {
            PatternClipEvent previousPattern = (PatternClipEvent)this.patternLane.getPreviousEvent(this.cursor);
            if (!isOverdub || previousPattern != null && previousPattern.getPattern() != targetPattern) {
                this.patternLane.recordEvent(new PatternClipEvent(this.patternLane, targetPattern));
            }
        }
    }

    @Override
    public void patternAdded(LXChannel channel, LXPattern pattern) {
        this.registerPattern(pattern);
    }

    @Override
    public void patternRemoved(LXChannel channel, LXPattern pattern) {
        this.unregisterPattern(pattern);
    }

    @Override
    public void patternWillChange(LXChannel channel, LXPattern pattern, LXPattern nextPattern) {
        if (this.isRecording()) {
            this.patternLane.recordPatternEvent(nextPattern);
        }
    }

    @Override
    protected void loadLane(LX lx, String laneType, JsonObject laneObj) {
        if (laneType.equals("pattern")) {
            this.patternLane.load(lx, laneObj);
        } else if (laneType.equals("midiNote")) {
            this.midiNoteLane.load(lx, laneObj);
        } else {
            super.loadLane(lx, laneType, laneObj);
        }
    }
}

