/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXDeviceComponent;
import heronarts.lx.LXLayeredComponent;
import heronarts.lx.LXPath;
import heronarts.lx.LXRunnableComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.Tempo;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.LXClipLane;
import heronarts.lx.clip.ParameterClipEvent;
import heronarts.lx.clip.ParameterClipLane;
import heronarts.lx.effect.LXEffect;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXListenableNormalizedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.parameter.QuantizedTriggerParameter;
import heronarts.lx.snapshot.LXClipSnapshot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class LXClip
extends LXRunnableComponent
implements LXOscComponent,
LXComponent.Renamable,
LXBus.Listener {
    private final List<Listener> listeners = new ArrayList<Listener>();
    public final Cursor cursor = new Cursor();
    public final Cursor launchFromCursor = new Cursor();
    private final Cursor nextCursor = new Cursor();
    private final List<CursorParameter> cursorParameters = new ArrayList<CursorParameter>();
    public final EnumParameter<Cursor.TimeBase> timeBase = new EnumParameter<Cursor.TimeBase>("Time Base", Cursor.TimeBase.ABSOLUTE).setDescription("Whether clip timing is absolute or tempo-based");
    public final CursorParameter length = new CursorParameter("Length").setDescription("The length of the clip");
    public final BooleanParameter loop = new BooleanParameter("Loop").setDescription("Whether to loop the clip");
    public final CursorParameter loopStart = new CursorParameter("Loop Start").setDescription("Where the clip will loop to when loop is enabled");
    public final CursorParameter loopEnd = new CursorParameter("Loop End").setDescription("End of the loop in milliseconds");
    public final CursorParameter loopLength = new CursorParameter("Loop Length").setDescription("Length of the loop in milliseconds");
    public final CursorParameter playStart = new CursorParameter("Play Start").setDescription("Where the loop will start playing when it is launched");
    public final CursorParameter playEnd = new CursorParameter("Play End").setDescription("Where an unlooped clip will stop playing");
    public final QuantizedTriggerParameter launch = new QuantizedTriggerParameter.Launch(this.lx, "Launch", this::_launch).onSchedule(this::_launchAutomationScheduled).setDescription("Launch this clip");
    public final QuantizedTriggerParameter launchAutomation = new QuantizedTriggerParameter.Launch(this.lx, "Launch", this::_launchAutomation).onSchedule(this::_launchAutomationScheduled);
    public final QuantizedTriggerParameter stop = new QuantizedTriggerParameter.Launch(this.lx, "Stop", this::_launchStop).setDescription("Stop this clip");
    protected final List<LXClipLane<?>> mutableLanes = new ArrayList();
    public final List<LXClipLane<?>> lanes = Collections.unmodifiableList(this.mutableLanes);
    public final BooleanParameter snapshotEnabled = new BooleanParameter("Snapshot", false).setDescription("Whether snapshot recall is enabled for this clip");
    public final BooleanParameter snapshotTransitionEnabled = new BooleanParameter("Transition", true).setDescription("Whether snapshot transition is enabled for this clip");
    public final BooleanParameter automationEnabled = new BooleanParameter("Automation", false).setDescription("Whether automation playback is enabled for this clip");
    public final BooleanParameter customSnapshotTransition = new BooleanParameter("Custom Snapshot Transition").setDescription("Whether to use custom snapshot transition settings for this clip");
    public final BoundedParameter referenceBpm = new BoundedParameter("Reference BPM", 120.0, 20.0, 240.0).setOscMode(LXNormalizedParameter.OscMode.ABSOLUTE).setDescription("Reference BPM of the clip");
    public final EnumParameter<ClipView> clipView = new EnumParameter<ClipView>("Clip View", ClipView.AUTOMATION);
    public final MutableParameter zoom = new MutableParameter("Zoom", 1.0);
    public final LXBus bus;
    public final LXClipSnapshot snapshot;
    private final Cursor startTransportReference = new Cursor();
    private final Cursor startCursorReference = new Cursor();
    private boolean hasTimeline = false;
    private int index;
    private final boolean busListener;
    private final LXParameterListener parameterRecorder = this::recordParameterChange;
    private boolean isQuantizedLaunch = false;
    private Tempo.Division isQuantizedStop = null;
    private boolean isRecording = false;
    private boolean isOverdubExtension = false;
    private final Map<LXNormalizedParameter, Double> parameterDefaults = new HashMap<LXNormalizedParameter, Double>();
    private final Map<LXComponent, List<LXComponent>> registeredChildren = new HashMap<LXComponent, List<LXComponent>>();
    private static final String KEY_LANES = "parameterLanes";
    public static final String KEY_INDEX = "index";
    private boolean inLoad = false;

    public final Cursor.Operator CursorOp() {
        return this.timeBase.getEnum().operator;
    }

    private void recordParameterChange(LXParameter p) {
        LXListenableNormalizedParameter parameter;
        ParameterClipLane lane;
        if (this.isRecording() && !(lane = this.getParameterLane(parameter = (LXListenableNormalizedParameter)p, true)).isInPlayback() && lane.shouldRecordParameterChange(parameter)) {
            lane.recordParameterEvent(new ParameterClipEvent(lane));
        }
    }

    public LXClip(LX lx, LXBus bus, int index) {
        this(lx, bus, index, true);
    }

    protected LXClip(LX lx, LXBus bus, int index, boolean registerListener) {
        super(lx);
        this.label.setDescription("The name of this clip");
        this.bus = bus;
        this.index = index;
        this.busListener = registerListener;
        this.setParent(this.bus);
        this.referenceBpm.setValue(lx.engine.tempo.bpm.getValue());
        this.addParameter("referenceBpm", this.referenceBpm);
        this.timeBase.setValue((Object)lx.engine.clips.timeBaseDefault.getEnum());
        this.addParameter("timeBase", this.timeBase);
        this.addParameter("launch", this.launch);
        this.addParameter("stop", this.stop);
        this.addParameter("loop", this.loop);
        this.addParameter("length", this.length);
        this.addParameter("loopStart", this.loopStart);
        this.addParameter("loopLength", this.loopLength);
        this.addParameter("playStart", this.playStart);
        this.addParameter("playEnd", this.playEnd);
        this.addParameter("snapshotEnabled", this.snapshotEnabled);
        this.addParameter("snapshotTransitionEnabled", this.snapshotTransitionEnabled);
        this.addParameter("automationEnabled", this.automationEnabled);
        this.addParameter("customSnapshotTransition", this.customSnapshotTransition);
        this.addInternalParameter("clipView", this.clipView);
        this.addInternalParameter("launchAutomation", this.launchAutomation);
        this.addInternalParameter("zoom", this.zoom);
        this.snapshot = new LXClipSnapshot(lx, this);
        this.addChild("snapshot", this.snapshot);
        this.addArray("lane", this.lanes);
        for (LXEffect effect : bus.effects) {
            this.registerComponent(effect);
        }
        if (registerListener) {
            bus.addListener(this);
        }
        bus.arm.addListener(this);
    }

    public Cursor.TimeBase getTimeBase() {
        return this.timeBase.getEnum();
    }

    public boolean isPending() {
        return this.launch.pending.isOn() || this.launchAutomation.pending.isOn();
    }

    public LXClip launch() {
        this.launchFromCursor.set(this.playStart.cursor);
        this.launch.trigger();
        return this;
    }

    public LXClip launchAutomation() {
        return this.launchAutomationFrom(this.playStart.cursor);
    }

    public LXClip launchAutomationFrom(Cursor cursor) {
        this.launchFromCursor.set(cursor.bound(this));
        this.launchAutomation.trigger();
        return this;
    }

    public LXClip launchAutomationFromCursor() {
        return this.launchAutomationFrom(this.cursor);
    }

    public LXClip playFrom(Cursor cursor) {
        if (!this.isRunning() && this.hasTimeline) {
            this._playFrom(cursor);
        }
        return this;
    }

    private void _playFrom(Cursor cursor) {
        if (this.hasTimeline) {
            this.launchFromCursor.set(this.CursorOp().bound(cursor, this));
            this.trigger();
        }
    }

    public LXClip playFromCursor() {
        return this.playFrom(this.cursor);
    }

    public LXClip triggerAction(boolean focus) {
        return this.triggerAction(focus, true);
    }

    public LXClip triggerAction(boolean focus, boolean fromGrid) {
        if (this.isRecording()) {
            this.stop();
        } else {
            if (!fromGrid) {
                if (this.isRunning()) {
                    this.stop();
                } else {
                    this._playFrom(this.playStart.cursor);
                }
            } else if (this.isRunning()) {
                this.launchAutomation();
            } else {
                this.launch();
            }
            if (focus) {
                this.lx.engine.clips.focusedClip.setClip(this);
            }
        }
        return this;
    }

    @Override
    public String getPath() {
        return "clip/" + (this.index + 1);
    }

    private void _launchAutomationScheduled() {
        for (LXClip clip : this.bus.clips) {
            if (clip == null || clip == this) continue;
            clip.launch.cancel();
            clip.launchAutomation.cancel();
        }
    }

    private void _launch(boolean quantized) {
        this.launchFromCursor.set(this.playStart.cursor.bound(this));
        this._launchAutomation(quantized);
        if (!this.isArmed() && this.snapshotEnabled.isOn()) {
            this.snapshot.recall();
        }
    }

    private void _launchAutomation(boolean quantized) {
        this.isQuantizedLaunch = quantized;
        this.trigger.trigger();
    }

    private void _launchStop(boolean quantized) {
        if (this.isRunning()) {
            Tempo.Division division = this.isQuantizedStop = quantized && this.timeBase.getEnum() == Cursor.TimeBase.TEMPO ? this.lx.engine.tempo.getLaunchQuantization() : null;
            if (this.isQuantizedStop == null) {
                this.stop();
            }
        }
    }

    private void setTransportReference(boolean quantize) {
        this.setTransportReference(this.constructTransportCursor(), quantize);
    }

    private void setTransportReference(Cursor transportCursor, boolean quantize) {
        if (quantize) {
            this.snapLaunchQuantization(transportCursor, true);
        }
        this.startTransportReference.set(transportCursor);
        this.startCursorReference.set(this.cursor);
    }

    private void launchTransport() {
        this.setCursor(this.launchFromCursor.constrain(this));
        this.setTransportReference(this.isQuantizedLaunch);
        this.isQuantizedLaunch = false;
    }

    @Override
    protected final void onTrigger() {
        super.onTrigger();
        if (this.isRunning()) {
            Cursor from = this.cursor.clone();
            this.launchTransport();
            if (!this.CursorOp().isEqual(from, this.cursor)) {
                this.jumpCursor(from, this.cursor);
            }
        }
    }

    @Override
    public void dispose() {
        for (LXEffect effect : this.bus.effects) {
            this.unregisterComponent(effect);
        }
        if (this.busListener) {
            this.bus.removeListener(this);
        }
        this.bus.arm.removeListener(this);
        int i = this.lanes.size() - 1;
        while (i >= 0) {
            this._removeLane(this.lanes.get(i));
            --i;
        }
        LX.dispose(this.snapshot);
        super.dispose();
        this.listeners.forEach(listener -> LX.warning("Stranded LXClip.Listener: " + String.valueOf(listener)));
        this.listeners.clear();
    }

    public double getLength() {
        return this.length.getValue();
    }

    private ParameterClipLane getParameterLane(LXNormalizedParameter parameter, boolean create) {
        return this.getParameterLane(parameter, create, -1);
    }

    private ParameterClipLane getParameterLane(LXNormalizedParameter parameter, boolean create, int index) {
        for (LXClipLane<?> lXClipLane : this.lanes) {
            if (!(lXClipLane instanceof ParameterClipLane) || ((ParameterClipLane)lXClipLane).parameter != parameter) continue;
            return (ParameterClipLane)lXClipLane;
        }
        if (create) {
            ParameterClipLane parameterClipLane = ParameterClipLane.create(this, parameter, this.parameterDefaults.get(parameter));
            if (index < 0) {
                this.mutableLanes.add(parameterClipLane);
            } else {
                this.mutableLanes.add(index, parameterClipLane);
            }
            for (Listener listener : this.listeners) {
                listener.parameterLaneAdded(this, parameterClipLane);
            }
            return parameterClipLane;
        }
        return null;
    }

    private LXClip _removeLane(LXClipLane<?> lane) {
        this.mutableLanes.remove(lane);
        if (lane instanceof ParameterClipLane) {
            for (Listener listener : this.listeners) {
                listener.parameterLaneRemoved(this, (ParameterClipLane)lane);
            }
        }
        LX.dispose(lane);
        return this;
    }

    public LXClip removeParameterLane(ParameterClipLane lane) {
        return this._removeLane(lane);
    }

    public LXClip moveClipLane(LXClipLane<?> lane, int index) {
        this.mutableLanes.remove(lane);
        this.mutableLanes.add(index, lane);
        for (Listener listener : this.listeners) {
            listener.clipLaneMoved(this, lane, index);
        }
        return this;
    }

    public LXClip addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXClip.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Already registered LXClip.Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public LXClip removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-registered LXClip.Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    protected void setCursor(CursorParameter timestamp) {
        this.setCursor(timestamp.cursor);
    }

    protected void setCursor(Cursor cursor) {
        if (!this.cursor.equals(cursor)) {
            this.cursor.set(cursor);
            for (Listener listener : this.listeners) {
                listener.cursorChanged(this, this.cursor);
            }
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public boolean isArmed() {
        return this.bus.arm.isOn();
    }

    public boolean isRecording() {
        return this.isRunning() && this.bus.arm.isOn();
    }

    public boolean isOverdub() {
        return this.isRecording() && this.hasTimeline;
    }

    public LXClip setLoopStart(Cursor loopStart) {
        loopStart = this.CursorOp().bound(loopStart, this.loopEnd.cursor.subtract(Cursor.MIN_LOOP));
        if (this.CursorOp().isAfter(loopStart, this.loopStart.cursor)) {
            this.loopLength.set(this.loopEnd.cursor.subtract(loopStart));
            this.loopStart.set(loopStart);
        } else {
            Cursor newLength = this.loopEnd.cursor.subtract(loopStart);
            this.loopStart.set(loopStart);
            this.loopLength.set(newLength);
        }
        return this;
    }

    public LXClip setLoopBrace(Cursor loopBrace) {
        Cursor oldEnd = this.loopEnd.cursor.clone();
        Cursor.Immutable max = this.CursorOp().isBefore(this.loopLength.cursor, this.length.cursor) ? this.length.cursor.subtract(this.loopLength.cursor) : Cursor.ZERO;
        loopBrace = this.CursorOp().bound(loopBrace, max);
        this.loopStart.set(loopBrace);
        this.captureCursorWithLoopMove(oldEnd);
        return this;
    }

    public LXClip setLoopEnd(Cursor loopEnd) {
        Cursor oldEnd = this.loopEnd.cursor.clone();
        loopEnd = this.CursorOp().bound(loopEnd, this.loopStart.cursor, this.length.cursor);
        this.loopLength.set(this.CursorOp().bound(loopEnd.subtract(this.loopStart.cursor), Cursor.MIN_LOOP, this.length.cursor.subtract(this.loopStart.cursor)));
        this.captureCursorWithLoopMove(oldEnd);
        return this;
    }

    public LXClip setLoopLength(Cursor loopLength) {
        return this.setLoopEnd(this.loopStart.cursor.add(loopLength));
    }

    public LXClip setPlayStart(Cursor playStart) {
        playStart = this.CursorOp().isAfter(this.playEnd.cursor, Cursor.MIN_LOOP) ? this.CursorOp().bound(playStart, this.playEnd.cursor.subtract(Cursor.MIN_LOOP)) : Cursor.ZERO;
        this.playStart.set(playStart);
        return this;
    }

    public LXClip setPlayEnd(Cursor playEnd) {
        Cursor oldEnd = this.playEnd.cursor.clone();
        playEnd = this.CursorOp().bound(playEnd, this.playStart.cursor.add(Cursor.MIN_LOOP), this.length.cursor);
        this.playEnd.set(playEnd);
        if (!this.loop.isOn() && this.isRunning() && !this.bus.arm.isOn() && this.CursorOp().isBefore(this.cursor, oldEnd) && this.CursorOp().isAfter(this.cursor, this.playEnd.cursor)) {
            this.stop();
        }
        return this;
    }

    private void captureCursorWithLoopMove(Cursor oldEnd) {
        if (this.loop.isOn() && this.isRunning() && !this.bus.arm.isOn() && this.CursorOp().isBefore(this.cursor, oldEnd) && this.CursorOp().isAfter(this.cursor, this.loopEnd.cursor)) {
            this.playCursor(this.cursor, oldEnd, true);
            this.setCursor(this.loopStart);
            this.setTransportReference(false);
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.bus.arm) {
            if (this.isRunning()) {
                if (this.bus.arm.isOn()) {
                    if (this.hasTimeline) {
                        this.startHotOverdub();
                    } else {
                        this.startHotFirstRecording();
                    }
                } else if (this.isRecording) {
                    if (this.hasTimeline) {
                        this.stopHotOverdub();
                    } else {
                        this.stopHotFirstRecording();
                    }
                }
            }
        } else if (p == this.automationEnabled) {
            if (!this.automationEnabled.isOn() && this.isRecording) {
                this.stop();
            }
        } else if (p == this.loopStart || p == this.loopLength) {
            this.loopEnd.set(this.loopStart.cursor.add(this.loopLength.cursor));
        } else if (p == this.snapshotEnabled && this.snapshotEnabled.isOn() && !this.inLoad) {
            this.snapshot.initialize();
        }
    }

    @Override
    protected final void onStart() {
        for (LXClip lXClip : this.bus.clips) {
            if (lXClip == null || lXClip == this) continue;
            lXClip.stop();
        }
        this.bus.onClipStart(this);
        this.launchTransport();
        for (LXClipLane lXClipLane : this.lanes) {
            lXClipLane.initializeCursorPlayback(this.cursor);
        }
        if (this.bus.arm.isOn()) {
            this.isRecording = true;
            if (this.hasTimeline) {
                this.startOverdub();
            } else {
                this.startFirstRecording();
            }
        } else {
            this.isRecording = false;
            this.startPlayback();
        }
    }

    @Override
    protected final void onStop() {
        super.onStop();
        if (this.isRecording) {
            this.isRecording = false;
            this.bus.arm.setValue(false);
            if (!this.hasTimeline) {
                this.stopFirstRecording();
            } else {
                this.stopOverdub();
            }
        } else {
            this.stopPlayback();
        }
        this.isOverdubExtension = false;
        this.snapshot.stopTransition();
        this.bus.onClipStop(this);
    }

    private void _startRecording(boolean isOverdub) {
        this.automationEnabled.setValue(true);
        this.updateParameterDefaults();
        this.resetRecordingState();
        this.onStartRecording(isOverdub);
    }

    private void startFirstRecording() {
        this.cursor.reset();
        this.length.reset();
        this.loopLength.reset();
        this.loopStart.reset();
        this.playStart.reset();
        this.playEnd.reset();
        this._startRecording(false);
    }

    private void startHotFirstRecording() {
        this.startFirstRecording();
        this.setTransportReference(false);
    }

    private void startOverdub() {
        this._startRecording(true);
    }

    private void startHotOverdub() {
        this.isRecording = true;
        this.startOverdub();
    }

    private void resetRecordingState() {
        this.isOverdubExtension = false;
        this.lanes.forEach(lane -> lane.resetRecordingState());
    }

    private void startPlayback() {
    }

    private void setRecordingLength(Cursor length, boolean isOverdub, boolean hotStop) {
        if (this.timeBase.getEnum() == Cursor.TimeBase.TEMPO && this.lx.engine.tempo.hasLaunchQuantization()) {
            this.setQuantizedRecordingLength(length, isOverdub, hotStop);
        } else {
            this.length.set(length);
        }
    }

    private void setQuantizedRecordingLength(Cursor length, boolean isOverdub, boolean hotStop) {
        Cursor.Operator CursorOp = this.CursorOp();
        Cursor snapSize = this.constructTempoCursor(this.lx.engine.tempo.getLaunchQuantization());
        Cursor snap = this.CursorOp().snap(length.clone(), this, snapSize);
        if (CursorOp.isBefore(snap, length)) {
            for (LXClipLane<?> lane : this.lanes) {
                if (lane.events.isEmpty()) continue;
                LXClipEvent lastEvent = (LXClipEvent)lane.events.get(lane.events.size() - 1);
                if (!CursorOp.isAfter(lastEvent.cursor, snap)) continue;
                snap = this.CursorOp().snapCeiling(length.clone(), this, this.constructTempoCursor(this.lx.engine.tempo.getLaunchQuantization()));
                break;
            }
        }
        this.length.set(snap);
        this.playEnd.set(this.length);
        if (isOverdub) {
            if (hotStop) {
                this.cursor.bound(this);
            } else {
                this.cursor.set(this.length.cursor);
            }
        } else {
            this.loop.setValue(true);
            if (hotStop) {
                if (CursorOp.isAfter(this.cursor, this.length.cursor)) {
                    this.cursor.set(this.cursor.subtract(this.length.cursor));
                    this.setTransportReference(false);
                }
            } else {
                this.cursor.set(this.length.cursor);
            }
        }
    }

    private void _stopFirstRecording(boolean hotStop) {
        this.loopStart.reset();
        this.playStart.reset();
        this.setRecordingLength(this.cursor, false, hotStop);
        this.loopLength.set(this.length);
        this.playEnd.set(this.length);
        this.hasTimeline = true;
        this.resetRecordingState();
        this.onStopRecording();
    }

    private void stopFirstRecording() {
        this._stopFirstRecording(false);
    }

    private void stopHotFirstRecording() {
        this._stopFirstRecording(true);
    }

    private void _stopOverdub(boolean hotStop) {
        if (this.isOverdubExtension) {
            this.setRecordingLength(this.cursor, true, hotStop);
        }
        this.resetRecordingState();
        this.onStopRecording();
    }

    private void stopOverdub() {
        this._stopOverdub(false);
    }

    private void stopHotOverdub() {
        this._stopOverdub(true);
        this.isRecording = false;
    }

    private void stopPlayback() {
        this.onStopPlayback();
    }

    protected void onStartRecording(boolean isOverdub) {
    }

    protected void onStopRecording() {
    }

    protected void onStopPlayback() {
    }

    private void clearLanes() {
        Iterator<LXClipLane<?>> iter = this.mutableLanes.iterator();
        while (iter.hasNext()) {
            LXClipLane<?> lane = iter.next();
            if (lane instanceof ParameterClipLane) {
                iter.remove();
                for (Listener listener : this.listeners) {
                    listener.parameterLaneRemoved(this, (ParameterClipLane)lane);
                }
                LX.dispose(lane);
                continue;
            }
            lane.clear();
        }
    }

    private void updateParameterDefaults() {
        for (LXNormalizedParameter p : this.parameterDefaults.keySet()) {
            double defaultValue = p.getBaseNormalized();
            this.parameterDefaults.put(p, defaultValue);
            ParameterClipLane lane = this.getParameterLane(p, false);
            if (lane == null) continue;
            lane.updateDefaultValue(defaultValue);
        }
    }

    protected void registerParameter(LXListenableNormalizedParameter p) {
        this.parameterDefaults.put(p, p.getBaseNormalized());
        p.addListener(this.parameterRecorder);
    }

    protected void unregisterParameter(LXListenableNormalizedParameter p) {
        this.parameterDefaults.remove(p);
        p.removeListener(this.parameterRecorder);
    }

    private List<LXComponent> _registeredChildren(LXComponent component) {
        List<LXComponent> list = this.registeredChildren.get(component);
        if (list == null) {
            list = new ArrayList<LXComponent>();
            this.registeredChildren.put(component, list);
        }
        return list;
    }

    protected void registerComponent(LXComponent component) {
        for (LXParameter p : component.getParameters()) {
            if (!(p instanceof LXListenableNormalizedParameter)) continue;
            this.registerParameter((LXListenableNormalizedParameter)p);
        }
        List<LXComponent> registeredChildren = this._registeredChildren(component);
        if (component instanceof LXLayeredComponent) {
            LXLayeredComponent layered = (LXLayeredComponent)component;
            layered.getLayers().forEach(layer -> {
                registeredChildren.add((LXComponent)layer);
                this.registerComponent((LXComponent)layer);
            });
        }
        if (component instanceof LXDeviceComponent) {
            LXDeviceComponent device = (LXDeviceComponent)component;
            device.automationChildren.values().forEach(child -> {
                registeredChildren.add((LXComponent)child);
                this.registerComponent((LXComponent)child);
            });
        }
    }

    public List<ParameterClipLane> findClipLanes(LXComponent component) {
        ArrayList<ParameterClipLane> removedLanes = null;
        for (LXClipLane<?> lane : this.mutableLanes) {
            if (!(lane instanceof ParameterClipLane)) continue;
            ParameterClipLane parameterLane = (ParameterClipLane)lane;
            if (!parameterLane.parameter.isDescendant(component)) continue;
            if (removedLanes == null) {
                removedLanes = new ArrayList<ParameterClipLane>();
            }
            removedLanes.add(parameterLane);
        }
        return removedLanes;
    }

    protected void unregisterComponent(LXComponent component) {
        for (LXParameter p : component.getParameters()) {
            if (!(p instanceof LXListenableNormalizedParameter)) continue;
            this.unregisterParameter((LXListenableNormalizedParameter)p);
            ParameterClipLane lane = this.getParameterLane((LXNormalizedParameter)p, false);
            if (lane == null) continue;
            this._removeLane(lane);
        }
        List<LXComponent> registeredChildren = this.registeredChildren.remove(component);
        if (registeredChildren != null) {
            registeredChildren.forEach(child -> this.unregisterComponent((LXComponent)child));
        }
    }

    public int getIndex() {
        return this.index;
    }

    public LXClip setIndex(int index) {
        this.index = index;
        return this;
    }

    private void jumpCursor(Cursor from, Cursor to) {
        this.lanes.forEach(lane -> lane.jumpCursor(from, to));
    }

    private void loopCursor(Cursor from, Cursor to) {
        this.lanes.forEach(lane -> lane.loopCursor(from, to));
    }

    private void playCursor(Cursor from, Cursor to, boolean inclusive) {
        this.lanes.forEach(lane -> lane.playCursor(from, to, inclusive));
    }

    private void overdubCursor(Cursor from, Cursor to, boolean inclusive) {
        this.lanes.forEach(lane -> lane.overdubCursor(from, to, inclusive));
    }

    private void computeNextCursor(double deltaMs) {
        switch (this.timeBase.getEnum()) {
            case TEMPO: {
                Cursor transportCursor = this.constructTransportCursor();
                if (this.CursorOp().isBefore(transportCursor, this.startTransportReference)) {
                    LX.warning("LXClip detected global transport rewind: " + String.valueOf(transportCursor) + " < " + String.valueOf(this.startTransportReference));
                    this.setTransportReference(transportCursor, false);
                    this.nextCursor.set(this.cursor);
                    break;
                }
                if (this.isQuantizedStop != null) {
                    this.CursorOp().snapFloor(transportCursor, this, this.constructTempoCursor(this.isQuantizedStop));
                }
                Cursor elapsed = transportCursor.subtract(this.startTransportReference);
                this.nextCursor.set(this.startCursorReference.add(elapsed));
                break;
            }
            default: {
                this.nextCursor.set(this.constructAbsoluteCursor(this.cursor.getMillis() + deltaMs));
            }
        }
    }

    @Override
    protected void run(double deltaMs) {
        this.computeNextCursor(deltaMs);
        if (this.bus.arm.isOn()) {
            if (!this.hasTimeline) {
                this.runFirstRecording();
            } else {
                this.runOverdub();
            }
        } else {
            boolean runAutomation = false;
            if (this.automationEnabled.isOn()) {
                runAutomation = this.runAutomation(false);
            }
            if (this.snapshotEnabled.isOn()) {
                this.snapshot.loop(deltaMs);
            }
            if (!runAutomation && !this.snapshot.isInTransition()) {
                this.stop();
            }
        }
        if (this.isQuantizedStop != null) {
            this.stop();
            this.isQuantizedStop = null;
        }
    }

    private void runFirstRecording() {
        this.lanes.forEach(lane -> {
            LXClipLane lXClipLane = lane.commitRecordQueue(true);
        });
        this.length.set(this.nextCursor);
        this.loopStart.reset();
        this.loopLength.set(this.nextCursor);
        this.playStart.reset();
        this.playEnd.set(this.nextCursor);
        this.setCursor(this.nextCursor);
    }

    private void runOverdub() {
        this.runAutomation(true);
    }

    private boolean runAutomation(boolean isOverdub) {
        Cursor.Operator CursorOp = this.CursorOp();
        boolean isLoop = this.loop.isOn();
        boolean extendOverdub = false;
        Cursor endCursor = this.playEnd.cursor;
        if (isLoop) {
            endCursor = this.loopEnd.cursor;
        } else if (isOverdub) {
            endCursor = this.length.cursor;
        }
        if (CursorOp.isAfter(this.cursor, endCursor)) {
            endCursor = this.length.cursor;
            isLoop = false;
        }
        if (isOverdub && !isLoop && CursorOp.isAfter(this.nextCursor, endCursor)) {
            endCursor = this.nextCursor;
            extendOverdub = true;
        }
        if (CursorOp.isBefore(this.nextCursor, endCursor)) {
            if (isOverdub) {
                this.overdubCursor(this.cursor, this.nextCursor, false);
            } else {
                this.playCursor(this.cursor, this.nextCursor, false);
            }
            this.setCursor(this.nextCursor);
            return true;
        }
        if (isOverdub) {
            this.overdubCursor(this.cursor, endCursor, true);
            if (extendOverdub) {
                this.isOverdubExtension = true;
                this.length.set(endCursor);
                this.playEnd.set(endCursor);
            }
        } else {
            this.playCursor(this.cursor, endCursor, true);
        }
        if (CursorOp.isZero(this.length.cursor) || !isLoop) {
            this.setCursor(endCursor);
            return false;
        }
        if (this.CursorOp().isZero(this.loopLength.cursor)) {
            LX.warning("LXClip has loop set with zero length, stopping");
            this.setCursor(this.loopStart.cursor);
            return false;
        }
        this.runAutomationLoop(isOverdub);
        return true;
    }

    private void runAutomationLoop(boolean isOverdub) {
        while (true) {
            this.nextCursor._subtract(this.loopLength.cursor);
            this.loopCursor(this.loopEnd.cursor, this.loopStart.cursor);
            if (this.CursorOp().isBefore(this.nextCursor, this.loopEnd.cursor)) {
                if (isOverdub) {
                    this.overdubCursor(this.loopStart.cursor, this.nextCursor, false);
                    break;
                }
                this.playCursor(this.loopStart.cursor, this.nextCursor, false);
                break;
            }
            if (isOverdub) {
                this.overdubCursor(this.loopStart.cursor, this.loopEnd.cursor, true);
                continue;
            }
            this.playCursor(this.loopStart.cursor, this.loopEnd.cursor, true);
        }
        this.setCursor(this.nextCursor);
        Cursor loopDelta = this.nextCursor.subtract(this.loopStart.cursor);
        Cursor transport = this.constructTransportCursor();
        if (this.CursorOp().isAfter(loopDelta, transport)) {
            LX.warning("Transport somehow smaller than loop delta - transport:" + String.valueOf(transport) + " < loopDelta:" + String.valueOf(loopDelta));
            this.setTransportReference(false);
        } else {
            this.startCursorReference.set(this.loopStart.cursor);
            this.startTransportReference.set(transport.subtract(loopDelta));
        }
    }

    @Override
    public void effectAdded(LXBus channel, LXEffect effect) {
        this.registerComponent(effect);
    }

    @Override
    public void effectRemoved(LXBus channel, LXEffect effect) {
        this.unregisterComponent(effect);
    }

    @Override
    public void effectMoved(LXBus channel, LXEffect effect) {
    }

    public Cursor constructTransportCursor() {
        return this.constructTempoCursor(this.lx.engine.tempo.beatCount(), this.lx.engine.tempo.basis());
    }

    public Cursor constructTempoCursor(Tempo.Division division) {
        int beatCount = (int)(1.0 / division.multiplier);
        double beatBasis = 1.0 / division.multiplier % 1.0;
        return this.constructTempoCursor(beatCount, beatBasis);
    }

    public Cursor constructTempoCursor(int beatCount, double beatBasis) {
        return new Cursor(((double)beatCount + beatBasis) * 60000.0 / this.referenceBpm.getValue(), beatCount, beatBasis);
    }

    public Cursor constructAbsoluteCursor(double millis) {
        double beatCountBasis = millis * this.referenceBpm.getValue() / 60000.0;
        return new Cursor(millis, (int)beatCountBasis, beatCountBasis % 1.0);
    }

    public Cursor snapLaunchQuantization(Cursor cursor) {
        return this.snapLaunchQuantization(cursor, false);
    }

    private Cursor snapLaunchQuantization(Cursor cursor, boolean snapToFloor) {
        Tempo.Quantization globalQ;
        if (this.timeBase.getEnum() == Cursor.TimeBase.TEMPO && (globalQ = this.lx.engine.tempo.launchQuantization.getObject()).hasDivision()) {
            return this.snapTempo(cursor, globalQ.getDivision(), snapToFloor);
        }
        return cursor;
    }

    public Cursor snapTempo(Cursor cursor, Tempo.Division division) {
        return this.snapTempo(cursor, division, false);
    }

    private Cursor snapTempo(Cursor cursor, Tempo.Division division, boolean snapToFloor) {
        Cursor snapSize = this.constructTempoCursor(division);
        return snapToFloor ? this.CursorOp().snapFloor(cursor, this, snapSize) : this.CursorOp().snap(cursor, this, snapSize);
    }

    private void loadLegacyCursor(JsonObject parametersObj, CursorParameter cursor) {
        if (parametersObj.has(cursor.getPath()) && !parametersObj.has(cursor.millis.getPath())) {
            double millis = parametersObj.get(cursor.getPath()).getAsDouble();
            cursor.set(this.constructAbsoluteCursor(millis));
        }
    }

    private void loadLegacyMarker(JsonObject parametersObj, CursorParameter marker) {
        if (!parametersObj.has(marker.getPath()) && !parametersObj.has(marker.millis.getPath())) {
            marker.set(this.length);
        }
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.clearLanes();
        this.inLoad = true;
        this.timeBase.reset();
        super.load(lx, obj);
        this.inLoad = false;
        if (obj.has("parameters")) {
            JsonObject parametersObj = obj.getAsJsonObject("parameters");
            for (CursorParameter cursor : this.cursorParameters) {
                this.loadLegacyCursor(parametersObj, cursor);
            }
            this.loadLegacyMarker(parametersObj, this.loopLength);
            this.loadLegacyMarker(parametersObj, this.playEnd);
        }
        boolean bl = this.hasTimeline = !this.CursorOp().isZero(this.length.cursor);
        if (obj.has(KEY_LANES)) {
            JsonArray lanesArr = obj.get(KEY_LANES).getAsJsonArray();
            for (JsonElement laneElement : lanesArr) {
                JsonObject laneObj = laneElement.getAsJsonObject();
                String laneType = laneObj.get("laneType").getAsString();
                this.loadLane(lx, laneType, laneObj);
            }
        }
    }

    public ParameterClipLane addParameterLane(LX lx, JsonObject laneObj, int index) {
        LXParameter parameter;
        if (laneObj.has("path")) {
            String parameterPath = laneObj.get("path").getAsString();
            parameter = LXPath.getParameter(this.bus, parameterPath);
            if (parameter == null) {
                LX.error("No parameter found for saved parameter clip lane on bus " + String.valueOf(this.bus) + " at path: " + parameterPath);
                return null;
            }
        } else {
            int componentId = laneObj.get("componentId").getAsInt();
            LXComponent component = lx.getProjectComponent(componentId);
            if (component == null) {
                LX.error("No component found for saved parameter clip lane on bus " + String.valueOf(this.bus) + " with id: " + componentId);
                return null;
            }
            String parameterPath = laneObj.get("parameterPath").getAsString();
            parameter = component.getParameter(parameterPath);
            if (parameter == null) {
                LX.error("No parameter found for saved parameter clip lane on component " + String.valueOf(component) + " at path: " + parameterPath);
                return null;
            }
        }
        ParameterClipLane lane = this.getParameterLane((LXNormalizedParameter)parameter, true, index);
        lane.load(lx, laneObj);
        return lane;
    }

    protected void loadLane(LX lx, String laneType, JsonObject laneObj) {
        if (laneType.equals("parameter")) {
            this.addParameterLane(lx, laneObj, -1);
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.addProperty(KEY_INDEX, (Number)this.index);
        obj.add(KEY_LANES, (JsonElement)LXSerializable.Utils.toArray(lx, this.lanes));
    }

    public static enum ClipView {
        AUTOMATION,
        SNAPSHOT;

    }

    public class CursorParameter
    extends AggregateParameter {
        public final LXClip clip;
        public final Cursor cursor;
        public final MutableParameter millis;
        public final DiscreteParameter beatCount;
        public final BoundedParameter beatBasis;
        private boolean inSetCursor;

        public CursorParameter(String label) {
            super(label);
            this.cursor = new Cursor();
            this.millis = new MutableParameter("Millis").setMinimum(0.0).setUnits(LXParameter.Units.MILLISECONDS);
            this.beatCount = new DiscreteParameter("Beat Count", 0, Integer.MAX_VALUE);
            this.beatBasis = new BoundedParameter("Beat Basis", 0.0, 1.0);
            this.inSetCursor = false;
            this.clip = LXClip.this;
            this.addSubparameter("millis", this.millis);
            this.addSubparameter("beatCount", this.beatCount);
            this.addSubparameter("beatBasis", this.beatBasis);
            LXClip.this.cursorParameters.add(this);
        }

        private CursorParameter set(CursorParameter cursor) {
            return this.set(cursor.cursor);
        }

        private CursorParameter set(Cursor cursor) {
            this.inSetCursor = true;
            if (!this.cursor.equals(cursor)) {
                this.millis.setValue(cursor.getMillis());
                this.beatCount.setValue(cursor.getBeatCount());
                this.beatBasis.setValue(cursor.getBeatBasis());
                this.cursor.set(cursor);
                this.bang();
            }
            this.inSetCursor = false;
            return this;
        }

        @Override
        public CursorParameter reset() {
            this.set(Cursor.ZERO);
            return this;
        }

        @Override
        protected double onUpdateValue(double value) {
            if (!this.inSetCursor) {
                throw new IllegalStateException("Cannot update CursorParameter with direct setValue() call");
            }
            return value;
        }

        @Override
        protected void updateSubparameters(double value) {
        }

        @Override
        protected void onSubparameterUpdate(LXParameter p) {
            if (!this.inSetCursor) {
                if (p == this.millis) {
                    this.set(LXClip.this.constructAbsoluteCursor(this.millis.getValue()));
                } else if (p == this.beatCount || p == this.beatBasis) {
                    this.set(LXClip.this.constructTempoCursor(this.beatCount.getValuei(), this.beatBasis.getValue()));
                }
            }
        }

        @Override
        public CursorParameter setDescription(String description) {
            super.setDescription(description);
            return this;
        }
    }

    public static interface Listener {
        default public void cursorChanged(LXClip clip, Cursor cursor) {
        }

        default public void clipLaneMoved(LXClip clip, LXClipLane<?> lane, int index) {
        }

        default public void parameterLaneAdded(LXClip clip, ParameterClipLane lane) {
        }

        default public void parameterLaneRemoved(LXClip clip, ParameterClipLane lane) {
        }
    }
}

