/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.Tempo;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXClip;
import heronarts.lx.midi.surface.MixerSurface;
import heronarts.lx.mixer.LXAbstractChannel;
import heronarts.lx.mixer.LXBus;
import heronarts.lx.mixer.LXChannel;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.parameter.QuantizedTriggerParameter;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class LXClipEngine
extends LXComponent
implements LXOscComponent {
    public static final int MIN_SCENES = 8;
    public static final int MAX_SCENES = 128;
    private final QuantizedTriggerParameter[] scenes = new QuantizedTriggerParameter[128];
    private final QuantizedTriggerParameter[] patternScenes = new QuantizedTriggerParameter[128];
    public final FocusedClipParameter focusedClip = new FocusedClipParameter();
    public final Grid grid;
    public final BooleanParameter gridViewExpanded = new BooleanParameter("Grid View", false).setDescription("Whether the clip grid view is expanded");
    public final DiscreteParameter gridViewOffset = new DiscreteParameter("Grid View Offset", 0, 1).setDescription("Offset of the clip grid view");
    public final EnumParameter<GridMode> gridMode = new EnumParameter<GridMode>("Grid Mode", GridMode.PATTERNS).setDescription("Whether the grid activates patterns or clips");
    public final DiscreteParameter gridPatternOffset = new DiscreteParameter("Grid Pattern Offset", 0, 1).setDescription("Offset of the pattern grid view");
    public final BooleanParameter clipInspectorExpanded = new BooleanParameter("Clip Inspector", false).setDescription("Whether the clip inspector is expanded");
    public final DiscreteParameter numScenes = new DiscreteParameter("Num Scenes", 8, 129).setDescription("Number of active scenes");
    public final DiscreteParameter numPatterns = new DiscreteParameter("Num Patterns", 8, 4097).setDescription("Number of active patterns");
    public final QuantizedTriggerParameter stopClips = new QuantizedTriggerParameter(this.lx, "Stop Clips", this::_stopClipsQuantized).onSchedule(this::_stopClipsScheduled).setDescription("Stops all clips running in the whole project");
    public final QuantizedTriggerParameter triggerPatternCycle = new QuantizedTriggerParameter(this.lx, "Trigger Pattern Cycle", this::triggerPatternCycle).setDescription("Triggers a pattern cycle on every eligible channel");
    public final QuantizedTriggerParameter launchPatternCycle = new QuantizedTriggerParameter(this.lx, "Launch Pattern Cycle", this.triggerPatternCycle::trigger).setDescription("Triggers a pattern cycle on every eligible channel");
    public final BoundedParameter snapshotTransitionTimeSecs = new BoundedParameter("Snapshot Transition Time", 5.0, 0.1, 180.0).setDescription("Sets the duration of interpolated transitions between clip snapshots").setUnits(LXParameter.Units.SECONDS);
    public final BooleanParameter snapshotTransitionEnabled = new BooleanParameter("Snapshot Transitions", false).setDescription("When enabled, transitions between clip snapshots use interpolation");
    public final EnumParameter<Cursor.TimeBase> timeBaseDefault = new EnumParameter<Cursor.TimeBase>("Time-Base Default", Cursor.TimeBase.TEMPO).setDescription("Which time-base new clips use by default");
    public final BooleanParameter clipSnapshotDefault = new BooleanParameter("Clip Snapshot Default", false).setDescription("Whether new clips have a snapshot by default");
    public final MutableParameter controlSurfaceSemaphore = new MutableParameter("Control-Surfaces", 0.0).setDescription("How many control surfaces are controlling this component");
    private final CopyOnWriteArraySet<MixerSurface> controlSurfaces = new CopyOnWriteArraySet();
    private final LXParameterListener clipSceneListener = this::_launchClipSceneUnique;
    private final LXParameterListener patternSceneListener = this::_launchPatternSceneUnique;

    public LXClipEngine(LX lx) {
        super(lx, "Clips");
        this.addParameter("focusedClip", this.focusedClip);
        this.addParameter("numScenes", this.numScenes);
        this.addParameter("snapshotTransitionEnabled", this.snapshotTransitionEnabled);
        this.addParameter("snapshotTransitionTimeSecs", this.snapshotTransitionTimeSecs);
        this.addParameter("stopClips", this.stopClips);
        this.addParameter("launchPatternCycle", this.launchPatternCycle);
        this.addParameter("triggerPatternCycle", this.triggerPatternCycle);
        this.addParameter("timeBaseDefault", this.timeBaseDefault);
        this.addParameter("clipSnapshotDefault", this.clipSnapshotDefault);
        this.addParameter("gridMode", this.gridMode);
        this.addParameter("gridViewOffset", this.gridViewOffset);
        this.addParameter("gridPatternOffset", this.gridPatternOffset);
        this.addParameter("gridViewExpanded", this.gridViewExpanded);
        this.addParameter("clipInspectorExpanded", this.clipInspectorExpanded);
        this.grid = new Grid(lx);
        this.addChild("grid", this.grid);
        this.launchPatternCycle.addListener(this.patternSceneListener);
        this.stopClips.addListener(this.clipSceneListener);
        int i = 0;
        while (i < this.scenes.length) {
            int sceneIndex = i;
            this.scenes[i] = new QuantizedTriggerParameter(lx, "Launch Scene-" + (i + 1), quantized -> this._launchClipSceneQuantized(sceneIndex, quantized)).onSchedule(() -> this._launchClipSceneScheduled(sceneIndex)).setDescription("Launches scene " + (i + 1));
            this.scenes[i].addListener(this.clipSceneListener);
            this.addParameter("scene-" + (i + 1), this.scenes[i]);
            this.patternScenes[i] = new QuantizedTriggerParameter(lx, "Launch Pattern-" + (i + 1), quantized -> this._launchPatternSceneQuantized(sceneIndex, quantized)).onSchedule(() -> this._launchPatternSceneScheduled(sceneIndex)).setDescription("Launches all patterns at index " + (i + 1));
            this.patternScenes[i].addListener(this.patternSceneListener);
            this.addParameter("pattern-" + (i + 1), this.patternScenes[i]);
            ++i;
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (this.numScenes == p) {
            this.gridViewOffset.setRange(this.numScenes.getValuei() - 8 + 1);
        }
    }

    public DiscreteParameter getGridOffsetParameter() {
        switch (this.gridMode.getEnum()) {
            case CLIPS: {
                return this.gridViewOffset;
            }
        }
        return this.gridPatternOffset;
    }

    public DiscreteParameter getGridSizeParameter() {
        switch (this.gridMode.getEnum()) {
            case CLIPS: {
                return this.numScenes;
            }
        }
        return this.numPatterns;
    }

    public int getGridOffset() {
        return this.getGridOffsetParameter().getValuei();
    }

    public int getGridSize() {
        return this.getGridSizeParameter().getValuei();
    }

    public void updatePatternGridSize() {
        int max = 0;
        for (LXAbstractChannel bus : this.lx.engine.mixer.channels) {
            if (!(bus instanceof LXChannel)) continue;
            LXChannel channel = (LXChannel)bus;
            max = LXUtils.max(max, channel.patterns.size());
        }
        this.numPatterns.setValue(LXUtils.max(8, max));
        this.gridPatternOffset.setRange(LXUtils.max(1, max - 8 + 1));
    }

    public LXComponent addControlSurface(MixerSurface surface) {
        if (this.controlSurfaces.contains(surface)) {
            throw new IllegalStateException("Cannot add same control surface to device twice: " + String.valueOf(surface));
        }
        this.controlSurfaces.add(surface);
        this.controlSurfaceSemaphore.increment();
        return this;
    }

    public LXComponent removeControlSurface(MixerSurface surface) {
        if (!this.controlSurfaces.contains(surface)) {
            throw new IllegalStateException("Cannot remove control surface that is not added: " + String.valueOf(surface));
        }
        this.controlSurfaces.remove(surface);
        this.controlSurfaceSemaphore.decrement();
        return this;
    }

    public Set<MixerSurface> getControlSurfaces() {
        return this.controlSurfaces;
    }

    public LXClip getFocusedClip() {
        return this.focusedClip.getClip();
    }

    public LXClipEngine setFocusedClip(LXClip clip) {
        this.focusedClip.setClip(clip);
        return this;
    }

    public QuantizedTriggerParameter getScene(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Cannot request scene less than 0: " + index);
        }
        return this.scenes[index];
    }

    public QuantizedTriggerParameter getPatternScene(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Cannot request scene less than 0: " + index);
        }
        return this.patternScenes[index];
    }

    public LXClipEngine launchScene(int index) {
        this.scenes[index].trigger();
        return this;
    }

    private void _launchClipSceneUnique(LXParameter p) {
        if (p.getValue() > 0.0) {
            QuantizedTriggerParameter[] quantizedTriggerParameterArray = this.scenes;
            int n = this.scenes.length;
            int n2 = 0;
            while (n2 < n) {
                QuantizedTriggerParameter scene = quantizedTriggerParameterArray[n2];
                if (p != scene) {
                    scene.cancel();
                }
                ++n2;
            }
        }
        if (p != this.stopClips) {
            this.stopClips.cancel();
        }
    }

    private void _launchClipSceneScheduled(int index) {
        boolean didSomething = false;
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            LXClip clip = channel.getClip(index);
            if (clip == null) continue;
            clip.launch.trigger();
            didSomething = true;
        }
        LXClip clip = this.lx.engine.mixer.masterBus.getClip(index);
        if (clip != null) {
            clip.launch.trigger();
            didSomething = true;
        }
        if (!didSomething) {
            this.scenes[index].cancel();
        }
    }

    private void _launchClipSceneQuantized(int index, boolean quantized) {
        if (!quantized) {
            this.triggerScene(index);
        }
    }

    public LXClipEngine triggerScene(int index) {
        LXClip clip;
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            clip = channel.getClip(index);
            if (clip == null) continue;
            clip.trigger();
        }
        clip = this.lx.engine.mixer.masterBus.getClip(index);
        if (clip != null) {
            clip.trigger();
        }
        return this;
    }

    public LXClipEngine launchPatternScene(int index) {
        this.patternScenes[index].trigger();
        return this;
    }

    private void _launchPatternSceneUnique(LXParameter p) {
        if (p.getValue() > 0.0) {
            QuantizedTriggerParameter[] quantizedTriggerParameterArray = this.patternScenes;
            int n = this.patternScenes.length;
            int n2 = 0;
            while (n2 < n) {
                QuantizedTriggerParameter pattern = quantizedTriggerParameterArray[n2];
                if (p != pattern) {
                    pattern.cancel();
                }
                ++n2;
            }
            if (p != this.launchPatternCycle) {
                this.launchPatternCycle.cancel();
            }
        }
    }

    private void _launchPatternSceneScheduled(int index) {
        boolean didSomething = false;
        for (LXAbstractChannel bus : this.lx.engine.mixer.channels) {
            if (!(bus instanceof LXChannel)) continue;
            LXChannel channel = (LXChannel)bus;
            if (index >= channel.patterns.size() || !channel.isPlaylist()) continue;
            channel.getPattern((int)index).launch.trigger();
            didSomething = true;
        }
        if (!didSomething) {
            this.patternScenes[index].cancel();
        }
    }

    private void _launchPatternSceneQuantized(int index, boolean quantized) {
        if (!quantized) {
            this.triggerPatternScene(index);
        }
    }

    public LXClipEngine triggerPatternScene(int index) {
        for (LXAbstractChannel bus : this.lx.engine.mixer.channels) {
            if (!(bus instanceof LXChannel)) continue;
            LXChannel channel = (LXChannel)bus;
            if (index >= channel.patterns.size()) continue;
            channel.goPatternIndex(index);
        }
        return this;
    }

    public LXClipEngine triggerPatternCycle() {
        for (LXAbstractChannel bus : this.lx.engine.mixer.channels) {
            LXChannel channel;
            if (!(bus instanceof LXChannel) || !(channel = (LXChannel)bus).isPlaylist()) continue;
            channel.triggerPatternCycle.trigger();
        }
        return this;
    }

    private void _stopClipsScheduled() {
        boolean hasPendingStop = false;
        for (LXBus lXBus : this.lx.engine.mixer.channels) {
            lXBus.stopClips.trigger();
            if (!lXBus.stopClips.pending.isOn()) continue;
            hasPendingStop = true;
        }
        this.lx.engine.mixer.masterBus.stopClips.trigger();
        if (this.lx.engine.mixer.masterBus.stopClips.pending.isOn()) {
            hasPendingStop = true;
        }
        if (!hasPendingStop) {
            this.stopClips.cancel();
        }
    }

    private void _stopClipsQuantized(boolean quantized) {
        if (!quantized) {
            this.stopClips();
        }
    }

    public LXClipEngine stopClips() {
        for (LXAbstractChannel channel : this.lx.engine.mixer.channels) {
            channel.stopClips();
        }
        this.lx.engine.mixer.masterBus.stopClips();
        return this;
    }

    private static void legacyNumScenes(JsonObject obj) {
        int numScenes;
        if (LXSerializable.Utils.hasParameter(obj, "numScenes") && (numScenes = LXSerializable.Utils.getParameter(obj, "numScenes").getAsInt()) < 8) {
            obj.get("parameters").getAsJsonObject().addProperty("numScenes", (Number)8);
        }
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        LXClipEngine.legacyNumScenes(obj);
        super.load(lx, obj);
        if (obj.has("_reset_")) {
            this.gridViewOffset.reset();
            this.numScenes.reset();
        }
    }

    @Override
    public void dispose() {
        this.launchPatternCycle.removeListener(this.patternSceneListener);
        this.stopClips.removeListener(this.clipSceneListener);
        QuantizedTriggerParameter[] quantizedTriggerParameterArray = this.scenes;
        int n = this.scenes.length;
        int n2 = 0;
        while (n2 < n) {
            QuantizedTriggerParameter scene = quantizedTriggerParameterArray[n2];
            scene.removeListener(this.clipSceneListener);
            ++n2;
        }
        quantizedTriggerParameterArray = this.patternScenes;
        n = this.patternScenes.length;
        n2 = 0;
        while (n2 < n) {
            QuantizedTriggerParameter pattern = quantizedTriggerParameterArray[n2];
            pattern.removeListener(this.patternSceneListener);
            ++n2;
        }
        super.dispose();
    }

    public class FocusedClipParameter
    extends MutableParameter {
        private LXClip clip;

        private FocusedClipParameter() {
            super("Focused Clip");
            this.clip = null;
            this.setDescription("Parameter which indicate the globally focused clip");
        }

        public FocusedClipParameter setClip(LXClip clip) {
            if (this.clip != clip) {
                this.clip = clip;
                this.bang();
            }
            return this;
        }

        public LXClip getClip() {
            return this.clip;
        }
    }

    public static class Grid
    extends LXComponent
    implements LXOscComponent {
        public final BooleanParameter snap = new BooleanParameter("Snap", true).setDescription("Toggles grid snapping on or off");
        public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.ADAPTIVE).setDescription("Whether grid lines are fixed or adaptive to the visible region");
        public final EnumParameter<Spacing> adaptiveSpacing = ((EnumParameter)new EnumParameter<Spacing>("Spacing", Spacing.MEDIUM).setDescription("Relative spacing of grid lines in Adaptive mode")).setWrappable(false);
        public final EnumParameter<TimeDivision> fixedSpacingAbsolute = ((EnumParameter)new EnumParameter<TimeDivision>("Fixed Grid Spacing", TimeDivision.SECOND).setDescription("Grid line spacing in Fixed mode when time scale is absolute")).setWrappable(false);
        public final ObjectParameter<Tempo.Quantization> fixedSpacingTempo = ((ObjectParameter)new ObjectParameter<Tempo.Quantization>("Fixed Grid Spacing", new Tempo.Quantization[]{Tempo.Division.EIGHT.toQuantization("8 Bars"), Tempo.Division.FOUR.toQuantization("4 Bars"), Tempo.Division.DOUBLE.toQuantization("2 Bars"), Tempo.Division.WHOLE.toQuantization("1 Bar"), Tempo.Division.HALF, Tempo.Division.QUARTER, Tempo.Division.EIGHTH, Tempo.Division.SIXTEENTH}).setDescription("Grid line spacing in Fixed mode when time scale is tempo")).setWrappable(false);
        private final List<Listener> listeners = new ArrayList<Listener>();

        private Grid(LX lx) {
            super(lx);
            this.addParameter("snap", this.snap);
            this.addParameter("mode", this.mode);
            this.addParameter("adaptiveSpacing", this.adaptiveSpacing);
            this.addParameter("fixedSpacingAbsolute", this.fixedSpacingAbsolute);
            this.addParameter("fixedSpacingTempo", this.fixedSpacingTempo);
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            super.onParameterChanged(p);
            for (Listener listener : this.listeners) {
                listener.onGridChanged(this);
            }
        }

        public final void addListener(Listener listener) {
            Objects.requireNonNull(listener, "May not add null LXClipEngine.Grid.Listener");
            if (this.listeners.contains(listener)) {
                throw new IllegalStateException("May not add duplicate LXClipEngine.Grid.Listener: " + String.valueOf(listener));
            }
            this.listeners.add(listener);
        }

        public final void removeListener(Listener listener) {
            if (!this.listeners.contains(listener)) {
                throw new IllegalStateException("May not remove non-registered LXClipEngine.Grid.Listener: " + String.valueOf(listener));
            }
            this.listeners.remove(listener);
        }

        public static interface Listener {
            public void onGridChanged(Grid var1);
        }

        public static enum Mode {
            ADAPTIVE("A"),
            FIXED("F");

            public final String label;

            private Mode(String label) {
                this.label = label;
            }

            public String toString() {
                return this.label;
            }
        }

        public static enum Spacing {
            NARROWEST("Narrowest", 64),
            NARROW("Narrow", 32),
            MEDIUM("Medium", 16),
            WIDE("Wide", 8),
            WIDEST("Widest", 4);

            public final String label;
            public final int divisions;

            private Spacing(String label, int divisions) {
                this.label = label;
                this.divisions = divisions;
            }

            public String toString() {
                return this.label;
            }
        }

        public static enum TimeDivision {
            QUARTER_SECOND("\u00bc second", 250.0f),
            HALF_SECOND("\u00bd second", 500.0f),
            SECOND("1 second", 1000.0f),
            TWO_SECONDS("2 seconds", 2000.0f),
            FOUR_SECONDS("4 seconds", 4000.0f);

            public final String label;
            public final float millis;

            private TimeDivision(String label, float millis) {
                this.label = label;
                this.millis = millis;
            }

            public String toString() {
                return this.label;
            }
        }
    }

    public static enum GridMode {
        PATTERNS("Patterns"),
        CLIPS("Clips");

        public final String label;

        private GridMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

