/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXClipLane;
import java.util.Comparator;

public abstract class LXClipEvent<T extends LXClipEvent<?>>
implements Comparator<T>,
LXSerializable {
    protected final LXClipLane<T> lane;
    protected final LXComponent component;
    public final Cursor cursor;
    protected static final String KEY_CURSOR = "cursor";

    LXClipEvent(LXClipLane<T> lane) {
        this(lane, lane.clip.cursor, null);
    }

    LXClipEvent(LXClipLane<T> lane, LXComponent component) {
        this(lane, lane.clip.cursor, component);
    }

    LXClipEvent(LXClipLane<T> lane, Cursor cursor) {
        this(lane, cursor, null);
    }

    LXClipEvent(LXClipLane<T> lane, Cursor cursor, LXComponent component) {
        this.lane = lane;
        this.cursor = cursor.clone();
        this.component = component;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    LXClipEvent<T> setCursor(Cursor cursor) {
        this.cursor.set(cursor);
        return this;
    }

    @Override
    public int compare(T arg0, T arg1) {
        return this.lane.clip.timeBase.getEnum().operator.compare(((LXClipEvent)arg0).cursor, ((LXClipEvent)arg1).cursor);
    }

    public abstract void execute();

    @Override
    public void load(LX lx, JsonObject obj) {
        if (obj.has(KEY_CURSOR)) {
            JsonElement cursorElem = obj.get(KEY_CURSOR);
            if (cursorElem.isJsonObject()) {
                this.cursor.load(lx, cursorElem.getAsJsonObject());
            } else {
                this.cursor.set(this.lane.clip.constructAbsoluteCursor(cursorElem.getAsDouble()));
            }
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        obj.add(KEY_CURSOR, (JsonElement)LXSerializable.Utils.toObject(lx, this.cursor));
    }
}

