/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.MidiNoteClipLane;
import heronarts.lx.clip.ParameterClipLane;
import heronarts.lx.clip.PatternClipLane;
import heronarts.lx.command.LXCommand;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.utils.LXEngineThreadArrayList;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class LXClipLane<T extends LXClipEvent<?>>
extends LXComponent {
    public final MutableParameter uiHeight = new MutableParameter("UI Height");
    public final BooleanParameter uiExpanded = new BooleanParameter("UI Expanded", true);
    public final BooleanParameter uiMaximized = new BooleanParameter("UI Maximized", false);
    public final MutableParameter onChange = new MutableParameter();
    public final LXClip clip;
    protected boolean overdubActive = false;
    protected final LXEngineThreadArrayList<T> mutableEvents = new LXEngineThreadArrayList();
    public final List<T> events = Collections.unmodifiableList(this.mutableEvents);
    final List<T> recordQueue = new ArrayList<T>();
    private static final String KEY_EVENTS = "events";
    protected static final String KEY_LANE_TYPE = "laneType";
    protected static final String VALUE_LANE_TYPE_PARAMETER = "parameter";
    protected static final String VALUE_LANE_TYPE_PATTERN = "pattern";
    protected static final String VALUE_LANE_TYPE_MIDI_NOTE = "midiNote";

    protected Cursor.Operator CursorOp() {
        return this.clip.CursorOp();
    }

    protected LXClipLane(LXClip clip) {
        this.setParent(clip);
        this.clip = clip;
        this.addInternalParameter("uiHeight", this.uiHeight);
        this.addInternalParameter("uiExpanded", this.uiExpanded);
        this.addInternalParameter("uiMaximized", this.uiMaximized);
    }

    final void resetRecordingState() {
        this.recordQueue.clear();
        this.overdubActive = false;
    }

    public int getIndex() {
        return this.clip.lanes.indexOf(this);
    }

    private Cursor lastEventCursor() {
        if (!this.events.isEmpty()) {
            return ((LXClipEvent)this.events.get((int)(this.events.size() - 1))).cursor;
        }
        return Cursor.ZERO;
    }

    protected final LXClipLane<T> recordEvent(T event) {
        this.recordQueue.add(event);
        return this;
    }

    LXClipLane<T> commitRecordQueue(boolean notify) {
        if (!this.recordQueue.isEmpty()) {
            this.mutableEvents.begin();
            for (LXClipEvent event : this.recordQueue) {
                this._insertEvent(event);
            }
            this.recordQueue.clear();
            this.mutableEvents.commit();
            if (notify) {
                this.onChange.bang();
            }
        }
        return this;
    }

    public List<T> getUIThreadEvents() {
        return this.mutableEvents.getUIThreadList();
    }

    public ListIterator<T> eventIterator(Cursor fromCursor) {
        return this.eventIterator(fromCursor, 0);
    }

    public ListIterator<T> eventIterator(Cursor fromCursor, int offset) {
        int index = LXUtils.constrain(this.cursorPlayIndex(fromCursor) + offset, 0, this.events.size());
        return this.events.listIterator(index);
    }

    public ListIterator<T> eventIterator(List<T> events, Cursor fromCursor, int offset) {
        int index = LXUtils.constrain(this.cursorPlayIndex(fromCursor) + offset, 0, events.size());
        return events.listIterator(index);
    }

    public ListIterator<T> eventIterator(List<T> events, Cursor fromCursor, boolean inclusive) {
        return events.listIterator(this.eventIndex(events, fromCursor, inclusive));
    }

    public int eventIndex(List<T> events, Cursor fromCursor, boolean inclusive) {
        return this.eventIndex(events, fromCursor, inclusive, 0);
    }

    public int eventIndex(List<T> events, Cursor fromCursor, boolean inclusive, int offset) {
        return LXUtils.constrain(this._cursorIndex(events, fromCursor, inclusive) + offset, 0, events.size());
    }

    private int _cursorIndex(List<T> events, Cursor cursor, boolean inclusive) {
        int geq = inclusive ? -1 : 0;
        int left = 0;
        int right = events.size() - 1;
        int result = right + 1;
        Cursor.Operator CursorOp = this.CursorOp();
        while (left <= right) {
            int mid = left + (right - left) / 2;
            if (CursorOp.compare(((LXClipEvent)events.get((int)mid)).cursor, cursor) > geq) {
                result = mid;
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return result;
    }

    protected int cursorPlayIndex(Cursor cursor) {
        return this._cursorIndex(this.events, cursor, true);
    }

    protected int cursorInsertIndex(Cursor cursor) {
        return this._cursorIndex(this.events, cursor, false);
    }

    protected int cursorPlayIndex(List<T> events, Cursor cursor) {
        return this._cursorIndex(events, cursor, true);
    }

    protected int cursorInsertIndex(List<T> events, Cursor cursor) {
        return this._cursorIndex(events, cursor, false);
    }

    protected void _insertEvent(T event) {
        if (this.CursorOp().isAfterOrEqual(((LXClipEvent)event).cursor, this.lastEventCursor())) {
            this.mutableEvents.add(event);
        } else {
            this.mutableEvents.add(this.cursorInsertIndex(((LXClipEvent)event).cursor), event);
        }
    }

    public LXClipLane<T> insertEvent(T event) {
        this._insertEvent(event);
        this.onChange.bang();
        return this;
    }

    public LXClipLane<T> moveEvent(T event, Cursor cursor) {
        Cursor min = Cursor.ZERO;
        Cursor max = this.clip.length.cursor;
        int index = this.events.indexOf(event);
        if (index > 0) {
            min = ((LXClipEvent)this.events.get((int)(index - 1))).cursor;
        }
        if (index < this.events.size() - 1) {
            max = ((LXClipEvent)this.events.get((int)(index + 1))).cursor;
        }
        this.CursorOp().constrain(cursor, min, max);
        if (!((LXClipEvent)event).cursor.equals(cursor)) {
            ((LXClipEvent)event).cursor.set(cursor);
            this.onChange.bang();
        }
        return this;
    }

    protected T getPreviousEvent(List<T> events, Cursor cursor) {
        int previousIndex = this.cursorInsertIndex(events, cursor) - 1;
        if (previousIndex >= 0) {
            return (T)((LXClipEvent)events.get(previousIndex));
        }
        return null;
    }

    protected T getPreviousEvent(Cursor cursor) {
        int previousIndex = this.cursorInsertIndex(cursor) - 1;
        if (previousIndex >= 0) {
            return (T)((LXClipEvent)this.events.get(previousIndex));
        }
        return null;
    }

    protected T getPreviousEvent() {
        return this.getPreviousEvent(this.clip.cursor);
    }

    public void setEventsCursors(ArrayList<T> originalEvents, Cursor fromSelectionMin, Cursor fromSelectionMax, Cursor toSelectionMin, Cursor toSelectionMax, Map<T, Double> fromValues, Map<T, Cursor> fromCursors, Map<T, Cursor> toCursors, LXCommand.Clip.Event.SetCursors.Operation operation) {
        int outerMaxIndex;
        int moveMinIndex;
        int moveMaxIndex;
        int outerMinIndex;
        for (Map.Entry<T, Cursor> entry : fromCursors.entrySet()) {
            ((LXClipEvent)entry.getKey()).setCursor(entry.getValue());
        }
        for (Map.Entry<T, Object> entry : fromValues.entrySet()) {
            this.setEventNormalized((LXClipEvent)entry.getKey(), (Double)entry.getValue());
        }
        if (operation == LXCommand.Clip.Event.SetCursors.Operation.NONE) {
            this.mutableEvents.set(originalEvents);
            this.onChange.bang();
            return;
        }
        boolean bl = operation.isReverse();
        boolean clear = operation.isClear();
        originalEvents = new ArrayList<T>(originalEvents);
        int selectFrom = this.cursorPlayIndex(originalEvents, fromSelectionMin);
        int selectTo = this.cursorInsertIndex(originalEvents, fromSelectionMax);
        int deleteFrom = -1;
        int deleteTo = -1;
        int moveTo = -1;
        LXClipEvent stitchInnerMin = null;
        LXClipEvent stitchInnerMax = null;
        T stitchOuterMin = null;
        T stitchOuterMax = null;
        T stitchMoveMin = null;
        T stitchMoveMax = null;
        switch (operation) {
            case STRETCH_TO_LEFT: {
                deleteFrom = this.cursorPlayIndex(originalEvents, toSelectionMin);
                deleteTo = selectFrom;
                stitchOuterMin = this.stitchOuter(originalEvents, toSelectionMin, deleteFrom);
                break;
            }
            case SHORTEN_FROM_LEFT: {
                stitchOuterMin = this.stitchOuter(originalEvents, fromSelectionMin, selectFrom);
                break;
            }
            case CLEAR_FROM_LEFT: {
                stitchOuterMin = this.stitchOuter(originalEvents, fromSelectionMin, selectFrom);
                break;
            }
            case REVERSE_LEFT_TO_RIGHT: {
                stitchOuterMin = this.stitchOuter(originalEvents, fromSelectionMin, selectFrom);
                deleteFrom = selectTo;
                deleteTo = this.cursorInsertIndex(originalEvents, toSelectionMax);
                stitchOuterMax = this.stitchOuter(originalEvents, toSelectionMax, deleteTo);
                break;
            }
            case STRETCH_TO_RIGHT: {
                deleteFrom = selectTo;
                deleteTo = this.cursorInsertIndex(originalEvents, toSelectionMax);
                stitchOuterMax = this.stitchOuter(originalEvents, toSelectionMax, deleteTo);
                break;
            }
            case SHORTEN_FROM_RIGHT: {
                stitchOuterMax = this.stitchOuter(originalEvents, fromSelectionMax, selectTo);
                break;
            }
            case CLEAR_FROM_RIGHT: {
                stitchOuterMax = this.stitchOuter(originalEvents, fromSelectionMax, selectTo);
                break;
            }
            case REVERSE_RIGHT_TO_LEFT: {
                stitchOuterMax = this.stitchOuter(originalEvents, fromSelectionMax, selectTo);
                deleteFrom = this.cursorPlayIndex(originalEvents, toSelectionMin);
                deleteTo = selectFrom;
                stitchOuterMin = this.stitchOuter(originalEvents, toSelectionMin, deleteFrom);
                break;
            }
            case MOVE_LEFT: {
                deleteFrom = this.cursorPlayIndex(originalEvents, toSelectionMin);
                stitchOuterMin = this.stitchOuter(originalEvents, toSelectionMin, deleteFrom);
                stitchOuterMax = this.stitchOuter(originalEvents, fromSelectionMax, selectTo);
                if (this.CursorOp().isAfterOrEqual(toSelectionMax, fromSelectionMin)) {
                    deleteTo = selectFrom;
                    break;
                }
                moveTo = deleteFrom;
                deleteTo = this.cursorInsertIndex(originalEvents, toSelectionMax);
                stitchMoveMax = this.stitchOuter(originalEvents, toSelectionMax, deleteTo);
                stitchMoveMin = this.stitchOuter(originalEvents, fromSelectionMin, selectFrom);
                break;
            }
            case MOVE_RIGHT: {
                deleteTo = this.cursorInsertIndex(originalEvents, toSelectionMax);
                stitchOuterMin = this.stitchOuter(originalEvents, fromSelectionMin, selectFrom);
                stitchOuterMax = this.stitchOuter(originalEvents, toSelectionMax, deleteTo);
                if (this.CursorOp().isBeforeOrEqual(toSelectionMin, fromSelectionMax)) {
                    deleteFrom = selectTo;
                    break;
                }
                moveTo = deleteTo;
                deleteFrom = this.cursorPlayIndex(originalEvents, toSelectionMin);
                stitchMoveMax = this.stitchOuter(originalEvents, fromSelectionMax, selectTo);
                stitchMoveMin = this.stitchOuter(originalEvents, toSelectionMin, deleteFrom);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled SetCursors.Operation: " + String.valueOf((Object)operation));
            }
        }
        stitchInnerMin = (LXClipEvent)this.stitchInnerMin(originalEvents, fromSelectionMin, selectFrom, clear);
        stitchInnerMax = (LXClipEvent)this.stitchInnerMax(originalEvents, fromSelectionMax, selectTo, clear);
        if (deleteTo > deleteFrom) {
            int numDelete = deleteTo - deleteFrom;
            originalEvents.subList(deleteFrom, deleteTo).clear();
            if (deleteFrom < selectFrom) {
                selectFrom -= numDelete;
                selectTo -= numDelete;
            }
            if (deleteFrom < moveTo) {
                moveTo -= numDelete;
            }
        }
        if (clear && selectTo > selectFrom) {
            originalEvents.subList(selectFrom, selectTo).clear();
            selectTo = selectFrom;
        }
        if (stitchInnerMin != null) {
            originalEvents.add(selectFrom, stitchInnerMin);
            if (moveTo > selectFrom) {
                ++moveTo;
            }
            ++selectTo;
        }
        if (stitchInnerMax != null) {
            originalEvents.add(selectTo, stitchInnerMax);
            if (moveTo >= selectTo) {
                ++moveTo;
            }
            ++selectTo;
        }
        if (bl && selectTo > selectFrom) {
            this.reverseEvents(originalEvents.subList(selectFrom, selectTo));
        }
        if (stitchInnerMin != null) {
            stitchInnerMin.setCursor(bl ? toSelectionMax : toSelectionMin);
        }
        if (stitchInnerMax != null) {
            stitchInnerMax.setCursor(bl ? toSelectionMin : toSelectionMax);
        }
        if (!clear) {
            for (Map.Entry<T, Cursor> entry : toCursors.entrySet()) {
                ((LXClipEvent)entry.getKey()).setCursor(entry.getValue().bound(this.clip));
            }
        }
        int numSelected = selectTo - selectFrom;
        if (moveTo >= 0 && numSelected > 0 && moveTo != selectFrom) {
            List<T> selection = originalEvents.subList(selectFrom, selectTo);
            ArrayList<T> copy = new ArrayList<T>(selection);
            selection.clear();
            if (moveTo > selectFrom) {
                moveTo -= numSelected;
            }
            originalEvents.addAll(moveTo, copy);
            selectFrom = moveTo;
            selectTo = selectFrom + numSelected;
        }
        if (stitchOuterMin != null && (outerMinIndex = this.stitchInsertIfNeeded(originalEvents, stitchOuterMin, false)) >= 0 && outerMinIndex <= selectFrom) {
            ++selectFrom;
            ++selectTo;
        }
        if (stitchMoveMax != null && (moveMaxIndex = this.stitchInsertIfNeeded(originalEvents, stitchMoveMax, true)) >= 0 && moveMaxIndex <= selectFrom) {
            ++selectFrom;
            ++selectTo;
        }
        if (stitchMoveMin != null && (moveMinIndex = this.stitchInsertIfNeeded(originalEvents, stitchMoveMin, false)) >= 0 && moveMinIndex <= selectFrom) {
            ++selectFrom;
            ++selectTo;
        }
        if (stitchOuterMax != null && (outerMaxIndex = this.stitchInsertIfNeeded(originalEvents, stitchOuterMax, true)) >= 0 && outerMaxIndex <= selectFrom) {
            ++selectFrom;
            ++selectTo;
        }
        if (this.stitchRemoveIfRedundant(originalEvents, stitchInnerMin, bl ? selectTo - 1 : selectFrom)) {
            --selectTo;
        }
        this.stitchRemoveIfRedundant(originalEvents, stitchInnerMax, bl ? selectFrom : selectTo - 1);
        this.mutableEvents.set(originalEvents);
        this.onChange.bang();
    }

    protected void reverseEvents(List<T> events) {
        Collections.reverse(events);
    }

    protected void setEventNormalized(T event, double value) {
    }

    protected T stitchSelectionMin(List<T> originalEvents, List<T> modifiedEvents, Cursor selectionMin, int stitchIndex, boolean force) {
        return null;
    }

    protected T stitchSelectionMax(List<T> originalEvents, List<T> modifiedEvents, Cursor selectionMax, int stitchIndex, boolean force) {
        return null;
    }

    protected T stitchInner(List<T> events, Cursor cursor, int rightIndex, boolean isMin, boolean force) {
        return null;
    }

    private final T stitchInnerMin(List<T> events, Cursor cursor, int rightIndex, boolean force) {
        return this.stitchInner(events, cursor, rightIndex, true, force);
    }

    private final T stitchInnerMax(List<T> events, Cursor cursor, int rightIndex, boolean force) {
        return this.stitchInner(events, cursor, rightIndex, false, force);
    }

    protected T stitchOuter(List<T> events, Cursor cursor, int rightIndex) {
        return null;
    }

    protected int stitchInsertIfNeeded(List<T> events, T stitch, boolean after) {
        return -1;
    }

    protected boolean stitchRemoveIfRedundant(List<T> events, T stitch, int index) {
        return false;
    }

    @Override
    public abstract String getLabel();

    void initializeCursorPlayback(Cursor to) {
    }

    void jumpCursor(Cursor from, Cursor to) {
    }

    void loopCursor(Cursor from, Cursor to) {
    }

    abstract void overdubCursor(Cursor var1, Cursor var2, boolean var3);

    void playCursor(Cursor from, Cursor to, boolean inclusive) {
        Cursor.Operator CursorOp = this.CursorOp();
        int limit = -1;
        ListIterator<T> iter = this.eventIterator(from);
        while (iter.hasNext()) {
            LXClipEvent event = (LXClipEvent)iter.next();
            if (CursorOp.compare(event.cursor, to) > -1) break;
            event.execute();
        }
    }

    public boolean removeRange(Cursor from, Cursor to) {
        return this.removeRange(from, to, true);
    }

    protected boolean removeRange(Cursor from, Cursor to, boolean notify) {
        if (!this.mutableEvents.isEmpty()) {
            int fromIndex = this.cursorPlayIndex(from);
            int toIndex = this.cursorInsertIndex(to);
            if (toIndex > fromIndex) {
                this.mutableEvents.removeRange(fromIndex, toIndex);
                if (notify) {
                    this.onChange.bang();
                }
                return true;
            }
        }
        return false;
    }

    public LXClipLane<T> removeEvent(T event) {
        this.mutableEvents.remove(event);
        this.onChange.bang();
        return this;
    }

    public LXClipLane<T> removeEvents(List<Integer> eventIndices) {
        if (!eventIndices.isEmpty()) {
            ArrayList<LXClipEvent> toRemove = new ArrayList<LXClipEvent>();
            for (int index : eventIndices) {
                toRemove.add((LXClipEvent)this.mutableEvents.get(index));
            }
            this.mutableEvents.removeAll(toRemove);
            this.onChange.bang();
        }
        return this;
    }

    void clear() {
        this.mutableEvents.clear();
        this.onChange.bang();
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        ArrayList<T> loadEvents = new ArrayList<T>();
        if (obj.has(KEY_EVENTS)) {
            this.beginLoadEvents(loadEvents);
            JsonArray eventsArr = obj.get(KEY_EVENTS).getAsJsonArray();
            for (JsonElement eventElem : eventsArr) {
                JsonObject eventObj = eventElem.getAsJsonObject();
                T event = this.loadEvent(lx, eventObj);
                if (event == null) continue;
                ((LXClipEvent)event).load(lx, eventObj);
                loadEvents.add(event);
            }
            this.endLoadEvents(loadEvents);
        }
        this.mutableEvents.set(loadEvents);
        this.onChange.bang();
    }

    protected void beginLoadEvents(List<T> loadEvents) {
    }

    protected void endLoadEvents(List<T> loadEvents) {
    }

    protected abstract T loadEvent(LX var1, JsonObject var2);

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        if (this instanceof ParameterClipLane) {
            obj.addProperty(KEY_LANE_TYPE, VALUE_LANE_TYPE_PARAMETER);
        } else if (this instanceof PatternClipLane) {
            obj.addProperty(KEY_LANE_TYPE, VALUE_LANE_TYPE_PATTERN);
        } else if (this instanceof MidiNoteClipLane) {
            obj.addProperty(KEY_LANE_TYPE, VALUE_LANE_TYPE_MIDI_NOTE);
        }
        obj.add(KEY_EVENTS, (JsonElement)LXSerializable.Utils.toArray(lx, this.events));
    }
}

