/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.MidiNoteClipLane;
import heronarts.lx.midi.MidiNote;
import javax.sound.midi.InvalidMidiDataException;

public class MidiNoteClipEvent
extends LXClipEvent<MidiNoteClipEvent> {
    public final MidiNoteClipLane lane;
    public final MidiNote midiNote;
    private MidiNoteClipEvent partner;
    protected static final String KEY_CHANNEL = "channel";
    protected static final String KEY_COMMAND = "command";
    protected static final String KEY_DATA_1 = "data1";
    protected static final String KEY_DATA_2 = "data2";

    MidiNoteClipEvent(MidiNoteClipLane lane, int command, int channel, int data1, int data2) throws InvalidMidiDataException {
        this(lane, MidiNote.constructMutable(command, channel, data1, data2));
    }

    MidiNoteClipEvent(MidiNoteClipLane lane, MidiNote midiNote) {
        super(lane);
        this.lane = lane;
        this.midiNote = midiNote;
    }

    public boolean isNoteOn() {
        return this.midiNote.isNoteOn();
    }

    public boolean isNoteOff() {
        return this.midiNote.isNoteOff();
    }

    void setNoteOff(MidiNoteClipEvent noteOff) {
        if (!this.isNoteOn()) {
            throw new IllegalStateException("Cannot setNoteOff() on a MIDI event that isn't note-on: " + String.valueOf(this));
        }
        if (noteOff.isNoteOn()) {
            throw new IllegalStateException("Cannot setNoteOff() to a MIDI event that isn't note-off: " + String.valueOf(noteOff));
        }
        if (noteOff.partner != null) {
            throw new IllegalStateException("Cannot setNoteOff() to a MIDI event already with a partner: " + String.valueOf(this) + " -> " + String.valueOf(noteOff));
        }
        this.partner = noteOff;
        noteOff.partner = this;
    }

    public MidiNoteClipEvent getNoteOff() {
        if (!this.isNoteOn()) {
            throw new UnsupportedOperationException("Can only getNoteOff() for a note on event");
        }
        return this.partner;
    }

    public MidiNoteClipEvent getNoteOn() {
        if (this.isNoteOn()) {
            throw new UnsupportedOperationException("Can only getNoteOn() for a note off event");
        }
        return this.partner;
    }

    @Override
    public void execute() {
        this.lane.playNote(this);
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.addProperty(KEY_CHANNEL, (Number)this.midiNote.getChannel());
        obj.addProperty(KEY_COMMAND, (Number)this.midiNote.getCommand());
        obj.addProperty(KEY_DATA_1, (Number)this.midiNote.getData1());
        obj.addProperty(KEY_DATA_2, (Number)this.midiNote.getData2());
    }
}

