/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXAbstractChannelClip;
import heronarts.lx.clip.LXClipLane;
import heronarts.lx.clip.MidiNoteClipEvent;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOff;
import heronarts.lx.parameter.MutableParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sound.midi.InvalidMidiDataException;

public class MidiNoteClipLane
extends LXClipLane<MidiNoteClipEvent> {
    public final LXAbstractChannelClip clip;
    public final MutableParameter uiZoom = new MutableParameter("UI Zoom", 4.0).setDescription("Amount of UI zoom on the MIDI clip lane");
    public final MutableParameter uiOffset = new MutableParameter("UI Offset", -1.0).setDescription("Scroll offset of MIDI piano roll");
    private final MidiNoteClipEvent[] playNoteStack = new MidiNoteClipEvent[128];
    private final MidiNoteClipEvent[] recordNoteStack = new MidiNoteClipEvent[128];
    private final MidiNoteClipEvent[] recordInputStack = new MidiNoteClipEvent[128];
    private final Set<MidiNoteClipEvent> overdubEvents = new HashSet<MidiNoteClipEvent>();
    private boolean inOverdub = false;
    private final MidiNoteClipEvent[] loadEventNoteStack = new MidiNoteClipEvent[128];

    protected MidiNoteClipLane(LXAbstractChannelClip clip) {
        super(clip);
        this.clip = clip;
        this.addInternalParameter("uiZoom ", this.uiZoom);
        this.addInternalParameter("uiOffset", this.uiOffset);
    }

    @Override
    public String getPath() {
        return "MIDI";
    }

    @Override
    public String getLabel() {
        return "MIDI";
    }

    private void dispatchNote(MidiNote note) {
        this.clip.channel.midiDispatch(note);
    }

    void playNote(MidiNoteClipEvent note) {
        if (note.isNoteOn()) {
            this.playNoteOn(note);
        } else {
            this.playNoteOff(note);
        }
    }

    private void playNoteOn(MidiNoteClipEvent noteOn) {
        int pitch = noteOn.midiNote.getPitch();
        MidiNoteClipEvent noteHeld = this.playNoteStack[pitch];
        if (noteHeld != null) {
            MidiNoteClipLane.debug("Firing note-off for stacked playback note: " + String.valueOf(noteOn));
            try {
                this.clip.channel.midiDispatch(new MidiNoteOff(noteOn.midiNote.getChannel(), pitch));
            }
            catch (InvalidMidiDataException imdx) {
                LX.error(imdx, "WTF invalid note-clone in MidiNoteClipLane.playNote");
            }
        }
        this.playNoteStack[pitch] = noteOn;
        this.recordNoteStack[pitch] = noteOn;
        this.dispatchNote(noteOn.midiNote);
    }

    private void playNoteOff(MidiNoteClipEvent noteOff) {
        int pitch = noteOff.midiNote.getPitch();
        MidiNoteClipEvent noteHeld = this.playNoteStack[pitch];
        if (noteHeld == null) {
            MidiNoteClipLane.debug("Ignoring note-off for non-held note: " + String.valueOf(noteOff.midiNote));
        } else {
            MidiNote dispatch;
            int heldChannel = noteHeld.midiNote.getChannel();
            if (heldChannel != (dispatch = noteOff.midiNote).getChannel()) {
                try {
                    dispatch = new MidiNoteOff(heldChannel, pitch);
                    MidiNoteClipLane.debug("Adjusted note-off channel (" + heldChannel + ") for playback note-off: " + String.valueOf(noteOff.midiNote));
                }
                catch (InvalidMidiDataException imdx) {
                    LX.error(imdx, "WTF invalid note-clone in MidiNoteClipLane.playNote");
                }
            }
            this.dispatchNote(dispatch);
        }
        this.playNoteStack[pitch] = null;
        this.recordNoteStack[pitch] = null;
    }

    private void terminatePlaybackNotes() {
        MidiNoteClipEvent[] midiNoteClipEventArray = this.playNoteStack;
        int n = this.playNoteStack.length;
        int n2 = 0;
        while (n2 < n) {
            MidiNoteClipEvent noteOn = midiNoteClipEventArray[n2];
            if (noteOn != null) {
                try {
                    this.dispatchNote(new MidiNoteOff(noteOn.midiNote.getChannel(), noteOn.midiNote.getPitch()));
                    MidiNoteClipLane.debug("Firing note-off for lingering note: " + String.valueOf(noteOn.midiNote));
                }
                catch (InvalidMidiDataException imdx) {
                    LX.error(imdx, "WTF, note clone has bad MIDI data");
                }
            }
            ++n2;
        }
        Arrays.fill(this.playNoteStack, null);
    }

    private void terminateRecordingNotes(Cursor to) {
        this.mutableEvents.begin();
        boolean changed = false;
        MidiNoteClipEvent[] midiNoteClipEventArray = this.recordInputStack;
        int n = this.recordInputStack.length;
        int n2 = 0;
        while (n2 < n) {
            MidiNoteClipEvent noteOn = midiNoteClipEventArray[n2];
            if (noteOn != null) {
                try {
                    MidiNoteClipEvent noteOff = new MidiNoteClipEvent(this, 128, noteOn.midiNote.getChannel(), noteOn.midiNote.getPitch(), 0);
                    noteOff.setCursor(to);
                    noteOn.setNoteOff(noteOff);
                    int insertIndex = this.CursorOp().isEqual(noteOn.cursor, noteOff.cursor) ? this.cursorInsertIndex(noteOff.cursor) : this.cursorPlayIndex(noteOff.cursor);
                    this.mutableEvents.add(insertIndex, noteOff);
                    MidiNoteClipLane.debug("Recorded note-off for hung note on recording: " + String.valueOf(noteOn));
                    changed = true;
                }
                catch (InvalidMidiDataException imdx) {
                    LX.error(imdx, "WTF, note clone has bad MIDI data");
                }
            }
            ++n2;
        }
        Arrays.fill(this.recordNoteStack, null);
        Arrays.fill(this.recordInputStack, null);
        this.mutableEvents.commit();
        if (changed) {
            this.onChange.bang();
        }
    }

    void onStopPlayback() {
        this.terminatePlaybackNotes();
    }

    private void initializeRecordNoteStack(Cursor to) {
        Arrays.fill(this.recordNoteStack, null);
        Arrays.fill(this.recordInputStack, null);
        int index = this.cursorPlayIndex(to);
        int i = 0;
        while (i < index) {
            MidiNoteClipEvent noteEvent = (MidiNoteClipEvent)this.events.get(i);
            this.recordNoteStack[noteEvent.midiNote.getPitch()] = noteEvent.midiNote.isNoteOn() ? noteEvent : null;
            ++i;
        }
    }

    void onStopRecording() {
        if (!this.clip.isRunning()) {
            this.terminatePlaybackNotes();
        }
        this.terminateRecordingNotes(this.clip.cursor);
    }

    @Override
    void initializeCursorPlayback(Cursor to) {
        Arrays.fill(this.playNoteStack, null);
        this.initializeRecordNoteStack(to);
    }

    @Override
    void jumpCursor(Cursor from, Cursor to) {
        this.terminatePlaybackNotes();
        this.terminateRecordingNotes(from);
        this.initializeCursorPlayback(to);
    }

    @Override
    void loopCursor(Cursor from, Cursor to) {
        this.jumpCursor(this.clip.loopEnd.cursor, to);
    }

    @Override
    void overdubCursor(Cursor from, Cursor to, boolean inclusive) {
        this.inOverdub = true;
        boolean changed = false;
        this.mutableEvents.begin();
        if (!this.recordQueue.isEmpty()) {
            this.commitRecordQueue(false);
            changed = true;
        }
        Cursor.Operator CursorOp = this.CursorOp();
        int limit = -1;
        int index = this.cursorPlayIndex(from);
        while (index < this.events.size()) {
            MidiNoteClipEvent note = (MidiNoteClipEvent)this.events.get(index);
            if (CursorOp.compare(note.cursor, to) > -1) break;
            if (!this.overdubEvents.contains(note)) {
                if (note.isNoteOn() && this.recordInputStack[note.midiNote.getPitch()] != null) {
                    this.mutableEvents.remove(index);
                    this.mutableEvents.remove(note.getNoteOff());
                    --index;
                    changed = true;
                } else {
                    this.playNote(note);
                }
            }
            ++index;
        }
        this.overdubEvents.clear();
        this.inOverdub = false;
        this.mutableEvents.commit();
        if (changed) {
            this.onChange.bang();
        }
    }

    public MidiNoteClipLane removeNote(MidiNoteClipEvent note) {
        this.mutableEvents.begin();
        this.mutableEvents.remove(note);
        this.mutableEvents.remove(note.getNoteOff());
        this.mutableEvents.commit();
        this.onChange.bang();
        return this;
    }

    @Override
    public boolean removeRange(Cursor from, Cursor to) {
        ArrayList<MidiNoteClipEvent> toRemove = null;
        Cursor.Operator CursorOp = this.CursorOp();
        for (MidiNoteClipEvent noteOn : this.events) {
            MidiNoteClipEvent noteOff;
            if (CursorOp.isAfter(noteOn.cursor, to)) break;
            if (!noteOn.isNoteOn() || !CursorOp.isBefore(noteOn.cursor, to) || (noteOff = noteOn.getNoteOff()) == null || !CursorOp.isAfter(noteOff.cursor, from)) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<MidiNoteClipEvent>();
            }
            toRemove.add(noteOn);
            toRemove.add(noteOff);
        }
        if (toRemove != null) {
            this.mutableEvents.removeAll(toRemove);
            this.onChange.bang();
            return true;
        }
        return false;
    }

    protected void recordNote(MidiNote note) {
        this.recordEvent(new MidiNoteClipEvent(this, note.mutableCopy()));
    }

    MidiNoteClipLane commitRecordQueue(boolean notify) {
        if (!this.recordQueue.isEmpty()) {
            this.mutableEvents.begin();
            this.recordQueue.forEach(note -> this._recordNote((MidiNoteClipEvent)note));
            this.recordQueue.clear();
            this.mutableEvents.commit();
            if (notify) {
                this.onChange.bang();
            }
        }
        return this;
    }

    private void _recordNote(MidiNoteClipEvent note) {
        if (note.isNoteOn()) {
            this._recordNoteOn(note);
        } else {
            this._recordNoteOff(note);
        }
    }

    private void _recordNoteOn(MidiNoteClipEvent noteOn) {
        int pitch = noteOn.midiNote.getPitch();
        MidiNoteClipEvent recordNoteOn = this.recordNoteStack[pitch];
        if (recordNoteOn != null) {
            int noteOffChannel = recordNoteOn.midiNote.getChannel();
            try {
                MidiNoteClipEvent noteOff = recordNoteOn.getNoteOff();
                if (noteOff != null) {
                    MidiNoteClipLane.debug("Truncating earlier note: " + String.valueOf(recordNoteOn));
                    this.mutableEvents.remove(noteOff);
                    noteOff.setCursor(noteOn.cursor);
                    noteOff.midiNote.setChannel(noteOffChannel);
                } else {
                    MidiNoteClipLane.debug("Adding missing note-off: " + String.valueOf(recordNoteOn));
                    noteOff = new MidiNoteClipEvent(this, 128, noteOffChannel, pitch, 0);
                    recordNoteOn.setNoteOff(noteOff);
                }
                this._insertNoteOff(noteOff);
                if (this.inOverdub) {
                    this.overdubEvents.add(noteOff);
                }
                if (this.playNoteStack[pitch] != null) {
                    this.playNote(noteOff);
                }
                this.recordNoteStack[pitch] = null;
                this.playNoteStack[pitch] = null;
            }
            catch (InvalidMidiDataException imdx) {
                LX.error(imdx, "WTF, note clone has bad MIDI data");
            }
        }
        this.playNoteStack[pitch] = noteOn;
        this.recordNoteStack[pitch] = noteOn;
        this.recordInputStack[pitch] = noteOn;
        this._insertEvent(noteOn);
        if (this.inOverdub) {
            this.overdubEvents.add(noteOn);
        }
    }

    private void _recordNoteOff(MidiNoteClipEvent noteOff) {
        int pitch = noteOff.midiNote.getPitch();
        if (this.recordInputStack[pitch] == null) {
            return;
        }
        MidiNoteClipEvent recordNoteOn = this.recordNoteStack[pitch];
        if (recordNoteOn == null) {
            MidiNoteClipLane.debug("Ignoring Note-off that had no counterpart");
        } else {
            int noteOffChannel = recordNoteOn.midiNote.getChannel();
            MidiNoteClipEvent existingNoteOff = recordNoteOn.getNoteOff();
            if (existingNoteOff != null) {
                MidiNoteClipLane.debug("Moving already-existing note-off: " + String.valueOf(recordNoteOn));
                this.mutableEvents.remove(existingNoteOff);
                existingNoteOff.midiNote.setChannel(noteOffChannel);
                existingNoteOff.setCursor(noteOff.cursor);
                noteOff = existingNoteOff;
            } else {
                if (noteOff.midiNote.getChannel() != noteOffChannel) {
                    noteOff.midiNote.setChannel(noteOffChannel);
                    MidiNoteClipLane.debug("Fixed MIDI channel (" + noteOffChannel + ") for note-off on held pitch: " + String.valueOf(noteOff));
                }
                recordNoteOn.setNoteOff(noteOff);
            }
            this._insertNoteOff(noteOff);
            if (this.inOverdub) {
                this.overdubEvents.add(noteOff);
            }
        }
        this.playNoteStack[pitch] = null;
        this.recordNoteStack[pitch] = null;
        this.recordInputStack[pitch] = null;
    }

    @Override
    protected void beginLoadEvents(List<MidiNoteClipEvent> loadEvents) {
        Arrays.fill(this.loadEventNoteStack, null);
    }

    @Override
    protected MidiNoteClipEvent loadEvent(LX lx, JsonObject eventObj) {
        int channel = eventObj.get("channel").getAsInt();
        int command = eventObj.get("command").getAsInt();
        int data1 = eventObj.get("data1").getAsInt();
        int data2 = eventObj.get("data2").getAsInt();
        try {
            MidiNote midiNote = MidiNote.constructMutable(command, channel, data1, data2);
            int pitch = midiNote.getPitch();
            MidiNoteClipEvent noteHeld = this.loadEventNoteStack[pitch];
            if (midiNote.isNoteOn()) {
                if (noteHeld == null) {
                    this.loadEventNoteStack[pitch] = new MidiNoteClipEvent(this, midiNote);
                    return this.loadEventNoteStack[pitch];
                }
                LX.error("Ignored stacked MIDI note in MIDI clip lane: " + String.valueOf(eventObj));
            } else {
                if (noteHeld != null) {
                    if (channel != noteHeld.midiNote.getChannel()) {
                        LX.error("Fixing note-off channel mismatch in MIDI clip lane: " + String.valueOf(eventObj));
                        midiNote.setChannel(noteHeld.midiNote.getChannel());
                    }
                    MidiNoteClipEvent noteOffEvent = new MidiNoteClipEvent(this, midiNote);
                    noteHeld.setNoteOff(noteOffEvent);
                    this.loadEventNoteStack[pitch] = null;
                    return noteOffEvent;
                }
                LX.error("Ignored MIDI note off in MIDI clip lane with no note on: " + String.valueOf(eventObj));
            }
        }
        catch (InvalidMidiDataException imdx) {
            LX.error(imdx, "Invalid MIDI in clip event: " + channel + " " + command + " " + data1 + " " + data2);
        }
        return null;
    }

    @Override
    protected void endLoadEvents(List<MidiNoteClipEvent> loadEvents) {
        MidiNoteClipEvent[] midiNoteClipEventArray = this.loadEventNoteStack;
        int n = this.loadEventNoteStack.length;
        int n2 = 0;
        while (n2 < n) {
            MidiNoteClipEvent noteOn = midiNoteClipEventArray[n2];
            if (noteOn != null) {
                try {
                    MidiNoteClipEvent noteOff = new MidiNoteClipEvent(this, 128, noteOn.midiNote.getChannel(), noteOn.midiNote.getPitch(), 0);
                    noteOff.setCursor(this.clip.length.cursor);
                    noteOn.setNoteOff(noteOff);
                    loadEvents.add(noteOff);
                    LX.error("Added note-off for hung MIDI note on in MIDI clip lane: " + String.valueOf(noteOn));
                }
                catch (InvalidMidiDataException imdx) {
                    LX.error(imdx, "Invalid MIDI in note-off clone: " + String.valueOf(noteOn.midiNote));
                }
            }
            ++n2;
        }
        Arrays.fill(this.loadEventNoteStack, null);
    }

    public boolean isClear(int pitch, Cursor from, Cursor to) {
        Cursor.Operator CursorOp = this.CursorOp();
        for (MidiNoteClipEvent noteOn : this.events) {
            if (CursorOp.isAfter(noteOn.cursor, to)) {
                return true;
            }
            if (!noteOn.isNoteOn() || noteOn.midiNote.getPitch() != pitch) continue;
            MidiNoteClipEvent noteOff = noteOn.getNoteOff();
            if (noteOff == null) {
                return false;
            }
            if (!CursorOp.isAfter(noteOff.cursor, from)) continue;
            return false;
        }
        return true;
    }

    private int _insertNoteOff(MidiNoteClipEvent noteOff) {
        if (noteOff.getNoteOn() == null) {
            LX.error(new Exception("Note off with no note-on"));
        }
        MidiNoteClipEvent noteOn = noteOff.getNoteOn();
        int index = -1;
        index = noteOn != null && this.CursorOp().isEqual(noteOn.cursor, noteOff.cursor) ? this.cursorInsertIndex(noteOn.cursor) + 1 : this.cursorPlayIndex(noteOff.cursor);
        this.mutableEvents.add(index, noteOff);
        return index;
    }

    private void _insertNote(MidiNoteClipEvent noteOn, MidiNoteClipEvent noteOff) {
        int insertIndex = this.cursorInsertIndex(noteOn.cursor);
        this.mutableEvents.add(insertIndex, noteOn);
        if (this.CursorOp().isEqual(noteOn.cursor, noteOff.cursor)) {
            this.mutableEvents.add(insertIndex + 1, noteOff);
        } else {
            this.mutableEvents.add(this.cursorPlayIndex(noteOff.cursor), noteOff);
        }
    }

    public MidiNoteClipEvent insertNote(int pitch, int velocity, Cursor from, Cursor to) {
        if (!this.isClear(pitch, from, to)) {
            return null;
        }
        try {
            MidiNoteClipEvent noteOn = new MidiNoteClipEvent(this, 144, 0, pitch, velocity);
            MidiNoteClipEvent noteOff = new MidiNoteClipEvent(this, 128, 0, pitch, 0);
            noteOn.setNoteOff(noteOff);
            noteOn.setCursor(from);
            noteOff.setCursor(to);
            this.mutableEvents.begin();
            this._insertNote(noteOn, noteOff);
            this.mutableEvents.commit();
            this.onChange.bang();
            return noteOn;
        }
        catch (InvalidMidiDataException imdx) {
            LX.error(imdx, "WTF, note clone has bad MIDI data");
            return null;
        }
    }

    public void editNote(MidiNoteClipEvent editNoteOn, int toPitch, int toVelocity, Cursor toStart, Cursor toEnd, List<MidiNoteClipEvent> restoreOriginal, boolean checkDelete, boolean cursorMoved) {
        Cursor.Operator CursorOp = this.CursorOp();
        this.mutableEvents.begin();
        this.mutableEvents.set(restoreOriginal);
        if (checkDelete) {
            ArrayList<MidiNoteClipEvent> toRemove = null;
            for (MidiNoteClipEvent noteOn : this.events) {
                MidiNoteClipEvent noteOff;
                if (noteOn.isNoteOff() || noteOn == editNoteOn) continue;
                if (CursorOp.isAfter(noteOn.cursor, toEnd)) break;
                if (noteOn.midiNote.getPitch() != toPitch || !CursorOp.isBefore(noteOn.cursor, toEnd) || (noteOff = noteOn.getNoteOff()) == null || !CursorOp.isAfter(noteOn.getNoteOff().cursor, toStart)) continue;
                if (toRemove == null) {
                    toRemove = new ArrayList<MidiNoteClipEvent>();
                }
                toRemove.add(noteOn);
                toRemove.add(noteOff);
            }
            if (toRemove != null) {
                this.mutableEvents.removeAll(toRemove);
            }
        }
        editNoteOn.midiNote.setVelocity(toVelocity);
        MidiNoteClipEvent editNoteOff = editNoteOn.getNoteOff();
        editNoteOn.midiNote.setPitch(toPitch);
        editNoteOff.midiNote.setPitch(toPitch);
        editNoteOn.cursor.set(toStart);
        editNoteOff.cursor.set(toEnd);
        if (cursorMoved) {
            this.mutableEvents.remove(editNoteOn);
            this.mutableEvents.remove(editNoteOff);
            this._insertNote(editNoteOn, editNoteOff);
        }
        this.mutableEvents.commit();
        this.onChange.bang();
    }

    private static void debug(String str) {
        LX.debug(str);
    }
}

