/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.ParameterClipLane;
import heronarts.lx.utils.LXUtils;

public class ParameterClipEvent
extends LXClipEvent<ParameterClipEvent> {
    public final ParameterClipLane lane;
    private double normalized;
    protected static final String KEY_NORMALIZED = "normalized";

    ParameterClipEvent(ParameterClipLane lane) {
        this(lane, lane.parameter.getBaseNormalized());
    }

    ParameterClipEvent(ParameterClipLane lane, Cursor cursor) {
        this(lane, cursor, lane.parameter.getBaseNormalized());
    }

    ParameterClipEvent(ParameterClipLane lane, double normalized) {
        super(lane, lane.parameter.getParent());
        this.lane = lane;
        this.normalized = this.normalizeEventValue(normalized);
    }

    ParameterClipEvent(ParameterClipLane lane, Cursor cursor, double normalized) {
        this(lane, normalized);
        this.setCursor(cursor);
    }

    private double normalizeEventValue(double normalized) {
        normalized = this.lane instanceof ParameterClipLane.Boolean ? (double)(normalized > 0.5 ? 1 : 0) : LXUtils.constrain(normalized, 0.0, 1.0);
        return normalized;
    }

    boolean _setNormalized(double normalized) {
        if (this.normalized != (normalized = this.normalizeEventValue(normalized))) {
            this.normalized = normalized;
            return true;
        }
        return false;
    }

    public ParameterClipEvent setNormalized(double normalized) {
        if (this._setNormalized(normalized)) {
            this.lane.onChange.bang();
        }
        return this;
    }

    public double getNormalized() {
        return this.normalized;
    }

    public float getNormalizedf() {
        return (float)this.normalized;
    }

    @Override
    public void execute() {
        this.lane.parameter.setNormalized(this.normalized);
    }

    public String toString() {
        return this.cursor.toString() + " -> " + this.lane.parameter.getLabel() + "=" + this.getNormalized();
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (obj.has(KEY_NORMALIZED)) {
            this.normalized = obj.get(KEY_NORMALIZED).getAsDouble();
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.addProperty(KEY_NORMALIZED, (Number)this.normalized);
    }
}

