/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.clip;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.clip.Cursor;
import heronarts.lx.clip.LXClip;
import heronarts.lx.clip.LXClipEvent;
import heronarts.lx.clip.LXClipLane;
import heronarts.lx.clip.ParameterClipEvent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class ParameterClipLane
extends LXClipLane<ParameterClipEvent> {
    public final LXNormalizedParameter parameter;
    private double initialNormalized;
    private static final double SMOOTHING_THRESHOLD_MS = 250.0;
    private boolean inPlayback = false;

    static ParameterClipLane create(LXClip clip, LXNormalizedParameter parameter, double initialNormalized) {
        if (parameter instanceof TriggerParameter) {
            return new Trigger(clip, (TriggerParameter)parameter);
        }
        if (parameter instanceof BooleanParameter) {
            return new Boolean(clip, (BooleanParameter)parameter, initialNormalized);
        }
        if (parameter instanceof DiscreteParameter) {
            return new Discrete(clip, (DiscreteParameter)parameter, initialNormalized);
        }
        return new Normalized(clip, parameter, initialNormalized);
    }

    private ParameterClipLane(LXClip clip, LXNormalizedParameter parameter, double initialNormalized) {
        super(clip);
        this.parameter = parameter;
        this.initialNormalized = initialNormalized;
    }

    void updateDefaultValue(double initialNormalized) {
        this.initialNormalized = initialNormalized;
    }

    @Override
    public String getLabel() {
        return this.parameter.getCanonicalLabel(this.clip.bus, " | ", 3);
    }

    public boolean shouldRecordParameterChange(LXNormalizedParameter p) {
        return true;
    }

    public boolean hasStitching() {
        return !(this instanceof Trigger);
    }

    public boolean hasInterpolation() {
        return this instanceof Normalized;
    }

    public boolean isStepped() {
        return this instanceof Boolean || this instanceof Discrete;
    }

    @Override
    protected void setEventNormalized(ParameterClipEvent event, double normalized) {
        event.setNormalized(normalized);
    }

    @Override
    protected void reverseEvents(List<ParameterClipEvent> events) {
        Collections.reverse(events);
        if (this.isStepped()) {
            int i = 0;
            while (i < events.size() - 1) {
                events.get(i).setNormalized(events.get(i + 1).getNormalized());
                ++i;
            }
        }
    }

    protected ParameterClipEvent stitchEvent(ParameterClipEvent prior, ParameterClipEvent next, Cursor cursor) {
        if (!this.hasStitching()) {
            return null;
        }
        if (prior == null || next == null) {
            return null;
        }
        if (this.hasInterpolation()) {
            return new ParameterClipEvent(this, cursor, LXUtils.lerp(prior.getNormalized(), next.getNormalized(), this.CursorOp().getLerpFactor(cursor, prior.cursor, next.cursor)));
        }
        return new ParameterClipEvent(this, cursor, this.CursorOp().isAfterOrEqual(cursor, next.cursor) ? next.getNormalized() : prior.getNormalized());
    }

    @Override
    protected ParameterClipEvent stitchInner(List<ParameterClipEvent> events, Cursor cursor, int stitchIndex, boolean isMin, boolean force) {
        if (!this.hasStitching()) {
            return null;
        }
        ParameterClipEvent prior = null;
        ParameterClipEvent next = null;
        if (stitchIndex > 0) {
            prior = events.get(stitchIndex - 1);
            if (!isMin && !force && this.CursorOp().isEqual(prior.cursor, cursor)) {
                return null;
            }
        }
        if (stitchIndex < events.size()) {
            next = events.get(stitchIndex);
            if (isMin && !force && this.CursorOp().isEqual(next.cursor, cursor)) {
                return null;
            }
        }
        if (prior != null && next != null) {
            return this.stitchEvent(prior, next, cursor);
        }
        if (prior != null) {
            return new ParameterClipEvent(this, cursor, prior.getNormalized());
        }
        if (next != null) {
            return new ParameterClipEvent(this, cursor, next.getNormalized());
        }
        return null;
    }

    @Override
    protected ParameterClipEvent stitchSelectionMin(List<ParameterClipEvent> originalEvents, List<ParameterClipEvent> modifiedEvents, Cursor selectionMin, int stitchIndex, boolean force) {
        if (!this.hasStitching()) {
            return null;
        }
        ParameterClipEvent prior = null;
        ParameterClipEvent next = null;
        if (stitchIndex > 0) {
            prior = originalEvents.get(stitchIndex - 1);
        }
        if (!modifiedEvents.isEmpty()) {
            next = modifiedEvents.get(0);
            if (!force && this.CursorOp().isEqual(next.cursor, selectionMin)) {
                return null;
            }
        } else if (stitchIndex < originalEvents.size()) {
            next = originalEvents.get(stitchIndex);
        }
        if (prior == null && next != null) {
            return new ParameterClipEvent(this, selectionMin, next.getNormalized());
        }
        return this.stitchEvent(prior, next, selectionMin);
    }

    @Override
    protected ParameterClipEvent stitchSelectionMax(List<ParameterClipEvent> originalEvents, List<ParameterClipEvent> modifiedEvents, Cursor selectionMax, int stitchIndex, boolean force) {
        if (!this.hasStitching()) {
            return null;
        }
        ParameterClipEvent prior = null;
        ParameterClipEvent next = null;
        if (stitchIndex < originalEvents.size()) {
            next = originalEvents.get(stitchIndex);
        }
        if (!modifiedEvents.isEmpty()) {
            prior = modifiedEvents.get(modifiedEvents.size() - 1);
            if (!force && this.CursorOp().isEqual(prior.cursor, selectionMax)) {
                return null;
            }
        } else if (stitchIndex > 0) {
            prior = originalEvents.get(stitchIndex - 1);
        }
        if (next == null && prior != null) {
            return new ParameterClipEvent(this, selectionMax, prior.getNormalized());
        }
        return this.stitchEvent(prior, next, selectionMax);
    }

    @Override
    protected ParameterClipEvent stitchOuter(List<ParameterClipEvent> events, Cursor cursor, int rightIndex) {
        if (!this.hasStitching()) {
            return null;
        }
        if (events.isEmpty()) {
            return null;
        }
        if (rightIndex > 0 && rightIndex < events.size()) {
            return this.stitchEvent(events.get(rightIndex - 1), events.get(rightIndex), cursor);
        }
        if (rightIndex == 0) {
            return new ParameterClipEvent(this, cursor, events.get(rightIndex).getNormalized());
        }
        if (rightIndex == events.size()) {
            return new ParameterClipEvent(this, cursor, events.get(rightIndex - 1).getNormalized());
        }
        return null;
    }

    private boolean stitchIsRedundant(List<ParameterClipEvent> events, ParameterClipEvent stitch, int priorIndex, int nextIndex) {
        if (events.isEmpty()) {
            return false;
        }
        ParameterClipEvent prior = null;
        ParameterClipEvent next = null;
        boolean equalsPrior = true;
        boolean equalsNext = true;
        double stitchNormalized = stitch.getNormalized();
        if (priorIndex >= 0) {
            prior = events.get(priorIndex);
            boolean bl = equalsPrior = stitchNormalized == prior.getNormalized();
            if (equalsPrior && (!this.hasInterpolation() || this.CursorOp().isEqual(stitch.cursor, prior.cursor))) {
                return true;
            }
        }
        if (nextIndex < events.size()) {
            next = events.get(nextIndex);
            boolean bl = equalsNext = stitchNormalized == next.getNormalized();
            if (equalsNext && this.CursorOp().isEqual(stitch.cursor, next.cursor)) {
                return true;
            }
        }
        return equalsPrior && equalsNext;
    }

    @Override
    protected int stitchInsertIfNeeded(List<ParameterClipEvent> events, ParameterClipEvent stitch, boolean after) {
        int index;
        int n = index = after ? this.cursorInsertIndex(events, stitch.cursor) : this.cursorPlayIndex(events, stitch.cursor);
        if (this.stitchIsRedundant(events, stitch, index - 1, index)) {
            return -1;
        }
        events.add(index, stitch);
        return index;
    }

    @Override
    protected boolean stitchRemoveIfRedundant(List<ParameterClipEvent> events, ParameterClipEvent stitch, int index) {
        if (stitch != null) {
            if (events.get(index) != stitch) {
                throw new IllegalStateException("stitchRemoveIfRedundant index was wrong");
            }
            if (this.stitchIsRedundant(events, stitch, index - 1, index + 1)) {
                events.remove(index);
                return true;
            }
        }
        return false;
    }

    public ParameterClipEvent insertEvent(Cursor cursor, double normalized) {
        ParameterClipEvent event = new ParameterClipEvent(this, normalized);
        event.setCursor(cursor);
        super.insertEvent(event);
        return event;
    }

    public void setEventsNormalized(Map<ParameterClipEvent, Double> normalized) {
        boolean changed = false;
        for (Map.Entry<ParameterClipEvent, Double> entry : normalized.entrySet()) {
            ParameterClipEvent event = entry.getKey();
            if (this.events.contains(event)) {
                if (!event._setNormalized(entry.getValue())) continue;
                changed = true;
                continue;
            }
            LX.error("ParameterClipLane.setEventsNormalized called with an event not in the events array: " + String.valueOf(event));
        }
        if (changed) {
            this.onChange.bang();
        }
    }

    protected ParameterClipLane recordParameterEvent(ParameterClipEvent event) {
        if (this.hasStitching()) {
            ParameterClipEvent previousEvent;
            int cursorIndex = this.cursorPlayIndex(this.clip.cursor);
            ParameterClipEvent parameterClipEvent = previousEvent = cursorIndex > 0 ? (ParameterClipEvent)this.events.get(cursorIndex - 1) : null;
            if (previousEvent == null) {
                if (cursorIndex < this.events.size()) {
                    ParameterClipEvent nextEvent = (ParameterClipEvent)this.events.get(cursorIndex);
                    this.recordEvent(new ParameterClipEvent(this, nextEvent.getNormalized()));
                } else {
                    this.recordEvent(new ParameterClipEvent(this, this.initialNormalized));
                }
            } else if (this.hasInterpolation() && this.clip.cursor.getDeltaMillis(previousEvent.cursor) > 250.0) {
                double normalized = 0.0;
                if (cursorIndex < this.events.size()) {
                    ParameterClipEvent nextEvent = (ParameterClipEvent)this.events.get(cursorIndex);
                    normalized = LXUtils.lerp(previousEvent.getNormalized(), nextEvent.getNormalized(), this.CursorOp().getLerpFactor(this.clip.cursor, previousEvent.cursor, nextEvent.cursor));
                } else {
                    normalized = previousEvent.getNormalized();
                }
                this.recordEvent(new ParameterClipEvent(this, normalized));
            }
        }
        this.recordEvent(event);
        this.overdubActive = true;
        return this;
    }

    public boolean isInPlayback() {
        return this.inPlayback;
    }

    @Override
    void loopCursor(Cursor from, Cursor to) {
        if (this.overdubActive && this.hasStitching() && !this.events.isEmpty()) {
            LXClipEvent stitchBeforeLoop = null;
            if (!this.CursorOp().isZero(to)) {
                stitchBeforeLoop = this.stitchOuter((List)this.mutableEvents, to, this.cursorPlayIndex(to));
                this.recordEvent(stitchBeforeLoop);
            }
            LXClipEvent stitchLoopEnd = this.stitchOuter((List)this.mutableEvents, to, this.cursorPlayIndex(from));
            if (stitchBeforeLoop == null || ((ParameterClipEvent)stitchBeforeLoop).getNormalized() != ((ParameterClipEvent)stitchLoopEnd).getNormalized()) {
                this.recordEvent(stitchLoopEnd);
            }
        }
    }

    @Override
    void playCursor(Cursor from, Cursor to, boolean inclusive) {
        this.inPlayback = true;
        if (this instanceof Trigger) {
            super.playCursor(from, to, inclusive);
        } else if (!this.events.isEmpty()) {
            ParameterClipEvent prior;
            int toIndex = LXUtils.min(this.cursorPlayIndex(to), this.events.size() - 1);
            ParameterClipEvent next = (ParameterClipEvent)this.events.get(toIndex);
            ParameterClipEvent parameterClipEvent = prior = toIndex > 0 ? (ParameterClipEvent)this.events.get(toIndex - 1) : null;
            if (prior == null || this.CursorOp().isAfter(to, next.cursor)) {
                this.parameter.setNormalized(next.getNormalized());
            } else if (this.hasInterpolation()) {
                this.parameter.setNormalized(LXUtils.lerp(prior.getNormalized(), next.getNormalized(), this.CursorOp().getLerpFactor(to, prior.cursor, next.cursor)));
            } else {
                this.parameter.setNormalized(prior.getNormalized());
            }
        }
        this.inPlayback = false;
    }

    @Override
    void overdubCursor(Cursor from, Cursor to, boolean inclusive) {
        Cursor.Operator CursorOp = this.CursorOp();
        boolean changed = false;
        this.mutableEvents.begin();
        ParameterClipEvent stitchInner = null;
        LXClipEvent stitchOuter = null;
        int stitchInnerIndex = -1;
        if (this.overdubActive && !this.mutableEvents.isEmpty()) {
            int endIndex;
            int startIndex = this.cursorPlayIndex(from);
            int n = endIndex = inclusive ? this.cursorInsertIndex(to) : this.cursorPlayIndex(to);
            if (CursorOp.isBefore(to, this.clip.length.cursor)) {
                stitchOuter = this.stitchOuter(this.events, to, endIndex);
            }
            if (endIndex > startIndex && this.overdubActive) {
                this.mutableEvents.removeRange(startIndex, endIndex);
                changed = true;
            }
        }
        if (!this.recordQueue.isEmpty()) {
            this.commitRecordQueue(false);
            changed = true;
        }
        if (this.overdubActive && !this.mutableEvents.isEmpty() && this.hasStitching() && (stitchInnerIndex = this.cursorPlayIndex(to)) > 0) {
            ParameterClipEvent innerEvent = (ParameterClipEvent)this.events.get(stitchInnerIndex - 1);
            if (CursorOp.isBefore(innerEvent.cursor, to)) {
                stitchInner = new ParameterClipEvent(this, to, innerEvent.getNormalized());
                this.mutableEvents.add(stitchInnerIndex, stitchInner);
                changed = true;
            }
        }
        this.playCursor(from, to, inclusive);
        if (stitchOuter != null) {
            this.stitchInsertIfNeeded((List<ParameterClipEvent>)this.mutableEvents, (ParameterClipEvent)stitchOuter, true);
        }
        if (stitchInner != null) {
            this.stitchRemoveIfRedundant((List<ParameterClipEvent>)this.mutableEvents, stitchInner, stitchInnerIndex);
        }
        this.mutableEvents.commit();
        if (changed) {
            this.onChange.bang();
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.addProperty("path", this.parameter.getCanonicalPath(this.clip.bus));
        obj.addProperty("componentId", (Number)this.parameter.getParent().getId());
        obj.addProperty("parameterPath", this.parameter.getPath());
    }

    @Override
    protected ParameterClipEvent loadEvent(LX lx, JsonObject eventObj) {
        double normalized = eventObj.get("normalized").getAsDouble();
        return new ParameterClipEvent(this, normalized);
    }

    public static class Boolean
    extends ParameterClipLane {
        public final BooleanParameter booleanParameter;

        private Boolean(LXClip clip, BooleanParameter parameter, double initialNormalized) {
            super(clip, parameter, initialNormalized);
            this.booleanParameter = parameter;
        }
    }

    public static class Discrete
    extends ParameterClipLane {
        public final DiscreteParameter discreteParameter;

        private Discrete(LXClip clip, DiscreteParameter parameter, double initialNormalized) {
            super(clip, parameter, initialNormalized);
            this.discreteParameter = parameter;
        }
    }

    public static class Normalized
    extends ParameterClipLane {
        private Normalized(LXClip clip, LXNormalizedParameter parameter, double initialNormalized) {
            super(clip, parameter, initialNormalized);
        }
    }

    public static class Trigger
    extends ParameterClipLane {
        public final TriggerParameter triggerParameter;

        private Trigger(LXClip clip, TriggerParameter parameter) {
            super(clip, parameter, 0.0);
            this.triggerParameter = parameter;
        }

        @Override
        public boolean shouldRecordParameterChange(LXNormalizedParameter p) {
            return p == this.triggerParameter && this.triggerParameter.isOn();
        }
    }
}

